/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.dateops;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.dateops.DateUtil$;
import ambience.etl.dateops.Format;
import ambience.etl.dateops.Format$Info$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.timestamp.FormatLogic$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Format$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    public static final Format$Info$ Info;
    private static final Json InfoJson;
    public static final Format$ MODULE$;

    private Format$() {
    }

    static {
        MODULE$ = new Format$();
        stepType = ETLStepType$.MODULE$.apply("date.Format");
        Format.Info info = (Format.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)Format$Info$.MODULE$.apply(Format$Info$.MODULE$.$lessinit$greater$default$1(), Format$Info$.MODULE$.$lessinit$greater$default$2(), Format$Info$.MODULE$.$lessinit$greater$default$3(), Format$Info$.MODULE$.$lessinit$greater$default$4()));
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Format$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        Format.Info info = (Format.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        Panel.Item fieldName = PanelItem$.MODULE$.text("sourceField", "Date Field", info.sourceField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item format = PanelItem$.MODULE$.text("format", "Format", info.format(), PanelItem$.MODULE$.text$default$4());
        Panel.Item locale = PanelItem$.MODULE$.select("locale", "Locale", Json$.MODULE$.fromString(info.locale()), DateUtil$.MODULE$.localeChoices(), PanelItem$.MODULE$.select$default$5());
        Panel.Item destField = PanelItem$.MODULE$.text("destField", "Result Field", info.destField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(fieldName, format, locale, destField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> augment(Builder.Context cxt, Format.Info info, DateTimeFormatter formatter, Observable<Document> from) {
        String dest = info.destField().isEmpty() ? info.sourceField() : info.destField();
        return from.mapEval((Function1 & Serializable)doc -> {
            Option option = BsonETL$.MODULE$.get(doc, info.sourceField());
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    Either<LogMessage, String> either = this.formatDate(formatter, s.getValue());
                    if (either instanceof Right) {
                        String result = (String)((Right)either).value();
                        return Task$.MODULE$.apply(() -> this.augment$$anonfun$1$$anonfun$1(doc, dest, result));
                    }
                    if (either instanceof Left) {
                        LogMessage msg = (LogMessage)((Left)either).value();
                        return cxt.logRecord(doc, msg);
                    }
                    throw new MatchError(either);
                }
                BsonValue x = bsonValue;
                return cxt.logRecord(doc, (LogMessage)LogMessage.Debug$.MODULE$.apply("String expected, got " + x));
            }
            if (None$.MODULE$.equals(option)) {
                return cxt.logRecord(doc, (LogMessage)LogMessage.Debug$.MODULE$.apply("Missing field " + info.sourceField()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Either<LogMessage, String> formatDate(DateTimeFormatter formatter, String date) {
        Option<LocalDate> option = DateUtil$.MODULE$.maybeParse(date);
        if (option instanceof Some) {
            LocalDate dt = (LocalDate)((Some)option).value();
            Try try_ = Try$.MODULE$.apply(() -> this.formatDate$$anonfun$1(dt, formatter));
            if (try_ instanceof Success) {
                String s = (String)((Success)try_).value();
                return package$.MODULE$.Right().apply((Object)s);
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                return package$.MODULE$.Left().apply((Object)LogMessage.Debug$.MODULE$.apply("Error formatting string: " + ex));
            }
            throw new MatchError((Object)try_);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Debug$.MODULE$.apply("String cannot be parsed as an ISODate (yyyy-MM-dd): " + date));
        }
        throw new MatchError(option);
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        Either either = this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::build$$anonfun$3)))));
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)this.error(step, err));
        }
        if (either instanceof Right) {
            Format.Info info = (Format.Info)((Right)either).value();
            Locale locale = DateUtil$.MODULE$.getLocale(info.locale());
            Try<DateTimeFormatter> try_ = FormatLogic$.MODULE$.buildFormatter(info.format(), locale);
            if (try_ instanceof Success) {
                DateTimeFormatter formatter = (DateTimeFormatter)((Success)try_).value();
                return package$.MODULE$.Right().apply((Function1 & Serializable)from -> this.augment(cxt, info, formatter, (Observable<Document>)from));
            }
            if (try_ instanceof Failure) {
                Throwable err = ((Failure)try_).exception();
                return package$.MODULE$.Left().apply((Object)BuildError$.MODULE$.apply("Can't build formatter " + info.format(), step, err));
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)either);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var2_1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        Format$Info$ format$Info$ = Format$Info$.MODULE$;
        return (Function1 & Serializable)p -> (Format.Info)format$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private final Format.Info $anonfun$4() {
        return Format$Info$.MODULE$.apply(Format$Info$.MODULE$.$lessinit$greater$default$1(), Format$Info$.MODULE$.$lessinit$greater$default$2(), Format$Info$.MODULE$.$lessinit$greater$default$3(), Format$Info$.MODULE$.$lessinit$greater$default$4());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item fieldName$1, Panel.Item format$1, Panel.Item locale$1, Panel.Item destField$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{fieldName$1, format$1, locale$1, destField$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        Format$Info$ format$Info$ = Format$Info$.MODULE$;
        return (Function1 & Serializable)p -> (Format.Info)format$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var2_1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            Format.Info info2 = (Format.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "sourceField";
            String string2 = "format";
            String string3 = "locale";
            String string4 = "destField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string5 = step$1.copy$default$1();
            String string6 = step$1.copy$default$2();
            String string7 = step$1.copy$default$3();
            String string8 = step$1.copy$default$4();
            String string9 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }

    private final Document augment$$anonfun$1$$anonfun$1(Document doc$1, String dest$2, String result$1) {
        return BsonETL$.MODULE$.put(doc$1, dest$2, (BsonValue)BsonString$.MODULE$.apply(result$1));
    }

    private final String formatDate$$anonfun$1(LocalDate dt$1, DateTimeFormatter formatter$2) {
        return dt$1.format(formatter$2);
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 build$$anonfun$2() {
        Format$Info$ format$Info$ = Format$Info$.MODULE$;
        return (Function1 & Serializable)p -> (Format.Info)format$Info$.fromProduct((Product)p);
    }

    private final Product build$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)Format$Info$.MODULE$.$lessinit$greater$default$4()));
    }
}

