/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.number.decimalops;

import ambience.bson.BsonETL$;
import ambience.etl.Builder;
import ambience.etl.number.RetainOperation;
import ambience.etl.number.decimalops.DecimalOperation$;
import java.io.Serializable;
import java.math.BigDecimal;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDecimal128$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DecimalInMemoryPercentOperation$
implements Serializable {
    private static final BigDecimal zero;
    public static final DecimalInMemoryPercentOperation$ MODULE$;

    private DecimalInMemoryPercentOperation$() {
    }

    static {
        MODULE$ = new DecimalInMemoryPercentOperation$();
        zero = new BigDecimal(0L);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DecimalInMemoryPercentOperation$.class);
    }

    public BigDecimal zero() {
        return zero;
    }

    public Observable<Document> run(Builder.Context cxt, RetainOperation.Info info, Observable<Document> from) {
        return Observable$.MODULE$.fromTask(from.toListL()).flatMap((Function1 & Serializable)all -> {
            Map grouped = all.groupBy((Function1 & Serializable)doc -> BsonETL$.MODULE$.get(doc, info.group()));
            Map totals = (Map)grouped.map((Function1 & Serializable)pair -> this.computeTotal(info, (Tuple2<Option<BsonValue>, List<Document>>)pair));
            return Observable$.MODULE$.fromIterable((Iterable)all.map((Function1 & Serializable)doc -> this.computePercent(info, (Map<Option<BsonValue>, BigDecimal>)totals, (Document)doc)));
        });
    }

    public Document computePercent(RetainOperation.Info info, Map<Option<BsonValue>, BigDecimal> totals, Document doc) {
        return (Document)totals.get((Object)BsonETL$.MODULE$.get(doc, info.group())).map((Function1 & Serializable)total -> {
            if (!BoxesRunTime.equals((Object)total, (Object)this.zero())) {
                BigDecimal actual = (BigDecimal)BsonETL$.MODULE$.get(doc, info.field()).map((Function1 & Serializable)bv -> this.getValue((BsonValue)bv)).getOrElse(this::$anonfun$4);
                return BsonETL$.MODULE$.put(doc, info.output(), (BsonValue)BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(actual.divide((BigDecimal)total, DecimalOperation$.MODULE$.DecimalMathContext()))));
            }
            return BsonETL$.MODULE$.put(doc, info.output(), (BsonValue)BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(this.zero())));
        }).getOrElse(() -> this.computePercent$$anonfun$2(doc));
    }

    public Tuple2<Option<BsonValue>, BigDecimal> computeTotal(RetainOperation.Info info, Tuple2<Option<BsonValue>, List<Document>> pair) {
        Option option = (Option)Predef$.MODULE$.ArrowAssoc(pair._1());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, (Object)this.sumValues((List<BsonValue>)((List)pair._2()).flatMap((Function1 & Serializable)_$1 -> BsonETL$.MODULE$.get(_$1, info.field()))));
    }

    public BigDecimal sumValues(List<BsonValue> values) {
        return (BigDecimal)values.map((Function1 & Serializable)bv -> this.getValue((BsonValue)bv)).foldLeft((Object)this.zero(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                BigDecimal a = (BigDecimal)tuple2._1();
                BigDecimal b = (BigDecimal)tuple2._2();
                return a.add(b);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public BigDecimal getValue(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 bi = (BsonInt32)bsonValue;
            return bi.decimal128Value().bigDecimalValue();
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 bi = (BsonInt64)bsonValue;
            return bi.decimal128Value().bigDecimalValue();
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble bi = (BsonDouble)bsonValue;
            return new BigDecimal(bi.doubleValue());
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 bi = (BsonDecimal128)bsonValue;
            return bi.decimal128Value().bigDecimalValue();
        }
        return this.zero();
    }

    private final BigDecimal $anonfun$4() {
        return this.zero();
    }

    private final Document computePercent$$anonfun$2(Document doc$2) {
        return doc$2;
    }
}

