/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.timeops;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.timeops.ExtractComponent;
import ambience.etl.timeops.ExtractComponent$Info$;
import ambience.etl.timeops.ExtractComponent$TimeAMPM$;
import ambience.etl.timeops.ExtractComponent$TimeClockHour$;
import ambience.etl.timeops.ExtractComponent$TimeMilitaryHour$;
import ambience.etl.timeops.ExtractComponent$TimeMinutes$;
import ambience.etl.timeops.ExtractComponent$TimeSeconds$;
import ambience.etl.timeops.TimeUtil$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class ExtractComponent$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    public static final ExtractComponent$Info$ Info;
    private static final String[] timeComponents;
    public static final ExtractComponent$TimeMilitaryHour$ TimeMilitaryHour;
    public static final ExtractComponent$TimeMinutes$ TimeMinutes;
    public static final ExtractComponent$TimeAMPM$ TimeAMPM;
    public static final ExtractComponent$TimeSeconds$ TimeSeconds;
    public static final ExtractComponent$TimeClockHour$ TimeClockHour;
    private static final List selectChoices;
    private static final DateTimeFormatter timeFormatter;
    public static final ExtractComponent$ MODULE$;

    private ExtractComponent$() {
    }

    static {
        MODULE$ = new ExtractComponent$();
        stepType = ETLStepType$.MODULE$.apply("time.ExtractComponent");
        timeComponents = new String[]{"Hour (Clock)", "Hour (Military)", "Minutes", "Seconds", "AM/PM"};
        selectChoices = Predef$.MODULE$.wrapRefArray((Object[])MODULE$.timeComponents()).toList().map((Function1 & Serializable)k -> Panel.SelectChoice$.MODULE$.apply(k, Json$.MODULE$.fromString(k)));
        timeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExtractComponent$.class);
    }

    public String stepType() {
        return stepType;
    }

    public String[] timeComponents() {
        return timeComponents;
    }

    public List<Panel.SelectChoice> selectChoices() {
        return selectChoices;
    }

    public DateTimeFormatter timeFormatter() {
        return timeFormatter;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "targetType";
        String string3 = "destField";
        int size = 3;
        ExtractComponent.Info info = (ExtractComponent.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        Panel.Item fieldName = PanelItem$.MODULE$.text("sourceField", "Time Field", info.sourceField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item targetType = PanelItem$.MODULE$.select("targetType", "Extract", Json$.MODULE$.fromString(info.targetType()), this.selectChoices(), true);
        Panel.Item destination = PanelItem$.MODULE$.text("destField", "Output Field", info.destField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(fieldName, targetType, destination));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "targetType";
        String string3 = "destField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> this.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> this.run((ExtractComponent.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(ExtractComponent.Info info, Observable<Document> from) {
        return from.map((Function1 & Serializable)record -> {
            ExtractComponent.TimeComponent timeComponent;
            Option source = record.get(info.sourceField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue());
            Option result = source.flatMap(arg_0 -> this.$anonfun$7(timeComponent = this.component(info), arg_0));
            Option option = result;
            if (option instanceof Some) {
                BsonValue value = (BsonValue)((Some)option).value();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(info.destField().trim()))) {
                    return BsonETL$.MODULE$.put(record, info.destField(), value);
                }
                return BsonETL$.MODULE$.put(record, info.sourceField(), value);
            }
            if (None$.MODULE$.equals(option)) {
                return record;
            }
            throw new MatchError((Object)option);
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private ExtractComponent.TimeComponent component(ExtractComponent.Info info) {
        Mirror.Singleton singleton;
        String string = info.targetType();
        switch (string == null ? 0 : string.hashCode()) {
            case -1565412161: {
                if (!"Minutes".equals(string)) break;
                singleton = ExtractComponent$TimeMinutes$.MODULE$;
                return singleton;
            }
            case -660217249: {
                if (!"Seconds".equals(string)) break;
                singleton = ExtractComponent$TimeSeconds$.MODULE$;
                return singleton;
            }
            case 62370496: {
                if (!"AM/PM".equals(string)) break;
                singleton = ExtractComponent$TimeAMPM$.MODULE$;
                return singleton;
            }
            case 499357191: {
                if (!"Hour (Clock)".equals(string)) break;
                singleton = ExtractComponent$TimeClockHour$.MODULE$;
                return singleton;
            }
        }
        singleton = ExtractComponent$TimeMilitaryHour$.MODULE$;
        return singleton;
    }

    public Option<BsonValue> doExtract(ExtractComponent.TimeComponent component, String source) {
        return TimeUtil$.MODULE$.maybeParse(source).flatMap((Function1 & Serializable)dt -> {
            ExtractComponent.TimeComponent timeComponent = component;
            if (ExtractComponent$TimeMilitaryHour$.MODULE$.equals(timeComponent)) {
                return this.doExtractMilitaryHour$1((LocalTime)dt);
            }
            if (ExtractComponent$TimeMinutes$.MODULE$.equals(timeComponent)) {
                return this.doExtractMinutes$1((LocalTime)dt);
            }
            if (ExtractComponent$TimeClockHour$.MODULE$.equals(timeComponent)) {
                return this.doExtractClockHour$1((LocalTime)dt);
            }
            if (ExtractComponent$TimeSeconds$.MODULE$.equals(timeComponent)) {
                return this.doExtractSeconds$1((LocalTime)dt);
            }
            if (ExtractComponent$TimeAMPM$.MODULE$.equals(timeComponent)) {
                return this.doExtractAMPM$1((LocalTime)dt);
            }
            throw new MatchError((Object)timeComponent);
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var2_1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        ExtractComponent$Info$ extractComponent$Info$ = ExtractComponent$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ExtractComponent.Info)extractComponent$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private final ExtractComponent.Info $anonfun$4() {
        return ExtractComponent$Info$.MODULE$.apply(ExtractComponent$Info$.MODULE$.$lessinit$greater$default$1(), ExtractComponent$Info$.MODULE$.$lessinit$greater$default$2(), ExtractComponent$Info$.MODULE$.$lessinit$greater$default$3());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item fieldName$1, Panel.Item targetType$1, Panel.Item destination$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{fieldName$1, targetType$1, destination$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var2_1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        ExtractComponent$Info$ extractComponent$Info$ = ExtractComponent$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ExtractComponent.Info)extractComponent$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        void var2_1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "sourceField";
        String string2 = "targetType";
        String string3 = "destField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            ExtractComponent.Info info2 = (ExtractComponent.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "sourceField";
            String string2 = "targetType";
            String string3 = "destField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$1.copy$default$1();
            String string5 = step$1.copy$default$2();
            String string6 = step$1.copy$default$3();
            String string7 = step$1.copy$default$4();
            String string8 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var2_1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 build$$anonfun$2() {
        ExtractComponent$Info$ extractComponent$Info$ = ExtractComponent$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ExtractComponent.Info)extractComponent$Info$.fromProduct((Product)p);
    }

    private final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ExtractComponent$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private final /* synthetic */ Option $anonfun$7(ExtractComponent.TimeComponent component$1$1, String source) {
        return this.doExtract(component$1$1, source);
    }

    private final Option doExtractMilitaryHour$1(LocalTime dt) {
        return Option$.MODULE$.apply((Object)BsonInt32$.MODULE$.apply(dt.getHour())).filter((Function1 & Serializable)_$2 -> _$2.getValue() < 24);
    }

    private final Option doExtractMinutes$1(LocalTime dt) {
        return Option$.MODULE$.apply((Object)BsonInt32$.MODULE$.apply(dt.getMinute()));
    }

    private final /* synthetic */ BsonInt32 doExtractClockHour$1$$anonfun$2(int _$3) {
        return BsonInt32$.MODULE$.apply(_$3);
    }

    private final Option doExtractClockHour$1(LocalTime dt) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)dt.getHour())).map((Function1)(JFunction1.mcII.sp & Serializable)hr -> {
            if (hr == 0) {
                return 12;
            }
            if (hr > 12) {
                return hr - 12;
            }
            return hr;
        }).map((Function1 & Serializable)_$3 -> this.doExtractClockHour$1$$anonfun$2(BoxesRunTime.unboxToInt((Object)_$3)));
    }

    private final Option doExtractSeconds$1(LocalTime dt) {
        return Option$.MODULE$.apply((Object)BsonInt32$.MODULE$.apply(dt.getSecond()));
    }

    private final /* synthetic */ String doExtractAMPM$1$$anonfun$1(int hr) {
        if (hr >= 12) {
            return "PM";
        }
        return "AM";
    }

    private final Option doExtractAMPM$1(LocalTime dt) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)dt.getHour())).map((Function1 & Serializable)hr -> this.doExtractAMPM$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)hr))).map((Function1 & Serializable)_$4 -> BsonString$.MODULE$.apply(_$4));
    }
}

