/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.atomic;

import monix.execution.atomic.AtomicFloat$;
import monix.execution.atomic.AtomicNumber;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.atomic.BoxedInt;

public final class AtomicFloat
extends AtomicNumber<Object> {
    private final BoxedInt ref;

    public static AtomicFloat apply(float f) {
        return AtomicFloat$.MODULE$.apply(f);
    }

    public static AtomicFloat create(float f, PaddingStrategy paddingStrategy, boolean bl) {
        return AtomicFloat$.MODULE$.create(f, paddingStrategy, bl);
    }

    public static AtomicFloat safe(float f, PaddingStrategy paddingStrategy) {
        return AtomicFloat$.MODULE$.safe(f, paddingStrategy);
    }

    public static AtomicFloat withPadding(float f, PaddingStrategy paddingStrategy) {
        return AtomicFloat$.MODULE$.withPadding(f, paddingStrategy);
    }

    public AtomicFloat(BoxedInt ref) {
        this.ref = ref;
    }

    @Override
    public float get() {
        return Float.intBitsToFloat(this.ref.volatileGet());
    }

    @Override
    public void set(float update) {
        this.ref.volatileSet(Float.floatToIntBits(update));
    }

    @Override
    public void lazySet(float update) {
        this.ref.lazySet(Float.floatToIntBits(update));
    }

    @Override
    public boolean compareAndSet(float expect, float update) {
        int expectLong = Float.floatToIntBits(expect);
        int updateLong = Float.floatToIntBits(update);
        return this.ref.compareAndSet(expectLong, updateLong);
    }

    @Override
    public float getAndSet(float update) {
        return Float.intBitsToFloat(this.ref.getAndSet(Float.floatToIntBits(update)));
    }

    @Override
    public void increment(int v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.incrementOp(current, v))) {
        }
    }

    @Override
    public int increment$default$1() {
        return 1;
    }

    @Override
    public void add(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.plusOp(current, v))) {
        }
    }

    @Override
    public float incrementAndGet(int v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.incrementOp(current, v))) {
        }
        return update;
    }

    @Override
    public int incrementAndGet$default$1() {
        return 1;
    }

    @Override
    public float addAndGet(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.plusOp(current, v))) {
        }
        return update;
    }

    @Override
    public float getAndIncrement(int v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.incrementOp(current, v))) {
        }
        return current;
    }

    @Override
    public int getAndIncrement$default$1() {
        return 1;
    }

    @Override
    public float getAndAdd(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.plusOp(current, v))) {
        }
        return current;
    }

    @Override
    public void subtract(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.minusOp(current, v))) {
        }
    }

    @Override
    public float subtractAndGet(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.minusOp(current, v))) {
        }
        return update;
    }

    @Override
    public float getAndSubtract(float v) {
        float update;
        float current;
        AtomicFloat atomicFloat = this;
        while (!atomicFloat.compareAndSet(current = atomicFloat.get(), update = atomicFloat.minusOp(current, v))) {
        }
        return current;
    }

    @Override
    public void decrement(int v) {
        this.increment(-v);
    }

    @Override
    public int decrement$default$1() {
        return 1;
    }

    @Override
    public float decrementAndGet(int v) {
        return this.incrementAndGet(-v);
    }

    @Override
    public int decrementAndGet$default$1() {
        return 1;
    }

    @Override
    public float getAndDecrement(int v) {
        return this.getAndIncrement(-v);
    }

    @Override
    public int getAndDecrement$default$1() {
        return 1;
    }

    private float plusOp(float a, float b) {
        return a + b;
    }

    private float minusOp(float a, float b) {
        return a - b;
    }

    private float incrementOp(float a, int b) {
        return a + (float)b;
    }
}

