/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.forkJoin;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;

public final class StandardWorkerThreadFactory
implements ThreadFactory,
ForkJoinPool.ForkJoinWorkerThreadFactory {
    private final String prefix;
    private final Thread.UncaughtExceptionHandler uncaught;
    private final boolean daemonic;

    public StandardWorkerThreadFactory(String prefix, Thread.UncaughtExceptionHandler uncaught, boolean daemonic) {
        this.prefix = prefix;
        this.uncaught = uncaught;
        this.daemonic = daemonic;
    }

    public <T extends Thread> T wire(T thread) {
        thread.setDaemon(this.daemonic);
        thread.setUncaughtExceptionHandler(this.uncaught);
        thread.setName(new StringBuilder(1).append(this.prefix).append("-").append(thread.getId()).toString());
        return thread;
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.wire(new Thread(r));
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return this.wire(new ForkJoinWorkerThread(pool){});
    }
}

