/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.schedulers;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import monix.execution.Cancelable;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.cancelables.OrderedCancelable;
import monix.execution.cancelables.OrderedCancelable$;
import monix.execution.internal.InterceptRunnable$;
import monix.execution.schedulers.ReferenceScheduler$WrappedScheduler$;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ReferenceScheduler
extends Scheduler {
    public static long clockRealTime$(ReferenceScheduler $this, TimeUnit unit) {
        return $this.clockRealTime(unit);
    }

    @Override
    default public long clockRealTime(TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), package$.MODULE$.MILLISECONDS());
    }

    public static long clockMonotonic$(ReferenceScheduler $this, TimeUnit unit) {
        return $this.clockMonotonic(unit);
    }

    @Override
    default public long clockMonotonic(TimeUnit unit) {
        return unit.convert(System.nanoTime(), package$.MODULE$.NANOSECONDS());
    }

    public static Cancelable scheduleWithFixedDelay$(ReferenceScheduler $this, long initialDelay, long delay, TimeUnit unit, Runnable r) {
        return $this.scheduleWithFixedDelay(initialDelay, delay, unit, r);
    }

    @Override
    default public Cancelable scheduleWithFixedDelay(long initialDelay, long delay, TimeUnit unit, Runnable r) {
        OrderedCancelable sub = OrderedCancelable$.MODULE$.apply();
        this.monix$execution$schedulers$ReferenceScheduler$$_$loop$1(unit, r, sub, initialDelay, delay);
        return sub;
    }

    public static Cancelable scheduleAtFixedRate$(ReferenceScheduler $this, long initialDelay, long period, TimeUnit unit, Runnable r) {
        return $this.scheduleAtFixedRate(initialDelay, period, unit, r);
    }

    @Override
    default public Cancelable scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, Runnable r) {
        OrderedCancelable sub = OrderedCancelable$.MODULE$.apply();
        long initialMs = package$.MODULE$.MILLISECONDS().convert(initialDelay, unit);
        long periodMs = package$.MODULE$.MILLISECONDS().convert(period, unit);
        this.monix$execution$schedulers$ReferenceScheduler$$_$loop$2(r, sub, initialMs, periodMs);
        return sub;
    }

    public static Scheduler withExecutionModel$(ReferenceScheduler $this, ExecutionModel em) {
        return $this.withExecutionModel(em);
    }

    @Override
    default public Scheduler withExecutionModel(ExecutionModel em) {
        return ReferenceScheduler$WrappedScheduler$.MODULE$.apply(this, em, ReferenceScheduler$WrappedScheduler$.MODULE$.$lessinit$greater$default$3());
    }

    public static Scheduler withUncaughtExceptionReporter$(ReferenceScheduler $this, UncaughtExceptionReporter r) {
        return $this.withUncaughtExceptionReporter(r);
    }

    @Override
    default public Scheduler withUncaughtExceptionReporter(UncaughtExceptionReporter r) {
        return ReferenceScheduler$WrappedScheduler$.MODULE$.apply(this, this.executionModel(), r);
    }

    public static void monix$execution$schedulers$ReferenceScheduler$$_$loop$1$(ReferenceScheduler $this, TimeUnit unit$1, Runnable r$1, OrderedCancelable sub$1, long initialDelay, long delay) {
        $this.monix$execution$schedulers$ReferenceScheduler$$_$loop$1(unit$1, r$1, sub$1, initialDelay, delay);
    }

    default public void monix$execution$schedulers$ReferenceScheduler$$_$loop$1(TimeUnit unit$1, Runnable r$1, OrderedCancelable sub$1, long initialDelay, long delay) {
        if (!sub$1.isCanceled()) {
            sub$1.$colon$eq(this.scheduleOnce(initialDelay, unit$1, new Runnable(unit$1, r$1, sub$1, delay, this){
                private final TimeUnit unit$2;
                private final Runnable r$2;
                private final OrderedCancelable sub$2;
                private final long delay$1;
                private final /* synthetic */ ReferenceScheduler $outer;
                {
                    this.unit$2 = unit$3;
                    this.r$2 = r$5;
                    this.sub$2 = sub$5;
                    this.delay$1 = delay$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.r$2.run();
                    this.$outer.monix$execution$schedulers$ReferenceScheduler$$_$loop$1(this.unit$2, this.r$2, this.sub$2, this.delay$1, this.delay$1);
                }
            }));
        }
    }

    public static void monix$execution$schedulers$ReferenceScheduler$$_$loop$2$(ReferenceScheduler $this, Runnable r$3, OrderedCancelable sub$3, long initialDelayMs, long periodMs) {
        $this.monix$execution$schedulers$ReferenceScheduler$$_$loop$2(r$3, sub$3, initialDelayMs, periodMs);
    }

    default public void monix$execution$schedulers$ReferenceScheduler$$_$loop$2(Runnable r$3, OrderedCancelable sub$3, long initialDelayMs, long periodMs) {
        long startedAtMillis = this.clockMonotonic(package$.MODULE$.MILLISECONDS()) + initialDelayMs;
        if (!sub$3.isCanceled()) {
            sub$3.$colon$eq(this.scheduleOnce(initialDelayMs, package$.MODULE$.MILLISECONDS(), new Runnable(r$3, sub$3, periodMs, startedAtMillis, this){
                private final Runnable r$4;
                private final OrderedCancelable sub$4;
                private final long periodMs$1;
                private final long startedAtMillis$1;
                private final /* synthetic */ ReferenceScheduler $outer;
                {
                    this.r$4 = r$6;
                    this.sub$4 = sub$6;
                    this.periodMs$1 = periodMs$2;
                    this.startedAtMillis$1 = startedAtMillis$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.r$4.run();
                    long durationMillis = this.$outer.clockMonotonic(package$.MODULE$.MILLISECONDS()) - this.startedAtMillis$1;
                    long d = this.periodMs$1 - durationMillis;
                    long delay = d >= 0L ? d : 0L;
                    this.$outer.monix$execution$schedulers$ReferenceScheduler$$_$loop$2(this.r$4, this.sub$4, delay, this.periodMs$1);
                }
            }));
        }
    }

    private static final class WrappedScheduler
    implements ExecutionContext,
    Scheduler,
    Product {
        private final Scheduler s;
        private final ExecutionModel executionModel;
        private final UncaughtExceptionReporter reporter;
        private final UncaughtExceptionReporter reporterRef;

        public static WrappedScheduler apply(Scheduler scheduler, ExecutionModel executionModel, UncaughtExceptionReporter uncaughtExceptionReporter) {
            return ReferenceScheduler$WrappedScheduler$.MODULE$.apply(scheduler, executionModel, uncaughtExceptionReporter);
        }

        public static WrappedScheduler fromProduct(Product product) {
            return ReferenceScheduler$WrappedScheduler$.MODULE$.fromProduct(product);
        }

        public static WrappedScheduler unapply(WrappedScheduler wrappedScheduler) {
            return ReferenceScheduler$WrappedScheduler$.MODULE$.unapply(wrappedScheduler);
        }

        public static UncaughtExceptionReporter $lessinit$greater$default$3() {
            return ReferenceScheduler$WrappedScheduler$.MODULE$.$lessinit$greater$default$3();
        }

        public WrappedScheduler(Scheduler s, ExecutionModel executionModel, UncaughtExceptionReporter reporter) {
            this.s = s;
            this.executionModel = executionModel;
            this.reporter = reporter;
            ExecutionContext.$init$((ExecutionContext)this);
            this.reporterRef = reporter == null ? s : reporter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WrappedScheduler)) return false;
            WrappedScheduler wrappedScheduler = (WrappedScheduler)object;
            Scheduler scheduler = this.s();
            Scheduler scheduler2 = wrappedScheduler.s();
            if (scheduler == null) {
                if (scheduler2 != null) {
                    return false;
                }
            } else if (!scheduler.equals(scheduler2)) return false;
            ExecutionModel executionModel = this.executionModel();
            ExecutionModel executionModel2 = wrappedScheduler.executionModel();
            if (executionModel == null) {
                if (executionModel2 != null) {
                    return false;
                }
            } else if (!executionModel.equals(executionModel2)) return false;
            UncaughtExceptionReporter uncaughtExceptionReporter = this.reporter();
            UncaughtExceptionReporter uncaughtExceptionReporter2 = wrappedScheduler.reporter();
            if (uncaughtExceptionReporter == null) {
                if (uncaughtExceptionReporter2 == null) return true;
                return false;
            } else {
                if (!uncaughtExceptionReporter.equals(uncaughtExceptionReporter2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WrappedScheduler;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WrappedScheduler";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "s";
                    break;
                }
                case 1: {
                    string = "executionModel";
                    break;
                }
                case 2: {
                    string = "reporter";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Scheduler s() {
            return this.s;
        }

        @Override
        public ExecutionModel executionModel() {
            return this.executionModel;
        }

        public UncaughtExceptionReporter reporter() {
            return this.reporter;
        }

        @Override
        public void execute(Runnable runnable) {
            this.s().execute(InterceptRunnable$.MODULE$.apply(runnable, this.reporter()));
        }

        @Override
        public void reportFailure(Throwable t) {
            this.reporterRef.reportFailure(t);
        }

        @Override
        public Cancelable scheduleOnce(long initialDelay, TimeUnit unit, Runnable r) {
            return this.s().scheduleOnce(initialDelay, unit, r);
        }

        @Override
        public Cancelable scheduleWithFixedDelay(long initialDelay, long delay, TimeUnit unit, Runnable r) {
            return this.s().scheduleWithFixedDelay(initialDelay, delay, unit, r);
        }

        @Override
        public Cancelable scheduleAtFixedRate(long initialDelay, long period, TimeUnit unit, Runnable r) {
            return this.s().scheduleAtFixedRate(initialDelay, period, unit, r);
        }

        @Override
        public long clockRealTime(TimeUnit unit) {
            return this.s().clockRealTime(unit);
        }

        @Override
        public long clockMonotonic(TimeUnit unit) {
            return this.s().clockMonotonic(unit);
        }

        @Override
        public Scheduler withExecutionModel(ExecutionModel em) {
            return this.copy(this.s(), em, this.copy$default$3());
        }

        @Override
        public long features() {
            return this.s().features();
        }

        @Override
        public Scheduler withUncaughtExceptionReporter(UncaughtExceptionReporter r) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), r);
        }

        public WrappedScheduler copy(Scheduler s, ExecutionModel executionModel, UncaughtExceptionReporter reporter) {
            return new WrappedScheduler(s, executionModel, reporter);
        }

        public Scheduler copy$default$1() {
            return this.s();
        }

        public ExecutionModel copy$default$2() {
            return this.executionModel();
        }

        public UncaughtExceptionReporter copy$default$3() {
            return this.reporter();
        }

        public Scheduler _1() {
            return this.s();
        }

        public ExecutionModel _2() {
            return this.executionModel();
        }

        public UncaughtExceptionReporter _3() {
            return this.reporter();
        }
    }
}

