/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.schedulers;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import monix.execution.Cancelable;
import monix.execution.ExecutionModel;
import monix.execution.Features$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.execution.atomic.AtomicAny;
import monix.execution.schedulers.BatchingScheduler;
import monix.execution.schedulers.ReferenceScheduler;
import monix.execution.schedulers.TestScheduler$;
import monix.execution.schedulers.TestScheduler$State$;
import monix.execution.schedulers.TestScheduler$Task$;
import monix.execution.schedulers.TrampolineExecutionContext;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class TestScheduler
implements ExecutionContext,
Scheduler,
ReferenceScheduler,
BatchingScheduler {
    private TrampolineExecutionContext monix$execution$schedulers$BatchingScheduler$$trampoline;
    private final AtomicAny<State> stateRef;
    private final ExecutionModel executionModel;
    private final long features;

    public static TestScheduler apply() {
        return TestScheduler$.MODULE$.apply();
    }

    public static TestScheduler apply(ExecutionModel executionModel) {
        return TestScheduler$.MODULE$.apply(executionModel);
    }

    public TestScheduler(AtomicAny<State> stateRef, ExecutionModel executionModel) {
        this.stateRef = stateRef;
        this.executionModel = executionModel;
        ExecutionContext.$init$((ExecutionContext)this);
        BatchingScheduler.$init$(this);
        this.features = Features$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{Scheduler$.MODULE$.BATCHING()}));
        Statics.releaseFence();
    }

    @Override
    public TrampolineExecutionContext monix$execution$schedulers$BatchingScheduler$$trampoline() {
        return this.monix$execution$schedulers$BatchingScheduler$$trampoline;
    }

    @Override
    public void monix$execution$schedulers$BatchingScheduler$_setter_$monix$execution$schedulers$BatchingScheduler$$trampoline_$eq(TrampolineExecutionContext x$0) {
        this.monix$execution$schedulers$BatchingScheduler$$trampoline = x$0;
    }

    @Override
    public ExecutionModel executionModel() {
        return this.executionModel;
    }

    public State state() {
        return this.stateRef.get();
    }

    @Override
    public long clockRealTime(TimeUnit unit) {
        FiniteDuration d = this.stateRef.get().clock();
        return unit.convert(d.length(), d.unit());
    }

    @Override
    public long clockMonotonic(TimeUnit unit) {
        return this.clockRealTime(unit);
    }

    @Override
    public Cancelable scheduleOnce(long initialDelay, TimeUnit unit, Runnable r) {
        Cancelable cancelable;
        TestScheduler testScheduler = this;
        while (true) {
            State current;
            Tuple2<Cancelable, State> tuple2;
            if ((tuple2 = TestScheduler$.MODULE$.monix$execution$schedulers$TestScheduler$$$scheduleOnce(current = testScheduler.stateRef.get(), FiniteDuration$.MODULE$.apply(initialDelay, unit), r, (Function1<Task, BoxedUnit>)(JProcedure1 & Serializable)t -> testScheduler.cancelTask((Task)t))) == null) {
                throw new MatchError(tuple2);
            }
            Cancelable cancelable2 = (Cancelable)tuple2._1();
            State newState = (State)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)cancelable2, (Object)newState);
            cancelable = (Cancelable)tuple22._1();
            State newState2 = (State)tuple22._2();
            if (testScheduler.stateRef.compareAndSet(current, newState2)) break;
        }
        return cancelable;
    }

    @Override
    public void executeAsync(Runnable r) {
        State update;
        State current;
        TestScheduler testScheduler = this;
        while (!testScheduler.stateRef.compareAndSet(current = testScheduler.stateRef.get(), update = TestScheduler$.MODULE$.monix$execution$schedulers$TestScheduler$$$execute(current, r))) {
        }
    }

    @Override
    public void reportFailure(Throwable t) {
        State update;
        State current;
        TestScheduler testScheduler = this;
        while (!testScheduler.stateRef.compareAndSet(current = testScheduler.stateRef.get(), update = current.copy(current.copy$default$1(), current.copy$default$2(), current.copy$default$3(), t))) {
        }
    }

    @Override
    public TestScheduler withExecutionModel(ExecutionModel em) {
        return new TestScheduler(this.stateRef, em);
    }

    @Override
    public long features() {
        return this.features;
    }

    public boolean tickOne() {
        boolean bl;
        block6: {
            Tuple2 tuple2;
            State current;
            Option<Tuple2<Task, SortedSet<Task>>> option;
            TestScheduler testScheduler = this;
            while ((option = testScheduler.extractOneTask(current = testScheduler.stateRef.get(), current.clock())) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Task head = (Task)tuple2._1();
                SortedSet rest = (SortedSet)tuple2._2();
                if (!testScheduler.stateRef.compareAndSet(current, current.copy(current.copy$default$1(), current.copy$default$2(), (SortedSet<Task>)rest, current.copy$default$4()))) continue;
                try {
                    head.task().run();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        testScheduler.reportFailure(ex);
                    }
                    throw throwable;
                }
                bl = true;
                break block6;
            }
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
        }
        return bl;
    }

    public void tick(FiniteDuration time, Option<Object> maxImmediateTasks) {
        this.loop$1(time, 0, BoxesRunTime.unboxToInt((Object)maxImmediateTasks.getOrElse(TestScheduler::tick$$anonfun$1)));
    }

    public FiniteDuration tick$default$1() {
        return Duration$.MODULE$.Zero();
    }

    public Option<Object> tick$default$2() {
        return None$.MODULE$;
    }

    private void cancelTask(Task t) {
        Throwable throwable;
        SortedSet sortedSet;
        FiniteDuration finiteDuration;
        long l;
        State update;
        State current;
        TestScheduler testScheduler = this;
        do {
            current = testScheduler.stateRef.get();
            sortedSet = (SortedSet)current.tasks().$minus((Object)t);
        } while (!testScheduler.stateRef.compareAndSet(current, update = current.copy(l = current.copy$default$1(), finiteDuration = current.copy$default$2(), (SortedSet<Task>)sortedSet, throwable = current.copy$default$4())));
    }

    private Option<Tuple2<Task, SortedSet<Task>>> extractOneTask(State current, FiniteDuration clock) {
        None$ none$;
        Option option = current.tasks().headOption().filter((Function1 & Serializable)_$1 -> _$1.runsAt().$less$eq((Object)clock));
        if (option instanceof Some) {
            Task value = (Task)((Some)option).value();
            FiniteDuration firstTick = value.runsAt();
            Task[] arr = (Task[])current.tasks().iterator().takeWhile((Function1 & Serializable)_$2 -> {
                FiniteDuration finiteDuration = _$2.runsAt();
                FiniteDuration finiteDuration2 = firstTick;
                return !(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null);
            }).take(10).toArray(ClassTag$.MODULE$.apply(Task.class));
            Task forExecution = arr[Random$.MODULE$.nextInt(arr.length)];
            SortedSet remaining = (SortedSet)current.tasks().$minus((Object)forExecution);
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)forExecution, (Object)remaining));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private final void loop$1(FiniteDuration time, int iterCount, int maxIterCount) {
        block8: {
            Option<Tuple2<Task, SortedSet<Task>>> option;
            int n = maxIterCount;
            int n2 = iterCount;
            FiniteDuration finiteDuration = time;
            while (true) {
                Tuple2 tuple2;
                FiniteDuration currentClock;
                State current;
                if ((option = this.extractOneTask(current = this.stateRef.get(), currentClock = current.clock().$plus(finiteDuration))) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Task head = (Task)tuple2._1();
                    SortedSet rest = (SortedSet)tuple2._2();
                    if (!this.stateRef.compareAndSet(current, current.copy(current.copy$default$1(), head.runsAt(), (SortedSet<Task>)rest, current.copy$default$4()))) continue;
                    try {
                        head.task().run();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            this.reportFailure(ex);
                        }
                        throw throwable;
                    }
                    FiniteDuration time2 = currentClock.$minus(head.runsAt());
                    FiniteDuration finiteDuration2 = finiteDuration;
                    FiniteDuration finiteDuration3 = time2;
                    if ((finiteDuration2 != null ? !finiteDuration2.equals(finiteDuration3) : finiteDuration3 != null) || n == 0) {
                        FiniteDuration finiteDuration4 = time2;
                        int n3 = 0;
                        int n4 = 0;
                        finiteDuration = finiteDuration4;
                        n2 = n3;
                        n = n4;
                        continue;
                    }
                    int iterCount2 = n2 + 1;
                    if (iterCount2 < n) {
                        FiniteDuration finiteDuration5 = time2;
                        int n5 = iterCount2;
                        finiteDuration = finiteDuration5;
                        n2 = n5;
                        continue;
                    }
                    break block8;
                }
                if (!None$.MODULE$.equals(option)) break;
                if (!this.stateRef.compareAndSet(current, current.copy(current.copy$default$1(), currentClock, current.copy$default$3(), current.copy$default$4()))) {
                    continue;
                }
                break block8;
                break;
            }
            throw new MatchError(option);
        }
    }

    private static final int tick$$anonfun$1() {
        return 0;
    }

    public static final class State
    implements Product,
    Serializable {
        private final long lastID;
        private final FiniteDuration clock;
        private final SortedSet tasks;
        private final Throwable lastReportedError;

        public static State apply(long l, FiniteDuration finiteDuration, SortedSet<Task> sortedSet, Throwable throwable) {
            return TestScheduler$State$.MODULE$.apply(l, finiteDuration, sortedSet, throwable);
        }

        public static State fromProduct(Product product) {
            return TestScheduler$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return TestScheduler$State$.MODULE$.unapply(state);
        }

        public State(long lastID, FiniteDuration clock, SortedSet<Task> tasks, Throwable lastReportedError) {
            this.lastID = lastID;
            this.clock = clock;
            this.tasks = tasks;
            this.lastReportedError = lastReportedError;
            if (tasks.headOption().exists((Function1 & Serializable)_$3 -> _$3.runsAt().$less((Object)clock))) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"The runsAt for any task must never be in the past");
            }
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastID()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clock()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tasks()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.lastReportedError()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.lastID() != state.lastID()) return false;
            FiniteDuration finiteDuration = this.clock();
            FiniteDuration finiteDuration2 = state.clock();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            SortedSet<Task> sortedSet = this.tasks();
            SortedSet<Task> sortedSet2 = state.tasks();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            Throwable throwable = this.lastReportedError();
            Throwable throwable2 = state.lastReportedError();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "lastID";
                    break;
                }
                case 1: {
                    string = "clock";
                    break;
                }
                case 2: {
                    string = "tasks";
                    break;
                }
                case 3: {
                    string = "lastReportedError";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public long lastID() {
            return this.lastID;
        }

        public FiniteDuration clock() {
            return this.clock;
        }

        public SortedSet<Task> tasks() {
            return this.tasks;
        }

        public Throwable lastReportedError() {
            return this.lastReportedError;
        }

        public State copy(long lastID, FiniteDuration clock, SortedSet<Task> tasks, Throwable lastReportedError) {
            return new State(lastID, clock, tasks, lastReportedError);
        }

        public long copy$default$1() {
            return this.lastID();
        }

        public FiniteDuration copy$default$2() {
            return this.clock();
        }

        public SortedSet<Task> copy$default$3() {
            return this.tasks();
        }

        public Throwable copy$default$4() {
            return this.lastReportedError();
        }

        public long _1() {
            return this.lastID();
        }

        public FiniteDuration _2() {
            return this.clock();
        }

        public SortedSet<Task> _3() {
            return this.tasks();
        }

        public Throwable _4() {
            return this.lastReportedError();
        }
    }

    public static final class Task
    implements Product,
    Serializable {
        private final long id;
        private final Runnable task;
        private final FiniteDuration runsAt;

        public static Task apply(long l, Runnable runnable, FiniteDuration finiteDuration) {
            return TestScheduler$Task$.MODULE$.apply(l, runnable, finiteDuration);
        }

        public static Task fromProduct(Product product) {
            return TestScheduler$Task$.MODULE$.fromProduct(product);
        }

        public static Ordering<Task> ordering() {
            return TestScheduler$Task$.MODULE$.ordering();
        }

        public static Task unapply(Task task) {
            return TestScheduler$Task$.MODULE$.unapply(task);
        }

        public Task(long id, Runnable task, FiniteDuration runsAt) {
            this.id = id;
            this.task = task;
            this.runsAt = runsAt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.task()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.runsAt()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Task)) return false;
            Task task = (Task)object;
            if (this.id() != task.id()) return false;
            Runnable runnable = this.task();
            Runnable runnable2 = task.task();
            if (runnable == null) {
                if (runnable2 != null) {
                    return false;
                }
            } else if (!runnable.equals(runnable2)) return false;
            FiniteDuration finiteDuration = this.runsAt();
            FiniteDuration finiteDuration2 = task.runsAt();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Task;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Task";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "task";
                    break;
                }
                case 2: {
                    string = "runsAt";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public long id() {
            return this.id;
        }

        public Runnable task() {
            return this.task;
        }

        public FiniteDuration runsAt() {
            return this.runsAt;
        }

        public Task copy(long id, Runnable task, FiniteDuration runsAt) {
            return new Task(id, task, runsAt);
        }

        public long copy$default$1() {
            return this.id();
        }

        public Runnable copy$default$2() {
            return this.task();
        }

        public FiniteDuration copy$default$3() {
            return this.runsAt();
        }

        public long _1() {
            return this.id();
        }

        public Runnable _2() {
            return this.task();
        }

        public FiniteDuration _3() {
            return this.runsAt();
        }
    }
}

