/*
 * Decompiled with CFR 0.152.
 */
package ambience.ocr.crop;

import ambience.module.UserDB;
import ambience.ocr.CroppedInfo;
import ambience.ocr.I18NContentHelper$;
import ambience.ocr.I18NContentHolder;
import ambience.ocr.I18NLanguage;
import ambience.ocr.OCRResult;
import ambience.ocr.OCRResult$;
import ambience.ocr.Util$;
import ambience.ocr.crop.OCRRunner;
import ambience.ocr.crop.OCRRunner$;
import ambience.ocr.host.OCRHostContext;
import ambience.ocr.host.OCRJsonHolder;
import ambience.ocr.validation.DatasetLookupValidator$;
import ambience.ocr.validation.DateValidator;
import ambience.ocr.validation.DateValidator$;
import ambience.ocr.validation.DecimalValidator$;
import ambience.ocr.validation.FieldValidationHolder;
import ambience.ocr.validation.IntegerValidator$;
import ambience.ocr.validation.LookupValidator$;
import ambience.ocr.validation.RegexValidator$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import java.io.Serializable;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class OCRHelper$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(OCRHelper$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Map<Object, Object> charToNumMap;
    public static final OCRHelper$ MODULE$;

    private OCRHelper$() {
    }

    static {
        MODULE$ = new OCRHelper$();
        Object[] objectArray = new Tuple2[6];
        Character c = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'S'));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c, (Object)BoxesRunTime.boxToCharacter((char)'5'));
        Character c2 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'I'));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c2, (Object)BoxesRunTime.boxToCharacter((char)'1'));
        Character c3 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'O'));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c3, (Object)BoxesRunTime.boxToCharacter((char)'0'));
        Character c4 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'Z'));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c4, (Object)BoxesRunTime.boxToCharacter((char)'2'));
        Character c5 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'A'));
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c5, (Object)BoxesRunTime.boxToCharacter((char)'4'));
        Character c6 = (Character)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'B'));
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)c6, (Object)BoxesRunTime.boxToCharacter((char)'8'));
        charToNumMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OCRHelper$.class);
    }

    public Task<Either<String, OCRResult>> run(UserDB.User user, OCRHostContext cxt, String fieldId, Locale locale, Json ocrState, CroppedInfo info, FieldValidationHolder fh, byte[] bytes, Option<I18NLanguage> i18nContentLang) {
        this.log().debug(() -> this.run$$anonfun$1(info), Line$.MODULE$.apply(26), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.run"));
        I18NContentHolder i18nContentHolder = I18NContentHelper$.MODULE$.getHolderFromState(ocrState);
        Option<I18NLanguage> localOpt = I18NContentHelper$.MODULE$.getLanguage(locale, i18nContentHolder, (Option<I18NLanguage>)fh.locale(), i18nContentLang);
        this.log().debug(() -> this.run$$anonfun$2(localOpt), Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.run"));
        Locale actualLocale = Util$.MODULE$.getLocale((Option<String>)localOpt.map((Function1 & Serializable)_$1 -> _$1.value()));
        Either<String, OCRRunner.OCRValue> either = OCRRunner$.MODULE$.apply(cxt.ocrHolder(), fh, bytes);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg));
        }
        if (either instanceof Right) {
            OCRRunner.OCRValue res = (OCRRunner.OCRValue)((Right)either).value();
            return this.validate(user, cxt.ocrHolder(), fieldId, i18nContentHolder, actualLocale, fh, res.value().trim()).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2));
        }
        throw new MatchError(either);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Task<OCRResult> validate(UserDB.User user, OCRJsonHolder ocrHolder, String fieldId, I18NContentHolder i18NContentHolder, Locale locale, FieldValidationHolder fh, String ocrValue) {
        Task task;
        String ocrArgs = (String)fh.ocrArgs().getOrElse(() -> this.$anonfun$2(ocrHolder));
        String string = fh.Type();
        switch (string == null ? 0 : string.hashCode()) {
            case -1097094790: {
                if (!"lookup".equals(string)) break;
                task = Task$.MODULE$.now((Object)this.validateLookup(locale, i18NContentHolder, fh, ocrValue));
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
            case -628561809: {
                if (!"dataset-lookup".equals(string)) break;
                task = this.validateDatasetLookup(user, fh, ocrValue);
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
            case 3076014: {
                if (!"date".equals(string)) break;
                task = Task$.MODULE$.now((Object)this.validateDate(locale, fh, ocrValue));
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
            case 108392519: {
                if (!"regex".equals(string)) break;
                task = Task$.MODULE$.now((Object)this.validateRegex(fh, ocrValue));
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
            case 1542263633: {
                if (!"decimal".equals(string)) break;
                task = Task$.MODULE$.now((Object)this.validateDecimal(locale, fh, ocrValue));
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
            case 1958052158: {
                if (!"integer".equals(string)) break;
                task = Task$.MODULE$.now((Object)this.validateInteger(locale, fh, ocrValue));
                return task.map((Function1 & Serializable)res -> {
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
                    Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
                    Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
                    String string = res.copy$default$1();
                    Option option = res.copy$default$2();
                    Option option2 = res.copy$default$3();
                    Option option3 = res.copy$default$4();
                    Option option4 = res.copy$default$5();
                    return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
                });
            }
        }
        task = Task$.MODULE$.now((Object)this.validateDefault(ocrValue));
        return task.map((Function1 & Serializable)res -> {
            this.log().info(() -> this.validate$$anonfun$1$$anonfun$1(fieldId, locale, fh, res, ocrArgs), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
            this.log().info(() -> this.validate$$anonfun$1$$anonfun$2(res), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validate"));
            Some some = Some$.MODULE$.apply((Object)locale.toLanguageTag());
            Some some2 = Some$.MODULE$.apply((Object)ocrArgs);
            String string = res.copy$default$1();
            Option option = res.copy$default$2();
            Option option2 = res.copy$default$3();
            Option option3 = res.copy$default$4();
            Option option4 = res.copy$default$5();
            return res.copy(string, option, option2, option3, option4, (Option)some, (Option)some2);
        });
    }

    public OCRResult validateInteger(Locale locale, FieldValidationHolder fh, String ocrValue) {
        Either<String, String> either = IntegerValidator$.MODULE$.run(locale, fh, this.cleanNumber(ocrValue));
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            this.log().warn(() -> this.validateInteger$$anonfun$1(msg), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validateInteger"));
            return OCRResult$.MODULE$.apply(ocrValue, (Option)None$.MODULE$, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        if (either instanceof Right) {
            String intStr = (String)((Right)either).value();
            return OCRResult$.MODULE$.apply(ocrValue, (Option)Some$.MODULE$.apply((Object)intStr), (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError(either);
    }

    public OCRResult validateDecimal(Locale locale, FieldValidationHolder fh, String ocrValue) {
        Either<String, String> either = DecimalValidator$.MODULE$.run(locale, fh, this.cleanNumber(ocrValue));
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            this.log().warn(() -> this.validateDecimal$$anonfun$1(msg), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.ocr.crop.OCRHelper.validateDecimal"));
            return OCRResult$.MODULE$.apply(ocrValue, (Option)None$.MODULE$, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        if (either instanceof Right) {
            String doubleStr = (String)((Right)either).value();
            return OCRResult$.MODULE$.apply(ocrValue, (Option)Some$.MODULE$.apply((Object)doubleStr), (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError(either);
    }

    public String cleanNumber(String str) {
        String s = str.replace(" ", "");
        String string = Predef$.MODULE$.augmentString(s);
        int firstDigitIdx = StringOps$.MODULE$.indexWhere$extension(string, (Function1 & Serializable)_$3 -> this.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$3)), StringOps$.MODULE$.indexWhere$default$2$extension(string));
        String sign = firstDigitIdx > 0 && s.charAt(firstDigitIdx - 1) == '-' ? "-" : "";
        return sign + StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s))), (Function1 & Serializable)v -> this.cleanNumber$$anonfun$1(BoxesRunTime.unboxToChar((Object)v)))))), (Function1 & Serializable)v -> this.cleanNumber$$anonfun$2(BoxesRunTime.unboxToChar((Object)v)))), (Function1 & Serializable)c -> this.cleanNumber$$anonfun$3(BoxesRunTime.unboxToChar((Object)c)));
    }

    public OCRResult validateRegex(FieldValidationHolder fh, String ocrValue) {
        Option valueStrOpt = RegexValidator$.MODULE$.run(fh, ocrValue);
        return OCRResult$.MODULE$.apply(ocrValue, valueStrOpt, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
    }

    public OCRResult validateDate(Locale locale, FieldValidationHolder fh, String ocrValue) {
        Either<String, DateValidator.Result> either = DateValidator$.MODULE$.run(locale, fh, ocrValue);
        if (either instanceof Left) {
            return OCRResult$.MODULE$.apply(ocrValue, (Option)None$.MODULE$, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        if (either instanceof Right) {
            DateValidator.Result res = (DateValidator.Result)((Right)either).value();
            return OCRResult$.MODULE$.apply(ocrValue, (Option)Some$.MODULE$.apply((Object)res.locale()), (Option)Some$.MODULE$.apply((Object)res.iso()), OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError(either);
    }

    public OCRResult validateLookup(Locale locale, I18NContentHolder i18NContentHolder, FieldValidationHolder fh, String ocrValue) {
        Option valueStrOpt = LookupValidator$.MODULE$.run(locale, i18NContentHolder, fh, ocrValue);
        return OCRResult$.MODULE$.apply(ocrValue, valueStrOpt, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
    }

    public Task<OCRResult> validateDatasetLookup(UserDB.User user, FieldValidationHolder fh, String ocrValue) {
        return DatasetLookupValidator$.MODULE$.run(user, fh, ocrValue).map((Function1 & Serializable)res -> OCRResult$.MODULE$.apply(ocrValue, res, (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7()));
    }

    public OCRResult validateDefault(String ocrValue) {
        return OCRResult$.MODULE$.apply(ocrValue, (Option)Some$.MODULE$.apply((Object)ocrValue), (Option)None$.MODULE$, OCRResult$.MODULE$.$lessinit$greater$default$4(), OCRResult$.MODULE$.$lessinit$greater$default$5(), OCRResult$.MODULE$.$lessinit$greater$default$6(), OCRResult$.MODULE$.$lessinit$greater$default$7());
    }

    private final Object run$$anonfun$1(CroppedInfo info$1) {
        return "OCR Crop info=" + info$1;
    }

    private final Object run$$anonfun$2(Option localOpt$1) {
        return "localOpt=" + localOpt$1;
    }

    private final String $anonfun$2(OCRJsonHolder ocrHolder$1) {
        return ocrHolder$1.tesseractArgs();
    }

    private final Object validate$$anonfun$1$$anonfun$1(String fieldId$2, Locale locale$3, FieldValidationHolder fh$2, OCRResult res$1, String ocrArgs$3) {
        return "OCR run on field=" + fieldId$2 + ", locale=" + locale$3.toLanguageTag() + ", type=" + fh$2.Type() + ", ocr string='" + res$1.ocrString() + "' with OCR args " + ocrArgs$3;
    }

    private final String validate$$anonfun$1$$anonfun$2$$anonfun$1() {
        return "";
    }

    private final String validate$$anonfun$1$$anonfun$2$$anonfun$2() {
        return "";
    }

    private final Object validate$$anonfun$1$$anonfun$2(OCRResult res$2) {
        return "OCR value='" + res$2.ocrValueOpt().getOrElse(this::validate$$anonfun$1$$anonfun$2$$anonfun$1) + "', corrected value='" + res$2.correctValueOpt().getOrElse(this::validate$$anonfun$1$$anonfun$2$$anonfun$2) + "'";
    }

    private final Object validateInteger$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private final Object validateDecimal$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private final /* synthetic */ boolean $anonfun$3(char _$3) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$3));
    }

    private final /* synthetic */ boolean cleanNumber$$anonfun$1(char v) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(v));
    }

    private final /* synthetic */ boolean cleanNumber$$anonfun$2(char v) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(v));
    }

    private final char cleanNumber$$anonfun$3$$anonfun$1(char c$1) {
        return c$1;
    }

    private final /* synthetic */ char cleanNumber$$anonfun$3(char c) {
        return BoxesRunTime.unboxToChar((Object)charToNumMap.getOrElse((Object)BoxesRunTime.boxToCharacter((char)c), () -> this.cleanNumber$$anonfun$3$$anonfun$1(c)));
    }
}

