/*
 * Decompiled with CFR 0.152.
 */
package ambience.ocr.etl;

import ambience.api.I18NAPI;
import ambience.bson.BsonETL$;
import ambience.etl.Builder;
import ambience.module.UserDB;
import ambience.ocr.AttachmentInfo;
import ambience.ocr.CropRoute$;
import ambience.ocr.CroppedInfo;
import ambience.ocr.FieldId;
import ambience.ocr.FieldId$;
import ambience.ocr.I18NCategory;
import ambience.ocr.I18NContentHelper$;
import ambience.ocr.I18NContentHolder;
import ambience.ocr.I18NContentHolder$;
import ambience.ocr.I18NHelper$;
import ambience.ocr.I18NLanguage;
import ambience.ocr.Lenses$;
import ambience.ocr.OCRResult;
import ambience.ocr.Util$;
import ambience.ocr.crop.OCRHelper$;
import ambience.ocr.crop.OCRRunner;
import ambience.ocr.crop.OCRRunner$;
import ambience.ocr.db.WorkflowDB;
import ambience.ocr.db.WorkflowDB$;
import ambience.ocr.etl.JsonLenses$;
import ambience.ocr.host.HostConfiguration$;
import ambience.ocr.host.OCRJsonHolder;
import ambience.ocr.validation.FieldValidationHolder;
import ambience.ocr.validation.FieldValidationHolder$;
import ambience.util.ExceptionUtil$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.webserver.I18N;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ETLUtil$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ETLUtil$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ETLUtil$ MODULE$ = new ETLUtil$();

    private ETLUtil$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ETLUtil$.class);
    }

    public Task<Either<String, BoxedUnit>> addToResultHistory(String workflowId, String instanceId, Json rec) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, instanceId)).flatMap((Function1 & Serializable)iInfo -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.loadWorkflowInstance((WorkflowDB.WFInstanceInfo)iInfo)).flatMap((Function1 & Serializable)instance -> EitherT$.MODULE$.apply(this.getResultHistory((Document)instance)).flatMap((Function1 & Serializable)results -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.updateResultHistory((WorkflowDB.WFInstanceInfo)iInfo, (Vector<Json>)((Vector)results.$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Json[]{rec})))))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, BoxedUnit>> addToAttachments(String field, String workflowId, String instanceId, AttachmentInfo info) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, instanceId)).flatMap((Function1 & Serializable)iInfo -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.loadWorkflowInstance((WorkflowDB.WFInstanceInfo)iInfo)).flatMap((Function1 & Serializable)instance -> EitherT$.MODULE$.apply(this.getAttachments(field, (Document)instance)).flatMap((Function1 & Serializable)atts -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.updateAttachments((WorkflowDB.WFInstanceInfo)iInfo, field, (List<AttachmentInfo>)((List)atts.$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttachmentInfo[]{info})))))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, List<AttachmentInfo>>> getAttachments(String field, Document instanceDoc) {
        return Task$.MODULE$.now((Object)instanceDoc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)doc -> BsonUtils$.MODULE$.toJson(doc)).toRight(this::getAttachments$$anonfun$2).flatMap((Function1 & Serializable)pubstr -> package$.MODULE$.parse(pubstr).left().map((Function1 & Serializable)ex -> ExceptionUtil$.MODULE$.getMessage(ex)).flatMap((Function1 & Serializable)json -> JsonLenses$.MODULE$.AttachmentsLens(field).getOption(json).toRight(() -> this.getAttachments$$anonfun$3$$anonfun$2$$anonfun$1(field, json)).map((Function1 & Serializable)atts -> atts))));
    }

    public Task<Either<String, Vector<Json>>> getResultHistory(Document instanceDoc) {
        return Task$.MODULE$.now((Object)instanceDoc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)doc -> BsonUtils$.MODULE$.toJson(doc)).toRight(this::getResultHistory$$anonfun$2).flatMap((Function1 & Serializable)pubstr -> package$.MODULE$.parse(pubstr).left().map((Function1 & Serializable)ex -> ExceptionUtil$.MODULE$.getMessage(ex)).map((Function1 & Serializable)json -> (Vector)JsonLenses$.MODULE$.ResultHistoryLens().getOption(json).getOrElse(this::getResultHistory$$anonfun$3$$anonfun$2$$anonfun$1))));
    }

    public Task<Either<String, BoxedUnit>> addAttachmentToOCRGroup(List<String> groups, String workflowId, String instanceId, AttachmentInfo info) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, instanceId)).flatMap((Function1 & Serializable)iInfo -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.loadWorkflowInstance((WorkflowDB.WFInstanceInfo)iInfo)).flatMap((Function1 & Serializable)instance -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)instance.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)doc -> BsonUtils$.MODULE$.toJson(doc)).toRight(this::addAttachmentToOCRGroup$$anonfun$1$$anonfun$1$$anonfun$2))).flatMap((Function1 & Serializable)pubstr -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)package$.MODULE$.parse(pubstr).left().map((Function1 & Serializable)ex -> ExceptionUtil$.MODULE$.getMessage(ex)))).flatMap((Function1 & Serializable)pubJson -> EitherT$.MODULE$.apply(this.updateUploads(groups, (Json)pubJson, info)).flatMap((Function1 & Serializable)json -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.updateElxPublic((WorkflowDB.WFInstanceInfo)iInfo, (Json)json)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, Json>> updateUploads(List<String> groups, Json json, AttachmentInfo info) {
        return Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply(groups.foldLeft((Object)json, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Json j = (Json)tuple2._1();
                String g = (String)tuple2._2();
                return this.updateGroupUpload(g, info, j);
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    public Json updateGroupUpload(String group, AttachmentInfo info, Json json) {
        List uploads = (List)((IterableOps)JsonLenses$.MODULE$.GroupUploadsLens(group).getOption((Object)json).getOrElse(this::$anonfun$1)).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttachmentInfo[]{info})));
        return (Json)JsonProcessor$.MODULE$.run((JsonProcessor.Action)JsonProcessor.Add$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)JsonProcessor.JsonPath$.MODULE$.apply(group + ".ocr")), "uploads", Json$.MODULE$.fromValues((Iterable)uploads.map((Function1 & Serializable)_$1 -> {
            AttachmentInfo attachmentInfo = (AttachmentInfo)io.circe.syntax.package$.MODULE$.EncoderOps(_$1);
            String string = "name";
            String string2 = "store";
            String string3 = "uuid";
            String string4 = "by";
            String string5 = "when";
            String string6 = "size";
            return package.EncoderOps$.MODULE$.asJson$extension((Object)attachmentInfo, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::updateGroupUpload$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        })))).apply((Object)json);
    }

    public Task<Either<String, OCRResult>> ocrCrop(UserDB.User user, String workflowId, String instanceId, String group, String fieldId, byte[] bytes) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, instanceId)).flatMap((Function1 & Serializable)info -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.loadWorkflowInstance((WorkflowDB.WFInstanceInfo)info)).flatMap((Function1 & Serializable)instance -> EitherT$.MODULE$.apply(this.instanceToJson((Document)instance)).flatMap((Function1 & Serializable)instanceJson -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getOCRState((Document)instance, group)).flatMap((Function1 & Serializable)s1 -> {
            boolean bl = EitherT$.MODULE$.right();
            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.now((Object)this.augmentI18N((Json)instanceJson, (Json)s1)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)s2 -> {
                boolean bl = EitherT$.MODULE$.right();
                return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, I18NContentHelper$.MODULE$.lookups(user, I18N.Language$.MODULE$.apply(Locale.getDefault().toLanguageTag()), (Json)instanceJson, (Json)s2), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)s3 -> EitherT$.MODULE$.apply(I18NHelper$.MODULE$.i18nOCRDefinition(user, (Json)instanceJson, (Json)s3)).flatMap((Function1 & Serializable)s4 -> {
                    boolean bl = EitherT$.MODULE$.right();
                    return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, I18NHelper$.MODULE$.i18nOCRValues((Json)s4), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)s5 -> {
                        boolean bl = EitherT$.MODULE$.right();
                        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, this.getFieldValidationHolder(fieldId, (Json)s5), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)fh -> {
                            boolean bl = EitherT$.MODULE$.right();
                            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, this.getI18NContentHolder((Json)s5), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)ch -> {
                                boolean bl = EitherT$.MODULE$.right();
                                return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, this.getFieldLang((I18NContentHolder)ch, (FieldValidationHolder)fh), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)fieldLang -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getElxHostId((Document)instance)).flatMap((Function1 & Serializable)hostId -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)HostConfiguration$.MODULE$.getHost((String)hostId).toRight(() -> this.ocrCrop$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(hostId)))).flatMap((Function1 & Serializable)hConfig -> EitherT$.MODULE$.apply(this.runOCR(user, hConfig.ocr(), (FieldValidationHolder)fh, (I18NContentHolder)ch, (Option<I18NLanguage>)fieldLang, fieldId, bytes)).flatMap((Function1 & Serializable)res1 -> {
                                    boolean bl = EitherT$.MODULE$.right();
                                    return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.now((Object)this.normaliseResult((OCRResult)res1)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)res2 -> {
                                        boolean bl = EitherT$.MODULE$.right();
                                        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, this.getI18nKey((Option<I18NLanguage>)fieldLang, (I18NContentHolder)ch, (OCRResult)res2), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)i18nKeyOpt -> res2.copy(res2.copy$default$1(), res2.copy$default$2(), res2.copy$default$3(), i18nKeyOpt, res2.copy$default$5(), res2.copy$default$6(), res2.copy$default$7()), (Functor)Task$.MODULE$.catsAsync());
                                    }, (Monad)Task$.MODULE$.catsAsync());
                                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                            }, (Monad)Task$.MODULE$.catsAsync());
                        }, (Monad)Task$.MODULE$.catsAsync());
                    }, (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Option<String>> getI18nKey(Option<I18NLanguage> fieldLang, I18NContentHolder ch, OCRResult ocrResult) {
        Tuple2 tuple2;
        Option option = ch.category().zip(fieldLang);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            I18NCategory cat = (I18NCategory)tuple2._1();
            I18NLanguage lang = (I18NLanguage)tuple2._2();
            return I18NHelper$.MODULE$.findI18nKey(I18NAPI.Language$.MODULE$.apply(lang.value()), I18NAPI.Category$.MODULE$.apply(cat.value()), (String)ocrResult.ocrValueOpt().getOrElse(() -> this.getI18nKey$$anonfun$1(ocrResult)));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.none();
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<String, OCRResult>> runOCR(UserDB.User user, OCRJsonHolder ocrHolder, FieldValidationHolder fh, I18NContentHolder ch, Option<I18NLanguage> fieldLocale, String fieldId, byte[] bytes) {
        Locale actualLocale = Util$.MODULE$.getLocale((Option<String>)fieldLocale.map((Function1 & Serializable)_$2 -> _$2.value()));
        Either<String, OCRRunner.OCRValue> either = OCRRunner$.MODULE$.apply(ocrHolder, fh, bytes);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)msg));
        }
        if (either instanceof Right) {
            OCRRunner.OCRValue res = (OCRRunner.OCRValue)((Right)either).value();
            return OCRHelper$.MODULE$.validate(user, ocrHolder, fieldId, ch, actualLocale, fh, res.value().trim()).map((Function1 & Serializable)_$3 -> scala.package$.MODULE$.Right().apply(_$3));
        }
        throw new MatchError(either);
    }

    public Task<Option<I18NLanguage>> getFieldLang(I18NContentHolder ch, FieldValidationHolder fh) {
        return Task$.MODULE$.now(I18NContentHelper$.MODULE$.getLanguage(Locale.getDefault(), ch, (Option<I18NLanguage>)fh.locale(), (Option<I18NLanguage>)None$.MODULE$));
    }

    public Task<FieldValidationHolder> getFieldValidationHolder(String fieldId, Json ocrState) {
        return Task$.MODULE$.now(((IterableOnceOps)Lenses$.MODULE$.FieldsArrLens().getOption((Object)ocrState).getOrElse(this::getFieldValidationHolder$$anonfun$1)).find((Function1 & Serializable)j -> Lenses$.MODULE$.FieldId().getOption(j).contains((Object)new FieldId(fieldId))).map((Function1 & Serializable)_$4 -> FieldValidationHolder$.MODULE$.apply(_$4)).getOrElse(this::getFieldValidationHolder$$anonfun$4));
    }

    public Task<I18NContentHolder> getI18NContentHolder(Json ocrState) {
        return Task$.MODULE$.now((Object)I18NContentHelper$.MODULE$.getHolderFromState(ocrState));
    }

    public Task<Either<String, BoxedUnit>> addOCRResult(String workflowId, String instanceId, String group, String field, CroppedInfo info, OCRResult ocrResult) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, instanceId)).flatMap((Function1 & Serializable)iInfo -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.loadWorkflowInstance((WorkflowDB.WFInstanceInfo)iInfo)).flatMap((Function1 & Serializable)instance -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)instance.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)doc -> BsonUtils$.MODULE$.toJson(doc)).toRight(this::addOCRResult$$anonfun$1$$anonfun$1$$anonfun$2))).flatMap((Function1 & Serializable)pubstr -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)package$.MODULE$.parse(pubstr).left().map((Function1 & Serializable)ex -> ExceptionUtil$.MODULE$.getMessage(ex)))).flatMap((Function1 & Serializable)pubJson -> EitherT$.MODULE$.apply(this.updateFieldArray(group, field, (Json)pubJson, info, ocrResult)).flatMap((Function1 & Serializable)json1 -> EitherT$.MODULE$.apply(this.updateFormField(group, field, (Json)json1, this.getValue(ocrResult))).flatMap((Function1 & Serializable)json2 -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.updateElxPublic((WorkflowDB.WFInstanceInfo)iInfo, (Json)json2)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, BoxedUnit>> updateElxHostId(String workflowId, String id, String hostId) {
        return (Task)EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.getWFInstanceInfo(workflowId, id)).flatMap((Function1 & Serializable)info -> EitherT$.MODULE$.apply(WorkflowDB$.MODULE$.updateElxHostId((WorkflowDB.WFInstanceInfo)info, hostId)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, Json>> updateFieldArray(String group, String field, Json json, CroppedInfo info, OCRResult result) {
        return Task$.MODULE$.now((Object)scala.package$.MODULE$.Right().apply((Object)CropRoute$.MODULE$.updateFieldArray(json, FieldId$.MODULE$.apply(field), (Option<Tuple2<CroppedInfo, OCRResult>>)Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)info, (Object)result)), JsonLenses$.MODULE$.OCRFieldsArrLens(group))));
    }

    public Task<Either<String, Json>> updateFormField(String group, String field, Json json, String value) {
        return Task$.MODULE$.apply(() -> this.updateFormField$$anonfun$1(group, field, value, json));
    }

    public String getValue(OCRResult result) {
        Option option = result.i18nKeyOpt();
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            return (String)result.ocrValueOpt().orElse(() -> this.getValue$$anonfun$1(result)).getOrElse(this::getValue$$anonfun$2);
        }
        throw new MatchError((Object)option);
    }

    public Json getState(Document doc) {
        return (Json)doc.get("wfiState", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)bsonDoc -> (Json)package$.MODULE$.parse(bsonDoc.toJson()).toOption().getOrElse(this::getState$$anonfun$1$$anonfun$1)).getOrElse(this::getState$$anonfun$2);
    }

    public Document addToElxPublic(List<String> fields, Document doc) {
        Document elxPublic = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$3));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$4));
        Document result = (Document)fields.foldLeft((Object)elxPublic, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(elxEvent, field).map((Function1 & Serializable)value -> BsonETL$.MODULE$.put(holder, field, value)).getOrElse(() -> this.$anonfun$5$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
        return (Document)doc.updated("elxPublic", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document mergeToElxPublic(List<String> fields, Document doc) {
        Document elxPublic = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$6));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$7));
        Document result = this.mergeFields(fields, elxEvent, elxPublic);
        return (Document)doc.updated("elxPublic", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document addToElxPrivate(List<String> fields, Document doc) {
        Document elxPrivate = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPrivate", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$8));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$9));
        Document result = (Document)fields.foldLeft((Object)elxPrivate, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(elxEvent, field).map((Function1 & Serializable)value -> BsonETL$.MODULE$.put(holder, field, value)).getOrElse(() -> this.$anonfun$10$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
        return (Document)doc.updated("elxPrivate", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document mergeToElxPrivate(List<String> fields, Document doc) {
        Document elxPrivate = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxPrivate", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$11));
        Document elxEvent = ambience.etl.package$.MODULE$.ETLRecord().apply((BsonDocument)doc.get("elxEvent", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(this::$anonfun$12));
        Document result = this.mergeFields(fields, elxEvent, elxPrivate);
        return (Document)doc.updated("elxPrivate", (Object)result, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
    }

    public Document getElxParameters(Document doc) {
        return (Document)doc.get("elxParameters", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)_$5 -> ambience.etl.package$.MODULE$.ETLRecord().apply(_$5)).getOrElse(() -> this.getElxParameters$$anonfun$2(doc));
    }

    public Document getElxParametersFromRoot(Document doc) {
        List l = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "workflowId", "states"}));
        return (Document)doc.filterNot((Function1 & Serializable)pair -> this.test$1(l, (Tuple2)pair));
    }

    public Document cleanResult(Document doc) {
        List l = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxPrivate", "elxHistory"}));
        return (Document)doc.filterNot((Function1 & Serializable)pair -> this.test$2(l, (Tuple2)pair));
    }

    public Document mergeFields(List<String> fields, Document from, Document to) {
        return (Document)fields.foldLeft((Object)to, (Function2 & Serializable)(x$12, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
            if (tuple2 != null) {
                Document holder = (Document)tuple2._1();
                String field = (String)tuple2._2();
                return (Document)BsonETL$.MODULE$.get(from, field).map((Function1 & Serializable)x$1 -> {
                    BsonValue bsonValue = x$1;
                    if (bsonValue instanceof BsonDocument) {
                        BsonValue bsonValue2;
                        BsonDocument vdoc = (BsonDocument)bsonValue;
                        Option option = BsonETL$.MODULE$.get(holder, field);
                        if (option instanceof Some && (bsonValue2 = (BsonValue)((Some)option).value()) instanceof BsonDocument) {
                            BsonDocument odoc = (BsonDocument)bsonValue2;
                            return BsonETL$.MODULE$.put(holder, field, (BsonValue)BsonETL$.MODULE$.deepMerge(odoc, vdoc));
                        }
                        return BsonETL$.MODULE$.put(holder, field, (BsonValue)vdoc);
                    }
                    BsonValue value = bsonValue;
                    return BsonETL$.MODULE$.put(holder, field, value);
                }).getOrElse(() -> this.mergeFields$$anonfun$1$$anonfun$2(holder));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Json timestamp(long ts) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$date");
        Object[] objectArray2 = new Tuple2[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$numberLong");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(String.valueOf(ts)));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public long timestamp$default$1() {
        return System.currentTimeMillis();
    }

    public Task<Document> errorT(Builder.Context cxt, String msg) {
        return cxt.logger().errorT(cxt.position(), () -> this.errorT$$anonfun$1(msg)).map((Function1 & Serializable)_$6 -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"result");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("failure: " + msg)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return ambience.etl.package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    public Task<Document> errorT(String msg) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"result");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("failure: " + msg)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Task$.MODULE$.now((Object)ambience.etl.package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public EitherT<Task, String, String> getDocValue(Document doc, String field) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.getDocValue$$anonfun$1(doc, field)));
    }

    public Json augmentI18N(Json instance, Json state) {
        JsonProcessor.Default default_ = JsonProcessor.Default$.MODULE$.apply((Option)None$.MODULE$, "title", Json$.MODULE$.fromString((String)Lenses$.MODULE$.ElxPublicTitle().getOption((Object)instance).getOrElse(this::$anonfun$13)));
        JsonProcessor.Default default_2 = JsonProcessor.Default$.MODULE$.apply((Option)None$.MODULE$, "i18nCategory", Json$.MODULE$.fromString((String)Lenses$.MODULE$.ElxPublicI18NCategory().getOption((Object)instance).map((Function1 & Serializable)_$8 -> _$8.trim()).getOrElse(this::$anonfun$15)));
        JsonProcessor.Default default_3 = JsonProcessor.Default$.MODULE$.apply((Option)None$.MODULE$, "i18nLanguage", Json$.MODULE$.fromString((String)Lenses$.MODULE$.ElxPublicI18NLanguage().getOption((Object)instance).map((Function1 & Serializable)_$9 -> _$9.trim()).getOrElse(this::$anonfun$17)));
        JsonProcessor.Default default_4 = JsonProcessor.Default$.MODULE$.apply((Option)None$.MODULE$, "elxI18nContent", (Json)Lenses$.MODULE$.ElxPublicI18NContent().getOption((Object)instance).getOrElse(this::$anonfun$18));
        return JsonProcessor$.MODULE$.run((Seq)scala.package$.MODULE$.Nil().$colon$colon((Object)default_4).$colon$colon((Object)default_3).$colon$colon((Object)default_2).$colon$colon((Object)default_), state);
    }

    public Task<Either<String, Json>> instanceToJson(Document instance) {
        return Task$.MODULE$.now((Object)package$.MODULE$.parse(BsonUtils$.MODULE$.toJson(instance)).left().map((Function1 & Serializable)ex -> ExceptionUtil$.MODULE$.getMessage(ex)));
    }

    public OCRResult normaliseResult(OCRResult res) {
        Option option = res.correctValueOpt().orElse(() -> this.$anonfun$19(res));
        String string = res.copy$default$1();
        Option option2 = res.copy$default$2();
        Option option3 = res.copy$default$4();
        Option option4 = res.copy$default$5();
        Option option5 = res.copy$default$6();
        Option option6 = res.copy$default$7();
        return res.copy(string, option2, option, option3, option4, option5, option6);
    }

    private final String getAttachments$$anonfun$2() {
        return "elxPublic not found";
    }

    private final String getAttachments$$anonfun$3$$anonfun$2$$anonfun$1(String field$6, Json json$1) {
        return "attachments field '" + field$6 + "' not found " + json$1;
    }

    private final String getResultHistory$$anonfun$2() {
        return "elxPublic not found";
    }

    private final Vector getResultHistory$$anonfun$3$$anonfun$2$$anonfun$1() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private final String addAttachmentToOCRGroup$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "elxPublic not found";
    }

    private final List $anonfun$1() {
        return scala.package$.MODULE$.Nil();
    }

    /*
     * WARNING - void declaration
     */
    private final List updateGroupUpload$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        void var2_1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeLong();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final String ocrCrop$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String hostId$1) {
        return "Host '" + hostId$1 + "' not found in conf";
    }

    private final String getI18nKey$$anonfun$1$$anonfun$1() {
        return "";
    }

    private final String getI18nKey$$anonfun$1(OCRResult ocrResult$1) {
        return (String)ocrResult$1.correctValueOpt().getOrElse(this::getI18nKey$$anonfun$1$$anonfun$1);
    }

    private final Vector getFieldValidationHolder$$anonfun$1() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private final FieldValidationHolder getFieldValidationHolder$$anonfun$4() {
        return FieldValidationHolder$.MODULE$.apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
    }

    private final String addOCRResult$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "elxPublic not found";
    }

    private final Right updateFormField$$anonfun$1(String group$9, String field$12, String value$1, Json json$2) {
        return scala.package$.MODULE$.Right().apply(JsonProcessor$.MODULE$.run((JsonProcessor.Action)JsonProcessor.Add$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)JsonProcessor.JsonPath$.MODULE$.apply(String.valueOf(group$9))), field$12, Json$.MODULE$.fromString(value$1))).apply((Object)json$2));
    }

    private final Option getValue$$anonfun$1(OCRResult result$1) {
        return result$1.correctValueOpt();
    }

    private final String getValue$$anonfun$2() {
        return "";
    }

    private final Json getState$$anonfun$1$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final Json getState$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final BsonDocument $anonfun$3() {
        return BsonDocument$.MODULE$.apply();
    }

    private final BsonDocument $anonfun$4() {
        return BsonDocument$.MODULE$.apply();
    }

    private final Document $anonfun$5$$anonfun$2(Document holder$2) {
        return holder$2;
    }

    private final BsonDocument $anonfun$6() {
        return BsonDocument$.MODULE$.apply();
    }

    private final BsonDocument $anonfun$7() {
        return BsonDocument$.MODULE$.apply();
    }

    private final BsonDocument $anonfun$8() {
        return BsonDocument$.MODULE$.apply();
    }

    private final BsonDocument $anonfun$9() {
        return BsonDocument$.MODULE$.apply();
    }

    private final Document $anonfun$10$$anonfun$2(Document holder$4) {
        return holder$4;
    }

    private final BsonDocument $anonfun$11() {
        return BsonDocument$.MODULE$.apply();
    }

    private final BsonDocument $anonfun$12() {
        return BsonDocument$.MODULE$.apply();
    }

    private final Document getElxParameters$$anonfun$2(Document doc$1) {
        return this.getElxParametersFromRoot(doc$1);
    }

    private final boolean test$1(List l$1, Tuple2 pair) {
        return l$1.contains(pair._1()) || ((String)pair._1()).startsWith("elx");
    }

    private final boolean test$2(List l$2, Tuple2 pair) {
        return l$2.contains(pair._1());
    }

    private final Document mergeFields$$anonfun$1$$anonfun$2(Document holder$6) {
        return holder$6;
    }

    private final Object errorT$$anonfun$1(String msg$1) {
        return "failure: " + msg$1;
    }

    private final String getDocValue$$anonfun$1$$anonfun$2(String field$17) {
        return field$17 + " field not found";
    }

    private final Either getDocValue$$anonfun$1(Document doc$2, String field$16) {
        return doc$2.get(field$16, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue()).toRight(() -> this.getDocValue$$anonfun$1$$anonfun$2(field$16));
    }

    private final String $anonfun$13() {
        return "";
    }

    private final String $anonfun$15() {
        return "";
    }

    private final String $anonfun$17() {
        return "";
    }

    private final Json $anonfun$18() {
        return I18NContentHolder$.MODULE$.defaultJSON();
    }

    private final Option $anonfun$19(OCRResult res$1) {
        return res$1.ocrValueOpt();
    }
}

