/*
 * Decompiled with CFR 0.152.
 */
package ambience.ocr.etl;

import ambience.etl.Builder;
import com.elixirtech.arch.LogMessage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import monix.eval.Task;
import monix.eval.Task$;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.bson.BsonBinary;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PDFHelper$
implements Serializable {
    public static final PDFHelper$ MODULE$ = new PDFHelper$();

    private PDFHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PDFHelper$.class);
    }

    public Task<Either<String, Document>> toImage(Builder.Context cxt, int dpi, int pageIdx, Document doc) {
        Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$1 -> _$1.getData());
        if (option instanceof Some) {
            byte[] bytes = (byte[])((Some)option).value();
            return this.toImage(cxt, dpi, doc, pageIdx, bytes).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"bytes field not found"));
        }
        throw new MatchError((Object)option);
    }

    public Task<Document> toImage(Builder.Context cxt, int dpi, Document doc, int pageIdx, byte[] bytes) {
        return this.toImage(dpi, doc, pageIdx, bytes).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return cxt.logT(lm).as(doc.$minus$minus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bytes", "mimeType"}))));
            }
            if (either instanceof Right) {
                Document d = (Document)((Right)either).value();
                return Task$.MODULE$.apply(() -> this.toImage$$anonfun$3$$anonfun$1(d));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, Document>> toImage(int dpi, Document doc, int pageIdx, byte[] bytes) {
        return Task$.MODULE$.apply(() -> this.toImage$$anonfun$4(bytes, pageIdx, dpi, doc));
    }

    public PDDocument loadDocument(byte[] bytes) {
        return Loader.loadPDF((byte[])bytes);
    }

    private final Document toImage$$anonfun$3$$anonfun$1(Document d$1) {
        return d$1;
    }

    private final Either toImage$$anonfun$4(byte[] bytes$1, int pageIdx$1, int dpi$1, Document doc$2) {
        PDDocument document = this.loadDocument(bytes$1);
        PDFRenderer renderer = new PDFRenderer(document);
        Range.Inclusive allowedRange = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), document.getNumberOfPages());
        if (allowedRange.contains(pageIdx$1)) {
            BufferedImage image = renderer.renderImageWithDPI(pageIdx$1 - 1, (float)dpi$1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", baos);
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)baos.toByteArray()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBinary());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"image/png"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            Document newDoc = (Document)doc$2.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            document.close();
            return package$.MODULE$.Right().apply((Object)newDoc);
        }
        return package$.MODULE$.Left().apply((Object)LogMessage.Debug$.MODULE$.apply("Page " + pageIdx$1 + " not found. Page range: (" + allowedRange + ")"));
    }
}

