/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.DualMessageSequences;
import com.mongodb.internal.connection.LevelCountingBsonWriter;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.AbstractBsonWriter;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonContextType;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonOutput;

public final class BsonWriterHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();

    static void appendElementsToDocument(BsonOutput bsonOutputWithDocument, int documentStartPosition, @Nullable List<BsonElement> bsonElements) {
        if (bsonElements == null || bsonElements.isEmpty()) {
            return;
        }
        try (AppendingBsonWriter writer = new AppendingBsonWriter(bsonOutputWithDocument, documentStartPosition);){
            for (BsonElement element : bsonElements) {
                String name = element.getName();
                BsonValue value = element.getValue();
                writer.writeName(name);
                BsonWriterHelper.encodeUsingRegistry(writer, value);
            }
        }
    }

    static void writePayloadArray(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, int messageStartPosition, SplittablePayload payload, int maxSplittableDocumentSize) {
        writer.writeStartArray(payload.getPayloadName());
        BsonWriterHelper.writePayload(writer, bsonOutput, BsonWriterHelper.getDocumentMessageSettings(settings), messageStartPosition, payload, maxSplittableDocumentSize);
        writer.writeEndArray();
    }

    static void writePayload(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, int messageStartPosition, SplittablePayload payload, int maxSplittableDocumentSize) {
        MessageSettings payloadSettings = BsonWriterHelper.getPayloadMessageSettings(payload.getPayloadType(), settings);
        List<BsonDocument> payloadDocuments = payload.getPayload();
        for (int i = 0; i < payloadDocuments.size() && BsonWriterHelper.writeDocument(writer, bsonOutput, payloadSettings, payloadDocuments.get(i), messageStartPosition, i + 1, maxSplittableDocumentSize); ++i) {
            payload.setPosition(i + 1);
        }
        if (payload.getPosition() == 0) {
            throw BsonWriterHelper.createBsonMaximumSizeExceededException(payloadSettings.getMaxDocumentSize());
        }
    }

    static DualMessageSequences.EncodeDocumentsResult writeDocumentsOfDualMessageSequences(DualMessageSequences dualMessageSequences, int commandDocumentSizeInBytes, BsonOutput firstOutput, BsonOutput secondOutput, MessageSettings messageSettings) {
        BsonBinaryWriter firstWriter = BsonWriterHelper.createBsonBinaryWriter(firstOutput, dualMessageSequences.getFirstFieldNameValidator(), null);
        BsonBinaryWriter secondWriter = BsonWriterHelper.createBsonBinaryWriter(secondOutput, dualMessageSequences.getSecondFieldNameValidator(), null);
        int messageOverheadInBytes = 1000;
        int maxSizeInBytes = messageSettings.getMaxMessageSize() - (messageOverheadInBytes + commandDocumentSizeInBytes);
        int firstStart = firstOutput.getPosition();
        int secondStart = secondOutput.getPosition();
        int maxBatchCount = messageSettings.getMaxBatchCount();
        return dualMessageSequences.encodeDocuments(writeAction -> {
            int firstBeforeWritePosition = firstOutput.getPosition();
            int secondBeforeWritePosition = secondOutput.getPosition();
            int batchCountAfterWrite = writeAction.doAndGetBatchCount(firstWriter, secondWriter);
            Assertions.assertTrue(batchCountAfterWrite <= maxBatchCount);
            int writtenSizeInBytes = firstOutput.getPosition() - firstStart + secondOutput.getPosition() - secondStart;
            if (writtenSizeInBytes < maxSizeInBytes && batchCountAfterWrite < maxBatchCount) {
                return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED;
            }
            if (writtenSizeInBytes > maxSizeInBytes) {
                firstOutput.truncateToPosition(firstBeforeWritePosition);
                secondOutput.truncateToPosition(secondBeforeWritePosition);
                if (batchCountAfterWrite == 1) {
                    throw BsonWriterHelper.createBsonMaximumSizeExceededException(messageSettings.getMaxDocumentSize());
                }
                return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.FAIL_LIMIT_EXCEEDED;
            }
            return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_REACHED;
        });
    }

    static BsonBinaryWriter createBsonBinaryWriter(BsonOutput out, FieldNameValidator validator, @Nullable MessageSettings messageSettings) {
        return new BsonBinaryWriter(new BsonWriterSettings(), messageSettings == null ? new BsonBinaryWriterSettings() : new BsonBinaryWriterSettings(messageSettings.getMaxDocumentSize() + 16384), out, validator);
    }

    static void backpatchLength(int startPosition, BsonOutput bsonOutput) {
        int messageLength = bsonOutput.getPosition() - startPosition;
        bsonOutput.writeInt32(startPosition, messageLength);
    }

    private static BsonMaximumSizeExceededException createBsonMaximumSizeExceededException(int maxSize) {
        return new BsonMaximumSizeExceededException(String.format("Payload document size is larger than maximum of %d.", maxSize));
    }

    private static boolean writeDocument(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, BsonDocument document, int messageStartPosition, int batchItemCount, int maxSplittableDocumentSize) {
        int currentPosition = bsonOutput.getPosition();
        BsonWriterHelper.encodeUsingRegistry(writer, (BsonValue)document);
        int messageSize = bsonOutput.getPosition() - messageStartPosition;
        int documentSize = bsonOutput.getPosition() - currentPosition;
        if (BsonWriterHelper.exceedsLimits(settings, messageSize, documentSize, batchItemCount) || batchItemCount > 1 && bsonOutput.getPosition() - messageStartPosition > maxSplittableDocumentSize) {
            bsonOutput.truncateToPosition(currentPosition);
            return false;
        }
        return true;
    }

    static void encodeUsingRegistry(BsonWriter writer, BsonValue value) {
        Codec encoder = REGISTRY.get(value.getClass());
        encoder.encode(writer, (Object)value, ENCODER_CONTEXT);
    }

    private static MessageSettings getPayloadMessageSettings(SplittablePayload.Type type, MessageSettings settings) {
        MessageSettings payloadMessageSettings = settings;
        if (type != SplittablePayload.Type.INSERT) {
            payloadMessageSettings = BsonWriterHelper.createMessageSettingsBuilder(settings).maxDocumentSize(settings.getMaxDocumentSize() + 16384).build();
        }
        return payloadMessageSettings;
    }

    private static MessageSettings getDocumentMessageSettings(MessageSettings settings) {
        return BsonWriterHelper.createMessageSettingsBuilder(settings).maxMessageSize(settings.getMaxDocumentSize() + 16384).build();
    }

    private static MessageSettings.Builder createMessageSettingsBuilder(MessageSettings settings) {
        return MessageSettings.builder().maxBatchCount(settings.getMaxBatchCount()).maxMessageSize(settings.getMaxMessageSize()).maxDocumentSize(settings.getMaxDocumentSize()).maxWireVersion(settings.getMaxWireVersion());
    }

    private static boolean exceedsLimits(MessageSettings settings, int messageSize, int documentSize, int batchItemCount) {
        if (batchItemCount > settings.getMaxBatchCount()) {
            return true;
        }
        if (messageSize > settings.getMaxMessageSize()) {
            return true;
        }
        return documentSize > settings.getMaxDocumentSize();
    }

    private BsonWriterHelper() {
    }

    private static final class AppendingBsonWriter
    extends LevelCountingBsonWriter
    implements AutoCloseable {
        private static final int INITIAL_LEVEL = 0;

        AppendingBsonWriter(BsonOutput bsonOutputWithDocument, int documentStartPosition) {
            super((BsonWriter)new InternalAppendingBsonBinaryWriter(bsonOutputWithDocument, documentStartPosition), 0);
        }

        @Override
        public void writeEndDocument() {
            Assertions.assertTrue(this.getCurrentLevel() > 0);
            super.writeEndDocument();
        }

        @Override
        public void close() {
            try (InternalAppendingBsonBinaryWriter writer = (InternalAppendingBsonBinaryWriter)this.getBsonWriter();){
                writer.writeEndDocument();
            }
        }

        private static final class InternalAppendingBsonBinaryWriter
        extends BsonBinaryWriter {
            InternalAppendingBsonBinaryWriter(BsonOutput bsonOutputWithDocument, int documentStartPosition) {
                super(bsonOutputWithDocument);
                int documentEndPosition = bsonOutputWithDocument.getPosition();
                int bsonDocumentEndingSize = 1;
                int appendFromPosition = documentEndPosition - bsonDocumentEndingSize;
                bsonOutputWithDocument.truncateToPosition(appendFromPosition);
                this.setState(AbstractBsonWriter.State.NAME);
                this.setContext((AbstractBsonWriter.Context)new BsonBinaryWriter.Context((BsonBinaryWriter)this, null, BsonContextType.DOCUMENT, documentStartPosition));
            }
        }
    }
}

