/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.daemon;

import ambience.etl.daemon.AuditHelper$;
import ambience.etl.daemon.DaemonConfig$;
import ambience.etl.daemon.DaemonSharedManager;
import ambience.etl.daemon.DaemonSharedManager$;
import ambience.etl.daemon.Model;
import ambience.module.CodexHelper$;
import ambience.util.ONConverter$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DaemonManager$
extends DaemonSharedManager
implements Serializable {
    public static final DaemonManager$ MODULE$ = new DaemonManager$();

    private DaemonManager$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DaemonManager$.class);
    }

    public Task<BoxedUnit> bumpAlive(Set<String> currentDaemons) {
        List filterList = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{DaemonSharedManager$.MODULE$.EqActualSystemId(), DaemonSharedManager$.MODULE$.InStatus((Set<BsonValue>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{DaemonSharedManager$.MODULE$.Running(), DaemonSharedManager$.MODULE$.Reclaiming()}))))}))).$plus$plus(this.filterCurrent(currentDaemons));
        CodexUpdate.Set update = CodexUpdate.Set$.MODULE$.apply("alive", (BsonValue)BsonDateTime$.MODULE$.apply(System.currentTimeMillis()));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$1 -> _$1.updateManyT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList), (CodexUpdate)update)).map((Function1)(JProcedure1 & Serializable)res -> this.info("(" + res.getModifiedCount() + ") Daemons bumped"));
    }

    public Task<BoxedUnit> resetRetries(Set<String> currentDaemons) {
        long now = System.currentTimeMillis();
        List filterList = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{DaemonSharedManager$.MODULE$.EqActualSystemId(), CodexFilter.Eq$.MODULE$.apply("retryStrategy.retriesRemaining", (BsonValue)BsonInt32$.MODULE$.apply(1)), DaemonSharedManager$.MODULE$.InStatus((Set<BsonValue>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{DaemonSharedManager$.MODULE$.Running(), DaemonSharedManager$.MODULE$.Reclaiming()}))))}))).$plus$plus(this.filterCurrent(currentDaemons));
        Task idCountListT = this.canon().cltnT().flatMap((Function1 & Serializable)_$2 -> _$2.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList)).toListL()).map((Function1 & Serializable)docs -> docs.flatMap((Function1 & Serializable)d -> d.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)id -> d.get("started", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDateTime.class)).flatMap((Function1 & Serializable)started -> d.get("retryStrategy", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)_$3 -> org.mongodb.scala.bson.package$.MODULE$.Document().apply(_$3)).flatMap((Function1 & Serializable)doc -> doc.get("count", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)count -> Tuple3$.MODULE$.apply(id, started, count)))))).filter((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                BsonDateTime started = (BsonDateTime)tuple3._2();
                long diff = now - started.getValue();
                return diff > DaemonConfig$.MODULE$.resetRetryIntervalMs().toMillis();
            }
            throw new MatchError((Object)tuple3);
        }));
        return idCountListT.flatMap((Function1 & Serializable)list -> {
            this.debug("retry id and counts to reset " + list.map((Function1 & Serializable)i -> "id:" + ((BsonString)i._1()).getValue() + ", count:" + ((BsonInt32)i._3()).getValue()));
            return Task$.MODULE$.sequence((Iterable)list.map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    BsonString id = (BsonString)tuple3._1();
                    BsonDateTime started = (BsonDateTime)tuple3._2();
                    BsonInt32 count = (BsonInt32)tuple3._3();
                    return this.updateRetries(Model.DaemonId$.MODULE$.apply(id.getValue()), count.getValue());
                }
                throw new MatchError((Object)tuple3);
            }), BuildFrom$.MODULE$.buildFromIterableOps());
        }).void();
    }

    public Task<Object> takePreferredDaemons(Set<String> currentDaemons, boolean isStartup) {
        long now = System.currentTimeMillis();
        BsonDateTime when = BsonDateTime$.MODULE$.apply(now - DaemonConfig$.MODULE$.deadAfterIntervalMs().toMillis());
        None$ aliveFilterOpt = isStartup ? None$.MODULE$ : Some$.MODULE$.apply((Object)CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.NotExists$.MODULE$.apply("alive"), CodexFilter.Lt$.MODULE$.apply("alive", (BsonValue)when)})));
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.EqPreferredSystemId();
        List filterList = (List)((IterableOps)package$.MODULE$.Nil().$colon$colon((Object)DaemonSharedManager$.MODULE$.EqAutoplayTrue()).$colon$colon((Object)codexFilter).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons))).$plus$plus((IterableOnce)aliveFilterOpt.toList());
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("alive", (BsonValue)BsonDateTime$.MODULE$.apply(now)), DaemonSharedManager$.MODULE$.SetActual()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$4 -> _$4.updateManyT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList), (CodexUpdate)update)).map((Function1 & Serializable)res -> {
            this.debug("(" + res.getModifiedCount() + ") Preferred Daemons taken");
            return res.getModifiedCount() > 0L;
        });
    }

    public Task<Option<String>> takeOneNonPreferredDaemon(Set<String> currentDaemons) {
        long now = System.currentTimeMillis();
        BsonDateTime when = BsonDateTime$.MODULE$.apply(now - DaemonConfig$.MODULE$.deadAfterIntervalMs().toMillis());
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter.Not not = CodexFilter.Not$.MODULE$.apply(DaemonSharedManager$.MODULE$.EqPreferredSystemId());
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.InStatus((Set<BsonValue>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{DaemonSharedManager$.MODULE$.Idle(), DaemonSharedManager$.MODULE$.Starting(), DaemonSharedManager$.MODULE$.Reclaiming(), DaemonSharedManager$.MODULE$.Running()}))));
        CodexFilter.Or or = CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.NotExists$.MODULE$.apply("alive"), CodexFilter.Lt$.MODULE$.apply("alive", (BsonValue)when)}));
        List filterList = (List)package$.MODULE$.Nil().$colon$colon((Object)or).$colon$colon((Object)DaemonSharedManager$.MODULE$.EqAutoplayTrue()).$colon$colon((Object)codexFilter).$colon$colon((Object)not).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("alive", (BsonValue)BsonDateTime$.MODULE$.apply(now)), DaemonSharedManager$.MODULE$.SetActual()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$5 -> _$5.findOneAndUpdateT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList), (CodexUpdate)update)).map((Function1 & Serializable)docOpt -> {
            Option idOpt = docOpt.flatMap((Function1 & Serializable)_$6 -> _$6.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)bv -> new Model.DaemonId(this.$anonfun$3$$anonfun$1((BsonString)bv))));
            this.debug("takeOneNonPreferredDaemon id=" + idOpt + " currentDaemons:" + currentDaemons);
            return idOpt;
        });
    }

    public Task<Option<String>> takeStartedDaemon(String id, Set<String> currentDaemons) {
        long now = System.currentTimeMillis();
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.EqDaemonId(id);
        CodexFilter codexFilter2 = DaemonSharedManager$.MODULE$.InStatus((Set<BsonValue>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{DaemonSharedManager$.MODULE$.Idle(), DaemonSharedManager$.MODULE$.Failed(), DaemonSharedManager$.MODULE$.Starting()}))));
        List filterList = (List)package$.MODULE$.Nil().$colon$colon((Object)codexFilter2).$colon$colon((Object)codexFilter).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("alive", (BsonValue)BsonDateTime$.MODULE$.apply(now)), DaemonSharedManager$.MODULE$.SetActual()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$7 -> _$7.findOneAndUpdateT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList), (CodexUpdate)update)).map((Function1 & Serializable)docOpt -> {
            Option idOpt = docOpt.flatMap((Function1 & Serializable)_$8 -> _$8.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)bv -> new Model.DaemonId(this.$anonfun$4$$anonfun$1((BsonString)bv))));
            this.debug("takeStartedDaemon id=" + idOpt + " currentDaemons:" + currentDaemons);
            return idOpt;
        });
    }

    public Task<Option<String>> takePreferredDaemon(String id, boolean autoplayOnly, Set<String> currentDaemons) {
        long now = System.currentTimeMillis();
        BsonDateTime when = BsonDateTime$.MODULE$.apply(now - DaemonConfig$.MODULE$.deadAfterIntervalMs().toMillis());
        None$ autoplayFilterOpt = autoplayOnly ? Some$.MODULE$.apply((Object)DaemonSharedManager$.MODULE$.EqAutoplayTrue()) : None$.MODULE$;
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.EqDaemonId(id);
        CodexFilter codexFilter2 = DaemonSharedManager$.MODULE$.EqPreferredSystemId();
        CodexFilter codexFilter3 = DaemonSharedManager$.MODULE$.InStatus((Set<BsonValue>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonValue[]{DaemonSharedManager$.MODULE$.Idle(), DaemonSharedManager$.MODULE$.Failed(), DaemonSharedManager$.MODULE$.Starting(), DaemonSharedManager$.MODULE$.Running()}))));
        CodexFilter.Or or = CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.NotExists$.MODULE$.apply("alive"), CodexFilter.Lt$.MODULE$.apply("alive", (BsonValue)when)}));
        List filterList = (List)((IterableOps)package$.MODULE$.Nil().$colon$colon((Object)or).$colon$colon((Object)codexFilter3).$colon$colon((Object)codexFilter2).$colon$colon((Object)codexFilter).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons))).$plus$plus((IterableOnce)autoplayFilterOpt.toList());
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("alive", (BsonValue)BsonDateTime$.MODULE$.apply(now)), DaemonSharedManager$.MODULE$.SetActual()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$9 -> _$9.findOneAndUpdateT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList), (CodexUpdate)update)).map((Function1 & Serializable)docOpt -> {
            Option idOpt = docOpt.flatMap((Function1 & Serializable)_$10 -> _$10.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)bv -> new Model.DaemonId(this.$anonfun$5$$anonfun$1((BsonString)bv))));
            this.debug("takePreferredDaemon id=" + idOpt);
            return idOpt;
        });
    }

    public Task<BoxedUnit> reclaimDaemons(Set<String> currentDaemons) {
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.EqPreferredSystemId();
        CodexFilter.Not not = CodexFilter.Not$.MODULE$.apply(DaemonSharedManager$.MODULE$.EqActualSystemId());
        CodexFilter.Eq eq2 = CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)DaemonSharedManager$.MODULE$.Running());
        List filterList = (List)package$.MODULE$.Nil().$colon$colon((Object)DaemonSharedManager$.MODULE$.EqAutoplayTrue()).$colon$colon((Object)eq2).$colon$colon((Object)not).$colon$colon((Object)codexFilter).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons));
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)filterList);
        CodexUpdate.Set update = CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)DaemonSharedManager$.MODULE$.Reclaiming());
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$11 -> _$11.updateManyT((CodexFilter)filter, (CodexUpdate)update)).map((Function1)(JProcedure1 & Serializable)res -> this.info("(" + res.getModifiedCount() + ") Daemons Reclaimed"));
    }

    public Task<List<Model.Daemon>> getPreferredAutoplayDaemons(Set<String> currentDaemons) {
        CodexFilter.Eq eq = CodexHelper$.MODULE$.IsEnabled();
        CodexFilter codexFilter = DaemonSharedManager$.MODULE$.EqPreferredSystemId();
        CodexFilter codexFilter2 = DaemonSharedManager$.MODULE$.EqActualSystemId();
        List filterList = (List)package$.MODULE$.Nil().$colon$colon((Object)codexFilter2).$colon$colon((Object)DaemonSharedManager$.MODULE$.EqAutoplayTrue()).$colon$colon((Object)codexFilter).$colon$colon((Object)eq).$plus$plus(this.filterNotCurrent(currentDaemons));
        return this.canon().cltnT().flatMap((Function1 & Serializable)cln -> cln.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)filterList)).toListL().flatMap((Function1 & Serializable)docs -> this.debugT("(" + docs.size() + ") Autoplay Preferred Daemons found, currentDaemons " + currentDaemons).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.toDaemons((List<Json>)docs.map((Function1 & Serializable)doc -> ONConverter$.MODULE$.bsonToRelaxedJson(doc)));
        })));
    }

    public Task<Either<LogMessage, BoxedUnit>> updateRetries(String id, int value) {
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("retryStrategy.retriesRemaining", (BsonValue)BsonInt32$.MODULE$.apply(value)), DaemonSharedManager$.MODULE$.SetLastModified()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$12 -> _$12.updateOneT(DaemonSharedManager$.MODULE$.EqDaemonId(id), (CodexUpdate)update)).map((Function1 & Serializable)res -> {
            if (res.getMatchedCount() > 0L) {
                this.debug("Daemon " + new Model.DaemonId(id) + " Retries updated " + value);
                AuditHelper$.MODULE$.sendT(true, id, "Retries Updated", (Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)value).toString()));
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            this.error("Daemon " + new Model.DaemonId(id) + " Retries not updated " + value);
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Daemon " + new Model.DaemonId(id) + " Retries not updated " + value));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> reset(String id) {
        return this.resetRetries(id, true);
    }

    public Task<Either<LogMessage, BoxedUnit>> resetRetries(String id, boolean setStatusIdle) {
        return this.getDaemon(id).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return Task$.MODULE$.apply(() -> this.resetRetries$$anonfun$2$$anonfun$1(lm));
            }
            if (either instanceof Right) {
                Model.Daemon daemon = (Model.Daemon)((Right)either).value();
                BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
                None$ statusUpdateOpt = setStatusIdle ? Some$.MODULE$.apply((Object)CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)DaemonSharedManager$.MODULE$.Idle())) : None$.MODULE$;
                Some actualUpdateOpt = setStatusIdle ? Some$.MODULE$.apply((Object)DaemonSharedManager$.MODULE$.SetActualEmpty()) : Some$.MODULE$.apply((Object)DaemonSharedManager$.MODULE$.SetActual());
                Option<CodexUpdate> historyUpdateOpt = setStatusIdle ? this.history(DaemonSharedManager$.MODULE$.Idle(), now, (Option<String>)Some$.MODULE$.apply((Object)"Daemon found not Running but status was Running. Setting to Idle")) : None$.MODULE$;
                List update = (List)((IterableOps)((IterableOps)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("retryStrategy.retriesRemaining", (BsonValue)BsonInt32$.MODULE$.apply(daemon.retryStrategy().count())), DaemonSharedManager$.MODULE$.SetLastModified()}))).$plus$plus((IterableOnce)statusUpdateOpt.toList())).$plus$plus((IterableOnce)historyUpdateOpt.toList())).$plus$plus((IterableOnce)actualUpdateOpt.toList());
                return this.canon().cltnT().flatMap((Function1 & Serializable)_$13 -> _$13.updateOneT(DaemonSharedManager$.MODULE$.EqDaemonId(id), (CodexUpdate)CodexUpdate.Combine$.MODULE$.apply((Seq)update))).map((Function1 & Serializable)res -> {
                    if (res.getMatchedCount() > 0L) {
                        this.debug("Daemon " + new Model.DaemonId(id) + " Retries reset to " + daemon.retryStrategy().count());
                        AuditHelper$.MODULE$.sendT(true, id, "Retries Reset", (Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)daemon.retryStrategy().count()).toString()));
                        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                    this.error("Daemon " + new Model.DaemonId(id) + " Retries not reset");
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Daemon " + new Model.DaemonId(id) + " Retries not reset"));
                });
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> updateAutoplay(String id, boolean yesNo) {
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("autoplay", (BsonValue)BsonBoolean$.MODULE$.apply(yesNo)), DaemonSharedManager$.MODULE$.SetLastModified()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$14 -> _$14.updateOneT(DaemonSharedManager$.MODULE$.EqDaemonId(id), (CodexUpdate)update)).map((Function1 & Serializable)res -> {
            if (res.getModifiedCount() > 0L) {
                this.debug("Daemon " + new Model.DaemonId(id) + " autoplay updated to " + yesNo);
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            this.warn("Daemon " + new Model.DaemonId(id) + " autoplay not updated");
            return package$.MODULE$.Left().apply((Object)LogMessage.Warn$.MODULE$.apply("Daemon " + new Model.DaemonId(id) + " autoplay not updated"));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> updateAutoplayAll(Set<String> ids, boolean yesNo) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.In$.MODULE$.apply("_id", (Set)ids.map((Function1 & Serializable)id -> this.$anonfun$6(id == null ? null : ((Model.DaemonId)id).value()))), CodexFilter.Eq$.MODULE$.apply("autoplay", (BsonValue)BsonBoolean$.MODULE$.apply(!yesNo))}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("autoplay", (BsonValue)BsonBoolean$.MODULE$.apply(yesNo)), DaemonSharedManager$.MODULE$.SetLastModified()}));
        return this.canon().cltnT().flatMap((Function1 & Serializable)_$15 -> _$15.updateManyT((CodexFilter)filter, (CodexUpdate)update)).map((Function1 & Serializable)res -> {
            if (res.getModifiedCount() > 0L) {
                this.debug("Daemon " + res.getModifiedCount() + " autoplays updated to " + yesNo + " " + ((IterableOnceOps)ids.map((Function1 & Serializable)_$16 -> this.updateAutoplayAll$$anonfun$2$$anonfun$1(_$16 == null ? null : ((Model.DaemonId)_$16).value()))).mkString(","));
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            this.warn("No Daemon autoplay updated");
            return package$.MODULE$.Left().apply((Object)LogMessage.Warn$.MODULE$.apply("Daemon " + ((IterableOnceOps)ids.map((Function1 & Serializable)_$17 -> this.updateAutoplayAll$$anonfun$2$$anonfun$2(_$17 == null ? null : ((Model.DaemonId)_$17).value()))).mkString(",") + " autoplay not updated"));
        });
    }

    private final /* synthetic */ String $anonfun$3$$anonfun$1(BsonString bv) {
        return Model.DaemonId$.MODULE$.apply(bv.getValue());
    }

    private final /* synthetic */ String $anonfun$4$$anonfun$1(BsonString bv) {
        return Model.DaemonId$.MODULE$.apply(bv.getValue());
    }

    private final /* synthetic */ String $anonfun$5$$anonfun$1(BsonString bv) {
        return Model.DaemonId$.MODULE$.apply(bv.getValue());
    }

    private final Left resetRetries$$anonfun$2$$anonfun$1(LogMessage lm$1) {
        return package$.MODULE$.Left().apply((Object)lm$1);
    }

    private final /* synthetic */ BsonValue $anonfun$6(String id) {
        return BsonString$.MODULE$.apply(id);
    }

    private final /* synthetic */ String updateAutoplayAll$$anonfun$2$$anonfun$1(String _$16) {
        return _$16;
    }

    private final /* synthetic */ String updateAutoplayAll$$anonfun$2$$anonfun$2(String _$17) {
        return _$17;
    }
}

