/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.codex.memory;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.memory.EncryptAtRest$;
import com.elixirtech.codex.memory.InMemoryCodexCollection$;
import com.elixirtech.codex.memory.InMemoryCodexDB;
import com.elixirtech.codex.memory.InMemoryCodexDB$CltnFile$;
import com.elixirtech.codex.memory.InMemoryCodexDB$CltnInfo$;
import com.elixirtech.mongodb.BsonUtils$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.bson.BsonBinaryReader;
import org.bson.BsonReader;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class InMemoryCodexDB$
implements LoggingHelper2,
Serializable {
    private volatile Object log$lzy1;
    public static final InMemoryCodexDB$CltnInfo$ CltnInfo;
    public static final InMemoryCodexDB$CltnFile$ CltnFile;
    private static final HashMap All;
    private volatile Object Root$lzy1;
    private volatile Object Temp$lzy1;
    public static final InMemoryCodexDB$ MODULE$;

    private InMemoryCodexDB$() {
    }

    static {
        MODULE$ = new InMemoryCodexDB$();
        All = new HashMap();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InMemoryCodexDB$.class);
    }

    public HashMap<String, InMemoryCodexDB.CltnFile> All() {
        return All;
    }

    public File Root() {
        Object object = this.Root$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.Root$lzyINIT1();
    }

    private Object Root$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.Root$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        File dir = new File(((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getString("elixir.codex.memory.root"));
                        dir.mkdirs();
                        this.log().info(() -> this.Root$lzyINIT1$$anonfun$1(dir), Line$.MODULE$.apply(32), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.Root"));
                        file = dir;
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Root$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.Root$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File Temp() {
        Object object = this.Temp$lzy1;
        if (object instanceof File) {
            return (File)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (File)this.Temp$lzyINIT1();
    }

    private Object Temp$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.Temp$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    File file = null;
                    try {
                        File dir = new File(((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getString("elixir.codex.memory.temp"));
                        dir.mkdirs();
                        this.log().info(() -> this.Temp$lzyINIT1$$anonfun$1(dir), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.Temp"));
                        file = dir;
                        object2 = file == null ? LazyVals.NullValue$.MODULE$ : file;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Temp$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.Temp$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return file;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, InMemoryCodexDB.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public InMemoryCodexDB.CltnFile getCltnFile(File f) {
        return (InMemoryCodexDB.CltnFile)this.All().getOrElseUpdate((Object)f.getCanonicalPath(), () -> this.getCltnFile$$anonfun$1(f));
    }

    public File getDir(InMemoryCodexDB.CltnInfo info) {
        File dir = info.isTemp() ? new File(this.Temp(), info.name()) : new File(this.Root(), info.name());
        dir.mkdirs();
        return dir;
    }

    public Try<Vector<Document>> readDocuments(File file) {
        return Try$.MODULE$.apply(() -> this.readDocuments$$anonfun$1(file));
    }

    public void writeDocuments(InMemoryCodexDB.CltnInfo cltnInfo, File file, Vector<Document> docs) {
        InMemoryCodexDB.CltnFile cf;
        File parent = file.getParentFile();
        String uuid = UUID.randomUUID().toString();
        File temp = new File(parent, "temp-" + uuid + ".bson");
        File bak = new File(parent, file.getName() + ".bak");
        byte[] bytes = EncryptAtRest$.MODULE$.encrypt(BsonUtils$.MODULE$.toByteArray((Seq<Document>)docs));
        boolean isDebug = InMemoryCodexCollection$.MODULE$.isDebug(cltnInfo.name());
        if (isDebug) {
            this.log().info(() -> this.writeDocuments$$anonfun$1(docs, bytes, file), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.writeDocuments"));
        }
        InMemoryCodexDB.CltnFile cltnFile = cf = this.getCltnFile(file);
        synchronized (cltnFile) {
            if (file.exists()) {
                if (bak.exists()) {
                    bak.delete();
                }
                Files.write(temp.toPath(), bytes, new OpenOption[0]);
                Files.move(file.toPath(), bak.toPath(), StandardCopyOption.REPLACE_EXISTING);
                v0 = Files.move(temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                v0 = Files.write(file.toPath(), bytes, new OpenOption[0]);
            }
            if (isDebug) {
                this.log().info(() -> this.writeDocuments$$anonfun$2(docs, bytes, file), Line$.MODULE$.apply(99), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.writeDocuments"));
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
        }
    }

    public Try<Vector<Document>> readRecords(InMemoryCodexDB.CltnInfo info) {
        File contentFile = new File(this.getDir(info), "records.data");
        return this.readDocuments(contentFile);
    }

    public Try<Vector<Document>> readIndexes(InMemoryCodexDB.CltnInfo info) {
        File indexFile = new File(this.getDir(info), "records.index");
        return this.readDocuments(indexFile);
    }

    public void writeRecords(InMemoryCodexDB.CltnInfo info, Vector<Document> records) {
        File contentFile = new File(this.getDir(info), "records.data");
        if (InMemoryCodexCollection$.MODULE$.isDebug(info.name())) {
            this.log().info(() -> this.writeRecords$$anonfun$1(info, records), Line$.MODULE$.apply(118), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.writeRecords"));
        }
        this.writeDocuments(info, contentFile, records);
    }

    public void writeIndexes(InMemoryCodexDB.CltnInfo info, Vector<Document> indexes) {
        File indexFile = new File(this.getDir(info), "records.index");
        if (InMemoryCodexCollection$.MODULE$.isDebug(info.name())) {
            this.log().info(() -> this.writeIndexes$$anonfun$1(info, indexes), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.writeIndexes"));
        }
        this.writeDocuments(info, indexFile, indexes);
    }

    private final Object Root$lzyINIT1$$anonfun$1(File dir$1) {
        return "Using codex: " + dir$1.getCanonicalPath() + " [A1]";
    }

    private final Object Temp$lzyINIT1$$anonfun$1(File dir$2) {
        return "Using codex-temp: " + dir$2.getCanonicalPath() + " [A1]";
    }

    private final InMemoryCodexDB.CltnFile getCltnFile$$anonfun$1(File f$1) {
        return InMemoryCodexDB$CltnFile$.MODULE$.apply(f$1);
    }

    private final Object readDocuments$$anonfun$1$$anonfun$1(ListBuffer buffer$1, File file$2) {
        return "loaded " + buffer$1.length() + " documents from " + file$2.getAbsolutePath();
    }

    private final Vector readDocuments$$anonfun$1(File file$1) {
        if (file$1.exists() && file$1.length() > 0L) {
            byte[] bytes = EncryptAtRest$.MODULE$.decrypt(Files.readAllBytes(file$1.toPath()));
            if (bytes.length > 0) {
                BsonDocumentCodec documentCodec = new BsonDocumentCodec();
                ListBuffer buffer = new ListBuffer();
                ByteBufNIO holder = new ByteBufNIO(ByteBuffer.wrap(bytes));
                long pos = 0L;
                while (pos < (long)bytes.length) {
                    ByteBufferBsonInput input = new ByteBufferBsonInput((ByteBuf)holder);
                    DecoderContext context = DecoderContext.builder().build();
                    BsonBinaryReader reader = new BsonBinaryReader((BsonInput)input);
                    buffer.$plus$eq((Object)Document$.MODULE$.apply(documentCodec.decode((BsonReader)reader, context)));
                    pos = Int$.MODULE$.int2long(input.getPosition());
                }
                holder.release();
                this.log().info(() -> this.readDocuments$$anonfun$1$$anonfun$1(buffer, file$1), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexDB.readDocuments"));
                return buffer.toVector();
            }
            return package$.MODULE$.Vector().empty();
        }
        return package$.MODULE$.Vector().empty();
    }

    private final Object writeDocuments$$anonfun$1(Vector docs$1, byte[] bytes$1, File file$3) {
        return "Writing " + docs$1.size() + " documents as " + bytes$1.length + " bytes in " + file$3.getAbsolutePath() + " (exists=" + file$3.exists() + ")";
    }

    private final Object writeDocuments$$anonfun$2(Vector docs$2, byte[] bytes$2, File file$4) {
        return "Written " + docs$2.size() + " documents as " + bytes$2.length + " bytes in " + file$4.getAbsolutePath();
    }

    private final Object writeRecords$$anonfun$1(InMemoryCodexDB.CltnInfo info$4, Vector records$1) {
        return "writeRecords " + info$4.name() + " [" + records$1.length() + "]";
    }

    private final Object writeIndexes$$anonfun$1(InMemoryCodexDB.CltnInfo info$5, Vector indexes$1) {
        return "writeIndexes " + info$5.name() + " [" + indexes$1.length() + "]";
    }
}

