/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mail;

import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.mail.DebugMailSender;
import com.elixirtech.mail.DebugMailSender$;
import com.elixirtech.mail.ElxMail$;
import com.elixirtech.mail.ExternalSMTPServerImpl;
import com.elixirtech.mail.GMailSender;
import com.elixirtech.mail.GMailSender$;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import com.typesafe.config.Config;
import java.io.Serializable;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ElxMail
implements MailSender {
    private final Config mailConfig;
    private final String custom;
    private final MailSender senderImpl;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ElxMail$.class.getDeclaredField("log$lzy1"));

    public static List<Address> buildAddresses(List<String> list) {
        return ElxMail$.MODULE$.buildAddresses(list);
    }

    public static LoggingInterface log() {
        return ElxMail$.MODULE$.log();
    }

    public ElxMail(SystemConfig sysConfig) {
        this.mailConfig = sysConfig.config().getConfig("elixir.mail");
        this.custom = (String)Try$.MODULE$.apply(this::$init$$$anonfun$1).toOption().getOrElse(ElxMail::$init$$$anonfun$2);
        this.senderImpl = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.custom)) ? this.loadCustom() : this.loadSMTP();
    }

    public MailSender loadCustom() {
        Object object;
        ElxMail$.MODULE$.log().info(this::loadCustom$$anonfun$1, Line$.MODULE$.apply(34), FullName$.MODULE$.apply("com.elixirtech.mail.ElxMail.loadCustom"));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Try try_ = Try$.MODULE$.apply(() -> this.loadCustom$$anonfun$2(classLoader));
        if (try_ instanceof Success && (object = ((Success)try_).value()) instanceof MailSender) {
            MailSender sender = (MailSender)object;
            return sender;
        }
        Try x = try_;
        ElxMail$.MODULE$.log().error(() -> this.loadCustom$$anonfun$3(x), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.mail.ElxMail.loadCustom"));
        ElxMail$.MODULE$.log().warn(ElxMail::loadCustom$$anonfun$4, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("com.elixirtech.mail.ElxMail.loadCustom"));
        return this.loadSMTP();
    }

    public MailSender loadSMTP() {
        String name = this.mailConfig.getString("smtp");
        boolean isDebug = DebugMailSender$.MODULE$.NAME().equalsIgnoreCase(name);
        Config chosenConfig = this.mailConfig.getConfig(name);
        if (isDebug) {
            return new DebugMailSender(chosenConfig);
        }
        return (MailSender)(GMailSender$.MODULE$.NAME().equalsIgnoreCase(name) ? new GMailSender(chosenConfig) : new ExternalSMTPServerImpl(chosenConfig));
    }

    @Override
    public LogMessage send(MailAPI.Mail2 mail) {
        if (mail.to().nonEmpty() || mail.cc().nonEmpty() || mail.bcc().nonEmpty()) {
            LogMessage logMessage = LogMessage$.MODULE$.merge((Seq)((List)((IterableOps)((IterableOps)mail.to().$plus$plus(mail.cc())).$plus$plus(mail.bcc())).$plus$plus(mail.replyTo())).map((Function1 & Serializable)email -> this.validate((String)email)));
            if (LogMessage.None$.MODULE$.equals(logMessage)) {
                return this.senderImpl.send(mail);
            }
            LogMessage other = logMessage;
            return other;
        }
        return LogMessage.Error$.MODULE$.apply("Mail not sent: No recipients");
    }

    private LogMessage validate(String email) {
        Try try_ = Try$.MODULE$.apply(() -> ElxMail.validate$$anonfun$1(email));
        if (try_ instanceof Success) {
            return LogMessage.None$.MODULE$;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return LogMessage.Error$.MODULE$.apply("Invalid email address: " + email + " (" + ex + ")");
        }
        throw new MatchError((Object)try_);
    }

    private final String $init$$$anonfun$1() {
        return this.mailConfig.getString("custom");
    }

    private static final String $init$$$anonfun$2() {
        return "";
    }

    private final Object loadCustom$$anonfun$1() {
        return "Loading custom MailSender: " + this.custom;
    }

    private final Object loadCustom$$anonfun$2(ClassLoader classLoader$1) {
        return classLoader$1.loadClass(this.custom).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private final Object loadCustom$$anonfun$3(Try x$1) {
        return "Can't load custom mail sender from " + this.custom + ": " + x$1;
    }

    private static final Object loadCustom$$anonfun$4() {
        return "Mail setup proceeding with smtp";
    }

    private static final InternetAddress validate$$anonfun$1(String email$1) {
        return new InternetAddress(email$1);
    }
}

