/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mail;

import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.HttpClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path$;
import com.elixirtech.mail.ElxMail$;
import com.elixirtech.mail.GMailSender$;
import com.elixirtech.mail.GMailSender$AccessToken$;
import com.elixirtech.mail.GMailSender$Reply$;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class GMailSender
implements MailSender,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GMailSender.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Scheduler executionContext = Scheduler$.MODULE$.global();
    private final String host;
    private final int port;
    private final boolean debug;
    private final String TOKEN_URL;
    private final String oauthUserName;
    private final String oauthClientId;
    private final String oauthSecret;
    private final String oauthRefreshToken;
    private AccessToken accessToken;

    public static String MAIL_SMTP_AUTH() {
        return GMailSender$.MODULE$.MAIL_SMTP_AUTH();
    }

    public static String MAIL_SMTP_AUTH_MECHANISMS() {
        return GMailSender$.MODULE$.MAIL_SMTP_AUTH_MECHANISMS();
    }

    public static String MAIL_SMTP_CONNECTIONTIMEOUT() {
        return GMailSender$.MODULE$.MAIL_SMTP_CONNECTIONTIMEOUT();
    }

    public static String MAIL_SMTP_HOST() {
        return GMailSender$.MODULE$.MAIL_SMTP_HOST();
    }

    public static String MAIL_SMTP_PORT() {
        return GMailSender$.MODULE$.MAIL_SMTP_PORT();
    }

    public static String MAIL_SMTP_SOCKET_FACTORY_CLASS() {
        return GMailSender$.MODULE$.MAIL_SMTP_SOCKET_FACTORY_CLASS();
    }

    public static String MAIL_SMTP_SOCKET_FACTORY_FALLBACK() {
        return GMailSender$.MODULE$.MAIL_SMTP_SOCKET_FACTORY_FALLBACK();
    }

    public static String MAIL_SMTP_STARTTLS_ENABLE() {
        return GMailSender$.MODULE$.MAIL_SMTP_STARTTLS_ENABLE();
    }

    public static String NAME() {
        return GMailSender$.MODULE$.NAME();
    }

    public static String UTF_8() {
        return GMailSender$.MODULE$.UTF_8();
    }

    public GMailSender(Config gmailConfig) {
        this.host = gmailConfig.getString("host");
        this.port = gmailConfig.getInt("port");
        this.debug = gmailConfig.getBoolean("debug");
        Config oauth2Config = gmailConfig.getConfig("oauth2");
        this.TOKEN_URL = "https://oauth2.googleapis.com/token";
        this.oauthUserName = oauth2Config.getString("userName");
        this.oauthClientId = oauth2Config.getString("clientId");
        this.oauthSecret = oauth2Config.getString("clientSecret");
        this.oauthRefreshToken = oauth2Config.getString("refreshToken");
        this.accessToken = GMailSender$AccessToken$.MODULE$.apply("", 0L);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler executionContext() {
        return this.executionContext;
    }

    @Override
    public LogMessage send(MailAPI.Mail2 mail) {
        return (LogMessage)Await$.MODULE$.result((Awaitable)this.sendT(mail).runToFuture(this.executionContext()), (Duration)FiniteDuration$.MODULE$.apply(30L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
    }

    public Task<LogMessage> sendT(MailAPI.Mail2 mail) {
        EitherT ret = EitherT$.MODULE$.apply(this.ensureValidAccessToken()).flatMap((Function1 & Serializable)x$1 -> {
            AccessToken accessToken = x$1;
            return EitherT$.MODULE$.apply(this.sendMail(mail)).map((Function1 & Serializable)msg -> msg, (Functor)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return ((Task)ret.value()).map((Function1 & Serializable)_$1 -> {
            Either either = Either$.MODULE$.MergeableEither(_$1);
            return (LogMessage)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    public Task<Either<LogMessage, LogMessage>> sendMail(MailAPI.Mail2 mail) {
        return Task$.MODULE$.apply(() -> this.sendMail$$anonfun$1(mail));
    }

    private Properties buildProperties() {
        Properties props = new Properties();
        props.put(GMailSender$.MODULE$.MAIL_SMTP_HOST(), this.host);
        props.put(GMailSender$.MODULE$.MAIL_SMTP_PORT(), BoxesRunTime.boxToInteger((int)this.port).toString());
        props.put(GMailSender$.MODULE$.MAIL_SMTP_AUTH(), "true");
        props.put(GMailSender$.MODULE$.MAIL_SMTP_STARTTLS_ENABLE(), "true");
        props.put(GMailSender$.MODULE$.MAIL_SMTP_AUTH_MECHANISMS(), "XOAUTH2");
        props.setProperty("mail.debug", BoxesRunTime.boxToBoolean((boolean)this.debug).toString());
        return props;
    }

    private void setMessageBody(MimeMultipart multipart, String content) {
        MimeBodyPart message = new MimeBodyPart();
        String body = (String)Option$.MODULE$.apply((Object)content).getOrElse(GMailSender::$anonfun$2);
        if (body.startsWith("<")) {
            message.setContent((Object)body, "text/html; charset=utf-8");
        } else {
            message.setText(body, GMailSender$.MODULE$.UTF_8());
        }
        multipart.addBodyPart((BodyPart)message);
    }

    private void buildList(Message msg, List<String> recipients, Message.RecipientType rType) {
        List<Address> rs = ElxMail$.MODULE$.buildAddresses(recipients);
        msg.setRecipients(rType, (Address[])rs.toArray(ClassTag$.MODULE$.apply(Address.class)));
    }

    private void addAttachments(MimeMultipart multipart, List<MailAPI.Attachment> attachments) {
        attachments.foreach((Function1)(JProcedure1 & Serializable)a -> {
            int idx = a.name().indexOf("|");
            String currFile = Path$.MODULE$.apply(idx >= 0 ? a.name().substring(0, idx) : a.name()).name();
            String attachmentName = MimeUtility.encodeText((String)currFile, (String)GMailSender$.MODULE$.UTF_8(), null);
            MimeBodyPart attachment = new MimeBodyPart();
            Object object = Predef$.MODULE$.byteArrayOps(a.bytes());
            ByteArrayDataSource source = new ByteArrayDataSource((byte[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(Byte.TYPE)), a.mimeType());
            attachment.setDataHandler(new DataHandler((DataSource)source));
            attachment.setFileName(attachmentName);
            attachment.setContentID("<" + attachmentName + ">");
            multipart.addBodyPart((BodyPart)attachment);
        });
    }

    public Task<Either<LogMessage, AccessToken>> ensureValidAccessToken() {
        if (System.currentTimeMillis() >= this.accessToken.expires()) {
            return this.getAccessToken().map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    this.log().warn(() -> GMailSender.ensureValidAccessToken$$anonfun$1$$anonfun$1(msg), Line$.MODULE$.apply(180), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.ensureValidAccessToken"));
                    return Left$.MODULE$.apply((Object)LogMessage.Warn$.MODULE$.apply("Unable to get AccessToken: " + msg));
                }
                if (either instanceof Right) {
                    AccessToken at;
                    this.accessToken = at = (AccessToken)((Right)either).value();
                    return Right$.MODULE$.apply((Object)this.accessToken);
                }
                throw new MatchError((Object)either);
            });
        }
        return Task$.MODULE$.now((Object)Right$.MODULE$.apply((Object)this.accessToken));
    }

    private Task<Either<String, AccessToken>> getAccessToken() {
        return Task$.MODULE$.apply(this::getAccessToken$$anonfun$1);
    }

    private Map<String, String> getTokenFormData() {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.oauthClientId);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.oauthSecret);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"refresh_token");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.oauthRefreshToken);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grant_type");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"refresh_token");
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private Either<String, AccessToken> buildAccessToken(String body) {
        long now = System.currentTimeMillis();
        String string = "access_token";
        String string2 = "expires_in";
        int size = 2;
        Either either = package$.MODULE$.decode(body, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Reply", GMailSender::buildAccessToken$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GMailSender::buildAccessToken$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GMailSender::buildAccessToken$$anonfun$3)))));
        if (either instanceof Right) {
            Reply reply = (Reply)((Right)either).value();
            return Right$.MODULE$.apply((Object)GMailSender$AccessToken$.MODULE$.apply(reply.access_token(), now + reply.expires_in() * 1000L));
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            this.log().error(() -> GMailSender.buildAccessToken$$anonfun$4(body), (Throwable)err, Line$.MODULE$.apply(214), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.buildAccessToken"));
            return Left$.MODULE$.apply((Object)("Can't read json [" + body + "]"));
        }
        throw new MatchError((Object)either);
    }

    private static final Object sendMail$$anonfun$1$$anonfun$1() {
        return "Creating session";
    }

    private static final Object sendMail$$anonfun$1$$anonfun$2() {
        return "Creating transport";
    }

    private static final Object sendMail$$anonfun$1$$anonfun$3() {
        return "Finished";
    }

    private final Either sendMail$$anonfun$1(MailAPI.Mail2 mail$2) {
        Left left;
        try {
            Properties props = this.buildProperties();
            this.log().debug(GMailSender::sendMail$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(96), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.sendMail"));
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage msg = new MimeMessage(session);
            this.buildList((Message)msg, mail$2.to(), Message.RecipientType.TO);
            this.buildList((Message)msg, mail$2.cc(), Message.RecipientType.CC);
            this.buildList((Message)msg, mail$2.bcc(), Message.RecipientType.BCC);
            msg.setReplyTo((Address[])ElxMail$.MODULE$.buildAddresses(mail$2.replyTo()).toArray(ClassTag$.MODULE$.apply(Address.class)));
            msg.setSubject(mail$2.subject());
            MimeMultipart multipart = new MimeMultipart();
            this.setMessageBody(multipart, mail$2.message());
            this.addAttachments(multipart, mail$2.attachments());
            msg.setContent((Multipart)multipart);
            this.log().debug(GMailSender::sendMail$$anonfun$1$$anonfun$2, Line$.MODULE$.apply(108), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.sendMail"));
            Thread t = Thread.currentThread();
            ClassLoader ccl = t.getContextClassLoader();
            try {
                t.setContextClassLoader(session.getClass().getClassLoader());
                Transport transport = session.getTransport("smtp");
                transport.connect(this.host, this.oauthUserName, this.accessToken.value());
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
            }
            finally {
                t.setContextClassLoader(ccl);
            }
            this.log().debug(GMailSender::sendMail$$anonfun$1$$anonfun$3, Line$.MODULE$.apply(122), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.sendMail"));
            left = Right$.MODULE$.apply((Object)LogMessage.None$.MODULE$);
        }
        catch (Exception ex) {
            left = Left$.MODULE$.apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error sending email: " + ex, (Throwable)ex));
        }
        return left;
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final Object ensureValidAccessToken$$anonfun$1$$anonfun$1(String msg$1) {
        return "Unable to get AccessToken: " + msg$1;
    }

    private final Object getAccessToken$$anonfun$1$$anonfun$1(HttpClientResponse response$1) {
        return "Getting token from " + this.TOKEN_URL + " returned " + response$1.statusCode() + ": " + response$1.bodyUtf8();
    }

    private final Either getAccessToken$$anonfun$1() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/json;q=1.0");
        HttpClientResponse response = HttpClientRequest$.MODULE$.post(this.TOKEN_URL, this.getTokenFormData(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        if (response.statusCode() == 200) {
            return this.buildAccessToken(response.bodyUtf8());
        }
        this.log().warn(() -> this.getAccessToken$$anonfun$1$$anonfun$1(response), Line$.MODULE$.apply(195), FullName$.MODULE$.apply("com.elixirtech.mail.GMailSender.getAccessToken"));
        return Left$.MODULE$.apply((Object)("getAccessToken returned a " + response.statusCode()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildAccessToken$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeLong();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 buildAccessToken$$anonfun$2() {
        GMailSender$Reply$ gMailSender$Reply$ = GMailSender$Reply$.MODULE$;
        return (Function1 & Serializable)p -> (Reply)gMailSender$Reply$.fromProduct((Product)p);
    }

    private static final Product buildAccessToken$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object buildAccessToken$$anonfun$4(String body$1) {
        return "Can't read json " + body$1;
    }

    public static final class AccessToken
    implements Product,
    Serializable {
        private final String value;
        private final long expires;

        public static AccessToken apply(String string, long l) {
            return GMailSender$AccessToken$.MODULE$.apply(string, l);
        }

        public static AccessToken fromProduct(Product product) {
            return GMailSender$AccessToken$.MODULE$.fromProduct(product);
        }

        public static AccessToken unapply(AccessToken accessToken) {
            return GMailSender$AccessToken$.MODULE$.unapply(accessToken);
        }

        public AccessToken(String value, long expires) {
            this.value = value;
            this.expires = expires;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expires()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AccessToken)) return false;
            AccessToken accessToken = (AccessToken)object;
            if (this.expires() != accessToken.expires()) return false;
            String string = this.value();
            String string2 = accessToken.value();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AccessToken;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AccessToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "expires";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public long expires() {
            return this.expires;
        }

        public AccessToken copy(String value, long expires) {
            return new AccessToken(value, expires);
        }

        public String copy$default$1() {
            return this.value();
        }

        public long copy$default$2() {
            return this.expires();
        }

        public String _1() {
            return this.value();
        }

        public long _2() {
            return this.expires();
        }
    }

    public static final class Reply
    implements Product,
    Serializable {
        private final String access_token;
        private final long expires_in;

        public static Reply apply(String string, long l) {
            return GMailSender$Reply$.MODULE$.apply(string, l);
        }

        public static Reply fromProduct(Product product) {
            return GMailSender$Reply$.MODULE$.fromProduct(product);
        }

        public static Reply unapply(Reply reply) {
            return GMailSender$Reply$.MODULE$.unapply(reply);
        }

        public Reply(String access_token, long expires_in) {
            this.access_token = access_token;
            this.expires_in = expires_in;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.access_token()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expires_in()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Reply)) return false;
            Reply reply = (Reply)object;
            if (this.expires_in() != reply.expires_in()) return false;
            String string = this.access_token();
            String string2 = reply.access_token();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Reply;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Reply";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "access_token";
            }
            if (1 == n2) {
                return "expires_in";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String access_token() {
            return this.access_token;
        }

        public long expires_in() {
            return this.expires_in;
        }

        public Reply copy(String access_token, long expires_in) {
            return new Reply(access_token, expires_in);
        }

        public String copy$default$1() {
            return this.access_token();
        }

        public long copy$default$2() {
            return this.expires_in();
        }

        public String _1() {
            return this.access_token();
        }

        public long _2() {
            return this.expires_in();
        }
    }
}

