/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BsonTransform$
implements Serializable {
    public static final BsonTransform$ MODULE$ = new BsonTransform$();

    private BsonTransform$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BsonTransform$.class);
    }

    public Json toJson(BsonValue bv2) {
        BsonValue bsonValue = bv2;
        if (bsonValue instanceof BsonNull) {
            BsonNull v = (BsonNull)bsonValue;
            return Json$.MODULE$.Null();
        }
        if (bsonValue instanceof BsonString) {
            BsonString v = (BsonString)bsonValue;
            return Json$.MODULE$.fromString(v.getValue());
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean v = (BsonBoolean)bsonValue;
            return Json$.MODULE$.fromBoolean(v.getValue());
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 v = (BsonInt32)bsonValue;
            return Json$.MODULE$.fromInt(v.getValue());
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 v = (BsonInt64)bsonValue;
            return Json$.MODULE$.fromLong(v.getValue());
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble v = (BsonDouble)bsonValue;
            return Json$.MODULE$.fromDoubleOrNull(v.getValue());
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 v = (BsonDecimal128)bsonValue;
            return Json$.MODULE$.fromString(v.getValue().bigDecimalValue().toPlainString());
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId v = (BsonObjectId)bsonValue;
            return Json$.MODULE$.fromString(v.getValue().toHexString());
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime v = (BsonDateTime)bsonValue;
            return Json$.MODULE$.fromLong(v.getValue());
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray v = (BsonArray)bsonValue;
            return Json$.MODULE$.fromValues((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(v.getValues()).asScala().map((Function1 & Serializable)bv -> this.toJson((BsonValue)bv)));
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument v = (BsonDocument)bsonValue;
            return Json$.MODULE$.fromFields((Iterable)CollectionConverters$.MODULE$.MapHasAsScala((Map)v).asScala().view().mapValues((Function1 & Serializable)bv -> this.toJson((BsonValue)bv)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary v = (BsonBinary)bsonValue;
            return (Json)this.jsonBinary(v).getOrElse(this::toJson$$anonfun$3);
        }
        BsonValue x = bsonValue;
        throw new RuntimeException("BsonTransform Unexpected BsonValue: " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(String.valueOf(x)), 20));
    }

    public Option<Json> jsonBinary(BsonBinary v) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Either either = package$.MODULE$.parse(BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).toJson());
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return json.asObject().flatMap((Function1 & Serializable)_$1 -> _$1.apply("bytes"));
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    private final Json toJson$$anonfun$3() {
        throw new RuntimeException("Can't build json bytes");
    }
}

