/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class BsonUtils$
implements Serializable {
    private static final BsonDocumentCodec documentCodec;
    private static final EncoderContext context;
    private static final DateTimeFormatter formatter;
    private static final BsonNull Null;
    private static final BsonBoolean True;
    private static final BsonBoolean False;
    private static final RawBsonDocument EmptyDocument;
    public static final BsonUtils$ MODULE$;

    private BsonUtils$() {
    }

    static {
        MODULE$ = new BsonUtils$();
        documentCodec = new BsonDocumentCodec();
        context = EncoderContext.builder().isEncodingCollectibleDocument(true).build();
        formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").toFormatter().withZone(ZoneId.systemDefault());
        Null = new BsonNull();
        True = new BsonBoolean(true);
        False = new BsonBoolean(false);
        EmptyDocument = new RawBsonDocument(new byte[]{5, 0, 0, 0, 0});
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BsonUtils$.class);
    }

    public BsonNull Null() {
        return Null;
    }

    public BsonBoolean True() {
        return True;
    }

    public BsonBoolean False() {
        return False;
    }

    public RawBsonDocument EmptyDocument() {
        return EmptyDocument;
    }

    public Option<BsonValue> get(Document doc, String attr) {
        return this.get((BsonValue)doc.toBsonDocument(), attr);
    }

    public Option<BsonValue> get(BsonValue bv, String attr) {
        None$ none$;
        try {
            none$ = this.doGet$1(bv, Predef$.MODULE$.wrapRefArray((Object[])attr.split("\\.")).toList());
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public byte[] toByteArray(Document doc) {
        return this.toByteArray(doc.toBsonDocument());
    }

    public byte[] toByteArray(org.mongodb.scala.bson.collection.mutable.Document doc) {
        return this.toByteArray(doc.toBsonDocument());
    }

    public byte[] toByteArray(BsonDocument doc) {
        BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)outputBuffer);
        documentCodec.encode((BsonWriter)writer, doc, context);
        return outputBuffer.toByteArray();
    }

    public byte[] toByteArrayMutable(Seq<BsonDocument> docs) {
        BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)outputBuffer);
        docs.foreach((Function1)(JProcedure1 & Serializable)doc -> documentCodec.encode((BsonWriter)writer, doc, context));
        return outputBuffer.toByteArray();
    }

    public byte[] toByteArray(Seq<Document> docs) {
        BasicOutputBuffer outputBuffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)outputBuffer);
        docs.foreach((Function1)(JProcedure1 & Serializable)doc -> documentCodec.encode((BsonWriter)writer, doc.toBsonDocument(), context));
        return outputBuffer.toByteArray();
    }

    public Document fromByteArray(byte[] bytes) {
        return Document$.MODULE$.apply((BsonDocument)new RawBsonDocument(bytes));
    }

    public BsonDocument toDocument(Bson bson) {
        return bson.toBsonDocument(Document.class, MongoClient$.MODULE$.DEFAULT_CODEC_REGISTRY());
    }

    public String toJson(Bson bson) {
        return this.toDocument(bson).toJson();
    }

    public String toJson(BsonDocument doc) {
        return doc.toJson();
    }

    public String toJson(Document doc) {
        return doc.toJson();
    }

    public String toJson(org.mongodb.scala.bson.collection.mutable.Document doc) {
        return doc.toJson();
    }

    public Document fromJson(String json) {
        return Document$.MODULE$.apply(BsonDocument.parse((String)json));
    }

    public byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        os.write(bytes);
        os.close();
        return baos.toByteArray();
    }

    public byte[] ungzip(byte[] bytes) {
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(bytes));
        return is.readAllBytes();
    }

    public Option<BsonString> pidMachine(BsonString pid) {
        String s = pid.getValue();
        int idx = s.indexOf("@");
        if (idx >= 0) {
            return Some$.MODULE$.apply((Object)new BsonString(s.substring(idx + 1)));
        }
        return None$.MODULE$;
    }

    public BsonDocument enrich(BsonDocument add, BsonDocument base) {
        BsonDocument doc = new BsonDocument();
        CollectionConverters$.MODULE$.SetHasAsScala(base.entrySet()).asScala().foreach((Function1 & Serializable)entry -> doc.put((String)entry.getKey(), (BsonValue)entry.getValue()));
        CollectionConverters$.MODULE$.SetHasAsScala(add.entrySet()).asScala().foreach((Function1 & Serializable)entry -> doc.put((String)entry.getKey(), (BsonValue)entry.getValue()));
        return doc;
    }

    public String asString(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonString) {
            BsonString v = (BsonString)bsonValue;
            return v.getValue();
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument v = (BsonDocument)bsonValue;
            return "Object{" + v.values().size() + " fields}";
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble v = (BsonDouble)bsonValue;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02f"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)v.getValue())}));
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 v = (BsonInt32)bsonValue;
            return BoxesRunTime.boxToInteger((int)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 v = (BsonInt64)bsonValue;
            return BoxesRunTime.boxToLong((long)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime v = (BsonDateTime)bsonValue;
            return this.timestampAsString(v.getValue());
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean v = (BsonBoolean)bsonValue;
            return BoxesRunTime.boxToBoolean((boolean)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 v = (BsonDecimal128)bsonValue;
            return v.getValue().bigDecimalValue().toString();
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId v = (BsonObjectId)bsonValue;
            return v.getValue().toHexString();
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray v = (BsonArray)bsonValue;
            return "Array[" + v.getValues().size() + "]";
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary v = (BsonBinary)bsonValue;
            return "[" + v.getData().length + " bytes]";
        }
        if (bsonValue instanceof BsonNull) {
            return "null";
        }
        BsonValue x = bsonValue;
        return String.valueOf(x);
    }

    public String asJson(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonString) {
            BsonString v = (BsonString)bsonValue;
            return "\"" + v.getValue() + "\"";
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 v = (BsonInt32)bsonValue;
            return BoxesRunTime.boxToInteger((int)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 v = (BsonInt64)bsonValue;
            return BoxesRunTime.boxToLong((long)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble v = (BsonDouble)bsonValue;
            return BoxesRunTime.boxToDouble((double)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 v = (BsonDecimal128)bsonValue;
            return v.getValue().toString();
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime v = (BsonDateTime)bsonValue;
            return BoxesRunTime.boxToLong((long)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean v = (BsonBoolean)bsonValue;
            return BoxesRunTime.boxToBoolean((boolean)v.getValue()).toString();
        }
        if (bsonValue instanceof BsonNull) {
            return "null";
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument v = (BsonDocument)bsonValue;
            return v.toJson();
        }
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(new BsonDocument("xxx", bv).toJson()), "{ \"xxx\" : ")), " }");
    }

    public String asFormattedString(BsonValue bv, String format) {
        String string;
        block14: {
            try {
                BsonValue bsonValue = bv;
                if (bsonValue instanceof BsonString) {
                    BsonString v = (BsonString)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v.getValue()}));
                    break block14;
                }
                if (bsonValue instanceof BsonDocument) {
                    BsonDocument v = (BsonDocument)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Object{" + v.values().size() + " fields}"}));
                    break block14;
                }
                if (bsonValue instanceof BsonDouble) {
                    BsonDouble v = (BsonDouble)bsonValue;
                    string = format.endsWith("d") ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format.replace("d", ".0f")), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)v.getValue())})) : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)v.getValue())}));
                    break block14;
                }
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 v = (BsonInt32)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v.getValue())}));
                    break block14;
                }
                if (bsonValue instanceof BsonInt64) {
                    BsonInt64 v = (BsonInt64)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)v.getValue())}));
                    break block14;
                }
                if (bsonValue instanceof BsonDateTime) {
                    BsonDateTime v = (BsonDateTime)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Date(v.getValue())}));
                    break block14;
                }
                if (bsonValue instanceof BsonBoolean) {
                    BsonBoolean v = (BsonBoolean)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)v.getValue())}));
                    break block14;
                }
                if (bsonValue instanceof BsonDecimal128) {
                    BsonDecimal128 v = (BsonDecimal128)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v.getValue().bigDecimalValue()}));
                    break block14;
                }
                if (bsonValue instanceof BsonObjectId) {
                    BsonObjectId v = (BsonObjectId)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v.getValue().toHexString()}));
                    break block14;
                }
                if (bsonValue instanceof BsonArray) {
                    BsonArray v = (BsonArray)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"Array[" + v.getValues().size() + "]"}));
                    break block14;
                }
                if (bsonValue instanceof BsonBinary) {
                    BsonBinary v = (BsonBinary)bsonValue;
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"[" + v.getData().length + " bytes]"}));
                    break block14;
                }
                if (bsonValue instanceof BsonNull) {
                    string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"null"}));
                    break block14;
                }
                BsonValue x = bsonValue;
                string = String.valueOf(x);
            }
            catch (Exception exception) {
                string = bv.toString();
            }
        }
        return string;
    }

    public String timestampAsString(long v) {
        return formatter.format(Instant.ofEpochMilli(v));
    }

    private final Option doGet$1(BsonValue bson, List attrs) {
        List list;
        while (true) {
            if (bson.isArray()) {
                List list2 = attrs;
                Object object = package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"length"}));
                if (!(list2 != null ? !list2.equals(object) : object != null)) {
                    return Some$.MODULE$.apply((Object)new BsonInt32(bson.asArray().size()));
                }
            }
            list = attrs;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                return Option$.MODULE$.apply((Object)bson);
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list4 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list4;
            BsonValue bsonValue = bson.asDocument().get((Object)head);
            List list5 = tail;
            bson = bsonValue;
            attrs = list5;
        }
        throw new MatchError((Object)list);
    }
}

