/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.mongodb.ConnectionStringInfo$;
import com.elixirtech.mongodb.DefaultMongoDB$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.MongoDB$;
import monix.eval.Task;
import monix.reactive.Observable$;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoClient;
import org.mongodb.scala.MongoClient$;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.package$;
import org.reactivestreams.Publisher;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DefaultMongoDB
implements MongoDB {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DefaultMongoDB.class.getDeclaredField("temp$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultMongoDB.class.getDeclaredField("logs$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultMongoDB.class.getDeclaredField("database$lzy1"));
    private final SystemConfig sysConfig;
    private final long mongoSerial;
    private final String connectionString;
    private final String mongoDatabase;
    private final String mongoLogsDatabase;
    private final String mongoTempDatabase;
    private final MongoClient mongoClient;
    private volatile Object database$lzy1;
    private volatile Object logs$lzy1;
    private volatile Object temp$lzy1;

    public static Regex ConnectionRegEx() {
        return DefaultMongoDB$.MODULE$.ConnectionRegEx();
    }

    /*
     * WARNING - void declaration
     */
    public DefaultMongoDB(SystemConfig sysConfig) {
        void var3_3;
        void var2_2;
        this.sysConfig = sysConfig;
        this.mongoSerial = MongoDB$.MODULE$.serialId().incrementAndGet();
        this.connectionString = Crypt$.MODULE$.encPrefixDecrypt(sysConfig.config().getString("elixir.mongo.connectionString"));
        this.logUsefulConnectionInfo(this.connectionString);
        this.mongoDatabase = sysConfig.config().getString("elixir.mongo.database");
        MongoDB$.MODULE$.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(25), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB"));
        String logs = sysConfig.config().getString("elixir.mongo.logsDatabase");
        this.mongoLogsDatabase = logs.isEmpty() ? this.mongoDatabase() + "-logs" : var2_2;
        String temp = sysConfig.config().getString("elixir.mongo.tempDatabase");
        this.mongoTempDatabase = temp.isEmpty() ? this.mongoDatabase() + "-temp" : var3_3;
        this.mongoClient = this.buildMongoClient();
    }

    @Override
    public SystemConfig sysConfig() {
        return this.sysConfig;
    }

    @Override
    public long mongoSerial() {
        return this.mongoSerial;
    }

    public String mongoDatabase() {
        return this.mongoDatabase;
    }

    public String mongoLogsDatabase() {
        return this.mongoLogsDatabase;
    }

    public String mongoTempDatabase() {
        return this.mongoTempDatabase;
    }

    @Override
    public MongoClient mongoClient() {
        return this.mongoClient;
    }

    public void logUsefulConnectionInfo(String cs) {
        MongoDB$.MODULE$.log().info(() -> DefaultMongoDB.logUsefulConnectionInfo$$anonfun$1(cs), Line$.MODULE$.apply(38), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.logUsefulConnectionInfo"));
    }

    public MongoClient buildMongoClient() {
        return (MongoClient)MongoDB$.MODULE$.log().infoElapsedTime(DefaultMongoDB::buildMongoClient$$anonfun$1, this::buildMongoClient$$anonfun$2, Line$.MODULE$.apply(44), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.buildMongoClient"));
    }

    @Override
    public boolean isValid() {
        Try try_ = Try$.MODULE$.apply(this::isValid$$anonfun$1);
        if (try_ instanceof Success) {
            return true;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            MongoDB$.MODULE$.log().error(() -> DefaultMongoDB.isValid$$anonfun$2(ex), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.isValid"));
            return false;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Task<BoxedUnit> ping() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.mongoClient().listDatabaseNames()).completedL();
    }

    @Override
    public MongoDatabase database() {
        Object object = this.database$lzy1;
        if (object instanceof MongoDatabase) {
            return (MongoDatabase)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDatabase)this.database$lzyINIT1();
    }

    private Object database$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.database$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDatabase mongoDatabase = null;
                    try {
                        MongoDB$.MODULE$.log().info(this::database$lzyINIT1$$anonfun$1, Line$.MODULE$.apply(62), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.database"));
                        mongoDatabase = this.mongoClient().getDatabase(this.mongoDatabase());
                        object2 = mongoDatabase == null ? LazyVals.NullValue$.MODULE$ : mongoDatabase;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.database$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.database$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return mongoDatabase;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public MongoDatabase logs() {
        Object object = this.logs$lzy1;
        if (object instanceof MongoDatabase) {
            return (MongoDatabase)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDatabase)this.logs$lzyINIT1();
    }

    private Object logs$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.logs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDatabase mongoDatabase = null;
                    try {
                        MongoDB$.MODULE$.log().info(this::logs$lzyINIT1$$anonfun$1, Line$.MODULE$.apply(67), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.logs"));
                        mongoDatabase = this.mongoClient().getDatabase(this.mongoLogsDatabase());
                        object2 = mongoDatabase == null ? LazyVals.NullValue$.MODULE$ : mongoDatabase;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.logs$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return mongoDatabase;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public MongoDatabase temp() {
        Object object = this.temp$lzy1;
        if (object instanceof MongoDatabase) {
            return (MongoDatabase)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDatabase)this.temp$lzyINIT1();
    }

    private Object temp$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.temp$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDatabase mongoDatabase = null;
                    try {
                        MongoDB$.MODULE$.log().info(this::temp$lzyINIT1$$anonfun$1, Line$.MODULE$.apply(72), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.temp"));
                        mongoDatabase = this.mongoClient().getDatabase(this.mongoTempDatabase());
                        object2 = mongoDatabase == null ? LazyVals.NullValue$.MODULE$ : mongoDatabase;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.temp$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.temp$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return mongoDatabase;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<BoxedUnit> compact(String collection) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"compact");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)collection), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.database().runCommand((Bson)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).completedL();
    }

    @Override
    public void close() {
        MongoDB$.MODULE$.log().info(DefaultMongoDB::close$$anonfun$1, Line$.MODULE$.apply(81), FullName$.MODULE$.apply("com.elixirtech.mongodb.DefaultMongoDB.close"));
        this.mongoClient().close();
    }

    private final Object $init$$$anonfun$1() {
        return "MongoDB " + this.mongoDatabase() + " Serial=" + this.mongoSerial();
    }

    private static final Object logUsefulConnectionInfo$$anonfun$1(String cs$1) {
        return "MongoDB connection information: " + ConnectionStringInfo$.MODULE$.extractUsefulConnectionInfo(cs$1);
    }

    private static final String buildMongoClient$$anonfun$1() {
        return "Building MongoDB Client";
    }

    private final MongoClient buildMongoClient$$anonfun$2() {
        return MongoClient$.MODULE$.apply(this.connectionString);
    }

    private final Observable isValid$$anonfun$1$$anonfun$1() {
        return this.mongoClient().listDatabaseNames();
    }

    private final Seq isValid$$anonfun$1() {
        return (Seq)Await$.MODULE$.result((Awaitable)package$.MODULE$.ObservableFuture(this::isValid$$anonfun$1$$anonfun$1).toFuture(), (Duration)FiniteDuration$.MODULE$.apply(15L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
    }

    private static final Object isValid$$anonfun$2(Throwable ex$1) {
        return "Error connecting to MongoDB " + ex$1;
    }

    private final Object database$lzyINIT1$$anonfun$1() {
        return "Opening database: " + this.mongoDatabase();
    }

    private final Object logs$lzyINIT1$$anonfun$1() {
        return "Opening logs database: " + this.mongoLogsDatabase();
    }

    private final Object temp$lzyINIT1$$anonfun$1() {
        return "Opening temp database: " + this.mongoTempDatabase();
    }

    private static final Object close$$anonfun$1() {
        return "Closing MongoDB Client";
    }
}

