/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.arch.info.RunMode;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.SerialId$;
import java.io.Serializable;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import org.mongodb.scala.package$;
import scala.Function1;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MongoDBRunInfo
implements RunInfo,
Elixir.OnShutdown,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBRunInfo.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBRunInfo.class.getDeclaredField("runCollection$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final RunMode runMode;
    private final Scheduler scheduler;
    private volatile Object runCollection$lzy1;
    private final BsonString pid;
    private final BsonObjectId docId;
    private final int runId;

    public MongoDBRunInfo(MongoDB mongoDB, RunMode runMode) {
        this.mongoDB = mongoDB;
        this.runMode = runMode;
        this.scheduler = Scheduler$.MODULE$.global();
        this.pid = new BsonString(JavaPID$.MODULE$.value());
        this.docId = BsonObjectId$.MODULE$.apply();
        this.runId = this.doRun();
        this.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(26), FullName$.MODULE$.apply("com.elixirtech.mongodb.MongoDBRunInfo"));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private MongoCollection<Document> runCollection() {
        Object object = this.runCollection$lzy1;
        if (object instanceof MongoCollection) {
            return (MongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoCollection)this.runCollection$lzyINIT1();
    }

    private Object runCollection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.runCollection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoCollection mongoCollection = null;
                    try {
                        mongoCollection = this.mongoDB.logs().getCollection("RunInfo", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
                        object2 = mongoCollection == null ? LazyVals.NullValue$.MODULE$ : mongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.runCollection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public BsonObjectId docId() {
        return this.docId;
    }

    public int runId() {
        return this.runId;
    }

    public void onShutdown() {
        Future fint = package$.MODULE$.SingleObservableFuture(this::$anonfun$1).toFuture();
        Await$.MODULE$.result((Awaitable)fint, (Duration)FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
        this.log().info(MongoDBRunInfo::onShutdown$$anonfun$1, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("com.elixirtech.mongodb.MongoDBRunInfo.onShutdown"));
    }

    /*
     * WARNING - void declaration
     */
    private int doRun() {
        int n;
        try {
            void var2_2;
            Task fint = SerialId$.MODULE$.get(this.mongoDB, "runCount").map((Function1)(JFunction1.mcII.sp & Serializable)runId -> {
                BsonInt32 run = new BsonInt32(runId);
                BsonDocument doc = new BsonDocument();
                doc.append("_id", (BsonValue)this.docId());
                doc.append("run", (BsonValue)run);
                doc.append("pid", (BsonValue)this.pid);
                doc.append("mode", (BsonValue)new BsonString(this.runMode.productId()));
                doc.append("started", (BsonValue)new BsonDateTime(System.currentTimeMillis()));
                package$.MODULE$.SingleObservableFuture(() -> this.$anonfun$2$$anonfun$1(doc)).toFuture();
                return runId;
            });
            int ret = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)fint.runToFuture(this.scheduler()), (Duration)FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS())));
            this.log().info(MongoDBRunInfo::doRun$$anonfun$1, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("com.elixirtech.mongodb.MongoDBRunInfo.doRun"));
            n = var2_2;
        }
        catch (Exception ex) {
            this.log().error(() -> MongoDBRunInfo.doRun$$anonfun$2(ex), (Throwable)ex, Line$.MODULE$.apply(54), FullName$.MODULE$.apply("com.elixirtech.mongodb.MongoDBRunInfo.doRun"));
            n = -2;
        }
        return n;
    }

    private final Object $init$$$anonfun$1() {
        return "PId = " + JavaPID$.MODULE$.value() + " RunId = " + this.runId();
    }

    private final SingleObservable $anonfun$1() {
        return this.runCollection().updateOne(Filters$.MODULE$.eq("_id", (Object)this.docId()), Updates$.MODULE$.set("stopped", (Object)new BsonDateTime(System.currentTimeMillis())));
    }

    private static final Object onShutdown$$anonfun$1() {
        return "Stopped";
    }

    private final SingleObservable $anonfun$2$$anonfun$1(BsonDocument doc$1) {
        return this.runCollection().insertOne((Object)Document$.MODULE$.apply(doc$1));
    }

    private static final Object doRun$$anonfun$1() {
        return "Started";
    }

    private static final Object doRun$$anonfun$2(Exception ex$1) {
        return "Error in doRun: " + ex$1;
    }
}

