/*
 * Decompiled with CFR 0.152.
 */
package io.github.nremond;

import io.github.nremond.PBKDF2$;
import io.github.nremond.SecureHash;
import io.github.nremond.SecureHash$internals$;
import io.github.nremond.SecureHash$internals$Decoded$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class SecureHash$
implements Serializable {
    public static final SecureHash$internals$ internals;
    public static final SecureHash$ MODULE$;

    private SecureHash$() {
    }

    static {
        MODULE$ = new SecureHash$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SecureHash$.class);
    }

    public String createHash(String password, int iterations, int dkLength, String cryptoAlgo, int saltLength) {
        byte[] b = new byte[saltLength];
        new SecureRandom().nextBytes(b);
        byte[] salt = b;
        byte[] key = PBKDF2$.MODULE$.apply(password.getBytes(StandardCharsets.UTF_8), salt, iterations, dkLength, cryptoAlgo);
        return SecureHash$internals$.MODULE$.encode(salt, key, iterations, cryptoAlgo);
    }

    public int createHash$default$2() {
        return 20000;
    }

    public int createHash$default$3() {
        return 32;
    }

    public String createHash$default$4() {
        return "HmacSHA512";
    }

    public int createHash$default$5() {
        return 24;
    }

    private boolean secureEquality(byte[] a1, byte[] a2) {
        Object object;
        Object object2;
        return a1.length == a2.length && BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object = Predef$.MODULE$.byteArrayOps(a1), (IterableOnce)Predef$.MODULE$.wrapByteArray(a2))), (Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> this.secureEquality$$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1), (Tuple2)x$2))) == 0;
    }

    public boolean validatePassword(String password, String hashedPassword) {
        SecureHash.internals.Decoded decoded;
        Option<SecureHash.internals.Decoded> option = SecureHash$internals$.MODULE$.decode(hashedPassword);
        if (option instanceof Some && (decoded = (SecureHash.internals.Decoded)((Some)option).value()) != null) {
            SecureHash.internals.Decoded decoded2 = SecureHash$internals$Decoded$.MODULE$.unapply(decoded);
            String string = decoded2._1();
            int n = decoded2._2();
            String string2 = decoded2._3();
            byte[] byArray = decoded2._4();
            byte[] byArray2 = decoded2._5();
            int iterations = n;
            String algo = string2;
            byte[] salt = byArray;
            byte[] key = byArray2;
            byte[] hash = PBKDF2$.MODULE$.apply(password.getBytes(StandardCharsets.UTF_8), salt, iterations, key.length, algo);
            return this.secureEquality(key, hash);
        }
        return false;
    }

    private final /* synthetic */ int secureEquality$$anonfun$1(int x$1, Tuple2 x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            int r = BoxesRunTime.unboxToInt((Object)tuple2._1());
            if (tuple22 != null) {
                byte x1 = BoxesRunTime.unboxToByte((Object)tuple22._1());
                byte x2 = BoxesRunTime.unboxToByte((Object)tuple22._2());
                return r | (byte)(x1 ^ x2);
            }
        }
        throw new MatchError((Object)tuple2);
    }
}

