/*
 * Decompiled with CFR 0.152.
 */
package ambience.apieditor.management;

import ambience.apieditor.management.APIManager;
import ambience.apieditor.oas.OAS3$;
import ambience.framework.UUIDDocumentManager2;
import ambience.framework.UUIDDocumentRoute2;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.mongodb.UploadHelper2$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UploadHelper
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UploadHelper.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final APIManager apiManager;
    private final UUIDDocumentRoute2 docRouteForAPI;

    public UploadHelper(APIManager apiManager, UUIDDocumentRoute2 docRouteForAPI) {
        this.apiManager = apiManager;
        this.docRouteForAPI = docRouteForAPI;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Json uploadedAPI(UserDB.User user, String name, Json apiJson) {
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(name));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(user.id()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"access");
        Object[] objectArray2 = new Tuple2[1];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"roles");
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil()));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromFields((Iterable)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"published");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromBoolean(false));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"api");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.fromString(apiJson.noSpaces()));
        Json ret = Json$.MODULE$.fromFields((Iterable)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.log().info(() -> UploadHelper.uploadedAPI$$anonfun$1(ret), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.apieditor.management.UploadHelper.uploadedAPI"));
        return ret;
    }

    public Either<String, Json> prepareUploadedData(String fileFormat, String data) {
        String string = fileFormat;
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Either either = package$.MODULE$.parse(data);
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return scala.package$.MODULE$.Right().apply((Object)json);
            }
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                return scala.package$.MODULE$.Left().apply((Object)err.message());
            }
            throw new MatchError((Object)either);
        }
        Either<ParsingFailure, Json> either = io.circe.yaml.parser.package$.MODULE$.parse(data);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return scala.package$.MODULE$.Right().apply((Object)json);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return scala.package$.MODULE$.Left().apply((Object)err.message());
        }
        throw new MatchError(either);
    }

    public Task<GravityResponse> handleUpload(UserDB.User user, String fileFormat, String name, String data, String overwrite) {
        Either<String, Json> either = this.prepareUploadedData(fileFormat, data);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            Either either2 = package$.MODULE$.decode(json.noSpaces(), OAS3$.MODULE$.decoder());
            if (either2 instanceof Right) {
                String string = overwrite;
                String string2 = "true";
                Task uploadPreparation = !(string != null ? !string.equals(string2) : string2 != null) ? UploadHelper2$.MODULE$.handleDeleteBeforeUpload((UUIDDocumentManager2)this.apiManager, user, name) : Task$.MODULE$.now((Object)LogMessage.None$.MODULE$);
                return uploadPreparation.flatMap((Function1 & Serializable)x$1 -> {
                    LogMessage logMessage = x$1;
                    if (LogMessage.None$.MODULE$.equals(logMessage)) {
                        Json newAPI = this.uploadedAPI(user, name, json);
                        return this.docRouteForAPI.save(user, newAPI);
                    }
                    LogMessage msg = logMessage;
                    this.log().apply(msg, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("ambience.apieditor.management.UploadHelper.handleUpload"));
                    return Gravity$.MODULE$.BadRequestResponseT("Overwrite removal failed");
                });
            }
            if (either2 instanceof Left) {
                return Gravity$.MODULE$.BadRequestResponseT("Upload failed, not valid OpenAPI 3.0.X format");
            }
            throw new MatchError((Object)either2);
        }
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            this.log().error(() -> UploadHelper.handleUpload$$anonfun$2(err), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.apieditor.management.UploadHelper.handleUpload"));
            return Gravity$.MODULE$.BadRequestResponseT("Upload failed " + err);
        }
        throw new MatchError(either);
    }

    private static final Object uploadedAPI$$anonfun$1(Json ret$1) {
        return "Uploaded API: " + ret$1.spaces2();
    }

    private static final Object handleUpload$$anonfun$2(String err$1) {
        return "Upload failed " + err$1;
    }
}

