/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.designer;

import ambience.SystemScheduler$;
import ambience.framework.EventBus;
import ambience.framework.EventBus$;
import ambience.theme.FileId;
import ambience.theme.FilePath;
import ambience.theme.FilePath$;
import ambience.theme.ThemeId;
import ambience.theme.ThemeId$;
import ambience.theme.ThemeName;
import ambience.themes.designer.FileHelper$;
import ambience.themes.designer.ThemeAPI$;
import ambience.themes.designer.ThemeAPI$ColFileInfo$;
import ambience.themes.designer.ThemeAPI$Theme$;
import ambience.themes.designer.ThemeAPI$WebFileInfo$;
import ambience.themes.designer.ThemeCache$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import java.io.Serializable;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ThemeAPI
implements ambience.api.ThemeAPI,
LoggingHelper2 {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ThemeAPI.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ThemeAPI.class.getDeclaredField("evtBus$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ThemeAPI.class.getDeclaredField("webCltn$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ThemeAPI.class.getDeclaredField("themeCltn$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private volatile Object themeCltn$lzy1;
    private volatile Object webCltn$lzy1;
    private volatile Object evtBus$lzy1;
    private final FindOneAndUpdateOptions updateOpts;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ThemeAPI$.class.getDeclaredField("ThemeEnabled$lzy1"));

    public static String DeleteSuffix() {
        return ThemeAPI$.MODULE$.DeleteSuffix();
    }

    public static boolean ThemeEnabled() {
        return ThemeAPI$.MODULE$.ThemeEnabled();
    }

    public static Option<ColFileInfo> buildColFileInfo(Document document) {
        return ThemeAPI$.MODULE$.buildColFileInfo(document);
    }

    public static String buildHash(byte[] byArray) {
        return ThemeAPI$.MODULE$.buildHash(byArray);
    }

    public static Option<Tuple2<String, String>> buildThemeInfo(Document document) {
        return ThemeAPI$.MODULE$.buildThemeInfo(document);
    }

    public static Bson deleteAction(String string) {
        return ThemeAPI$.MODULE$.deleteAction(string);
    }

    public static Bson exists() {
        return ThemeAPI$.MODULE$.exists();
    }

    public static Bson inWebFolder() {
        return ThemeAPI$.MODULE$.inWebFolder();
    }

    public static String newId() {
        return ThemeAPI$.MODULE$.newId();
    }

    public static long now() {
        return ThemeAPI$.MODULE$.now();
    }

    public static Document toDoc(String string, Path path, boolean bl) {
        return ThemeAPI$.MODULE$.toDoc(string, path, bl);
    }

    public static Document toDoc(String string, String string2, String string3, byte[] byArray, boolean bl, Option<Object> option) {
        return ThemeAPI$.MODULE$.toDoc(string, string2, string3, byArray, bl, option);
    }

    public static Bson undeleteAction(String string) {
        return ThemeAPI$.MODULE$.undeleteAction(string);
    }

    public static String uniqueKey() {
        return ThemeAPI$.MODULE$.uniqueKey();
    }

    public static Bson withId(String string) {
        return ThemeAPI$.MODULE$.withId(string);
    }

    public static Bson withPath(String string) {
        return ThemeAPI$.MODULE$.withPath(string);
    }

    public static Bson withThemeId(String string) {
        return ThemeAPI$.MODULE$.withThemeId(string);
    }

    public ThemeAPI(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
        Scheduler scheduler = SystemScheduler$.MODULE$.global();
        this.updateOpts = new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER);
        EventBus$.MODULE$.events().mapEval((Function1 & Serializable)msg -> this.eventBusUpdate(msg.eventType(), msg.doc())).completedL().runAsyncAndForget(Scheduler$.MODULE$.global());
        this.loadCache(false).runAsyncAndForget(scheduler);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection themeCltn() {
        Object object = this.themeCltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.themeCltn$lzyINIT1();
    }

    private Object themeCltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.themeCltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB.database().getCollection("Theme", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.themeCltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection webCltn() {
        Object object = this.webCltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.webCltn$lzyINIT1();
    }

    private Object webCltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.webCltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB.database().getCollection("Web", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.webCltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public EventBus evtBus() {
        Object object = this.evtBus$lzy1;
        if (object instanceof EventBus) {
            return (EventBus)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (EventBus)this.evtBus$lzyINIT1();
    }

    private Object evtBus$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.evtBus$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    EventBus eventBus = null;
                    try {
                        eventBus = (EventBus)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(EventBus.class));
                        object2 = eventBus == null ? LazyVals.NullValue$.MODULE$ : eventBus;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.evtBus$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return eventBus;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<DataBytes> content(String path, String language) {
        return ThemeCache$.MODULE$.contentBytesPath(FilePath$.MODULE$.apply(path), language).map((Function1 & Serializable)_$8 -> FullDataBytes$.MODULE$.apply(_$8));
    }

    public Task<Either<String, List<FileInfo>>> fileList(String themeId) {
        return this.themeExists(themeId).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right && BoxesRunTime.unboxToBoolean((Object)((Right)either).value())) {
                return this.colFiles(themeId).map((Function1 & Serializable)list -> {
                    List found = this.webFiles().map((Function1 & Serializable)wf -> (FileInfo)list.find((Function1 & Serializable)_$9 -> {
                        String string = wf.path();
                        String string2 = _$9.path();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }).getOrElse(() -> ThemeAPI.$anonfun$1$$anonfun$2(wf)));
                    List foundPaths = found.map((Function1 & Serializable)_$10 -> new FilePath(_$10.path()));
                    List notFound = list.filter((Function1 & Serializable)cf -> !foundPaths.contains((Object)new FilePath(cf.path())));
                    return package$.MODULE$.Right().apply(found.$plus$plus((IterableOnce)notFound));
                });
            }
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("No Theme found for id: " + themeId)));
        });
    }

    public List<WebFileInfo> webFiles() {
        return FileHelper$.MODULE$.buildFilePathList(FileHelper$.MODULE$.buildFilePathList$default$1()).map((Function1 & Serializable)path -> ThemeAPI$WebFileInfo$.MODULE$.apply(FilePath$.MODULE$.apply(FileHelper$.MODULE$.normalisePath(FileHelper$.MODULE$.toRelativePath((Path)path).toString())), (Path)path));
    }

    public Task<List<ColFileInfo>> colFiles(String themeId) {
        return this.webCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ThemeAPI$.MODULE$.withThemeId(themeId), ThemeAPI$.MODULE$.exists()}))).flatMap((Function1 & Serializable)doc -> {
            Option<ColFileInfo> option = ThemeAPI$.MODULE$.buildColFileInfo((Document)doc);
            if (None$.MODULE$.equals(option)) {
                return Observable$.MODULE$.empty();
            }
            if (option instanceof Some) {
                ColFileInfo cfi = (ColFileInfo)((Some)option).value();
                return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ColFileInfo[]{cfi}));
            }
            throw new MatchError(option);
        }).onErrorHandleWith((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.colFiles$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(176), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.colFiles"));
            return Observable$.MODULE$.empty();
        }).toListL();
    }

    public Task<Option<ColFileInfo>> fileInfo(String id) {
        Option<ColFileInfo> option = ThemeCache$.MODULE$.get(id);
        if (option instanceof Some) {
            ColFileInfo cf = (ColFileInfo)((Some)option).value();
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)cf));
        }
        if (None$.MODULE$.equals(option)) {
            return this.colFileInfo(id);
        }
        throw new MatchError(option);
    }

    public Task<Option<byte[]>> contentBytesId(String id) {
        Option<ColFileInfo> option = ThemeCache$.MODULE$.get(id);
        if (option instanceof Some) {
            ColFileInfo cf = (ColFileInfo)((Some)option).value();
            return Task$.MODULE$.now((Object)Some$.MODULE$.apply((Object)cf.bytes()));
        }
        if (None$.MODULE$.equals(option)) {
            return this.colFileInfo(id).map((Function1 & Serializable)_$11 -> _$11.map((Function1 & Serializable)_$12 -> _$12.bytes()));
        }
        throw new MatchError(option);
    }

    public Task<Option<ColFileInfo>> colFileInfo(String id) {
        return this.webCltn().findOneO(ThemeAPI$.MODULE$.withId(id)).map((Function1 & Serializable)doc -> ThemeAPI$.MODULE$.buildColFileInfo((Document)doc)).onErrorHandleWith((Function1 & Serializable)_$13 -> Observable$.MODULE$.empty()).firstOrElseL(ThemeAPI::colFileInfo$$anonfun$3);
    }

    public Task<Either<String, ColFileInfo>> add(String userId, String themeId, String path, byte[] bytes, boolean inWebFolder, Option<Object> updated) {
        String id = ThemeAPI$.MODULE$.newId();
        return this.webCltn().insertOneT(ThemeAPI$.MODULE$.toDoc(themeId, id, path, bytes, inWebFolder, updated)).flatMap((Function1 & Serializable)_$14 -> this.updateLastModifiedBy(userId, themeId).flatMap((Function1 & Serializable)_$15 -> this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)_$16 -> package$.MODULE$.Right().apply((Object)ThemeAPI$ColFileInfo$.MODULE$.apply(id, path, bytes, inWebFolder, ThemeAPI$.MODULE$.buildHash(bytes), updated))))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.add$$anonfun$2$$anonfun$1(path, ex), ex, Line$.MODULE$.apply(221), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.add"));
            return package$.MODULE$.Left().apply((Object)("Error inserting " + path));
        });
    }

    public Task<Either<String, ColFileInfo>> deleteByPath(String userId, String themeId, String path) {
        Bson filters = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ThemeAPI$.MODULE$.withThemeId(themeId), ThemeAPI$.MODULE$.exists(), ThemeAPI$.MODULE$.withPath(path)}));
        return this.webCltn().findOneAndUpdateT(filters, ThemeAPI$.MODULE$.deleteAction(ThemeAPI$.MODULE$.uniqueKey()), this.updateOpts).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("No document found with path: " + path)));
            }
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return this.updateLastModifiedBy(userId, themeId).flatMap((Function1 & Serializable)_$17 -> {
                    Option<ColFileInfo> option = ThemeAPI$.MODULE$.buildColFileInfo(doc);
                    if (None$.MODULE$.equals(option)) {
                        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("Problem building ColFileInfo from: " + doc)));
                    }
                    if (option instanceof Some) {
                        ColFileInfo cfi = (ColFileInfo)((Some)option).value();
                        return this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)_$18 -> package$.MODULE$.Right().apply((Object)cfi));
                    }
                    throw new MatchError(option);
                });
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.deleteByPath$$anonfun$2$$anonfun$1(path, ex), ex, Line$.MODULE$.apply(241), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.deleteByPath"));
            return package$.MODULE$.Left().apply((Object)("Error deleting " + path));
        });
    }

    public Task<Either<String, BoxedUnit>> deleteById(String userId, String id) {
        return this.webCltn().findOneAndUpdateT(ThemeAPI$.MODULE$.withId(id), ThemeAPI$.MODULE$.deleteAction(ThemeAPI$.MODULE$.uniqueKey()), this.updateOpts).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("No document found with id: " + id)));
            }
            if (option instanceof Some) {
                return this.updateLastModifiedByFromFileId(userId, id).flatMap((Function1 & Serializable)_$19 -> this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)_$20 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.deleteById$$anonfun$2$$anonfun$1(id, ex), ex, Line$.MODULE$.apply(257), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.deleteById"));
            return package$.MODULE$.Left().apply((Object)("Error deleting " + new FileId(id)));
        });
    }

    public Task<Either<String, BoxedUnit>> undeleteById(String userId, String id) {
        return this.webCltn().findOneAndUpdateT(ThemeAPI$.MODULE$.withId(id), ThemeAPI$.MODULE$.undeleteAction(ThemeAPI$.MODULE$.uniqueKey()), this.updateOpts).flatMap((Function1 & Serializable)optDoc -> this.updateLastModifiedByFromFileId(userId, id).flatMap((Function1 & Serializable)_$21 -> {
            Option option = optDoc.flatMap((Function1 & Serializable)doc -> ThemeAPI$.MODULE$.buildColFileInfo((Document)doc));
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("Undelete document not found in collection " + new FileId(id))));
            }
            if (option instanceof Some) {
                return this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)_$22 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
            throw new MatchError((Object)option);
        })).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.undeleteById$$anonfun$2$$anonfun$1(id, ex), ex, Line$.MODULE$.apply(274), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.undeleteById"));
            return package$.MODULE$.Left().apply((Object)("Error deleting " + new FileId(id)));
        });
    }

    public Task<Either<String, BoxedUnit>> reset(String userId, String themeId, String id) {
        return this.deleteById(userId, id);
    }

    public Task<Either<String, ColFileInfo>> unreset(String userId, String themeId, String id) {
        return this.webCltn().findOneAndUpdateT(ThemeAPI$.MODULE$.withId(id), ThemeAPI$.MODULE$.undeleteAction(ThemeAPI$.MODULE$.uniqueKey()), this.updateOpts).flatMap((Function1 & Serializable)optDoc -> this.updateLastModifiedBy(userId, themeId).flatMap((Function1 & Serializable)_$23 -> {
            Option option = optDoc.flatMap((Function1 & Serializable)doc -> ThemeAPI$.MODULE$.buildColFileInfo((Document)doc));
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("unreset document not found in collection " + new FileId(id))));
            }
            if (option instanceof Some) {
                ColFileInfo fi = (ColFileInfo)((Some)option).value();
                return this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)_$24 -> package$.MODULE$.Right().apply((Object)fi));
            }
            throw new MatchError((Object)option);
        })).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.unreset$$anonfun$2$$anonfun$1(id, ex), ex, Line$.MODULE$.apply(295), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.unreset"));
            return package$.MODULE$.Left().apply((Object)("Error deleting " + new FileId(id)));
        });
    }

    public Task<Either<String, BoxedUnit>> resetAll(String userId, String themeId) {
        Task result = this.webCltn().deleteManyT(ThemeAPI$.MODULE$.withThemeId(themeId)).flatMap((Function1 & Serializable)x$1 -> {
            DeleteResult deleteResult = x$1;
            return this.loadCache(this.loadCache$default$1()).map((Function1 & Serializable)result -> result);
        });
        return result.flatMap((Function1 & Serializable)res -> this.updateLastModifiedBy(userId, themeId).map((Function1 & Serializable)_$25 -> res)).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.resetAll$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(310), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.resetAll"));
            return package$.MODULE$.Left().apply((Object)"Error dropping Web Collection");
        });
    }

    public Task<Either<String, BoxedUnit>> deleteAll(String userId, String themeId) {
        return this.webCltn().updateManyT(ThemeAPI$.MODULE$.withThemeId(themeId), ThemeAPI$.MODULE$.deleteAction(ThemeAPI$.MODULE$.uniqueKey())).flatMap((Function1 & Serializable)_$26 -> this.updateLastModifiedBy(userId, themeId).flatMap((Function1 & Serializable)_$27 -> this.loadCache(this.loadCache$default$1()))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.deleteAll$$anonfun$2$$anonfun$1(themeId, ex), ex, Line$.MODULE$.apply(322), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.deleteAll"));
            return package$.MODULE$.Left().apply((Object)("Error deleting all for " + new ThemeId(themeId)));
        });
    }

    public Task<Either<String, BoxedUnit>> undeleteAll(String userId, String themeId) {
        return this.webCltn().updateManyT(ThemeAPI$.MODULE$.withThemeId(themeId), ThemeAPI$.MODULE$.undeleteAction(ThemeAPI$.MODULE$.uniqueKey())).flatMap((Function1 & Serializable)_$28 -> this.updateLastModifiedBy(userId, themeId).flatMap((Function1 & Serializable)_$29 -> this.loadCache(this.loadCache$default$1()))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.undeleteAll$$anonfun$2$$anonfun$1(themeId, ex), ex, Line$.MODULE$.apply(334), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.undeleteAll"));
            return package$.MODULE$.Left().apply((Object)("Error undeleting all for " + new ThemeId(themeId)));
        });
    }

    public Task<Either<String, BoxedUnit>> update(String userId, String id, byte[] bytes) {
        long ts = ThemeAPI$.MODULE$.now();
        Bson updates = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.set("bytes", (Object)BsonBinary$.MODULE$.apply(bytes)), Updates$.MODULE$.set("updated", (Object)BsonDateTime$.MODULE$.apply(ts))}));
        return this.webCltn().updateOneT(ThemeAPI$.MODULE$.withId(id), updates).flatMap((Function1 & Serializable)_$30 -> this.updateLastModifiedByFromFileId(userId, id).flatMap((Function1 & Serializable)_$31 -> this.loadCache(this.loadCache$default$1()))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.update$$anonfun$2$$anonfun$1(id, ex), ex, Line$.MODULE$.apply(348), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.update"));
            return package$.MODULE$.Left().apply((Object)("Error updating " + new FileId(id)));
        });
    }

    public Task<BoxedUnit> updateLastModifiedBy(String userId, String id) {
        long ts = ThemeAPI$.MODULE$.now();
        Bson updates = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Updates$.MODULE$.set("lastModifiedBy", (Object)BsonString$.MODULE$.apply(userId)), Updates$.MODULE$.set("lastModified", (Object)BsonDateTime$.MODULE$.apply(ts))}));
        return this.themeCltn().updateOneT(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id)), updates).map((Function1)(JProcedure1 & Serializable)_$32 -> {});
    }

    public Task<BoxedUnit> updateLastModifiedByFromFileId(String userId, String id) {
        return this.getThemeIdFromFileId(id).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object object = ((Some)option).value();
                String themeId = object == null ? null : ((ThemeId)object).value();
                return this.updateLastModifiedBy(userId, themeId);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().error(() -> ThemeAPI.updateLastModifiedByFromFileId$$anonfun$1$$anonfun$1(id), Line$.MODULE$.apply(363), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.updateLastModifiedByFromFileId"));
                return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<String>> getThemeIdFromFileId(String id) {
        return this.webCltn().findOneO(ThemeAPI$.MODULE$.withId(id)).map((Function1 & Serializable)_$33 -> _$33.get("themeId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)v -> new ThemeId(ThemeId$.MODULE$.apply(v.getValue())))).onErrorHandleWith((Function1 & Serializable)_$34 -> Observable$.MODULE$.empty()).firstOrElseL(ThemeAPI::getThemeIdFromFileId$$anonfun$3);
    }

    public Task<Option<String>> findThemeName(String themeId) {
        return this.themeCltn().findOneO(ThemeAPI$Theme$.MODULE$.withId(themeId)).map((Function1 & Serializable)doc2 -> Option$.MODULE$.apply(doc2).map((Function1 & Serializable)doc -> ThemeAPI$.MODULE$.buildThemeInfo((Document)doc)).flatMap((Function1 & Serializable)_$35 -> _$35.map((Function1 & Serializable)_$36 -> new ThemeName(ThemeAPI.findThemeName$$anonfun$1$$anonfun$2$$anonfun$1(_$36))))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.findThemeName$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(383), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findThemeName"));
            return None$.MODULE$;
        }).firstOrElseL(ThemeAPI::findThemeName$$anonfun$3);
    }

    public Task<Option<String>> findThemeName(String userId, String themeId) {
        return this.themeCltn().findOneO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ThemeAPI$Theme$.MODULE$.withId(themeId), ThemeAPI$Theme$.MODULE$.exists()}))).map((Function1 & Serializable)doc2 -> Option$.MODULE$.apply(doc2).map((Function1 & Serializable)doc -> ThemeAPI$.MODULE$.buildThemeInfo((Document)doc)).flatMap((Function1 & Serializable)_$37 -> _$37.map((Function1 & Serializable)_$38 -> new ThemeName(ThemeAPI.findThemeName$$anonfun$4$$anonfun$2$$anonfun$1(_$38))))).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.findThemeName$$anonfun$5$$anonfun$1(ex), ex, Line$.MODULE$.apply(396), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findThemeName"));
            return None$.MODULE$;
        }).firstOrElseL(ThemeAPI::findThemeName$$anonfun$6);
    }

    public Task<BoxedUnit> eventBusUpdate(String eventType, Document doc) {
        String string = eventType;
        String string2 = "Themes/cacheReloaded";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.eventBusUpdate$$anonfun$1();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.loadCache(false).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        this.log().error(() -> ThemeAPI.eventBusUpdate$$anonfun$2$$anonfun$1$$anonfun$1(eventType), Line$.MODULE$.apply(407), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.eventBusUpdate"));
                        return;
                    }
                    if (either instanceof Right) {
                        this.log().info(() -> ThemeAPI.eventBusUpdate$$anonfun$2$$anonfun$1$$anonfun$2(eventType), Line$.MODULE$.apply(408), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.eventBusUpdate"));
                        return;
                    }
                    throw new MatchError((Object)either);
                }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> doLoadCache(String eventType) {
        String string = eventType;
        String string2 = "Themes/cacheReloaded";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.doLoadCache$$anonfun$1();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.loadCache(false).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        this.log().error(() -> ThemeAPI.doLoadCache$$anonfun$2$$anonfun$1$$anonfun$1(eventType), Line$.MODULE$.apply(420), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.doLoadCache"));
                        return;
                    }
                    if (either instanceof Right) {
                        this.log().info(() -> ThemeAPI.doLoadCache$$anonfun$2$$anonfun$1$$anonfun$2(eventType), Line$.MODULE$.apply(421), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.doLoadCache"));
                        return;
                    }
                    throw new MatchError((Object)either);
                }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<Either<String, BoxedUnit>> loadCache(boolean fireEvent) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            ThemeAPI.loadCache$$anonfun$1();
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.findActiveTheme().flatMap((Function1 & Serializable)x$12 -> {
                Either either = x$12;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg));
                }
                if (either instanceof Right) {
                    Option option = (Option)((Right)either).value();
                    if (None$.MODULE$.equals(option)) {
                        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                    }
                    if (option instanceof Some) {
                        Object object = ((Some)option).value();
                        String themeId = object == null ? null : ((ThemeId)object).value();
                        return this.load(themeId).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Left) {
                                String v = (String)((Left)either).value();
                                return package$.MODULE$.Left().apply((Object)v);
                            }
                            if (either instanceof Right) {
                                if (fireEvent) {
                                    this.log().info(ThemeAPI::loadCache$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(438), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.loadCache"));
                                    this.evtBus().addEvent("Themes/cacheReloaded", Document$.MODULE$.apply());
                                }
                                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            }
                            throw new MatchError((Object)either);
                        });
                    }
                }
                throw new MatchError((Object)either);
            }).map((Function1 & Serializable)res -> res);
        });
    }

    public boolean loadCache$default$1() {
        return true;
    }

    private Task<Either<String, Object>> themeExists(String themeId) {
        return this.themeCltn().findOneO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ThemeAPI$Theme$.MODULE$.withId(themeId), ThemeAPI$Theme$.MODULE$.exists()}))).map((Function1 & Serializable)doc -> {
            Option option = Option$.MODULE$.apply(doc);
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (option instanceof Some) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.themeExists$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(457), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.themeExists"));
            return package$.MODULE$.Left().apply((Object)"Error finding active Theme");
        }).firstOrElseL(ThemeAPI::themeExists$$anonfun$3);
    }

    private Task<Either<String, BoxedUnit>> load(String themeId) {
        return this.webCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{ThemeAPI$.MODULE$.withThemeId(themeId), ThemeAPI$.MODULE$.exists()}))).map((Function1 & Serializable)doc -> {
            ThemeAPI$.MODULE$.buildColFileInfo((Document)doc).foreach((Function1)(JProcedure1 & Serializable)info -> ThemeCache$.MODULE$.put((ColFileInfo)info));
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.load$$anonfun$2$$anonfun$1(ex), ex, Line$.MODULE$.apply(471), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.load"));
            return package$.MODULE$.Left().apply((Object)"Error loading cache");
        }).lastOrElseL(ThemeAPI::load$$anonfun$3);
    }

    public Task<Either<String, Option<String>>> findActiveTheme() {
        if (!ThemeAPI$.MODULE$.ThemeEnabled()) {
            this.log().info(ThemeAPI::findActiveTheme$$anonfun$1, Line$.MODULE$.apply(479), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findActiveTheme"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        }
        return this.themeCltn().findOneO(ThemeAPI$Theme$.MODULE$.active()).map((Function1 & Serializable)doc -> {
            Option option = Option$.MODULE$.apply(doc);
            if (None$.MODULE$.equals(option)) {
                this.log().info(ThemeAPI::findActiveTheme$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(488), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findActiveTheme"));
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            if (option instanceof Some) {
                Document doc2 = (Document)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)ThemeAPI$.MODULE$.buildThemeInfo(doc2).map((Function1 & Serializable)x$1 -> new ThemeId(this.findActiveTheme$$anonfun$2$$anonfun$2((Tuple2)x$1))));
            }
            throw new MatchError((Object)option);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> ThemeAPI.findActiveTheme$$anonfun$3$$anonfun$1(ex), ex, Line$.MODULE$.apply(498), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findActiveTheme"));
            return package$.MODULE$.Left().apply((Object)"Error finding active Theme");
        }).firstOrElseL(ThemeAPI::findActiveTheme$$anonfun$4);
    }

    private static final FileInfo $anonfun$1$$anonfun$2(WebFileInfo wf$2) {
        return wf$2;
    }

    private static final Object colFiles$$anonfun$2$$anonfun$1(Throwable ex$1) {
        return "Error loading from Web Collection: " + ex$1;
    }

    private static final Option colFileInfo$$anonfun$3() {
        return None$.MODULE$;
    }

    private static final Object add$$anonfun$2$$anonfun$1(String path$5, Throwable ex$2) {
        return "Error inserting " + path$5 + ": " + ex$2;
    }

    private static final Object deleteByPath$$anonfun$2$$anonfun$1(String path$8, Throwable ex$3) {
        return "Error deleting " + path$8 + ": " + ex$3;
    }

    private static final Object deleteById$$anonfun$2$$anonfun$1(String id$6, Throwable ex$4) {
        return "Error deleting " + new FileId(id$6) + ": " + ex$4;
    }

    private static final Object undeleteById$$anonfun$2$$anonfun$1(String id$10, Throwable ex$5) {
        return "Error undeleting " + new FileId(id$10) + ": " + ex$5;
    }

    private static final Object unreset$$anonfun$2$$anonfun$1(String id$14, Throwable ex$6) {
        return "Error undeleting " + new FileId(id$14) + ": " + ex$6;
    }

    private static final Object resetAll$$anonfun$2$$anonfun$1(Throwable ex$7) {
        return "Error dropping Web Collection: " + ex$7;
    }

    private static final Object deleteAll$$anonfun$2$$anonfun$1(String themeId$8, Throwable ex$8) {
        return "Error deleting all for " + new ThemeId(themeId$8) + ": " + ex$8;
    }

    private static final Object undeleteAll$$anonfun$2$$anonfun$1(String themeId$11, Throwable ex$9) {
        return "Error undeleting all for " + new ThemeId(themeId$11) + ": " + ex$9;
    }

    private static final Object update$$anonfun$2$$anonfun$1(String id$17, Throwable ex$10) {
        return "Error updating " + new FileId(id$17) + ": " + ex$10;
    }

    private static final Object updateLastModifiedByFromFileId$$anonfun$1$$anonfun$1(String id$19) {
        return "Problem updateLastModifiedBy via fileId:" + new FileId(id$19);
    }

    private static final Option getThemeIdFromFileId$$anonfun$3() {
        return None$.MODULE$;
    }

    private static final /* synthetic */ String findThemeName$$anonfun$1$$anonfun$2$$anonfun$1(Tuple2 _$36) {
        if (_$36._2() == null) {
            return null;
        }
        return ((ThemeName)_$36._2()).value();
    }

    private static final Object findThemeName$$anonfun$2$$anonfun$1(Throwable ex$11) {
        return "Error finding Theme: " + ex$11;
    }

    private static final Option findThemeName$$anonfun$3() {
        return None$.MODULE$;
    }

    private static final /* synthetic */ String findThemeName$$anonfun$4$$anonfun$2$$anonfun$1(Tuple2 _$38) {
        if (_$38._2() == null) {
            return null;
        }
        return ((ThemeName)_$38._2()).value();
    }

    private static final Object findThemeName$$anonfun$5$$anonfun$1(Throwable ex$12) {
        return "Error finding Theme: " + ex$12;
    }

    private static final Option findThemeName$$anonfun$6() {
        return None$.MODULE$;
    }

    private static final Object eventBusUpdate$$anonfun$1$$anonfun$1() {
        return "cacheReloaded event received";
    }

    private final void eventBusUpdate$$anonfun$1() {
        this.log().info(ThemeAPI::eventBusUpdate$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(405), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.eventBusUpdate"));
    }

    private static final Object eventBusUpdate$$anonfun$2$$anonfun$1$$anonfun$1(String eventType$3) {
        return "Failed to reload cache eventBusUpdate eventType:" + eventType$3;
    }

    private static final Object eventBusUpdate$$anonfun$2$$anonfun$1$$anonfun$2(String eventType$4) {
        return "Cache reload cache eventType:" + eventType$4;
    }

    private static final Object doLoadCache$$anonfun$1$$anonfun$1() {
        return "cacheReloaded event received";
    }

    private final void doLoadCache$$anonfun$1() {
        this.log().info(ThemeAPI::doLoadCache$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(418), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.doLoadCache"));
    }

    private static final Object doLoadCache$$anonfun$2$$anonfun$1$$anonfun$1(String eventType$7) {
        return "Failed to reload cache eventBusUpdate eventType:" + eventType$7;
    }

    private static final Object doLoadCache$$anonfun$2$$anonfun$1$$anonfun$2(String eventType$8) {
        return "Cache reload cache eventType:" + eventType$8;
    }

    private static final void loadCache$$anonfun$1() {
        ThemeCache$.MODULE$.clear();
    }

    private static final Object loadCache$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "Firing Cache reload event";
    }

    private static final Object themeExists$$anonfun$2$$anonfun$1(Throwable ex$13) {
        return "Error finding active Theme: " + ex$13;
    }

    private static final Either themeExists$$anonfun$3() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private static final Object load$$anonfun$2$$anonfun$1(Throwable ex$14) {
        return "Error loading cache: " + ex$14;
    }

    private static final Either load$$anonfun$3() {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private static final Object findActiveTheme$$anonfun$1() {
        return "Theme disabled";
    }

    private static final Object findActiveTheme$$anonfun$2$$anonfun$1() {
        return "No Active Theme found";
    }

    private static final Object findActiveTheme$$anonfun$2$$anonfun$2$$anonfun$1(String id$20, String name$1) {
        return "Active Theme id:" + id$20 + " name:" + new ThemeName(name$1);
    }

    private final /* synthetic */ String findActiveTheme$$anonfun$2$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String id = tuple2._1() == null ? null : ((ThemeId)tuple2._1()).value();
            String name = tuple2._2() == null ? null : ((ThemeName)tuple2._2()).value();
            this.log().info(() -> ThemeAPI.findActiveTheme$$anonfun$2$$anonfun$2$$anonfun$1(id, name), Line$.MODULE$.apply(492), FullName$.MODULE$.apply("ambience.themes.designer.ThemeAPI.findActiveTheme"));
            return id;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Object findActiveTheme$$anonfun$3$$anonfun$1(Throwable ex$15) {
        return "Error finding active Theme: " + ex$15;
    }

    private static final Either findActiveTheme$$anonfun$4() {
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    public static final class ColFileInfo
    implements FileInfo,
    Product,
    Serializable {
        private final String id;
        private final String path;
        private final byte[] bytes;
        private final boolean inWebFolder;
        private final String hash;
        private final Option updated;

        public static ColFileInfo apply(String string, String string2, byte[] byArray, boolean bl, String string3, Option<Object> option) {
            return ThemeAPI$ColFileInfo$.MODULE$.apply(string, string2, byArray, bl, string3, option);
        }

        public static ColFileInfo fromProduct(Product product) {
            return ThemeAPI$ColFileInfo$.MODULE$.fromProduct(product);
        }

        public static ColFileInfo unapply(ColFileInfo colFileInfo) {
            return ThemeAPI$ColFileInfo$.MODULE$.unapply(colFileInfo);
        }

        public ColFileInfo(String id, String path, byte[] bytes, boolean inWebFolder, String hash, Option<Object> updated) {
            this.id = id;
            this.path = path;
            this.bytes = bytes;
            this.inWebFolder = inWebFolder;
            this.hash = hash;
            this.updated = updated;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new FileId(this.id())));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new FilePath(this.path())));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bytes()));
            n = Statics.mix((int)n, (int)(this.inWebFolder() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hash()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.updated()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ColFileInfo)) return false;
            ColFileInfo colFileInfo = (ColFileInfo)object;
            if (this.inWebFolder() != colFileInfo.inWebFolder()) return false;
            String string = this.id();
            String string2 = colFileInfo.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.path();
            String string4 = colFileInfo.path();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.bytes() != colFileInfo.bytes()) return false;
            String string5 = this.hash();
            String string6 = colFileInfo.hash();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Option<Object> option = this.updated();
            Option<Object> option2 = colFileInfo.updated();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ColFileInfo;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ColFileInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return new FileId(this._1());
                }
                case 1: {
                    return new FilePath(this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "path";
                }
                case 2: {
                    return "bytes";
                }
                case 3: {
                    return "inWebFolder";
                }
                case 4: {
                    return "hash";
                }
                case 5: {
                    return "updated";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        @Override
        public String path() {
            return this.path;
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public boolean inWebFolder() {
            return this.inWebFolder;
        }

        public String hash() {
            return this.hash;
        }

        public Option<Object> updated() {
            return this.updated;
        }

        public ColFileInfo copy(String id, String path, byte[] bytes, boolean inWebFolder, String hash, Option<Object> updated) {
            return new ColFileInfo(id, path, bytes, inWebFolder, hash, updated);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.path();
        }

        public byte[] copy$default$3() {
            return this.bytes();
        }

        public boolean copy$default$4() {
            return this.inWebFolder();
        }

        public String copy$default$5() {
            return this.hash();
        }

        public Option<Object> copy$default$6() {
            return this.updated();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.path();
        }

        public byte[] _3() {
            return this.bytes();
        }

        public boolean _4() {
            return this.inWebFolder();
        }

        public String _5() {
            return this.hash();
        }

        public Option<Object> _6() {
            return this.updated();
        }
    }

    public static interface FileInfo {
        public String path();
    }

    public static final class WebFileInfo
    implements FileInfo,
    Product,
    Serializable {
        private final String path;
        private final Path fsPath;

        public static WebFileInfo apply(String string, Path path) {
            return ThemeAPI$WebFileInfo$.MODULE$.apply(string, path);
        }

        public static WebFileInfo fromProduct(Product product) {
            return ThemeAPI$WebFileInfo$.MODULE$.fromProduct(product);
        }

        public static WebFileInfo unapply(WebFileInfo webFileInfo) {
            return ThemeAPI$WebFileInfo$.MODULE$.unapply(webFileInfo);
        }

        public WebFileInfo(String path, Path fsPath) {
            this.path = path;
            this.fsPath = fsPath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WebFileInfo)) return false;
            WebFileInfo webFileInfo = (WebFileInfo)object;
            String string = this.path();
            String string2 = webFileInfo.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Path path = this.fsPath();
            Path path2 = webFileInfo.fsPath();
            if (path == null) {
                if (path2 == null) return true;
                return false;
            } else {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WebFileInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WebFileInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return new FilePath(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "fsPath";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String path() {
            return this.path;
        }

        public Path fsPath() {
            return this.fsPath;
        }

        public WebFileInfo copy(String path, Path fsPath) {
            return new WebFileInfo(path, fsPath);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Path copy$default$2() {
            return this.fsPath();
        }

        public String _1() {
            return this.path();
        }

        public Path _2() {
            return this.fsPath();
        }
    }
}

