/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.management;

import ambience.framework.DocumentManager2$;
import ambience.module.UserDB;
import ambience.themes.management.DocManager$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class DocManager {
    public static Bson withId(BsonString bsonString) {
        return DocManager$.MODULE$.withId(bsonString);
    }

    public static Bson withId(String string) {
        return DocManager$.MODULE$.withId(string);
    }

    public DocManager() {
        DocumentManager2$.MODULE$.setupUniqueColumn(this.cltn(), this.uniqueKey()).runToFuture(Scheduler$.MODULE$.global());
    }

    public abstract ExecutionContext exeCxt();

    public abstract RichMongoCollection cltn();

    public abstract String uniqueKey();

    public abstract String extension();

    public String filenameExtractor(Json json) {
        String name = (String)json.hcursor().downField(this.uniqueKey()).focus().flatMap((Function1 & Serializable)_$1 -> _$1.asString()).getOrElse(DocManager::$anonfun$2);
        return name + this.extension();
    }

    public Task<Json> get() {
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option3 = FindOptions$.MODULE$.$lessinit$greater$default$4();
        FindOptions opts = FindOptions$.MODULE$.apply(option, (Option)some, option2, option3);
        return this.cltn().findO(DocumentManager2$.MODULE$.exists(this.uniqueKey()), opts).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.map((Function1 & Serializable)_$2 -> _$2.toJson()).mkString("[", ",", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                ((LoggingMixin)this).log().error(() -> DocManager.get$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(48), FullName$.MODULE$.apply("ambience.themes.management.DocManager.get"));
                return Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Option<Json>> get(String uuid) {
        return this.cltn().findOneO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(uuid))).toListL().map((Function1 & Serializable)doc2 -> doc2.headOption().flatMap((Function1 & Serializable)doc -> io.circe.parser.package$.MODULE$.parse(doc.toJson()).toOption()));
    }

    public Task<GravityResponse> download(String uuid) {
        return this.get(uuid).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                String filename = this.filenameExtractor(json);
                Gravity.Header contentDisposition = GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
                return GravityResponse$.MODULE$.json(json).withHeader(contentDisposition);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg2 = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg2));
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonString id = (BsonString)((Some)option).value();
                return this.update(id, key, doc).map((Function1 & Serializable)msg -> package$.MODULE$.Left().apply(msg));
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(user, key, doc).map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> this.docToJson((Document)doc)));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Json docToJson(Document doc) {
        Either either = io.circe.parser.package$.MODULE$.parse(doc.toJson());
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            throw new IllegalStateException("Unable to parse Bson as Json: " + err);
        }
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return json;
        }
        throw new MatchError((Object)either);
    }

    public Task<LogMessage> delete(UserDB.User user, String uuid) {
        ((LoggingMixin)this).log().info(() -> DocManager.delete$$anonfun$1(uuid), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.themes.management.DocManager.delete"));
        return this.cltn().updateOneT(DocManager$.MODULE$.withId(uuid), DocumentManager2$.MODULE$.deleteAction(this.uniqueKey())).map((Function1 & Serializable)_$3 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Delete failed", ex);
            }
        });
    }

    public Task<LogMessage> undelete(UserDB.User user, String uuid) {
        ((LoggingMixin)this).log().info(() -> DocManager.undelete$$anonfun$1(uuid), Line$.MODULE$.apply(103), FullName$.MODULE$.apply("ambience.themes.management.DocManager.undelete"));
        return this.cltn().updateOneT(DocManager$.MODULE$.withId(uuid), DocumentManager2$.MODULE$.undeleteAction(this.uniqueKey())).map((Function1 & Serializable)_$4 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Undelete failed", ex);
            }
        });
    }

    public Task<Either<LogMessage, Document>> add(UserDB.User user, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocManager.add$$anonfun$1(key), Line$.MODULE$.apply(111), FullName$.MODULE$.apply("ambience.themes.management.DocManager.add"));
        BsonString id = BsonString$.MODULE$.apply(UUID.randomUUID().toString());
        BsonString owner = BsonString$.MODULE$.apply(user.id());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)owner), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document finalDoc = (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.cltn().insertOneT(finalDoc).map((Function1 & Serializable)_$5 -> package$.MODULE$.Right().apply((Object)finalDoc)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Add failed", ex));
            }
        });
    }

    public Task<LogMessage> update(BsonString id, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocManager.update$$anonfun$1(key), Line$.MODULE$.apply(122), FullName$.MODULE$.apply("ambience.themes.management.DocManager.update"));
        return this.cltn().replaceOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocManager$.MODULE$.withId(id), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), doc).map((Function1 & Serializable)_$6 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Update failed", ex);
            }
        });
    }

    public Either<LogMessage, Option<BsonString>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)s));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(this.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    private static final String $anonfun$2() {
        return "unknown";
    }

    private static final Object get$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object delete$$anonfun$1(String uuid$1) {
        return "deleting " + uuid$1;
    }

    private static final Object undelete$$anonfun$1(String uuid$2) {
        return "undeleting " + uuid$2;
    }

    private static final Object add$$anonfun$1(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private static final Object update$$anonfun$1(BsonValue key$2) {
        return "updating " + key$2;
    }
}

