/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler;

import ambience.scheduler.Model;
import ambience.scheduler.util.CronExp;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.text.ParseException;
import java.time.ZoneId;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class SchedulerUtil$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SchedulerUtil$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final SchedulerUtil$ MODULE$ = new SchedulerUtil$();

    private SchedulerUtil$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SchedulerUtil$.class);
    }

    public Either<ParseException, CronExp> buildCronExpression(String cronString, ZoneId timeZone) {
        Left left;
        try {
            CronExp cronEx = new CronExp(cronString, timeZone);
            left = package$.MODULE$.Right().apply((Object)cronEx);
        }
        catch (ParseException ex) {
            left = package$.MODULE$.Left().apply((Object)ex);
        }
        return left;
    }

    public LogMessage validateCRON(String cron) {
        LogMessage.None$ none$;
        try {
            new CronExp(cron, ZoneId.systemDefault());
            this.log().info(() -> this.validateCRON$$anonfun$1(cron), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.scheduler.SchedulerUtil.validateCRON"));
            none$ = LogMessage.None$.MODULE$;
        }
        catch (Exception ex) {
            this.log().info(() -> this.validateCRON$$anonfun$2(cron, ex), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("ambience.scheduler.SchedulerUtil.validateCRON"));
            none$ = LogMessage.Error$.MODULE$.apply(ex.toString());
        }
        return none$;
    }

    public String cronExpression(Model.CronMode cronMode) {
        Model.CronMode cronMode2 = cronMode;
        if (cronMode2 instanceof Model.CronHourly) {
            Model.CronHourly c = (Model.CronHourly)cronMode2;
            return c.time().second() + " " + c.time().minute() + " * * * ? *";
        }
        if (cronMode2 instanceof Model.CronDaily) {
            Model.CronDaily c = (Model.CronDaily)cronMode2;
            return this.tod$1(c.time()) + " * * ? *";
        }
        if (cronMode2 instanceof Model.CronFull) {
            Model.CronFull c = (Model.CronFull)cronMode2;
            return c.expression();
        }
        if (cronMode2 instanceof Model.CronMonthly) {
            Model.CronMonthly c = (Model.CronMonthly)cronMode2;
            String months = c.months().size() == 12 ? "*" : this.setToString((Set<Object>)c.months());
            return this.tod$1(c.time()) + " " + c.daysOfMonth() + " " + months + " ? *";
        }
        if (cronMode2 instanceof Model.CronMonthlySpecialDay) {
            Object object;
            Model.CronMonthlySpecialDay c = (Model.CronMonthlySpecialDay)cronMode2;
            String months = c.months().size() == 12 ? "*" : this.setToString((Set<Object>)c.months());
            Model.SpecialDay specialDay = c.specialDay();
            Model.SpecialDay specialDay2 = Model.SpecialDay$.MODULE$.FirstDay();
            Model.SpecialDay specialDay3 = specialDay;
            if (!(specialDay2 != null ? !specialDay2.equals(specialDay3) : specialDay3 != null)) {
                object = "1";
            } else {
                Model.SpecialDay specialDay4 = Model.SpecialDay$.MODULE$.LastDay();
                Model.SpecialDay specialDay5 = specialDay;
                if (!(specialDay4 != null ? !specialDay4.equals(specialDay5) : specialDay5 != null)) {
                    object = "L";
                } else {
                    Model.SpecialDay specialDay6 = Model.SpecialDay$.MODULE$.FirstWeekday();
                    Model.SpecialDay specialDay7 = specialDay;
                    if (!(specialDay6 != null ? !specialDay6.equals(specialDay7) : specialDay7 != null)) {
                        object = "1W";
                    } else {
                        Model.SpecialDay specialDay8 = Model.SpecialDay$.MODULE$.LastWeekday();
                        Model.SpecialDay specialDay9 = specialDay;
                        object = !(specialDay8 != null ? !specialDay8.equals(specialDay9) : specialDay9 != null) ? "LW" : "Invalid SpecialDay: " + c.specialDay();
                    }
                }
            }
            String part = object;
            return this.tod$1(c.time()) + " " + part + " " + months + " ? *";
        }
        if (cronMode2 instanceof Model.CronMonthlyWeekday) {
            Model.CronMonthlyWeekday c = (Model.CronMonthlyWeekday)cronMode2;
            String months = c.months().size() == 12 ? "*" : this.setToString((Set<Object>)c.months());
            String part = c.count() == 0 || c.count() == 6 ? c.dayOfWeek() + "L" : c.dayOfWeek() + "#" + c.count();
            return this.tod$1(c.time()) + " ? " + months + " " + part + " *";
        }
        if (cronMode2 instanceof Model.CronOnce) {
            Model.CronOnce c = (Model.CronOnce)cronMode2;
            return this.tod$1(c.time()) + " " + c.day() + " " + c.month() + " ? " + c.year();
        }
        if (cronMode2 instanceof Model.CronWeekly) {
            Model.CronWeekly c = (Model.CronWeekly)cronMode2;
            return this.tod$1(c.time()) + " ? * " + this.setToString((Set<Object>)c.daysOfWeek()) + " *";
        }
        throw new MatchError((Object)cronMode2);
    }

    public String setToString(Set<Object> set) {
        return ((IterableOnceOps)set.toList().sorted((Ordering)Ordering.Int$.MODULE$)).mkString(",");
    }

    private final Object validateCRON$$anonfun$1(String cron$1) {
        return "cron validate \"" + cron$1 + "\" ok";
    }

    private final Object validateCRON$$anonfun$2(String cron$2, Exception ex$1) {
        return "cron validate \"" + cron$2 + "\" error: " + ex$1;
    }

    private final String tod$1(Model.TimeOfDay time) {
        return time.second() + " " + time.minute() + " " + time.hour();
    }
}

