/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler.calendar;

import ambience.scheduler.CalendarModel;
import ambience.scheduler.util.CronExp;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class CalendarTester$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CalendarTester$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final CalendarModel.Calendar AllowAll;
    public static final CalendarTester$ MODULE$;

    private CalendarTester$() {
    }

    static {
        MODULE$ = new CalendarTester$();
        AllowAll = CalendarModel.Calendar$.MODULE$.apply(CalendarModel.Calendar$.MODULE$.$lessinit$greater$default$1(), CalendarModel.Calendar$.MODULE$.$lessinit$greater$default$2(), CalendarModel.Calendar$.MODULE$.$lessinit$greater$default$3(), CalendarModel.Calendar$.MODULE$.$lessinit$greater$default$4(), CalendarModel.Calendar$.MODULE$.$lessinit$greater$default$5());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CalendarTester$.class);
    }

    public CalendarModel.Calendar AllowAll() {
        return AllowAll;
    }

    public boolean matches(CalendarModel.Calendar calendar, ZonedDateTime timestamp) {
        LazyInt lazyInt = new LazyInt();
        LazyRef lazyRef = new LazyRef();
        ZoneId timeZone = this.lookupTimezone(calendar);
        ZonedDateTime ts = timestamp.withZoneSameInstant(timeZone);
        CalendarModel.CalendarConstraint calendarConstraint = calendar.constraint();
        if (calendarConstraint instanceof CalendarModel.DayOfWeekConstraint) {
            Set set;
            CalendarModel.DayOfWeekConstraint dayOfWeekConstraint = CalendarModel.DayOfWeekConstraint$.MODULE$.unapply((CalendarModel.DayOfWeekConstraint)calendarConstraint);
            Set days = set = dayOfWeekConstraint._1();
            return days.contains((Object)BoxesRunTime.boxToInteger((int)ts.getDayOfWeek().getValue()));
        }
        if (calendarConstraint instanceof CalendarModel.DayOfMonthConstraint) {
            Set set;
            CalendarModel.DayOfMonthConstraint dayOfMonthConstraint = CalendarModel.DayOfMonthConstraint$.MODULE$.unapply((CalendarModel.DayOfMonthConstraint)calendarConstraint);
            Set days = set = dayOfMonthConstraint._1();
            return days.contains((Object)BoxesRunTime.boxToInteger((int)ts.getDayOfMonth()));
        }
        if (calendarConstraint instanceof CalendarModel.DailyConstraint) {
            Set set;
            CalendarModel.DailyConstraint dailyConstraint = CalendarModel.DailyConstraint$.MODULE$.unapply((CalendarModel.DailyConstraint)calendarConstraint);
            Set ranges = set = dailyConstraint._1();
            return ranges.exists((Function1 & Serializable)_$1 -> this.hits((CalendarModel.DailyRange)_$1, Int$.MODULE$.int2long(this.secs$1(lazyInt, ts))));
        }
        if (calendarConstraint instanceof CalendarModel.HolidayConstraint) {
            Set set;
            CalendarModel.HolidayConstraint holidayConstraint = CalendarModel.HolidayConstraint$.MODULE$.unapply((CalendarModel.HolidayConstraint)calendarConstraint);
            Set days = set = holidayConstraint._1();
            return days.contains((Object)this.day$1(lazyRef, ts));
        }
        if (calendarConstraint instanceof CalendarModel.CronConstraint) {
            String string;
            CalendarModel.CronConstraint cronConstraint = CalendarModel.CronConstraint$.MODULE$.unapply((CalendarModel.CronConstraint)calendarConstraint);
            String cronString = string = cronConstraint._1();
            CronExp cronExpression = new CronExp(cronString, timeZone);
            return cronExpression.getTimeAfter(ts.minusSeconds(1L)).contains((Object)ts);
        }
        throw new MatchError((Object)calendarConstraint);
    }

    public ZoneId lookupTimezone(CalendarModel.Calendar calendar) {
        if (calendar.timeZone().trim().isEmpty()) {
            return ZoneId.systemDefault();
        }
        return (ZoneId)Try$.MODULE$.apply(() -> this.lookupTimezone$$anonfun$1(calendar)).toOption().getOrElse(this::lookupTimezone$$anonfun$2);
    }

    private boolean hits(CalendarModel.DailyRange dailyRange, long secs) {
        if (dailyRange.from() < dailyRange.to()) {
            return (long)dailyRange.from() <= secs && secs < (long)dailyRange.to();
        }
        return secs >= (long)dailyRange.from() || secs < (long)dailyRange.to();
    }

    private final int secs$lzyINIT1$1(LazyInt secs$lzy1$1, ZonedDateTime ts$1) {
        int n;
        LazyInt lazyInt = secs$lzy1$1;
        synchronized (lazyInt) {
            n = secs$lzy1$1.initialized() ? secs$lzy1$1.value() : secs$lzy1$1.initialize(ts$1.get(ChronoField.SECOND_OF_DAY));
        }
        return n;
    }

    private final int secs$1(LazyInt secs$lzy1$2, ZonedDateTime ts$2) {
        if (secs$lzy1$2.initialized()) {
            return secs$lzy1$2.value();
        }
        return this.secs$lzyINIT1$1(secs$lzy1$2, ts$2);
    }

    private final CalendarModel.HolidayDay day$lzyINIT1$1(LazyRef day$lzy1$1, ZonedDateTime ts$3) {
        CalendarModel.HolidayDay holidayDay;
        LazyRef lazyRef = day$lzy1$1;
        synchronized (lazyRef) {
            holidayDay = (CalendarModel.HolidayDay)(day$lzy1$1.initialized() ? day$lzy1$1.value() : day$lzy1$1.initialize((Object)CalendarModel.HolidayDay$.MODULE$.apply(ts$3.getYear(), ts$3.getMonthValue(), ts$3.getDayOfMonth())));
        }
        return holidayDay;
    }

    private final CalendarModel.HolidayDay day$1(LazyRef day$lzy1$2, ZonedDateTime ts$4) {
        return (CalendarModel.HolidayDay)(day$lzy1$2.initialized() ? day$lzy1$2.value() : this.day$lzyINIT1$1(day$lzy1$2, ts$4));
    }

    private final ZoneId lookupTimezone$$anonfun$1(CalendarModel.Calendar calendar$1) {
        return ZoneId.of(calendar$1.timeZone());
    }

    private final ZoneId lookupTimezone$$anonfun$2() {
        return ZoneId.systemDefault();
    }
}

