/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.Crypt;
import com.elixirtech.arch.Crypt$HashString$;
import com.elixirtech.arch.Crypt2$;
import com.elixirtech.arch.CryptSupplier$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.util.ByteUtil$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class Crypt$
implements Serializable {
    private static final String DEFAULT_PASSWORD;
    private static final String DEFAULT_ENCODING;
    private static final String ASCII_ENCODING;
    private static final Regex EncId;
    public static final Crypt$HashString$ HashString;
    public static final Crypt$ MODULE$;

    private Crypt$() {
    }

    static {
        MODULE$ = new Crypt$();
        DEFAULT_PASSWORD = "ElixirSafe";
        DEFAULT_ENCODING = "UTF-8";
        ASCII_ENCODING = "US-ASCII";
        EncId = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\{enc\\:([^\\}]+)}(.*)$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Crypt$.class);
    }

    public String DEFAULT_PASSWORD() {
        return DEFAULT_PASSWORD;
    }

    public String DEFAULT_ENCODING() {
        return DEFAULT_ENCODING;
    }

    public String ASCII_ENCODING() {
        return ASCII_ENCODING;
    }

    public Regex EncId() {
        return EncId;
    }

    public String hash(String s) {
        return ByteUtil$.MODULE$.toHex(this.getKey(s));
    }

    public Crypt.HashString hash(String name, String s) {
        return this.hashSHA512(name, s);
    }

    public Crypt.HashString hashToMatch(Crypt.HashString enc, String name, String s) {
        if (enc.value().startsWith("{sha1:")) {
            return this.hashSHA1(name, s);
        }
        if (enc.value().startsWith("{sha512:")) {
            return this.hashSHA512(name, s);
        }
        throw new IllegalArgumentException("Unsupported encyption type:" + enc.value());
    }

    public Crypt.HashString hashSHA1(String name, String s) {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        String in = name + ":" + s;
        md.update(in.getBytes(this.DEFAULT_ENCODING()));
        byte[] raw = md.digest();
        return Crypt$HashString$.MODULE$.apply("{sha1:" + new String(Base64.encodeBase64((byte[])raw), this.ASCII_ENCODING()).trim() + "}");
    }

    public Crypt.HashString hashSHA512(String name, String s) {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        String in = name + ":" + s;
        md.update(in.getBytes(this.DEFAULT_ENCODING()));
        byte[] raw = md.digest();
        return Crypt$HashString$.MODULE$.apply("{sha512:" + new String(Base64.encodeBase64((byte[])raw), this.ASCII_ENCODING()).trim() + "}");
    }

    public String encrypt(String s) {
        return Crypt2$.MODULE$.encrypt20(s);
    }

    public String decrypt(String s) {
        if (s.startsWith(Crypt2$.MODULE$.Prefix20())) {
            return Crypt2$.MODULE$.decrypt20(s);
        }
        return this.decryptOld(s);
    }

    public String encryptOld(String s) {
        return this.encode(this.encryptOld(s.getBytes(this.DEFAULT_ENCODING()), this.DEFAULT_PASSWORD()));
    }

    public String decryptOld(String s) {
        return new String(this.decryptOld(this.decode(s), this.DEFAULT_PASSWORD()), this.DEFAULT_ENCODING());
    }

    public String encPrefixDecrypt(String s) {
        return this.encPrefixDecrypt(s, true);
    }

    public String encPrefixDecrypt(String s, boolean allowFile) {
        return this.encPrefixDecrypt((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class)), s, allowFile);
    }

    public String encPrefixDecrypt(Config config, String s, boolean allowFile) {
        if (allowFile && s.startsWith(Crypt2$.MODULE$.PrefixFile())) {
            return Crypt2$.MODULE$.decryptFile(config, s);
        }
        if (s.startsWith("{enc")) {
            List list;
            Option option;
            if (s.startsWith("{enc}")) {
                return this.decrypt(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s), "{enc}"));
            }
            String string = s;
            if (string != null && !(option = this.EncId().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)list.apply(0);
                String string3 = (String)list.apply(1);
                String id = string2;
                String remainder = string3;
                Try result = CryptSupplier$.MODULE$.getSupplier(config, id).flatMap((Function1 & Serializable)supplier -> supplier.decrypt(remainder).map((Function1 & Serializable)result -> result));
                Try try_ = result;
                if (try_ instanceof Success) {
                    String s2 = (String)((Success)try_).value();
                    return s2;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    CryptSupplier$.MODULE$.log().error((Function0<Object>)((Function0 & Serializable)() -> this.encPrefixDecrypt$$anonfun$1(s, ex)), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("com.elixirtech.arch.Crypt.encPrefixDecrypt"));
                    return "";
                }
                throw new MatchError((Object)try_);
            }
            CryptSupplier$.MODULE$.log().error((Function0<Object>)((Function0 & Serializable)() -> this.encPrefixDecrypt$$anonfun$2(s)), Line$.MODULE$.apply(99), FullName$.MODULE$.apply("com.elixirtech.arch.Crypt.encPrefixDecrypt"));
            return "";
        }
        return s;
    }

    private byte[] encryptOld(byte[] bytes, String password) {
        Cipher encodeCipher = Cipher.getInstance("AES");
        SecretKeySpec key = new SecretKeySpec(this.getKey(password), "AES");
        encodeCipher.init(1, key);
        return encodeCipher.doFinal(bytes);
    }

    private byte[] decryptOld(byte[] bytes, String password) {
        Cipher decodeCipher = Cipher.getInstance("AES");
        SecretKeySpec key = new SecretKeySpec(this.getKey(password), "AES");
        decodeCipher.init(2, key);
        return decodeCipher.doFinal(bytes);
    }

    private byte[] getKey(String password) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(this.DEFAULT_PASSWORD().getBytes(this.DEFAULT_ENCODING()));
        return md.digest(password.getBytes(this.DEFAULT_ENCODING()));
    }

    public String encode(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes, (boolean)true), this.ASCII_ENCODING()).trim();
    }

    public byte[] decode(String s) {
        return Base64.decodeBase64((byte[])s.getBytes(this.ASCII_ENCODING()));
    }

    private final Object encPrefixDecrypt$$anonfun$1(String s$1, Throwable ex$1) {
        return "Decrypt error: " + s$1 + " " + ex$1.toString();
    }

    private final Object encPrefixDecrypt$$anonfun$2(String s$2) {
        return "Decrypt error: Can't parse " + s$2;
    }
}

