/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.LoggingHelper$Error$;
import com.elixirtech.arch.LoggingHelper$Warn$;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class HourlyLogger {
    private final LoggingInterface log;
    private final int level;
    private final boolean isWarn;
    private final boolean isError;
    private int currentHour;
    private final HashSet<String> messages;

    public HourlyLogger(LoggingInterface log) {
        this.log = log;
        this.level = log.getLevel().level();
        this.isWarn = this.level() >= LoggingHelper$Warn$.MODULE$.level();
        this.isError = this.level() >= LoggingHelper$Error$.MODULE$.level();
        this.currentHour = -1;
        this.messages = new HashSet();
    }

    public int level() {
        return this.level;
    }

    public boolean isWarn() {
        return this.isWarn;
    }

    public boolean isError() {
        return this.isError;
    }

    private void testAndApply(String s, Function1<String, BoxedUnit> fn) {
        int hour = this.getCurrentHour();
        HourlyLogger hourlyLogger = this;
        synchronized (hourlyLogger) {
            if (hour != this.currentHour) {
                this.currentHour = hour;
                this.messages.clear();
                this.messages.$plus$eq((Object)s);
                v0 = (BoxedUnit)fn.apply((Object)("[HourlyLogger] " + s));
            } else if (!this.messages.contains((Object)s)) {
                this.messages.$plus$eq((Object)s);
                v0 = (BoxedUnit)fn.apply((Object)("[HourlyLogger] " + s));
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    private int getCurrentHour() {
        return (int)(System.currentTimeMillis() / 3600000L);
    }

    public void warn(Function0<String> fs) {
        if (this.isWarn()) {
            this.testAndApply((String)fs.apply(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)s -> this.log.warn((Function0<Object>)((Function0 & Serializable)() -> HourlyLogger.warn$$anonfun$1$$anonfun$1(s)), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("com.elixirtech.arch.HourlyLogger.warn")));
            return;
        }
    }

    public void error(Function0<String> fs) {
        if (this.isError()) {
            this.testAndApply((String)fs.apply(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)s -> this.log.error((Function0<Object>)((Function0 & Serializable)() -> HourlyLogger.error$$anonfun$1$$anonfun$1(s)), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("com.elixirtech.arch.HourlyLogger.error")));
            return;
        }
    }

    private static final Object warn$$anonfun$1$$anonfun$1(String s$1) {
        return s$1;
    }

    private static final Object error$$anonfun$1$$anonfun$1(String s$2) {
        return s$2;
    }
}

