/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.s3v2;

import ambience.api.Secrets;
import ambience.etl.s3v2.AssumeRoleHelper;
import ambience.etl.s3v2.AssumeRoleHelper$;
import ambience.etl.s3v2.AssumeRoleHelper$STSEndpointConfig$;
import ambience.etl.s3v2.AssumeRoleHelper$STSRegionConfig$;
import ambience.etl.s3v2.Bucket;
import ambience.module.UserDB;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class S3Logic$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(S3Logic$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(S3Logic$.class.getDeclaredField("secretsAPI$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object secretsAPI$lzy1;
    public static final S3Logic$ MODULE$ = new S3Logic$();

    private S3Logic$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(S3Logic$.class);
    }

    public Secrets secretsAPI() {
        Object object = this.secretsAPI$lzy1;
        if (object instanceof Secrets) {
            return (Secrets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Secrets)this.secretsAPI$lzyINIT1();
    }

    private Object secretsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.secretsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Secrets secrets = null;
                    try {
                        secrets = (Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class));
                        object2 = secrets == null ? LazyVals.NullValue$.MODULE$ : secrets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.secretsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return secrets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<LogMessage, AwsCredentials>> credentials(UserDB.User user, Bucket b) {
        return this.secretsAPI().getSecret(user, b.secret()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value encSecret = (Secrets.Value)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)AwsBasicCredentials.create((String)Crypt$.MODULE$.encPrefixDecrypt(b.access()), (String)Crypt$.MODULE$.encPrefixDecrypt(encSecret.value())));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + b.secret() + " not available"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, AwsCredentials>> systemCredentials(Bucket b) {
        return this.secretsAPI().getSystemSecret(b.secret()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value encSecret = (Secrets.Value)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)AwsBasicCredentials.create((String)Crypt$.MODULE$.encPrefixDecrypt(b.access()), (String)Crypt$.MODULE$.encPrefixDecrypt(encSecret.value())));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + b.secret() + " not available"));
            }
            throw new MatchError((Object)option);
        });
    }

    public <T> Either<LogMessage, T> client(Bucket b, AwsCredentials creds, Function1<S3Client, T> fn) {
        Left left;
        block3: {
            try {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(b.roleArn()))) {
                    left = package$.MODULE$.Right().apply(this.assumeClient(b.region(), creds, b.roleArn(), b.roleSessionName(), b.stsServiceEndpoint(), fn));
                    break block3;
                }
                left = package$.MODULE$.Right().apply(this.directClient(b.region(), creds, fn));
            }
            catch (Exception ex) {
                left = package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("AWS client exception: " + ex, (Throwable)ex));
            }
        }
        return left;
    }

    public <T> T directClient(String regionName, AwsCredentials credentials, Function1<S3Client, T> fn) {
        this.log().info(this::directClient$$anonfun$1, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.etl.s3v2.S3Logic.directClient"));
        Region region = Region.of((String)regionName);
        StaticCredentialsProvider credsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        return (T)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            S3Client s3 = (S3Client)arm.manage(S3Client.builder().region(region).credentialsProvider((AwsCredentialsProvider)credsProvider).build());
            return fn.apply((Object)s3);
        });
    }

    public <T> T assumeClient(String regionName, AwsCredentials creds, String roleArn, String roleSessionName, String serviceEndpoint, Function1<S3Client, T> fn) {
        this.log().info(() -> this.assumeClient$$anonfun$1(roleArn), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.etl.s3v2.S3Logic.assumeClient"));
        Region region = Region.of((String)regionName);
        AssumeRoleHelper.STSConfig stsConfig = (AssumeRoleHelper.STSConfig)(serviceEndpoint.trim().isEmpty() ? AssumeRoleHelper$STSRegionConfig$.MODULE$.apply(region) : AssumeRoleHelper$STSEndpointConfig$.MODULE$.apply(region, serviceEndpoint));
        AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(roleSessionName).build();
        return (T)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            StsClient client = (StsClient)arm.manage((Object)AssumeRoleHelper$.MODULE$.buildSts(creds, stsConfig));
            StsAssumeRoleCredentialsProvider provider = (StsAssumeRoleCredentialsProvider)arm.manage((Object)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(client)).refreshRequest(roleRequest).build());
            S3Client s3 = (S3Client)arm.manage(S3Client.builder().credentialsProvider((AwsCredentialsProvider)provider).region(region).build());
            return fn.apply((Object)s3);
        });
    }

    private final Object directClient$$anonfun$1() {
        return "direct client";
    }

    private final Object assumeClient$$anonfun$1(String roleArn$1) {
        return "assume client " + roleArn$1;
    }
}

