/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.Secrets;
import ambience.arch.EitherTELM$;
import ambience.etl.s3v2.Bucket;
import ambience.etl.s3v2.Bucket$;
import ambience.etl.s3v2.S3Logic$;
import ambience.framework.AWSS3BinaryStoreLocation$;
import ambience.framework.AWSS3BinaryStoreLocation$ClientInfo$;
import ambience.framework.AWSS3BinaryStoreLocation$ConfigInfo$;
import ambience.framework.AWSS3BinaryStoreLocation$SysRefInfo$;
import ambience.framework.BinaryStoreAPI;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import io.circe.Json$;
import io.circe.parser.package$;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AWSS3BinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AWSS3BinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AWSS3BinaryStoreLocation.class.getDeclaredField("secretsAPI$lzy1"));
    private volatile Object log$lzy1;
    private final BinaryStoreAPI.BSConfig bsConfig;
    private volatile Object secretsAPI$lzy1;
    private final String id;
    private final Info info;
    private final long maxSize;

    public static Task<Either<LogMessage, Bucket>> load(Info info) {
        return AWSS3BinaryStoreLocation$.MODULE$.load(info);
    }

    public AWSS3BinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        Info info;
        this.bsConfig = bsConfig;
        this.id = bsConfig.id();
        Option option = Try$.MODULE$.apply(() -> AWSS3BinaryStoreLocation.$init$$$anonfun$1(bsConfig)).toOption();
        if (option instanceof Some) {
            String sysref = (String)((Some)option).value();
            String subPath = (String)Try$.MODULE$.apply(() -> AWSS3BinaryStoreLocation.$anonfun$1(bsConfig)).map((Function1 & Serializable)_$3 -> _$3.trim()).getOrElse(AWSS3BinaryStoreLocation::$anonfun$3);
            info = AWSS3BinaryStoreLocation$SysRefInfo$.MODULE$.apply(sysref, subPath);
        } else if (None$.MODULE$.equals(option)) {
            info = this.loadConfigInfo();
        } else {
            throw new MatchError((Object)option);
        }
        this.info = info;
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Secrets secretsAPI() {
        Object object = this.secretsAPI$lzy1;
        if (object instanceof Secrets) {
            return (Secrets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Secrets)this.secretsAPI$lzyINIT1();
    }

    private Object secretsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.secretsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Secrets secrets = null;
                    try {
                        secrets = (Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class));
                        object2 = secrets == null ? LazyVals.NullValue$.MODULE$ : secrets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.secretsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return secrets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public Info info() {
        return this.info;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public Info loadConfigInfo() {
        String region = this.bsConfig.config().getString("region");
        String bucket = this.bsConfig.config().getString("bucket");
        String path = this.bsConfig.config().getString("path");
        String access = Crypt$.MODULE$.encPrefixDecrypt(this.bsConfig.config().getString("access"));
        String secretName = Crypt$.MODULE$.encPrefixDecrypt(this.bsConfig.config().getString("secretName"));
        String roleArn = (String)Try$.MODULE$.apply(this::$anonfun$4).toOption().getOrElse(AWSS3BinaryStoreLocation::$anonfun$5);
        String roleSessionName = (String)Try$.MODULE$.apply(this::$anonfun$6).toOption().getOrElse(AWSS3BinaryStoreLocation::$anonfun$7);
        String stsServiceEndpoint = (String)Try$.MODULE$.apply(this::$anonfun$8).toOption().getOrElse(AWSS3BinaryStoreLocation::$anonfun$9);
        Bucket b = Bucket$.MODULE$.apply(Bucket$.MODULE$.$lessinit$greater$default$1(), bucket, region, access, secretName, bucket, path, roleArn, roleSessionName, stsServiceEndpoint, Bucket$.MODULE$.$lessinit$greater$default$11());
        return AWSS3BinaryStoreLocation$ConfigInfo$.MODULE$.apply(b);
    }

    public <T> Task<Either<LogMessage, T>> run(Function1<ClientInfo, T> fn) {
        return EitherTELM$.MODULE$.apply(AWSS3BinaryStoreLocation$.MODULE$.load(this.info())).flatMap((Function1 & Serializable)bucket -> EitherTELM$.MODULE$.apply(S3Logic$.MODULE$.systemCredentials((Bucket)bucket)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> AWSS3BinaryStoreLocation.run$$anonfun$1$$anonfun$1$$anonfun$1(bucket, creds, fn))).map((Function1 & Serializable)t -> t))).value();
    }

    public String description() {
        return this.info().description();
    }

    public Task<String> add(BinaryStore.Content content) {
        return DataBytes$.MODULE$.toFullT(content.bytes()).flatMap((Function1 & Serializable)full -> {
            String uuid = UUID.randomUUID().toString();
            if (full.length() > this.maxSize()) {
                throw new BinaryStore.MaxSizeException(full.length(), this.maxSize());
            }
            long contentLength = full.length();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("Content-Length", String.valueOf(contentLength));
            metadata.put("elxMetadata", content.metadata().noSpaces());
            return this.run((Function1 & Serializable)clientInfo -> new BinaryStore.ContentId(this.add$$anonfun$1$$anonfun$1(uuid, metadata, contentLength, (FullDataBytes)full, (ClientInfo)clientInfo))).map((Function1 & Serializable)x$1 -> new BinaryStore.ContentId(this.add$$anonfun$1$$anonfun$2((Either)x$1)));
        });
    }

    public Observable<String> all() {
        Task task = this.run((Function1 & Serializable)clientInfo -> {
            ListObjectsV2Request req = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(clientInfo.bucket()).prefix(clientInfo.path()).build();
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListObjectsV2Response[]{clientInfo.client().listObjectsV2(req)})).flatMap((Function1 & Serializable)result -> Observable$.MODULE$.fromIterable((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.contents()).asScala().map((Function1 & Serializable)_$4 -> _$4.key())).toList().map((Function1 & Serializable)value -> new BinaryStore.ContentId(BinaryStore.ContentId$.MODULE$.apply(value)))).map((Function1 & Serializable)v1 -> new BinaryStore.ContentId(v1 == null ? null : ((BinaryStore.ContentId)v1).value())));
        });
        return Observable$.MODULE$.fromTask(task.map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Observable cId = (Observable)((Right)either).value();
                return cId;
            }
            if (either instanceof Left) {
                LogMessage err = (LogMessage)((Left)either).value();
                this.log().apply(err, Line$.MODULE$.apply(142), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.all"));
                throw new RuntimeException("Can't get all: " + err);
            }
            throw new MatchError((Object)either);
        })).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Task<Option<BinaryStore.Content>> get(String id) {
        return this.run((Function1 & Serializable)clientInfo -> {
            GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(clientInfo.bucket()).key(clientInfo.path() + "/" + id).build();
            ResponseBytes s3Obj = clientInfo.client().getObjectAsBytes(req);
            Json metadata = (Json)this.getMetadataFromMap((scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(((GetObjectResponse)s3Obj.response()).metadata()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse(AWSS3BinaryStoreLocation::$anonfun$11);
            return BinaryStore.Content$.MODULE$.apply(DataBytes$.MODULE$.apply(s3Obj.asByteArray()), metadata);
        }).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                BinaryStore.Content c = (BinaryStore.Content)((Right)either).value();
                return Some$.MODULE$.apply((Object)c);
            }
            if (either instanceof Left) {
                LogMessage err = (LogMessage)((Left)either).value();
                this.log().apply(err, Line$.MODULE$.apply(157), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.get"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> AWSS3BinaryStoreLocation.get$$anonfun$3$$anonfun$1(id, ex), Line$.MODULE$.apply(160), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.get"));
            return None$.MODULE$;
        });
    }

    public Task<Option<Json>> getMetadata(String id) {
        Task task = this.run((Function1 & Serializable)clientInfo -> {
            HeadObjectRequest req = (HeadObjectRequest)HeadObjectRequest.builder().bucket(clientInfo.bucket()).key(clientInfo.path() + "/" + id).build();
            HeadObjectResponse s3Obj = clientInfo.client().headObject(req);
            s3Obj.metadata();
            return this.getMetadataFromMap((scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(clientInfo.client().headObject(req).metadata()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
        return task.map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(175), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.getMetadata"));
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Option value = (Option)((Right)either).value();
                return value;
            }
            throw new MatchError((Object)either);
        }).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> AWSS3BinaryStoreLocation.getMetadata$$anonfun$2$$anonfun$1(id, ex), Line$.MODULE$.apply(180), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.getMetadata"));
            return None$.MODULE$;
        });
    }

    public Task<BoxedUnit> remove(String id) {
        return this.run((Function1 & Serializable)clientInfo -> {
            DeleteObjectRequest req = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(clientInfo.bucket()).key(clientInfo.path() + "/" + id).build();
            return clientInfo.client().deleteObject(req);
        }).void();
    }

    private Option<Json> parseJson(String s) {
        return package$.MODULE$.parse(s).toOption();
    }

    private Option<Json> getMetadataFromMap(scala.collection.immutable.Map<String, String> md) {
        return md.get((Object)"elxmetadata").orElse(() -> AWSS3BinaryStoreLocation.getMetadataFromMap$$anonfun$1(md)).flatMap((Function1 & Serializable)s -> this.parseJson((String)s));
    }

    private static final String $init$$$anonfun$1(BinaryStoreAPI.BSConfig bsConfig$1) {
        return bsConfig$1.config().getString("systemReference");
    }

    private static final String $anonfun$1(BinaryStoreAPI.BSConfig bsConfig$2) {
        return bsConfig$2.config().getString("subPath");
    }

    private static final String $anonfun$3() {
        return "";
    }

    private final String $anonfun$4() {
        return this.bsConfig.config().getString("roleArn");
    }

    private static final String $anonfun$5() {
        return "";
    }

    private final String $anonfun$6() {
        return this.bsConfig.config().getString("roleSessionName");
    }

    private static final String $anonfun$7() {
        return "";
    }

    private final String $anonfun$8() {
        return this.bsConfig.config().getString("stsServiceEndpoint");
    }

    private static final String $anonfun$9() {
        return "";
    }

    private static final Either run$$anonfun$1$$anonfun$1$$anonfun$1(Bucket bucket$2, AwsCredentials creds$1, Function1 fn$2) {
        return S3Logic$.MODULE$.client(bucket$2, creds$1, (Function1 & Serializable)s3 -> {
            ClientInfo ci = AWSS3BinaryStoreLocation$ClientInfo$.MODULE$.apply((S3Client)s3, bucket$2.region(), bucket$2.bucket(), bucket$2.path());
            return fn$2.apply((Object)ci);
        });
    }

    private static final Object add$$anonfun$1$$anonfun$1$$anonfun$1(ClientInfo clientInfo$1) {
        return "add clientInfo=" + clientInfo$1;
    }

    private static final Object add$$anonfun$1$$anonfun$1$$anonfun$2(long contentLength$2, ClientInfo clientInfo$2, String uuid$2) {
        return "Writing " + contentLength$2 + " bytes to " + clientInfo$2.path() + "/" + uuid$2;
    }

    private final /* synthetic */ String add$$anonfun$1$$anonfun$1(String uuid$1, HashMap metadata$1, long contentLength$1, FullDataBytes full$1, ClientInfo clientInfo) {
        this.log().info(() -> AWSS3BinaryStoreLocation.add$$anonfun$1$$anonfun$1$$anonfun$1(clientInfo), Line$.MODULE$.apply(115), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.add"));
        PutObjectRequest req = (PutObjectRequest)PutObjectRequest.builder().bucket(clientInfo.bucket()).key(clientInfo.path() + "/" + uuid$1).metadata((Map)metadata$1).build();
        this.log().info(() -> AWSS3BinaryStoreLocation.add$$anonfun$1$$anonfun$1$$anonfun$2(contentLength$1, clientInfo, uuid$1), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.add"));
        clientInfo.client().putObject(req, RequestBody.fromBytes((byte[])full$1.bytes()));
        return BinaryStore.ContentId$.MODULE$.apply(uuid$1);
    }

    private final /* synthetic */ String add$$anonfun$1$$anonfun$2(Either x$1) {
        Either either = x$1;
        if (either instanceof Right) {
            Object object = ((Right)either).value();
            String cId = object == null ? null : ((BinaryStore.ContentId)object).value();
            return cId;
        }
        if (either instanceof Left) {
            LogMessage err = (LogMessage)((Left)either).value();
            this.log().apply(err, Line$.MODULE$.apply(123), FullName$.MODULE$.apply("ambience.framework.AWSS3BinaryStoreLocation.add"));
            throw new RuntimeException("Can't add content: " + err);
        }
        throw new MatchError((Object)either);
    }

    private static final Json $anonfun$11() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final Object get$$anonfun$3$$anonfun$1(String id$3, Throwable ex$1) {
        return "Error reading " + new BinaryStore.ContentId(id$3) + ": " + ex$1;
    }

    private static final Object getMetadata$$anonfun$2$$anonfun$1(String id$6, Throwable ex$2) {
        return "Error reading metadata for " + new BinaryStore.ContentId(id$6) + ": " + ex$2;
    }

    private static final Option getMetadataFromMap$$anonfun$1(scala.collection.immutable.Map md$1) {
        return md$1.get((Object)"elxMetadata");
    }

    public static final class ClientInfo
    implements Product,
    Serializable {
        private final S3Client client;
        private final String region;
        private final String bucket;
        private final String path;

        public static ClientInfo apply(S3Client s3Client, String string, String string2, String string3) {
            return AWSS3BinaryStoreLocation$ClientInfo$.MODULE$.apply(s3Client, string, string2, string3);
        }

        public static ClientInfo fromProduct(Product product) {
            return AWSS3BinaryStoreLocation$ClientInfo$.MODULE$.fromProduct(product);
        }

        public static ClientInfo unapply(ClientInfo clientInfo) {
            return AWSS3BinaryStoreLocation$ClientInfo$.MODULE$.unapply(clientInfo);
        }

        public ClientInfo(S3Client client, String region, String bucket, String path) {
            this.client = client;
            this.region = region;
            this.bucket = bucket;
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClientInfo)) return false;
            ClientInfo clientInfo = (ClientInfo)object;
            S3Client s3Client = this.client();
            S3Client s3Client2 = clientInfo.client();
            if (s3Client == null) {
                if (s3Client2 != null) {
                    return false;
                }
            } else if (!s3Client.equals(s3Client2)) return false;
            String string = this.region();
            String string2 = clientInfo.region();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.bucket();
            String string4 = clientInfo.bucket();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.path();
            String string6 = clientInfo.path();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClientInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ClientInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "client";
                }
                case 1: {
                    return "region";
                }
                case 2: {
                    return "bucket";
                }
                case 3: {
                    return "path";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public S3Client client() {
            return this.client;
        }

        public String region() {
            return this.region;
        }

        public String bucket() {
            return this.bucket;
        }

        public String path() {
            return this.path;
        }

        public ClientInfo copy(S3Client client, String region, String bucket, String path) {
            return new ClientInfo(client, region, bucket, path);
        }

        public S3Client copy$default$1() {
            return this.client();
        }

        public String copy$default$2() {
            return this.region();
        }

        public String copy$default$3() {
            return this.bucket();
        }

        public String copy$default$4() {
            return this.path();
        }

        public S3Client _1() {
            return this.client();
        }

        public String _2() {
            return this.region();
        }

        public String _3() {
            return this.bucket();
        }

        public String _4() {
            return this.path();
        }
    }

    public static final class ConfigInfo
    implements Info,
    Product,
    Serializable {
        private final Bucket bucket;

        public static ConfigInfo apply(Bucket bucket) {
            return AWSS3BinaryStoreLocation$ConfigInfo$.MODULE$.apply(bucket);
        }

        public static ConfigInfo fromProduct(Product product) {
            return AWSS3BinaryStoreLocation$ConfigInfo$.MODULE$.fromProduct(product);
        }

        public static ConfigInfo unapply(ConfigInfo configInfo) {
            return AWSS3BinaryStoreLocation$ConfigInfo$.MODULE$.unapply(configInfo);
        }

        public ConfigInfo(Bucket bucket) {
            this.bucket = bucket;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConfigInfo)) return false;
            ConfigInfo configInfo = (ConfigInfo)object;
            Bucket bucket = this.bucket();
            Bucket bucket2 = configInfo.bucket();
            if (bucket != null) {
                if (!((Object)bucket).equals(bucket2)) return false;
                return true;
            }
            if (bucket2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfigInfo;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ConfigInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bucket";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Bucket bucket() {
            return this.bucket;
        }

        @Override
        public String description() {
            return "AWS BinaryStore using " + this.bucket().region() + ":" + this.bucket().bucket() + " " + this.bucket().path();
        }

        public ConfigInfo copy(Bucket bucket) {
            return new ConfigInfo(bucket);
        }

        public Bucket copy$default$1() {
            return this.bucket();
        }

        public Bucket _1() {
            return this.bucket();
        }
    }

    public static interface Info {
        public String description();
    }

    public static final class SysRefInfo
    implements Info,
    Product,
    Serializable {
        private final String value;
        private final String subPath;

        public static SysRefInfo apply(String string, String string2) {
            return AWSS3BinaryStoreLocation$SysRefInfo$.MODULE$.apply(string, string2);
        }

        public static SysRefInfo fromProduct(Product product) {
            return AWSS3BinaryStoreLocation$SysRefInfo$.MODULE$.fromProduct(product);
        }

        public static SysRefInfo unapply(SysRefInfo sysRefInfo) {
            return AWSS3BinaryStoreLocation$SysRefInfo$.MODULE$.unapply(sysRefInfo);
        }

        public SysRefInfo(String value, String subPath) {
            this.value = value;
            this.subPath = subPath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SysRefInfo)) return false;
            SysRefInfo sysRefInfo = (SysRefInfo)object;
            String string = this.value();
            String string2 = sysRefInfo.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.subPath();
            String string4 = sysRefInfo.subPath();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SysRefInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SysRefInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "subPath";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public String subPath() {
            return this.subPath;
        }

        @Override
        public String description() {
            return "AWS BinaryStore using " + this.value() + " subPath: " + this.subPath();
        }

        public SysRefInfo copy(String value, String subPath) {
            return new SysRefInfo(value, subPath);
        }

        public String copy$default$1() {
            return this.value();
        }

        public String copy$default$2() {
            return this.subPath();
        }

        public String _1() {
            return this.value();
        }

        public String _2() {
            return this.subPath();
        }
    }
}

