/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.db;

import ambience.cms.db.CMSResourcesDB;
import ambience.cms.management.resources.BinaryStoreHelper$;
import ambience.framework.DocumentManager2$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CMSResourcesMongoDB
implements CMSResourcesDB,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CMSResourcesMongoDB.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CMSResourcesMongoDB.class.getDeclaredField("resourcesDB$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final ExecutionContext exeCxt;
    private volatile Object resourcesDB$lzy1;

    public CMSResourcesMongoDB(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
        this.exeCxt = mongoDB.sysConfig().exeCxt();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public ExecutionContext exeCxt() {
        return this.exeCxt;
    }

    public RichMongoCollection resourcesDB() {
        Object object = this.resourcesDB$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.resourcesDB$lzyINIT1();
    }

    private Object resourcesDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.resourcesDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB().database().getCollection("CMSResources", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.resourcesDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Json> getResourcesByContentType(UserDB.User user, List<String> mimeTypeList) {
        Bson in = Filters$.MODULE$.in("contentType", (Seq)mimeTypeList.map((Function1 & Serializable)mt -> BsonString$.MODULE$.apply(mt)));
        FindOptions opts = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"storeCategoryName", "store", "category", "name"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        return this.resourcesDB().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists("storeCategoryName"), in})), opts).toListL().map((Function1 & Serializable)reply -> {
            Either either = package$.MODULE$.parse(reply.map((Function1 & Serializable)_$1 -> _$1.toJson()).mkString("[", ",\n", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> CMSResourcesMongoDB.getResourcesByContentType$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(31), FullName$.MODULE$.apply("ambience.cms.db.CMSResourcesMongoDB.getResourcesByContentType"));
                return Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        }).map((Function1 & Serializable)res -> res);
    }

    public Task<Option<Json>> getResources(UserDB.User user, String storeCategoryName) {
        Bson cn = Filters$.MODULE$.eq("storeCategoryName", (Object)BsonString$.MODULE$.apply(storeCategoryName));
        FindOptions opts = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"storeCategoryName", "contentType", "contentId"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        return this.resourcesDB().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists("storeCategoryName"), cn})), opts).firstOptionL().map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)doc -> {
            Either either = package$.MODULE$.parse(doc.toJson());
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> CMSResourcesMongoDB.getResources$$anonfun$1$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.cms.db.CMSResourcesMongoDB.getResources"));
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return Some$.MODULE$.apply((Object)json);
            }
            throw new MatchError((Object)either);
        })).map((Function1 & Serializable)res -> res);
    }

    @Override
    public Task<Option<Json>> getResourcesByStoreCategoryName(UserDB.User user, String storeCategoryName) {
        Bson cn = Filters$.MODULE$.eq("storeCategoryName", (Object)BsonString$.MODULE$.apply(storeCategoryName));
        FindOptions opts = FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"storeCategoryName", "contentType", "contentId"}))), FindOptions$.MODULE$.$lessinit$greater$default$2(), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4());
        return this.resourcesDB().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists("storeCategoryName"), cn})), opts).firstOptionL().map((Function1 & Serializable)_$3 -> _$3.flatMap((Function1 & Serializable)doc -> {
            Either either = package$.MODULE$.parse(doc.toJson());
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> CMSResourcesMongoDB.getResourcesByStoreCategoryName$$anonfun$1$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.cms.db.CMSResourcesMongoDB.getResourcesByStoreCategoryName"));
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return Some$.MODULE$.apply((Object)json);
            }
            throw new MatchError((Object)either);
        })).map((Function1 & Serializable)res -> res);
    }

    @Override
    public Task<Option<byte[]>> getContentFromBinaryStore(String store, String contentId) {
        return BinaryStoreHelper$.MODULE$.getBytes(store, contentId);
    }

    private static final Object getResourcesByContentType$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object getResources$$anonfun$1$$anonfun$1$$anonfun$1(ParsingFailure err$2) {
        return "Error parsing BSON json output: " + err$2;
    }

    private static final Object getResourcesByStoreCategoryName$$anonfun$1$$anonfun$1$$anonfun$1(ParsingFailure err$3) {
        return "Error parsing BSON json output: " + err$3;
    }
}

