/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.api.BinaryStore;
import ambience.cms.Lenses$;
import ambience.cms.SnapshotId$;
import ambience.cms.management.AutoPublishHelper$DeployInfo$;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.SitesManager;
import ambience.cms.management.Util$;
import ambience.cms.management.snapshots.SnapshotDeployHandler;
import ambience.cms.management.snapshots.SnapshotDeployHandler$;
import ambience.framework.EventBus$;
import ambience.module.ProjectConfig;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AutoPublishHelper
implements LoggingHelper2,
SnapshotDeployHandler {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(AutoPublishHelper.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(AutoPublishHelper.class.getDeclaredField("baseDir$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(AutoPublishHelper.class.getDeclaredField("initialDuration$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AutoPublishHelper.class.getDeclaredField("initialDelay$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AutoPublishHelper.class.getDeclaredField("pc$lzy1"));
    private volatile Object log$lzy1;
    private final CMSManagementModule module;
    private volatile Object pc$lzy1;
    private volatile Object initialDelay$lzy1;
    private volatile Object initialDuration$lzy1;
    private volatile Object baseDir$lzy1;

    public AutoPublishHelper(CMSManagementModule module) {
        this.module = module;
        EventBus$.MODULE$.events().mapEval((Function1 & Serializable)msg -> this.eventBusUpdate(msg.eventType(), msg.doc())).completedL().runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public CMSManagementModule module() {
        return this.module;
    }

    @Override
    public ProjectConfig pc() {
        Object object = this.pc$lzy1;
        if (object instanceof ProjectConfig) {
            return (ProjectConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ProjectConfig)this.pc$lzyINIT1();
    }

    private Object pc$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pc$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ProjectConfig projectConfig = null;
                    try {
                        projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
                        object2 = projectConfig == null ? LazyVals.NullValue$.MODULE$ : projectConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pc$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return projectConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Duration initialDelay() {
        Object object = this.initialDelay$lzy1;
        if (object instanceof Duration) {
            return (Duration)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Duration)this.initialDelay$lzyINIT1();
    }

    private Object initialDelay$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.initialDelay$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Duration duration = null;
                    try {
                        duration = this.pc().config().getDuration("ambience.modules.cms-management.auto-publish.initial-delay");
                        object2 = duration == null ? LazyVals.NullValue$.MODULE$ : duration;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.initialDelay$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return duration;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FiniteDuration initialDuration() {
        Object object = this.initialDuration$lzy1;
        if (object instanceof FiniteDuration) {
            return (FiniteDuration)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FiniteDuration)this.initialDuration$lzyINIT1();
    }

    private Object initialDuration$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.initialDuration$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FiniteDuration finiteDuration = null;
                    try {
                        finiteDuration = Duration$.MODULE$.apply(this.initialDelay().toMillis(), package$.MODULE$.MILLISECONDS());
                        object2 = finiteDuration == null ? LazyVals.NullValue$.MODULE$ : finiteDuration;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.initialDuration$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return finiteDuration;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Path baseDir() {
        Object object = this.baseDir$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.baseDir$lzyINIT1();
    }

    private Object baseDir$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.baseDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        Path p = Paths.get(this.pc().WebRootDir().toPath().toString(), "cms");
                        Files.createDirectories(p, new FileAttribute[0]);
                        path = p;
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.baseDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.baseDir$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<BoxedUnit> runAutoRedeploy() {
        return this.doRunAutoRedeploy().delayExecution(this.initialDuration());
    }

    public Task<BoxedUnit> doRunAutoRedeploy() {
        this.log().info(AutoPublishHelper::doRunAutoRedeploy$$anonfun$1, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.cms.management.AutoPublishHelper.doRunAutoRedeploy"));
        return this.buildSitesDeployInfo().flatMap((Function1 & Serializable)list -> {
            List tasks = this.findSitesToDeploy((List<DeployInfo>)list).map((Function1 & Serializable)info -> {
                SnapshotDeployHandler.Context cxt = this.buildContext((DeployInfo)info);
                return SnapshotDeployHandler$.MODULE$.deploy(this.baseDir(), cxt.directoryPrefix(), BinaryStore.LocationId$.MODULE$.apply(SnapshotDeployHandler$.MODULE$.STORE()), info.contentId(), cxt.buildSubstitutionMap(info.contentId())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        String msg = (String)((Left)either).value();
                        this.log().error(() -> AutoPublishHelper.$anonfun$1$$anonfun$1$$anonfun$1(info, msg), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.cms.management.AutoPublishHelper.tasks"));
                        return;
                    }
                    if (either instanceof Right) {
                        Json value = (Json)((Right)either).value();
                        this.log().info(() -> AutoPublishHelper.$anonfun$1$$anonfun$1$$anonfun$2(info), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.cms.management.AutoPublishHelper.tasks"));
                        return;
                    }
                    throw new MatchError((Object)either);
                });
            });
            return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
        });
    }

    public SnapshotDeployHandler.Context buildContext(DeployInfo info) {
        return new SnapshotDeployHandler.Context(info){
            private final DeployInfo info$5;
            private final String snapshotId;
            {
                this.info$5 = info$4;
                this.snapshotId = SnapshotId$.MODULE$.apply(info$4.site().snapshotId());
            }

            public String snapshotId() {
                return this.snapshotId;
            }

            public String redirectUrl(String contentId, Json metadata) {
                return "";
            }

            public Map buildSubstitutionMap(String contentId) {
                Object[] objectArray = new Tuple2[3];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"elx-base");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Util$.MODULE$.publishBase());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elx-url-prefix");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)ambience.cms.Util$.MODULE$.fixURLSlashes("cms/" + this.info$5.site().urlPrefix()));
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elx-parameters");
                objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"${elx-parameters}");
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }

            public String directoryPrefix() {
                return this.info$5.site().name() + "-";
            }
        };
    }

    public List<DeployInfo> findSitesToDeploy(List<DeployInfo> list) {
        List toDeploy = list.filterNot((Function1 & Serializable)_$2 -> _$2.deployPath().toFile().exists());
        this.log().info(() -> AutoPublishHelper.findSitesToDeploy$$anonfun$1(toDeploy), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.cms.management.AutoPublishHelper.findSitesToDeploy"));
        return toDeploy;
    }

    public Task<List<DeployInfo>> buildSitesDeployInfo() {
        return this.module().sitesManager().getIdSiteMap(this.module().sitesManager().getIdSiteMap$default$1()).flatMap((Function1 & Serializable)smap -> {
            Task tasks = Task$.MODULE$.sequence((Iterable)smap.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SitesManager.Site site = (SitesManager.Site)tuple2._2();
                    return this.getContentId(site).map((Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)cId -> this.$anonfun$3$$anonfun$1$$anonfun$1(site, cId == null ? null : ((BinaryStore.ContentId)cId).value())));
                }
                throw new MatchError((Object)tuple2);
            }), BuildFrom$.MODULE$.buildFromIterableOps());
            return tasks.map((Function1 & Serializable)_$5 -> ((IterableOnceOps)_$5.flatten(Predef$.MODULE$.$conforms())).toList());
        });
    }

    public Task<Option<String>> getContentId(SitesManager.Site site) {
        return this.module().snapshotsManager().getById(SnapshotId$.MODULE$.apply(site.snapshotId())).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return Lenses$.MODULE$.SnapshotId().getOption((Object)json).map((Function1 & Serializable)value -> new BinaryStore.ContentId(BinaryStore.ContentId$.MODULE$.apply(value)));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    public Path sitePath(SitesManager.Site site, String id) {
        return Paths.get(this.baseDir().toString(), site.name() + "-snapshot-" + id);
    }

    public Task<BoxedUnit> eventBusUpdate(String eventType, Document doc) {
        String string = eventType;
        String string2 = "CMS/site-published";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.doRunAutoRedeploy();
        }
        return Task$.MODULE$.unit();
    }

    private static final Object doRunAutoRedeploy$$anonfun$1() {
        return "run auto redeploy";
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$1(DeployInfo info$2, String msg$1) {
        return "Re-deployment of Site=" + info$2.site().name() + " failed. snapshotId=" + info$2.site().snapshotId() + " " + msg$1;
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$2(DeployInfo info$3) {
        return "Re-deployment of Site=" + info$3.site().name() + " successful";
    }

    private static final Object findSitesToDeploy$$anonfun$1(List toDeploy$1) {
        return "Site candidates for re-deployment (" + toDeploy$1.size() + ") " + toDeploy$1.map((Function1 & Serializable)_$3 -> _$3.site().name()).mkString(",");
    }

    private final /* synthetic */ DeployInfo $anonfun$3$$anonfun$1$$anonfun$1(SitesManager.Site site$2, String cId) {
        return AutoPublishHelper$DeployInfo$.MODULE$.apply(site$2, cId, this.sitePath(site$2, cId));
    }

    public static final class DeployInfo
    implements Product,
    Serializable {
        private final SitesManager.Site site;
        private final String contentId;
        private final Path deployPath;

        public static DeployInfo apply(SitesManager.Site site, String string, Path path) {
            return AutoPublishHelper$DeployInfo$.MODULE$.apply(site, string, path);
        }

        public static DeployInfo fromProduct(Product product) {
            return AutoPublishHelper$DeployInfo$.MODULE$.fromProduct(product);
        }

        public static DeployInfo unapply(DeployInfo deployInfo) {
            return AutoPublishHelper$DeployInfo$.MODULE$.unapply(deployInfo);
        }

        public DeployInfo(SitesManager.Site site, String contentId, Path deployPath) {
            this.site = site;
            this.contentId = contentId;
            this.deployPath = deployPath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeployInfo)) return false;
            DeployInfo deployInfo = (DeployInfo)object;
            SitesManager.Site site = this.site();
            SitesManager.Site site2 = deployInfo.site();
            if (site == null) {
                if (site2 != null) {
                    return false;
                }
            } else if (!((Object)site).equals(site2)) return false;
            String string = this.contentId();
            String string2 = deployInfo.contentId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Path path = this.deployPath();
            Path path2 = deployInfo.deployPath();
            if (path == null) {
                if (path2 == null) return true;
                return false;
            } else {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeployInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DeployInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return new BinaryStore.ContentId(this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "site";
                }
                case 1: {
                    return "contentId";
                }
                case 2: {
                    return "deployPath";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SitesManager.Site site() {
            return this.site;
        }

        public String contentId() {
            return this.contentId;
        }

        public Path deployPath() {
            return this.deployPath;
        }

        public DeployInfo copy(SitesManager.Site site, String contentId, Path deployPath) {
            return new DeployInfo(site, contentId, deployPath);
        }

        public SitesManager.Site copy$default$1() {
            return this.site();
        }

        public String copy$default$2() {
            return this.contentId();
        }

        public Path copy$default$3() {
            return this.deployPath();
        }

        public SitesManager.Site _1() {
            return this.site();
        }

        public String _2() {
            return this.contentId();
        }

        public Path _3() {
            return this.deployPath();
        }
    }
}

