/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.api.BinaryStore;
import ambience.cms.Lenses$;
import ambience.cms.PageName;
import ambience.cms.PageName$;
import ambience.cms.SiteId$;
import ambience.cms.SnapshotId;
import ambience.cms.SnapshotId$;
import ambience.cms.Util$;
import ambience.cms.management.CMSGetFromDirectory;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.CMSManagementModule$;
import ambience.cms.management.CMSRoute$PagePrivilege$;
import ambience.cms.management.CMSRoute$SnapshotInfo$;
import ambience.cms.management.HTMLTemplateRoute;
import ambience.cms.management.HttpResponseHandler;
import ambience.cms.management.HttpResponseHandler$;
import ambience.cms.management.HttpResponseHandler$Context$;
import ambience.cms.management.SitesManager;
import ambience.cms.management.resources.BinaryStoreHelper$;
import ambience.cms.management.snapshots.SnapshotDeployHandler$;
import ambience.gravity.GravityHelper$;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.webserver.I18N$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface CMSRoute
extends HTMLTemplateRoute {
    public static void $init$(CMSRoute $this) {
    }

    public static Scheduler exeCxt$(CMSRoute $this) {
        return $this.exeCxt();
    }

    default public Scheduler exeCxt() {
        return Scheduler$.MODULE$.global();
    }

    public static UserDB userDB$(CMSRoute $this) {
        return $this.userDB();
    }

    default public UserDB userDB() {
        return (UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class));
    }

    public static ProjectConfig pc$(CMSRoute $this) {
        return $this.pc();
    }

    default public ProjectConfig pc() {
        return (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
    }

    public static Duration cacheMaxAge$(CMSRoute $this) {
        return $this.cacheMaxAge();
    }

    default public Duration cacheMaxAge() {
        return this.pc().config().getDuration("ambience.modules.cms-management.cache-control.public.max-age");
    }

    public static CMSGetFromDirectory ambience$cms$management$CMSRoute$$getFromDirectory$(CMSRoute $this) {
        return $this.ambience$cms$management$CMSRoute$$getFromDirectory();
    }

    default public CMSGetFromDirectory ambience$cms$management$CMSRoute$$getFromDirectory() {
        return new CMSGetFromDirectory(((CMSManagementModule)this).projectConfig().WebRootDir(), this.cacheMaxAge());
    }

    public static HttpResponseHandler responseHandler$(CMSRoute $this) {
        return $this.responseHandler();
    }

    default public HttpResponseHandler responseHandler() {
        HttpResponseHandler$.MODULE$.register();
        return (HttpResponseHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(HttpResponseHandler.class));
    }

    public static Path publishedPath$(CMSRoute $this) {
        return $this.publishedPath();
    }

    default public Path publishedPath() {
        Path p = Paths.get(((CMSManagementModule)this).projectConfig().WebRootDir().toPath().toString(), "cms");
        Files.createDirectories(p, new FileAttribute[0]);
        return p;
    }

    public static Function1 cmsRoute$(CMSRoute $this) {
        return $this.cmsRoute();
    }

    default public Function1<GravityRequest, Task<GravityResponse>> cmsRoute() {
        return GravitySystem$.MODULE$.fromRoutes((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.log((Function1)(JProcedure1 & Serializable)req -> ((CMSManagementModule)this).log().info(() -> CMSRoute.cmsRoute$$anonfun$1$$anonfun$1(req), Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.cms.management.CMSRoute.cmsRoute"))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "view-site/*", this.viewSiteSeg()), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "dataset/*", ((CMSManagementModule)this).datasetRoute()), GravityRoute$.MODULE$.path("banner/*", GravitySystem$.MODULE$.fromRoutes(((CMSManagementModule)this).bannerRoutes(), GravitySystem$.MODULE$.fromRoutes$default$2())), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "htpri/*", RouteHelper$.MODULE$.withModUser(((CMSManagementModule)this).id(), (Function1 & Serializable)user -> this.htmlTemplatePrivateRoute((UserDB.User)user))), GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "htpub/*", this.htmlTemplatePublicRoute()), GravityRoute$.MODULE$.all(this.handleRemaining())})), GravitySystem$.MODULE$.fromRoutes$default$2());
    }

    public static Function1 viewSiteSeg$(CMSRoute $this) {
        return $this.viewSiteSeg();
    }

    default public Function1<GravityRequest, Task<GravityResponse>> viewSiteSeg() {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)siteId -> ((CMSManagementModule)this).oAuth2Client().approveWithUser((Function1 & Serializable)user -> (Function1 & Serializable)_$5 -> this.getSiteUrl((UserDB.User)user, siteId.value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                String siteUrl = (String)((Some)option).value();
                return Gravity$.MODULE$.TempRedirectResponse(((CMSManagementModule)this).prefix() + siteUrl);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse("No Published content found for this Site");
            }
            throw new MatchError((Object)option);
        })));
    }

    public static Function1 handleRemaining$(CMSRoute $this) {
        return $this.handleRemaining();
    }

    default public Function1<GravityRequest, Task<GravityResponse>> handleRemaining() {
        return (Function1 & Serializable)request -> {
            Gravity.Path url = request.unmatchedPath();
            return (Task)this.handleSiteRequest(url.toString(), (Function1<SitesManager.Site, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)site -> ((CMSManagementModule)this).oAuth2Client().optAuthenticated((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    UserDB.User user = (UserDB.User)((Some)option).value();
                    return (Function1 & Serializable)_$6 -> {
                        boolean hasSiteRole;
                        boolean bl = hasSiteRole = site.roles().isEmpty() || ((IterableOnceOps)user.roles().filter((Function1 & Serializable)_$7 -> _$7.enabled())).exists((Function1 & Serializable)r -> site.roles().contains((Object)r.id()));
                        if (hasSiteRole) {
                            Task handler = ((CMSManagementModule)this).sitesManager().getById(user, SiteId$.MODULE$.apply(site.id()), ((CMSManagementModule)this).sitesManager().getById$default$3()).map((Function1 & Serializable)x$1 -> {
                                Option option = x$1;
                                if (option instanceof Some) {
                                    return this.siteRequest((SitesManager.Site)site, (Option<UserDB.User>)Some$.MODULE$.apply((Object)user));
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return this.publicSiteRequest((SitesManager.Site)site, (Option<UserDB.User>)Some$.MODULE$.apply((Object)user));
                                }
                                throw new MatchError((Object)option);
                            });
                            return handler.flatMap((Function1 & Serializable)_$8 -> (Task)_$8.apply(request));
                        }
                        return (Task)Gravity$.MODULE$.UnauthorizedHandler().apply(request);
                    };
                }
                if (None$.MODULE$.equals(option)) {
                    return this.publicSiteRequest((SitesManager.Site)site, (Option<UserDB.User>)None$.MODULE$);
                }
                throw new MatchError((Object)option);
            })).apply(request);
        };
    }

    public static Function1 publicSiteRequest$(CMSRoute $this, SitesManager.Site site, Option userOpt) {
        return $this.publicSiteRequest(site, (Option<UserDB.User>)userOpt);
    }

    default public Function1<GravityRequest, Task<GravityResponse>> publicSiteRequest(SitesManager.Site site, Option<UserDB.User> userOpt) {
        if (site.isPublic()) {
            return this.siteRequest(site, userOpt);
        }
        return ((CMSManagementModule)this).oAuth2Client().approveWithUser((Function1 & Serializable)_$9 -> this.siteRequest(site, userOpt));
    }

    public static Function1 siteRequest$(CMSRoute $this, SitesManager.Site site, Option userOpt) {
        return $this.siteRequest(site, (Option<UserDB.User>)userOpt);
    }

    default public Function1<GravityRequest, Task<GravityResponse>> siteRequest(SitesManager.Site site, Option<UserDB.User> userOpt) {
        return (Function1 & Serializable)request -> {
            String string;
            Gravity.RequestBody requestBody;
            Gravity.Parameters parameters;
            Gravity.Headers headers;
            Gravity.Method method;
            Gravity.Path path;
            String string2;
            Vector all = (Vector)((IterableOps)Gravity.Path$.MODULE$.apply("cms").segments().$plus$plus((IterableOnce)Gravity.Path$.MODULE$.apply(site.fileSystemPath()).segments())).$plus$plus((IterableOnce)request.unmatchedPath().segments().drop(1));
            Gravity.Path path2 = Gravity.Path$.MODULE$.fromRaw((Vector)all.map((Function1 & Serializable)_$10 -> _$10.value()));
            String string3 = request.copy$default$1();
            GravityRequest full = request.copy(string3, string2 = request.copy$default$2(), path = request.copy$default$3(), path2, method = request.copy$default$5(), headers = request.copy$default$6(), parameters = request.copy$default$7(), requestBody = request.copy$default$8(), string = request.copy$default$9());
            if (full.unmatchedPath().toString().endsWith(".html")) {
                return this.handleCMSPage(full, site, userOpt);
            }
            return this.ambience$cms$management$CMSRoute$$getFromDirectory().apply(full);
        };
    }

    public static Task handleCMSPage$(CMSRoute $this, GravityRequest req, SitesManager.Site site, Option userOpt) {
        return $this.handleCMSPage(req, site, (Option<UserDB.User>)userOpt);
    }

    default public Task<GravityResponse> handleCMSPage(GravityRequest req, SitesManager.Site site, Option<UserDB.User> userOpt) {
        Option pageNameOpt = ((IndexedSeqOps)req.path().segments().reverse()).headOption().map((Function1 & Serializable)n -> new PageName(PageName$.MODULE$.apply(n.value().replace(".html", ""))));
        Option option = pageNameOpt;
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String name = object == null ? null : ((PageName)object).value();
            return ((CMSManagementModule)this).snapshotsManager().getById(SnapshotId$.MODULE$.apply(site.snapshotId())).map((Function1 & Serializable)_$11 -> (Json)_$11.getOrElse(CMSRoute::handleCMSPage$$anonfun$1$$anonfun$1)).flatMap((Function1 & Serializable)snapshot -> Task$.MODULE$.now((Object)CMSRoute$SnapshotInfo$.MODULE$.apply((Json)snapshot)).flatMap((Function1 & Serializable)info -> this.hasPagePrivilege((SnapshotInfo)info, site, PageName$.MODULE$.apply(name), userOpt).flatMap((Function1 & Serializable)valid -> this.handleCMSPage$$anonfun$2$$anonfun$1$$anonfun$1(req, site, userOpt, (SnapshotInfo)info, name, BoxesRunTime.unboxToBoolean((Object)valid)))));
        }
        if (None$.MODULE$.equals(option)) {
            return Gravity$.MODULE$.BadRequestResponseT();
        }
        throw new MatchError((Object)option);
    }

    public static Task buildCMSPageResponse$(CMSRoute $this, GravityRequest req, SitesManager.Site site, Option user, Option i18NCategory, List pageI18NPropertyList) {
        return $this.buildCMSPageResponse(req, site, (Option<UserDB.User>)user, (Option<String>)i18NCategory, (List<String>)pageI18NPropertyList);
    }

    default public Task<GravityResponse> buildCMSPageResponse(GravityRequest req, SitesManager.Site site, Option<UserDB.User> user, Option<String> i18NCategory, List<String> pageI18NPropertyList) {
        String lang = I18N$.MODULE$.getAcceptLanguage(req);
        PartialFunction elxParameters = (PartialFunction)user.map((Function1 & Serializable)u -> CMSManagementModule$.MODULE$.getParams((UserDB.User)u, lang, site.isPublic())).getOrElse(() -> CMSRoute.$anonfun$7(lang, site));
        HttpResponseHandler.Context cxt = HttpResponseHandler$Context$.MODULE$.apply(user, req, I18N$.MODULE$.getAcceptLanguage(req), site, req.unmatchedPath(), (PartialFunction<String, String>)elxParameters, i18NCategory, pageI18NPropertyList);
        return this.responseHandler().buildHttpResponse(((CMSManagementModule)this).webReply(), cxt);
    }

    public static Task hasPagePrivilege$(CMSRoute $this, SnapshotInfo info, SitesManager.Site site, String pageName, Option userOpt) {
        return $this.hasPagePrivilege(info, site, pageName, (Option<UserDB.User>)userOpt);
    }

    default public Task<Object> hasPagePrivilege(SnapshotInfo info, SitesManager.Site site, String pageName, Option<UserDB.User> userOpt) {
        String name = pageName.replace(".html", "");
        Option<UserDB.User> option = userOpt;
        if (option instanceof Some) {
            if (site.isPublic()) {
                return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            UserDB.User user = (UserDB.User)((Some)option).value();
            return this.userHasPrivilege(user, info, name);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new MatchError(option);
    }

    public static Task userHasPrivilege$(CMSRoute $this, UserDB.User user, SnapshotInfo info, String name) {
        return $this.userHasPrivilege(user, info, name);
    }

    default public Task<Object> userHasPrivilege(UserDB.User user, SnapshotInfo info, String name) {
        Option option = info.pagePrivileges().filter((Function1 & Serializable)_$12 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$12.privilege().trim()))).find((Function1 & Serializable)_$13 -> {
            String string = _$13.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            PagePrivilege priv = (PagePrivilege)((Some)option).value();
            return this.userDB().getPrivileges().toListL().map((Function1 & Serializable)res -> res.filter((Function1 & Serializable)p -> user.privileges().contains((Object)p.name())).map((Function1 & Serializable)_$14 -> _$14.id()).contains((Object)priv.privilege()));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        throw new MatchError((Object)option);
    }

    public static Function1 handleSiteRequest$(CMSRoute $this, String url, Function1 innerRoute) {
        return $this.handleSiteRequest(url, (Function1<SitesManager.Site, Function1<GravityRequest, Task<GravityResponse>>>)innerRoute);
    }

    default public Function1<GravityRequest, Task<GravityResponse>> handleSiteRequest(String url, Function1<SitesManager.Site, Function1<GravityRequest, Task<GravityResponse>>> innerRoute) {
        return (Function1 & Serializable)request -> this.buildSiteInfo(url).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                ((CMSManagementModule)this).log().error(() -> CMSRoute.handleSiteRequest$$anonfun$1$$anonfun$1$$anonfun$1(msg), Line$.MODULE$.apply(202), FullName$.MODULE$.apply("ambience.cms.management.CMSRoute.handleSiteRequest"));
                return Gravity$.MODULE$.NotFoundResponseT();
            }
            if (either instanceof Right) {
                SitesManager.Site info = (SitesManager.Site)((Right)either).value();
                return (Task)((Function1)innerRoute.apply((Object)info)).apply(request);
            }
            throw new MatchError((Object)either);
        });
    }

    public static Task buildSiteInfo$(CMSRoute $this, String url) {
        return $this.buildSiteInfo(url);
    }

    default public Task<Either<String, SitesManager.Site>> buildSiteInfo(String url) {
        return (Task)EitherT$.MODULE$.apply((Object)this.lookupSite(url).map((Function1 & Serializable)_$15 -> _$15.toRight(CMSRoute::buildSiteInfo$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)siteInfo -> EitherT$.MODULE$.apply(this.getFileSystemPath((SitesManager.Site)siteInfo)).map((Function1 & Serializable)path -> siteInfo.copy(siteInfo.copy$default$1(), siteInfo.copy$default$2(), siteInfo.copy$default$3(), siteInfo.copy$default$4(), siteInfo.copy$default$5(), siteInfo.copy$default$6(), (String)path), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public static Task getFileSystemPath$(CMSRoute $this, SitesManager.Site site) {
        return $this.getFileSystemPath(site);
    }

    default public Task<Either<String, String>> getFileSystemPath(SitesManager.Site site) {
        return ((Task)OptionT$.MODULE$.apply(((CMSManagementModule)this).snapshotsManager().getById(SnapshotId$.MODULE$.apply(site.snapshotId()))).flatMap((Function1 & Serializable)snapshot -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SnapshotId().getOption(snapshot).map((Function1 & Serializable)value -> new SnapshotId(SnapshotId$.MODULE$.apply(value))))).map((Function1 & Serializable)snapshotId -> CMSRoute.getFileSystemPath$$anonfun$1$$anonfun$2(site, snapshotId == null ? null : ((SnapshotId)snapshotId).value()), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)p);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)"Site not available2");
            }
            throw new MatchError((Object)option);
        });
    }

    public static Task getSiteUrl$(CMSRoute $this, UserDB.User user, String siteId) {
        return $this.getSiteUrl(user, siteId);
    }

    default public Task<Option<String>> getSiteUrl(UserDB.User user, String siteId) {
        return (Task)OptionT$.MODULE$.apply(((CMSManagementModule)this).sitesManager().getById(user, SiteId$.MODULE$.apply(siteId), ((CMSManagementModule)this).sitesManager().getById$default$3())).flatMap((Function1 & Serializable)site -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SiteUrlPrefix().getOption(site))).flatMap((Function1 & Serializable)siteUrl -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SnapshotId().getOption(site).map((Function1 & Serializable)value -> new SnapshotId(SnapshotId$.MODULE$.apply(value))))).flatMap((Function1 & Serializable)siteSnapshotId -> this.getSiteUrl$$anonfun$1$$anonfun$1$$anonfun$2((String)siteUrl, siteSnapshotId == null ? null : ((SnapshotId)siteSnapshotId).value()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public static Option buildUrl$(CMSRoute $this, String siteUrl, Json metadata) {
        return $this.buildUrl(siteUrl, metadata);
    }

    default public Option<String> buildUrl(String siteUrl, Json metadata) {
        String urlPrefix = (String)Lenses$.MODULE$.URLPrefix().getOption((Object)metadata).getOrElse(CMSRoute::$anonfun$8);
        String startPage = (String)Lenses$.MODULE$.StartPage().getOption((Object)metadata).getOrElse(CMSRoute::$anonfun$9);
        Object url = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(urlPrefix)) ? urlPrefix + "/" + startPage : String.valueOf(startPage);
        return Some$.MODULE$.apply((Object)Util$.MODULE$.fixURLSlashes("/cms/" + siteUrl + "/" + (String)url));
    }

    public static Task lookupSite$(CMSRoute $this, String url) {
        return $this.lookupSite(url);
    }

    default public Task<Option<SitesManager.Site>> lookupSite(String url) {
        String reqUrlPrefix = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(url), "/").trim()), (Function1 & Serializable)_$16 -> CMSRoute.$anonfun$10(BoxesRunTime.unboxToChar((Object)_$16)));
        return ((CMSManagementModule)this).sitesManager().getIdSiteMap(((CMSManagementModule)this).sitesManager().getIdSiteMap$default$1()).map((Function1 & Serializable)mapping -> {
            ((CMSManagementModule)this).log().info(() -> CMSRoute.lookupSite$$anonfun$1$$anonfun$1(url, mapping), Line$.MODULE$.apply(249), FullName$.MODULE$.apply("ambience.cms.management.CMSRoute.lookupSite"));
            Option noUrlPrefixSite = mapping.find((Function1 & Serializable)_$17 -> {
                String string = ((SitesManager.Site)_$17._2()).urlPrefix().trim();
                String string2 = "/";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$18 -> (SitesManager.Site)_$18._2());
            return mapping.find((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SitesManager.Site site = (SitesManager.Site)tuple2._2();
                    String urlPrefix = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(site.urlPrefix()), "/").trim();
                    if (urlPrefix.isEmpty()) {
                        return false;
                    }
                    String string = reqUrlPrefix;
                    String string2 = urlPrefix;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)_$19 -> (SitesManager.Site)_$19._2()).orElse(() -> CMSRoute.lookupSite$$anonfun$1$$anonfun$4(noUrlPrefixSite));
        });
    }

    private static Object cmsRoute$$anonfun$1$$anonfun$1(GravityRequest req$1) {
        return "cmsRoute request: " + req$1.unmatchedPath();
    }

    private static Json handleCMSPage$$anonfun$1$$anonfun$1() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static List handleCMSPage$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private /* synthetic */ Task handleCMSPage$$anonfun$2$$anonfun$1$$anonfun$1(GravityRequest req$4, SitesManager.Site site$9, Option userOpt$5, SnapshotInfo info$1, String name$3, boolean valid) {
        return (valid ? this.buildCMSPageResponse(req$4, site$9, (Option<UserDB.User>)userOpt$5, info$1.i18NCategoryOpt(), (List<String>)((List)info$1.pageI18Map().get((Object)name$3).getOrElse(CMSRoute::handleCMSPage$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1))) : Gravity$.MODULE$.UnauthorizedResponseT()).map((Function1 & Serializable)res -> res);
    }

    private static PartialFunction $anonfun$7(String lang$2, SitesManager.Site site$11) {
        return CMSManagementModule$.MODULE$.getParams(lang$2, site$11.isPublic());
    }

    private static Object handleSiteRequest$$anonfun$1$$anonfun$1$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private static String buildSiteInfo$$anonfun$1$$anonfun$1() {
        return "Site not available1";
    }

    private static /* synthetic */ String getFileSystemPath$$anonfun$1$$anonfun$2(SitesManager.Site site$13, String snapshotId) {
        return site$13.name() + "-snapshot-" + snapshotId;
    }

    private /* synthetic */ OptionT getSiteUrl$$anonfun$1$$anonfun$1$$anonfun$2(String siteUrl$1, String siteSnapshotId) {
        return OptionT$.MODULE$.apply(((CMSManagementModule)this).snapshotsManager().getById(SnapshotId$.MODULE$.apply(siteSnapshotId))).flatMap((Function1 & Serializable)snapshot -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SnapshotId().getOption(snapshot))).flatMap((Function1 & Serializable)ssId -> OptionT$.MODULE$.apply(BinaryStoreHelper$.MODULE$.getMetadata(BinaryStore.LocationId$.MODULE$.apply(SnapshotDeployHandler$.MODULE$.STORE()), BinaryStore.ContentId$.MODULE$.apply(ssId))).flatMap((Function1 & Serializable)metadata -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now(this.buildUrl(siteUrl$1, (Json)metadata))).map((Function1 & Serializable)url -> url, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
    }

    private static String $anonfun$8() {
        return "";
    }

    private static String $anonfun$9() {
        return "";
    }

    private static /* synthetic */ boolean $anonfun$10(char _$16) {
        return _$16 != '/';
    }

    private static Object lookupSite$$anonfun$1$$anonfun$1(String url$3, Map mapping$1) {
        return "lookupSite(" + url$3 + ") with mappings: " + mapping$1;
    }

    private static Option lookupSite$$anonfun$1$$anonfun$4(Option noUrlPrefixSite$1) {
        return noUrlPrefixSite$1;
    }

    public static final class PagePrivilege
    implements Product,
    Serializable {
        private final String name;
        private final String privilege;

        public static Option<PagePrivilege> apply(Json json) {
            return CMSRoute$PagePrivilege$.MODULE$.apply(json);
        }

        public static PagePrivilege apply(String string, String string2) {
            return CMSRoute$PagePrivilege$.MODULE$.apply(string, string2);
        }

        public static PagePrivilege fromProduct(Product product) {
            return CMSRoute$PagePrivilege$.MODULE$.fromProduct(product);
        }

        public static PagePrivilege unapply(PagePrivilege pagePrivilege) {
            return CMSRoute$PagePrivilege$.MODULE$.unapply(pagePrivilege);
        }

        public PagePrivilege(String name, String privilege) {
            this.name = name;
            this.privilege = privilege;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PagePrivilege)) return false;
            PagePrivilege pagePrivilege = (PagePrivilege)object;
            String string = this.name();
            String string2 = pagePrivilege.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.privilege();
            String string4 = pagePrivilege.privilege();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PagePrivilege;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PagePrivilege";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "privilege";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String privilege() {
            return this.privilege;
        }

        public PagePrivilege copy(String name, String privilege) {
            return new PagePrivilege(name, privilege);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.privilege();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.privilege();
        }
    }

    public static final class SnapshotInfo
    implements Product,
    Serializable {
        private final Option i18NCategoryOpt;
        private final Map pageI18Map;
        private final List pagePrivileges;

        public static SnapshotInfo apply(Json json) {
            return CMSRoute$SnapshotInfo$.MODULE$.apply(json);
        }

        public static SnapshotInfo apply(Option<String> option, Map<String, List<String>> map, List<PagePrivilege> list) {
            return CMSRoute$SnapshotInfo$.MODULE$.apply(option, map, list);
        }

        public static SnapshotInfo fromProduct(Product product) {
            return CMSRoute$SnapshotInfo$.MODULE$.fromProduct(product);
        }

        public static SnapshotInfo unapply(SnapshotInfo snapshotInfo) {
            return CMSRoute$SnapshotInfo$.MODULE$.unapply(snapshotInfo);
        }

        public SnapshotInfo(Option<String> i18NCategoryOpt, Map<String, List<String>> pageI18Map, List<PagePrivilege> pagePrivileges) {
            this.i18NCategoryOpt = i18NCategoryOpt;
            this.pageI18Map = pageI18Map;
            this.pagePrivileges = pagePrivileges;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SnapshotInfo)) return false;
            SnapshotInfo snapshotInfo = (SnapshotInfo)object;
            Option<String> option = this.i18NCategoryOpt();
            Option<String> option2 = snapshotInfo.i18NCategoryOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, List<String>> map = this.pageI18Map();
            Map<String, List<String>> map2 = snapshotInfo.pageI18Map();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            List<PagePrivilege> list = this.pagePrivileges();
            List<PagePrivilege> list2 = snapshotInfo.pagePrivileges();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SnapshotInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SnapshotInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "i18NCategoryOpt";
                }
                case 1: {
                    return "pageI18Map";
                }
                case 2: {
                    return "pagePrivileges";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<String> i18NCategoryOpt() {
            return this.i18NCategoryOpt;
        }

        public Map<String, List<String>> pageI18Map() {
            return this.pageI18Map;
        }

        public List<PagePrivilege> pagePrivileges() {
            return this.pagePrivileges;
        }

        public SnapshotInfo copy(Option<String> i18NCategoryOpt, Map<String, List<String>> pageI18Map, List<PagePrivilege> pagePrivileges) {
            return new SnapshotInfo(i18NCategoryOpt, pageI18Map, pagePrivileges);
        }

        public Option<String> copy$default$1() {
            return this.i18NCategoryOpt();
        }

        public Map<String, List<String>> copy$default$2() {
            return this.pageI18Map();
        }

        public List<PagePrivilege> copy$default$3() {
            return this.pagePrivileges();
        }

        public Option<String> _1() {
            return this.i18NCategoryOpt();
        }

        public Map<String, List<String>> _2() {
            return this.pageI18Map();
        }

        public List<PagePrivilege> _3() {
            return this.pagePrivileges();
        }
    }
}

