/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.cms.Lenses$;
import ambience.cms.SiteId;
import ambience.cms.SiteId$;
import ambience.cms.SnapshotId;
import ambience.cms.SnapshotId$;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.SitesManager$Site$;
import ambience.cms.management.SitesManager$SnapshotInfo$;
import ambience.cms.management.Util$;
import ambience.framework.AuditedUUIDDocumentManager2;
import ambience.framework.DocumentManager2$;
import ambience.framework.ErrorExplanation$;
import ambience.framework.URAugment2$;
import ambience.framework.URFilter2$;
import ambience.framework.UUIDDocumentManager2$;
import ambience.framework.UserRoleInfo2;
import ambience.framework.UserRoleInfo2$;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.UpdateResult;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonBoolean;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SitesManager
extends AuditedUUIDDocumentManager2
implements LoggingHelper2 {
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("baseDir$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("pc$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("extension$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("uniqueKey$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("snapshotsCltn$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SitesManager.class.getDeclaredField("cltn$lzy1"));
    private volatile Object log$lzy1;
    private final CMSManagementModule module;
    private final Scheduler exeCxt;
    private volatile Object cltn$lzy1;
    private volatile Object snapshotsCltn$lzy1;
    private volatile Object uniqueKey$lzy1;
    private volatile Object extension$lzy1;
    private final AuditAPI.AuditAppender auditAppender;
    private final AuditAPI.Component auditComponent;
    private volatile Object pc$lzy1;
    private volatile Object baseDir$lzy1;
    private final Function1 UnAugmenter;

    public SitesManager(CMSManagementModule module) {
        this.module = module;
        this.exeCxt = Scheduler$.MODULE$.global();
        this.auditAppender = module.auditAppender();
        this.auditComponent = module.AuditComponent();
        List list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Remove[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("snapshotName")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("ownerName")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("access.roleNames"))}));
        this.UnAugmenter = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list, json);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.module.mongoDB().database().getCollection("CMSSites", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection snapshotsCltn() {
        Object object = this.snapshotsCltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.snapshotsCltn$lzyINIT1();
    }

    private Object snapshotsCltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.snapshotsCltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.module.mongoDB().database().getCollection("CMSSnapshots", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.snapshotsCltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String uniqueKey() {
        Object object = this.uniqueKey$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.uniqueKey$lzyINIT1();
    }

    private Object uniqueKey$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uniqueKey$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "name";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uniqueKey$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String extension() {
        Object object = this.extension$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.extension$lzyINIT1();
    }

    private Object extension$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.extension$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ".cms-site.json";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.extension$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public ProjectConfig pc() {
        Object object = this.pc$lzy1;
        if (object instanceof ProjectConfig) {
            return (ProjectConfig)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ProjectConfig)this.pc$lzyINIT1();
    }

    private Object pc$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pc$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ProjectConfig projectConfig = null;
                    try {
                        projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
                        object2 = projectConfig == null ? LazyVals.NullValue$.MODULE$ : projectConfig;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pc$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return projectConfig;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Path baseDir() {
        Object object = this.baseDir$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.baseDir$lzyINIT1();
    }

    private Object baseDir$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.baseDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = Paths.get(this.pc().WebRootDir().toPath().toString(), "cms");
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.baseDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<Json, Json> UnAugmenter() {
        return this.UnAugmenter;
    }

    public Task<Option<Json>> getById(UserDB.User user, String id, boolean ignoreUniqueKey) {
        Bson idFilter = Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> {
            Bson fs = ignoreUniqueKey ? Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, idFilter})) : Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, DocumentManager2$.MODULE$.exists(this.uniqueKey()), idFilter}));
            return this.cltn().findOneO(fs).firstOptionL().map((Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)doc -> package$.MODULE$.parse(doc.toJson()).toOption()));
        });
    }

    public boolean getById$default$3() {
        return false;
    }

    public Task<Option<Json>> getById(String id) {
        Bson idFilter = Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
        Bson fs = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists(this.uniqueKey()), idFilter}));
        return this.cltn().findOneO(fs).firstOptionL().map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)doc -> package$.MODULE$.parse(doc.toJson()).toOption()));
    }

    public Task<Map<String, Site>> getIdSiteMap(boolean publishedOnly) {
        None$ pubOpt = publishedOnly ? Some$.MODULE$.apply((Object)Filters$.MODULE$.eq("published", (Object)BsonBoolean$.MODULE$.apply(true))) : None$.MODULE$;
        List fs = (List)((IterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("enabled", (Object)BsonBoolean$.MODULE$.apply(true)), DocumentManager2$.MODULE$.exists(this.uniqueKey())}))).$plus$plus((IterableOnce)pubOpt.toList());
        return this.cltn().findO(Filters$.MODULE$.and((Seq)fs)).toListL().map((Function1 & Serializable)docs -> docs.flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)id -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)name -> doc.get("urlPrefix", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)mapping -> doc.get("public", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).flatMap((Function1 & Serializable)bsonBoolean -> doc.get("snapshotId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)snapshotId -> {
            SiteId siteId = (SiteId)Predef$.MODULE$.ArrowAssoc((Object)new SiteId(SiteId$.MODULE$.apply(id.getValue())));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)siteId, (Object)SitesManager$Site$.MODULE$.apply(id.getValue(), name.getValue(), mapping.getValue(), bsonBoolean.getValue(), snapshotId.getValue(), this.getRoles((Document)doc), SitesManager$Site$.MODULE$.$lessinit$greater$default$7()));
        })))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)res -> res);
    }

    public boolean getIdSiteMap$default$1() {
        return true;
    }

    public List<String> getRoles(Document doc) {
        return (List)BsonUtils$.MODULE$.get(doc, "access.roles").map((Function1 & Serializable)v -> {
            if (v.isArray()) {
                return CollectionConverters$.MODULE$.ListHasAsScala(v.asArray().getValues()).asScala().toList().map((Function1 & Serializable)bv -> BsonUtils$.MODULE$.asString(bv));
            }
            return scala.package$.MODULE$.Nil();
        }).getOrElse(SitesManager::getRoles$$anonfun$2);
    }

    public Task<Json> get(UserDB.User user) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> UserRoleInfo2$.MODULE$.load().flatMap((Function1 & Serializable)info -> this.loadSnapshots().flatMap((Function1 & Serializable)ssMap -> this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, DocumentManager2$.MODULE$.exists(this.uniqueKey())})), FindOptions$.MODULE$.sorts(Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})))).toListL().map((Function1 & Serializable)reply -> {
            Either either = package$.MODULE$.parse(reply.map((Function1 & Serializable)_$3 -> this.aug$1((Map)ssMap, (UserRoleInfo2.Info)info, (Document)_$3).toJson()).mkString("[", ",\n", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> SitesManager.get$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(143), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.get"));
                return Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        }).map((Function1 & Serializable)res -> res))));
    }

    public Document augment(Map<String, SnapshotInfo> snapshots, Document doc) {
        SnapshotInfo snapshot = (SnapshotInfo)doc.get("snapshotId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)t -> snapshots.get((Object)t.getValue())).getOrElse(SitesManager::$anonfun$2);
        return (Document)doc.updated("snapshotName", (Object)BsonString$.MODULE$.apply(snapshot.name()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
    }

    public Task<Map<String, SnapshotInfo>> loadSnapshots() {
        return this.module.snapshotsManager().get().map((Function1 & Serializable)_$4 -> (Map)_$4.asArray().map((Function1 & Serializable)arr -> arr.toList().flatMap((Function1 & Serializable)j -> j.hcursor().downField("_id").focus().flatMap((Function1 & Serializable)_$5 -> _$5.asString()).flatMap((Function1 & Serializable)id -> j.hcursor().downField("name").focus().flatMap((Function1 & Serializable)_$6 -> _$6.asString()).map((Function1 & Serializable)name -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(id);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)SitesManager$SnapshotInfo$.MODULE$.apply((String)id, (String)name));
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse(SitesManager::loadSnapshots$$anonfun$1$$anonfun$2));
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        return super.save(user, (Json)this.UnAugmenter().apply((Object)json));
    }

    public Task<Either<LogMessage, Json>> save(Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)msg));
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonString id = (BsonString)((Some)option).value();
                return this.update(id, key, doc).map((Function1 & Serializable)x$1 -> {
                    LogMessage logMessage = x$1;
                    if (LogMessage.None$.MODULE$.equals(logMessage)) {
                        return scala.package$.MODULE$.Right().apply((Object)json);
                    }
                    LogMessage m = logMessage;
                    return scala.package$.MODULE$.Left().apply((Object)m);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Save failed id not found")));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Task<LogMessage> update(BsonString id, BsonValue key, Document doc) {
        Task ret = this.logInfo(() -> SitesManager.$anonfun$4(key)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn().replaceOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{UUIDDocumentManager2$.MODULE$.withId(id), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), doc).map((Function1 & Serializable)x$1 -> {
                UpdateResult updateResult = x$1;
                return LogMessage.None$.MODULE$;
            });
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Update failed", BsonUtils$.MODULE$.asString(key), ex));
    }

    public Task<LogMessage> delete(UserDB.User user, String uuid) {
        return this.renameSiteDeployDirectory(user, SiteId$.MODULE$.apply(uuid), true).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return super.delete(user, uuid).flatMap((Function1 & Serializable)res -> this.cleanDeletedDeployDirectories().map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return res;
            }));
        });
    }

    public Task<LogMessage> undelete(UserDB.User user, String uuid) {
        return super.undelete(user, uuid).flatMap((Function1 & Serializable)res -> this.renameSiteDeployDirectory(user, SiteId$.MODULE$.apply(uuid), false).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return res;
        }));
    }

    public Task<BoxedUnit> renameSiteDeployDirectory(UserDB.User user, String siteId, boolean isDelete) {
        return ((Task)OptionT$.MODULE$.apply(this.module.sitesManager().getById(user, siteId, true)).flatMap((Function1 & Serializable)site -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.Name().getOption(site))).flatMap((Function1 & Serializable)name -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SnapshotId().getOption(site).map((Function1 & Serializable)value -> new SnapshotId(SnapshotId$.MODULE$.apply(value))))).flatMap((Function1 & Serializable)siteSnapshotId -> this.renameSiteDeployDirectory$$anonfun$1$$anonfun$1$$anonfun$2(user, (String)name, siteSnapshotId == null ? null : ((SnapshotId)siteSnapshotId).value()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String name = (String)tuple2._1();
                String snId = tuple2._2() == null ? null : ((SnapshotId)tuple2._2()).value();
                Tuple2 tuple22 = isDelete ? Tuple2$.MODULE$.apply((Object)"", (Object)"_deleted") : Tuple2$.MODULE$.apply((Object)"_deleted", (Object)"");
                String fromPostfix = (String)tuple22._1();
                String toPostfix = (String)tuple22._2();
                File from = this.baseDir().resolve(name + "-snapshot-" + snId + fromPostfix).toFile();
                File to = this.baseDir().resolve(name + "-snapshot-" + snId + toPostfix).toFile();
                this.log().info(() -> SitesManager.renameSiteDeployDirectory$$anonfun$2$$anonfun$1(from, to), Line$.MODULE$.apply(233), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.renameSiteDeployDirectory"));
                Try try_ = Try$.MODULE$.apply(() -> SitesManager.renameSiteDeployDirectory$$anonfun$2$$anonfun$2(from, to));
                if (try_ instanceof Success) {
                    boolean ok = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
                    if (!ok) {
                        this.log().warn(SitesManager::renameSiteDeployDirectory$$anonfun$2$$anonfun$3, Line$.MODULE$.apply(235), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.renameSiteDeployDirectory"));
                        return;
                    }
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    this.log().error(() -> SitesManager.renameSiteDeployDirectory$$anonfun$2$$anonfun$4(ex), Line$.MODULE$.apply(236), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.renameSiteDeployDirectory"));
                    return;
                }
                throw new MatchError((Object)try_);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().error(() -> SitesManager.renameSiteDeployDirectory$$anonfun$2$$anonfun$5(siteId), Line$.MODULE$.apply(238), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.renameSiteDeployDirectory"));
                return;
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<BoxedUnit> cleanDeletedDeployDirectories() {
        Instant expire = Instant.now().minus(5L, ChronoUnit.MINUTES);
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.baseDir().toFile().listFiles(f -> f.isDirectory() && f.getName().endsWith("_deleted")));
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> this.getFileCreationEpoch((File)f).foreach((Function1)(JProcedure1 & Serializable)c -> {
            if (c.isBefore(expire)) {
                this.log().info(() -> SitesManager.cleanDeletedDeployDirectories$$anonfun$2$$anonfun$1$$anonfun$1(f), Line$.MODULE$.apply(247), FullName$.MODULE$.apply("ambience.cms.management.SitesManager.cleanDeletedDeployDirectories"));
                Util$.MODULE$.deleteDir((File)f);
                return;
            }
        }));
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public Try<Instant> getFileCreationEpoch(File file) {
        return Try$.MODULE$.apply(() -> SitesManager.getFileCreationEpoch$$anonfun$1(file));
    }

    private static final List getRoles$$anonfun$2() {
        return scala.package$.MODULE$.Nil();
    }

    private final Document aug$1(Map ssMap$1, UserRoleInfo2.Info info$1, Document doc) {
        return this.augment((Map<String, SnapshotInfo>)ssMap$1, URAugment2$.MODULE$.apply(info$1, doc));
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final SnapshotInfo $anonfun$2() {
        return SitesManager$SnapshotInfo$.MODULE$.apply(SitesManager$SnapshotInfo$.MODULE$.$lessinit$greater$default$1(), SitesManager$SnapshotInfo$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Map loadSnapshots$$anonfun$1$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final String $anonfun$4(BsonValue key$1) {
        return "updating " + key$1;
    }

    private final /* synthetic */ OptionT renameSiteDeployDirectory$$anonfun$1$$anonfun$1$$anonfun$2(UserDB.User user$5, String name$4, String siteSnapshotId) {
        return OptionT$.MODULE$.apply(this.module.snapshotsManager().getById(user$5, SnapshotId$.MODULE$.apply(siteSnapshotId))).flatMap((Function1 & Serializable)snapshot -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.SnapshotId().getOption(snapshot).map((Function1 & Serializable)value -> new SnapshotId(SnapshotId$.MODULE$.apply(value))))).map((Function1 & Serializable)snapshotId -> Tuple2$.MODULE$.apply((Object)name$4, (Object)new SnapshotId(snapshotId == null ? null : ((SnapshotId)snapshotId).value())), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
    }

    private static final Object renameSiteDeployDirectory$$anonfun$2$$anonfun$1(File from$1, File to$1) {
        return "rename site directory from " + from$1 + " to " + to$1;
    }

    private static final boolean renameSiteDeployDirectory$$anonfun$2$$anonfun$2(File from$2, File to$2) {
        return from$2.renameTo(to$2);
    }

    private static final Object renameSiteDeployDirectory$$anonfun$2$$anonfun$3() {
        return "Rename failed";
    }

    private static final Object renameSiteDeployDirectory$$anonfun$2$$anonfun$4(Throwable ex$1) {
        return "Rename failed: " + ex$1;
    }

    private static final Object renameSiteDeployDirectory$$anonfun$2$$anonfun$5(String siteId$2) {
        return "snapshotId not found for site " + siteId$2;
    }

    private static final Object cleanDeletedDeployDirectories$$anonfun$2$$anonfun$1$$anonfun$1(File f$2) {
        return "clean deleted directory " + f$2;
    }

    private static final Instant getFileCreationEpoch$$anonfun$1(File file$1) {
        BasicFileAttributes attr = Files.readAttributes(file$1.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        return attr.creationTime().toInstant();
    }

    public static final class Site
    implements Product,
    Serializable {
        private final String id;
        private final String name;
        private final String urlPrefix;
        private final boolean isPublic;
        private final String snapshotId;
        private final List roles;
        private final String fileSystemPath;

        public static Site apply(String string, String string2, String string3, boolean bl, String string4, List<String> list, String string5) {
            return SitesManager$Site$.MODULE$.apply(string, string2, string3, bl, string4, list, string5);
        }

        public static Site fromProduct(Product product) {
            return SitesManager$Site$.MODULE$.fromProduct(product);
        }

        public static Site unapply(Site site) {
            return SitesManager$Site$.MODULE$.unapply(site);
        }

        public static String $lessinit$greater$default$7() {
            return SitesManager$Site$.MODULE$.$lessinit$greater$default$7();
        }

        public Site(String id, String name, String urlPrefix, boolean isPublic, String snapshotId, List<String> roles, String fileSystemPath) {
            this.id = id;
            this.name = name;
            this.urlPrefix = urlPrefix;
            this.isPublic = isPublic;
            this.snapshotId = snapshotId;
            this.roles = roles;
            this.fileSystemPath = fileSystemPath;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.urlPrefix()));
            n = Statics.mix((int)n, (int)(this.isPublic() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.snapshotId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.roles()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.fileSystemPath()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Site)) return false;
            Site site = (Site)object;
            if (this.isPublic() != site.isPublic()) return false;
            String string = this.id();
            String string2 = site.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = site.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.urlPrefix();
            String string6 = site.urlPrefix();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.snapshotId();
            String string8 = site.snapshotId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            List<String> list = this.roles();
            List<String> list2 = site.roles();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string9 = this.fileSystemPath();
            String string10 = site.fileSystemPath();
            if (string9 == null) {
                if (string10 == null) return true;
                return false;
            } else {
                if (!string9.equals(string10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Site;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Site";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "urlPrefix";
                }
                case 3: {
                    return "isPublic";
                }
                case 4: {
                    return "snapshotId";
                }
                case 5: {
                    return "roles";
                }
                case 6: {
                    return "fileSystemPath";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public String urlPrefix() {
            return this.urlPrefix;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public String snapshotId() {
            return this.snapshotId;
        }

        public List<String> roles() {
            return this.roles;
        }

        public String fileSystemPath() {
            return this.fileSystemPath;
        }

        public Site copy(String id, String name, String urlPrefix, boolean isPublic, String snapshotId, List<String> roles, String fileSystemPath) {
            return new Site(id, name, urlPrefix, isPublic, snapshotId, roles, fileSystemPath);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.urlPrefix();
        }

        public boolean copy$default$4() {
            return this.isPublic();
        }

        public String copy$default$5() {
            return this.snapshotId();
        }

        public List<String> copy$default$6() {
            return this.roles();
        }

        public String copy$default$7() {
            return this.fileSystemPath();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }

        public String _3() {
            return this.urlPrefix();
        }

        public boolean _4() {
            return this.isPublic();
        }

        public String _5() {
            return this.snapshotId();
        }

        public List<String> _6() {
            return this.roles();
        }

        public String _7() {
            return this.fileSystemPath();
        }
    }

    public static final class SnapshotInfo
    implements Product,
    Serializable {
        private final String id;
        private final String name;

        public static SnapshotInfo apply(String string, String string2) {
            return SitesManager$SnapshotInfo$.MODULE$.apply(string, string2);
        }

        public static SnapshotInfo fromProduct(Product product) {
            return SitesManager$SnapshotInfo$.MODULE$.fromProduct(product);
        }

        public static SnapshotInfo unapply(SnapshotInfo snapshotInfo) {
            return SitesManager$SnapshotInfo$.MODULE$.unapply(snapshotInfo);
        }

        public static String $lessinit$greater$default$1() {
            return SitesManager$SnapshotInfo$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return SitesManager$SnapshotInfo$.MODULE$.$lessinit$greater$default$2();
        }

        public SnapshotInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SnapshotInfo)) return false;
            SnapshotInfo snapshotInfo = (SnapshotInfo)object;
            String string = this.id();
            String string2 = snapshotInfo.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = snapshotInfo.name();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SnapshotInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SnapshotInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            if (1 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public SnapshotInfo copy(String id, String name) {
            return new SnapshotInfo(id, name);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }
    }
}

