/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.import;

import ambience.cms.Lenses$;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.import.ImportStructure;
import ambience.cms.management.import.NewIdManager;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import com.elixirtech.arch.LogMessage;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface StructureSaver {
    public static Task save$(StructureSaver $this, UserDB.User user, ImportStructure structure) {
        return $this.save(user, structure);
    }

    default public Task<Either<LogMessage, BoxedUnit>> save(UserDB.User user, ImportStructure structure) {
        return (Task)EitherT$.MODULE$.apply(this.saveInfo("Saving group")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.addGroup(user, structure.group())).flatMap((Function1 & Serializable)x$1 -> {
                Document document = x$1;
                return EitherT$.MODULE$.apply(this.saveInfo("Saving (" + structure.pages().size() + ") pages")).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.addPages(user, structure.pages())).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return EitherT$.MODULE$.apply(this.saveInfo("Saving (" + structure.templates().size() + ") templates")).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return EitherT$.MODULE$.apply(this.addTemplates(user, structure.templates())).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return EitherT$.MODULE$.apply(this.saveInfo("Saving (" + structure.resources().size() + ") resources")).flatMap((Function1 & Serializable)x$12 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return EitherT$.MODULE$.apply(this.addResources(user, structure.resources())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }, (Functor)Task$.MODULE$.catsAsync());
                                }, (Monad)Task$.MODULE$.catsAsync());
                            }, (Monad)Task$.MODULE$.catsAsync());
                        }, (Monad)Task$.MODULE$.catsAsync());
                    }, (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public static Task saveInfo$(StructureSaver $this, String msg) {
        return $this.saveInfo(msg);
    }

    default public Task<Either<LogMessage, BoxedUnit>> saveInfo(String msg) {
        return Task$.MODULE$.apply(() -> this.saveInfo$$anonfun$1(msg));
    }

    public static Task addGroup$(StructureSaver $this, UserDB.User user, Json group) {
        return $this.addGroup(user, group);
    }

    default public Task<Either<LogMessage, Document>> addGroup(UserDB.User user, Json group) {
        return (Task)EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.Name().getOption((Object)group).toRight(StructureSaver::addGroup$$anonfun$1))).flatMap((Function1 & Serializable)name -> EitherT$.MODULE$.apply(((CMSManagementModule)this).groupsManager().addWithUUID(user, (BsonValue)BsonString$.MODULE$.apply(name), Document$.MODULE$.apply(group.noSpaces()))).map((Function1 & Serializable)doc -> doc, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public static Task addPages$(StructureSaver $this, UserDB.User user, Vector pages) {
        return $this.addPages(user, (Vector<Json>)pages);
    }

    default public Task<Either<LogMessage, BoxedUnit>> addPages(UserDB.User user, Vector<Json> pages) {
        return Task$.MODULE$.sequence((Iterable)((IterableOnceOps)pages.map((Function1 & Serializable)p -> this.add$1(user, (Json)p))).toList(), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)res -> {
            Tuple2 tuple2 = res.partition((Function1 & Serializable)_$1 -> _$1.isLeft());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List l = (List)tuple2._1();
            List l2 = l;
            if (l2.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(l2.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Either x) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Either x, Function1 function1) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return log;
                        }
                        return function1.apply((Object)x);
                    }
                })));
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
    }

    public static Task addTemplates$(StructureSaver $this, UserDB.User user, Vector templates) {
        return $this.addTemplates(user, (Vector<Json>)templates);
    }

    default public Task<Either<LogMessage, BoxedUnit>> addTemplates(UserDB.User user, Vector<Json> templates) {
        return Task$.MODULE$.sequence((Iterable)((IterableOnceOps)templates.map((Function1 & Serializable)p -> this.add$2(user, (Json)p))).toList(), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)res -> {
            Tuple2 tuple2 = res.partition((Function1 & Serializable)_$2 -> _$2.isLeft());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List l = (List)tuple2._1();
            List l2 = l;
            if (l2.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(l2.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Either x) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Either x, Function1 function1) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return log;
                        }
                        return function1.apply((Object)x);
                    }
                })));
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
    }

    public static Task addResources$(StructureSaver $this, UserDB.User user, Vector resources) {
        return $this.addResources(user, (Vector<Json>)resources);
    }

    default public Task<Either<LogMessage, BoxedUnit>> addResources(UserDB.User user, Vector<Json> resources) {
        return Task$.MODULE$.sequence((Iterable)((IterableOnceOps)resources.map((Function1 & Serializable)resource -> this.add$3(user, (Json)resource))).toList(), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)res -> {
            Tuple2 tuple2 = res.partition((Function1 & Serializable)_$3 -> _$3.isLeft());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List l = (List)tuple2._1();
            List l2 = l;
            if (l2.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(l2.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Either x) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Either x, Function1 function1) {
                        Either either = x;
                        if (either instanceof Left) {
                            LogMessage log = (LogMessage)((Left)either).value();
                            return log;
                        }
                        return function1.apply((Object)x);
                    }
                })));
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
    }

    public static Task revertImport$(StructureSaver $this, UserDB.User user, NewIdManager idManager) {
        return $this.revertImport(user, idManager);
    }

    default public Task<Either<LogMessage, BoxedUnit>> revertImport(UserDB.User user, NewIdManager idManager) {
        return (Task)EitherT$.MODULE$.apply(((CMSManagementModule)this).resourcesManager().deleteAll(user, idManager.resourcesIds())).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(((CMSManagementModule)this).templatesManager().deleteAll(user, idManager.templateIds())).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(((CMSManagementModule)this).pagesManager().deleteAll(user, idManager.pageIds())).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(((CMSManagementModule)this).groupsManager().deleteAll(user, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)idManager.group()._2()}))))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    private static Object saveInfo$$anonfun$1$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private Right saveInfo$$anonfun$1(String msg$1) {
        Right$ right$ = package$.MODULE$.Right();
        ((CMSManagementModule)this).log().info(() -> StructureSaver.saveInfo$$anonfun$1$$anonfun$1(msg$1), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.cms.management.import.StructureSaver.saveInfo"));
        return right$.apply((Object)BoxedUnit.UNIT);
    }

    private static LogMessage.Error addGroup$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Group 'name' field not found");
    }

    private static LogMessage.Error add$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Page 'uniqueKey' field not found");
    }

    private Task add$1(UserDB.User user$9, Json p) {
        return (Task)EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.UniqueKey().getOption((Object)p).toRight(StructureSaver::add$1$$anonfun$1))).flatMap((Function1 & Serializable)uniqueKey -> EitherT$.MODULE$.apply(((CMSManagementModule)this).pagesManager().addWithUUID(user$9, (BsonValue)BsonString$.MODULE$.apply(uniqueKey), Document$.MODULE$.apply(p.noSpaces()))).map((Function1 & Serializable)doc -> doc, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    private static LogMessage.Error add$2$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Template 'uniqueKey' not found");
    }

    private Task add$2(UserDB.User user$11, Json p) {
        return (Task)EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.UniqueKey().getOption((Object)p).toRight(StructureSaver::add$2$$anonfun$1))).flatMap((Function1 & Serializable)uniqueKey -> EitherT$.MODULE$.apply(((CMSManagementModule)this).templatesManager().addWithUUID(user$11, (BsonValue)BsonString$.MODULE$.apply(uniqueKey), Document$.MODULE$.apply(p.noSpaces()))).map((Function1 & Serializable)doc -> doc, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    private static LogMessage.Error add$3$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Resource 'storeCategoryName' field not found");
    }

    private Task add$3(UserDB.User user$13, Json resource) {
        return (Task)EitherT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.StoreCategoryName().getOption((Object)resource).toRight(StructureSaver::add$3$$anonfun$1))).flatMap((Function1 & Serializable)uniqueKey -> EitherT$.MODULE$.apply(((CMSManagementModule)this).resourcesManager().addWithUUID(user$13, (BsonValue)BsonString$.MODULE$.apply(uniqueKey), Document$.MODULE$.apply(resource.noSpaces()))).map((Function1 & Serializable)doc -> doc, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }
}

