/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.resources;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.cms.Lenses$;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.implicits$;
import cats.syntax.OptionIdOps$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BinaryStoreHelper$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreHelper$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final BinaryStoreHelper$ MODULE$ = new BinaryStoreHelper$();

    private BinaryStoreHelper$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BinaryStoreHelper$.class);
    }

    public Task<GravityResponse> getContentAsGravityResponse(String store, String contentId, boolean isInline) {
        return this.getContent(store, contentId).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                String filename = (String)Lenses$.MODULE$.Name().getOption((Object)content.metadata()).getOrElse(this::$anonfun$1);
                Gravity.Header contentType = Gravity.Header$.MODULE$.ContentType((String)Lenses$.MODULE$.MimeType().getOption((Object)content.metadata()).getOrElse(this::$anonfun$2));
                Gravity.Header contentDisposition = isInline ? GravityResponse.ContentDisposition$.MODULE$.inline(filename) : GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType, contentDisposition}));
                return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), headers, content.bytes());
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<String>> updateContent(String store, String contentId, byte[] bytes) {
        return (Task)OptionT$.MODULE$.apply(this.getContent(store, contentId)).flatMap((Function1 & Serializable)old -> OptionT$.MODULE$.apply((Object)((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(store)).flatMap((Function1 & Serializable)location -> OptionT$.MODULE$.apply(this.save((BinaryStore.Location)location, old.metadata(), bytes)).flatMap((Function1 & Serializable)newId -> OptionT$.MODULE$.apply((Object)this.delete((BinaryStore.Location)location, contentId).map((Function1 & Serializable)_$1 -> _$1.toOption())).map((Function1 & Serializable)x$1 -> new BinaryStore.ContentId(this.updateContent$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2((String)newId, (BoxedUnit)x$1)), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Option<BinaryStore.Content>> getContent(String store, String contentId) {
        return BinaryStore$.MODULE$.get(BinaryStore.Id$.MODULE$.apply(store, contentId)).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                return Some$.MODULE$.apply((Object)content);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> this.getContent$$anonfun$1$$anonfun$1(store, contentId), Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.cms.management.resources.BinaryStoreHelper.getContent"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<byte[]>> getBytes(String store, String contentId) {
        return this.getContent(store, contentId).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                BinaryStore.Content value = (BinaryStore.Content)((Some)option).value();
                return value.bytes().observable().foldLeftL(this::getBytes$$anonfun$1$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        byte[] a1 = (byte[])tuple2._1();
                        byte[] a2 = (byte[])tuple2._2();
                        return (byte[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{a1, a2}), ClassTag$.MODULE$.apply(Byte.TYPE));
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)_$2 -> Some$.MODULE$.apply(_$2));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.apply(this::getBytes$$anonfun$1$$anonfun$4);
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<Json>> getMetadata(String store, String contentId) {
        return this.getContent(store, contentId).map((Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)_$4 -> _$4.metadata()));
    }

    public Task<Option<String>> doStoreUpload(UserDB.User user, String store, Json metadata, byte[] bytes) {
        OptionT task = OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$3(user, store, metadata))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return OptionT$.MODULE$.apply((Object)((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(BinaryStore.LocationId$.MODULE$.apply(store))).flatMap((Function1 & Serializable)location -> OptionT$.MODULE$.apply(this.save((BinaryStore.Location)location, metadata, bytes)).flatMap((Function1 & Serializable)uuid -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(store, uuid))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return uuid;
            }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync());
        return (Task)task.value();
    }

    public Task<Option<String>> save(BinaryStore.Location location, Json metadata, byte[] bytes) {
        return location.add(BinaryStore.Content$.MODULE$.apply((DataBytes)FullDataBytes$.MODULE$.apply(bytes), metadata)).map((Function1 & Serializable)_$5 -> this.save$$anonfun$1(_$5 == null ? null : ((BinaryStore.ContentId)_$5).value())).onErrorRecover((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                BinaryStoreHelper$.MODULE$.log().error(() -> BinaryStoreHelper$.ambience$cms$management$resources$BinaryStoreHelper$$anon$1$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.cms.management.resources.BinaryStoreHelper.save"));
                return None$.MODULE$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$cms$management$resources$BinaryStoreHelper$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public Task<Either<String, BoxedUnit>> delete(BinaryStore.Location location, String contentId) {
        return location.remove(contentId).as((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).onErrorRecover((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)("delete resource failed: " + ex));
            }
        });
    }

    private final String $anonfun$1() {
        return "content.data";
    }

    private final String $anonfun$2() {
        return "application/octet-stream";
    }

    private final /* synthetic */ String updateContent$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(String newId$1, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return BinaryStore.ContentId$.MODULE$.apply(newId$1);
    }

    private final Object getContent$$anonfun$1$$anonfun$1(String store$3, String contentId$5) {
        return "No content found in binary store=" + store$3 + " for contentId " + contentId$5;
    }

    private final byte[] getBytes$$anonfun$1$$anonfun$1() {
        return Array$.MODULE$.emptyByteArray();
    }

    private final None$ getBytes$$anonfun$1$$anonfun$4() {
        return None$.MODULE$;
    }

    private final Object $anonfun$3$$anonfun$1(UserDB.User user$2, String store$5, Json metadata$2) {
        return "Storing Resource user=" + user$2.name() + " store=" + store$5 + " metadata=" + metadata$2;
    }

    private final Option $anonfun$3(UserDB.User user$1, String store$4, Json metadata$1) {
        this.log().info(() -> this.$anonfun$3$$anonfun$1(user$1, store$4, metadata$1), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.cms.management.resources.BinaryStoreHelper.task"));
        return Option$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }

    private final Object $anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String store$10, String uuid$2) {
        return "New Resource Added store=" + store$10 + " uuid=" + uuid$2;
    }

    private final Option $anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(String store$9, String uuid$1) {
        this.log().info(() -> this.$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(store$9, uuid$1), Line$.MODULE$.apply(70), FullName$.MODULE$.apply("ambience.cms.management.resources.BinaryStoreHelper.task"));
        return Option$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ Option save$$anonfun$1(String _$5) {
        String string = (String)implicits$.MODULE$.catsSyntaxOptionId((Object)_$5);
        return OptionIdOps$.MODULE$.some$extension((Object)string);
    }

    public static final Object ambience$cms$management$resources$BinaryStoreHelper$$anon$1$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "Save bytes failed: " + ex$1;
    }
}

