/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.resources;

import ambience.api.BinaryStore;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.resources.BinaryStoreHelper$;
import ambience.cms.management.resources.ResourcesManager$StoreCategoryName$;
import ambience.framework.AuditedUUIDDocumentManager2;
import ambience.framework.DocumentManager2$;
import ambience.framework.ErrorExplanation$;
import ambience.framework.URAugment2$;
import ambience.framework.URFilter2$;
import ambience.framework.UUIDDocumentManager2$;
import ambience.framework.UserRoleInfo2;
import ambience.framework.UserRoleInfo2$;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ResourcesManager
extends AuditedUUIDDocumentManager2
implements LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ResourcesManager.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ResourcesManager.class.getDeclaredField("extension$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ResourcesManager.class.getDeclaredField("cltn$lzy1"));
    private volatile Object log$lzy1;
    private final CMSManagementModule module;
    private final Scheduler exeCxt;
    private volatile Object cltn$lzy1;
    private volatile Object extension$lzy1;
    private final AuditAPI.AuditAppender auditAppender;
    private final AuditAPI.Component auditComponent;
    private final Function1 UnAugmenter;
    private final Function1 UnAugmentContent;

    public ResourcesManager(CMSManagementModule module) {
        this.module = module;
        this.exeCxt = Scheduler$.MODULE$.global();
        this.auditAppender = module.auditAppender();
        this.auditComponent = module.AuditComponent();
        List list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Remove[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("ownerName")), JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("access.roleNames"))}));
        this.UnAugmenter = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list, json);
        List list2 = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonProcessor.Remove[]{JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("content"))}));
        this.UnAugmentContent = (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)list2, json);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public RichMongoCollection cltn() {
        Object object = this.cltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.cltn$lzyINIT1();
    }

    private Object cltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.module.mongoDB().database().getCollection("CMSResources", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String uniqueKey() {
        return "storeCategoryName";
    }

    public String extension() {
        Object object = this.extension$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.extension$lzyINIT1();
    }

    private Object extension$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.extension$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ".cms-resource.json";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.extension$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    public Function1<Json, Json> UnAugmenter() {
        return this.UnAugmenter;
    }

    public Function1<Json, Json> UnAugmentContent() {
        return this.UnAugmentContent;
    }

    public Task<Either<LogMessage, Document>> addWithUUID(UserDB.User user, BsonValue key, Document doc) {
        Task ret = this.logInfo(() -> ResourcesManager.$anonfun$1(key)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> this.$anonfun$2$$anonfun$1(doc, user)).flatMap((Function1 & Serializable)finalDoc -> this.cltn().insertOneT(finalDoc).map((Function1 & Serializable)x$1 -> {
                InsertOneResult insertOneResult = x$1;
                return scala.package$.MODULE$.Right().apply(finalDoc);
            }));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> scala.package$.MODULE$.Left().apply((Object)ErrorExplanation$.MODULE$.apply("Add failed", ex)));
    }

    public Task<Either<LogMessage, BoxedUnit>> deleteAll(UserDB.User user, Set<String> uuids) {
        Bson in = Filters$.MODULE$.in("_id", (Seq)uuids.toSeq().map((Function1 & Serializable)_$1 -> BsonString$.MODULE$.apply(_$1)));
        Task ret = this.logInfo(() -> ResourcesManager.$anonfun$4(uuids)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn().deleteManyT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{in, UUIDDocumentManager2$.MODULE$.owner(user)}))).map((Function1 & Serializable)x$1 -> {
                DeleteResult deleteResult = x$1;
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            });
        });
        return ret.onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("DeleteAll failed"));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> deleteByStoreCategoryName(UserDB.User user, String storeCategoryName) {
        Bson filter = Filters$.MODULE$.eq("storeCategoryName", (Object)BsonString$.MODULE$.apply(storeCategoryName));
        Task ret = this.logInfo(() -> ResourcesManager.$anonfun$6(storeCategoryName)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltn().deleteManyT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, UUIDDocumentManager2$.MODULE$.owner(user)}))).map((Function1 & Serializable)x$1 -> {
                DeleteResult deleteResult = x$1;
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            });
        });
        return ret.onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return scala.package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Delete failed", ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Task<List<StoreCategoryName>> getResourceStoreCategoryNames(UserDB.User user) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, DocumentManager2$.MODULE$.exists(this.uniqueKey())})), FindOptions$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"store", "category", "name"}))), (Option)Some$.MODULE$.apply((Object)Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()}))), FindOptions$.MODULE$.$lessinit$greater$default$3(), FindOptions$.MODULE$.$lessinit$greater$default$4())).toListL().map((Function1 & Serializable)_$2 -> (List)_$2.flatMap((Function1 & Serializable)doc -> doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).flatMap((Function1 & Serializable)s -> doc.get("category", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).flatMap((Function1 & Serializable)c -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).map((Function1 & Serializable)n -> ResourcesManager$StoreCategoryName$.MODULE$.apply((String)s, (String)c, (String)n))))).distinct()).map((Function1 & Serializable)res -> res));
    }

    public Task<Option<Json>> getById(UserDB.User user, String id) {
        Bson idFilter = Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(id));
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> this.cltn().findOneO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, DocumentManager2$.MODULE$.exists(this.uniqueKey()), idFilter}))).firstOptionL().map((Function1 & Serializable)_$6 -> _$6.flatMap((Function1 & Serializable)doc -> package$.MODULE$.parse(doc.toJson()).toOption())));
    }

    public Task<Json> get(UserDB.User user) {
        return UserRoleInfo2$.MODULE$.load().flatMap((Function1 & Serializable)info -> this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists(this.uniqueKey())})), FindOptions$.MODULE$.sorts(Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})))).toListL().map((Function1 & Serializable)reply -> {
            Either either = package$.MODULE$.parse(reply.map((Function1 & Serializable)_$7 -> ResourcesManager.aug$1(info, _$7).toJson()).mkString("[", ",\n", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> ResourcesManager.get$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(122), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourcesManager.get"));
                return Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        }).map((Function1 & Serializable)res -> res));
    }

    public Task<List<Json>> getByUniqueKeys(UserDB.User user, Set<String> keys) {
        Bson in = Filters$.MODULE$.in(this.uniqueKey(), (Seq)((IterableOnceOps)keys.map((Function1 & Serializable)_$8 -> BsonString$.MODULE$.apply(_$8))).toList());
        return this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager2$.MODULE$.exists(this.uniqueKey()), in}))).toListL().map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)_$9 -> _$9.toJson()).flatMap((Function1 & Serializable)j -> {
            Either either = package$.MODULE$.parse(j);
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                this.log().error(() -> ResourcesManager.getByUniqueKeys$$anonfun$1$$anonfun$2$$anonfun$1(err), Line$.MODULE$.apply(140), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourcesManager.getByUniqueKeys"));
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return Some$.MODULE$.apply((Object)json);
            }
            throw new MatchError((Object)either);
        })).map((Function1 & Serializable)res -> res);
    }

    public Task<Json> getByMimeType(UserDB.User user, String mimeType) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> {
            Bson mt = Filters$.MODULE$.eq("mimeType", (Object)BsonString$.MODULE$.apply(mimeType));
            Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
            Some some2 = Some$.MODULE$.apply((Object)Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"category-name", "category", "name"})));
            Option option = FindOptions$.MODULE$.$lessinit$greater$default$3();
            Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$4();
            FindOptions opts = FindOptions$.MODULE$.apply((Option)some2, (Option)some, option, option2);
            return this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, DocumentManager2$.MODULE$.exists(this.uniqueKey()), mt})), opts).toListL().map((Function1 & Serializable)reply -> {
                Either either = package$.MODULE$.parse(reply.map((Function1 & Serializable)_$10 -> _$10.toJson()).mkString("[", ",\n", "]"));
                if (either instanceof Left) {
                    ParsingFailure err = (ParsingFailure)((Left)either).value();
                    this.log().error(() -> ResourcesManager.getByMimeType$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(160), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourcesManager.getByMimeType"));
                    return Json$.MODULE$.fromValues((Iterable)scala.package$.MODULE$.Nil());
                }
                if (either instanceof Right) {
                    Json json = (Json)((Right)either).value();
                    return json;
                }
                throw new MatchError((Object)either);
            }).map((Function1 & Serializable)res -> res);
        });
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        return super.save(user, (Json)this.UnAugmenter().apply((Object)this.applyUniqueKey(json)));
    }

    public Task<LogMessage> update(UserDB.User user, BsonString id, BsonValue key, Document doc) {
        Tuple3 tuple3;
        Option option = doc.get("content", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$11 -> _$11.getValue()).flatMap((Function1 & Serializable)cnt -> doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$12 -> _$12.getValue()).flatMap((Function1 & Serializable)store -> doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$13 -> _$13.getValue()).map((Function1 & Serializable)contentId -> Tuple3$.MODULE$.apply(cnt, store, contentId))));
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            String cnt2 = (String)tuple3._1();
            String store = (String)tuple3._2();
            String contentId = (String)tuple3._3();
            return BinaryStoreHelper$.MODULE$.updateContent(BinaryStore.LocationId$.MODULE$.apply(store), BinaryStore.ContentId$.MODULE$.apply(contentId), cnt2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Object object = ((Some)option).value();
                    String cid = object == null ? null : ((BinaryStore.ContentId)object).value();
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentId");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(cid)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    Document updated = (Document)((BaseDocument)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"content"}));
                    return super.update(user, id, key, updated);
                }
                if (None$.MODULE$.equals(option)) {
                    return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Problem updating resource " + id));
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return super.update(user, id, key, doc);
        }
        throw new MatchError((Object)option);
    }

    private Json applyUniqueKey(Json json) {
        String store = (String)json.hcursor().downField("store").as(Decoder$.MODULE$.decodeString()).getOrElse(ResourcesManager::$anonfun$9);
        String category = (String)json.hcursor().downField("category").as(Decoder$.MODULE$.decodeString()).getOrElse(ResourcesManager::$anonfun$10);
        String name = (String)json.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).getOrElse(ResourcesManager::$anonfun$11);
        return json.mapObject((Function1 & Serializable)_$14 -> _$14.add(this.uniqueKey(), Json$.MODULE$.fromString(store + "_" + category + "_" + name)));
    }

    public Task<String> validateStoreCategoryName(UserDB.User user, Json json) {
        Tuple3 tuple3;
        Option vOpt = json.hcursor().downField("store").focus().flatMap((Function1 & Serializable)_$15 -> _$15.asString()).flatMap((Function1 & Serializable)store -> json.hcursor().downField("category").focus().flatMap((Function1 & Serializable)_$16 -> _$16.asString()).flatMap((Function1 & Serializable)category -> json.hcursor().downField("name").focus().flatMap((Function1 & Serializable)_$17 -> _$17.asString()).map((Function1 & Serializable)name -> Tuple3$.MODULE$.apply(store, category, name))));
        Option option = vOpt;
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            String store2 = (String)tuple3._1();
            String category = (String)tuple3._2();
            String name = (String)tuple3._3();
            return this.cltn().findOneO(this.where(store2, category, name)).headOptionL().map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Document doc = (Document)((Some)option).value();
                    String string = user.id();
                    Object object = doc.get("owner", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$18 -> _$18.getValue()).getOrElse(ResourcesManager::validateStoreCategoryName$$anonfun$1$$anonfun$2);
                    if (!(string != null ? !string.equals(object) : object != null)) {
                        return "Overwrite";
                    }
                    return "NotAvailable";
                }
                if (None$.MODULE$.equals(option)) {
                    return "Ok";
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(() -> ResourcesManager.validateStoreCategoryName$$anonfun$2(json), Line$.MODULE$.apply(214), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourcesManager.validateStoreCategoryName"));
            return Task$.MODULE$.now((Object)"Error");
        }
        throw new MatchError((Object)option);
    }

    public Task<List<String>> getCategoryList() {
        return Task$.MODULE$.fromFuture(org.mongodb.scala.package$.MODULE$.ObservableFuture(this::getCategoryList$$anonfun$1).toFuture()).map((Function1 & Serializable)_$19 -> ((IterableOnceOps)((SeqOps)_$19.filter((Function1 & Serializable)_$20 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$20)))).sorted((Ordering)Ordering.String$.MODULE$)).toList()).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                Predef$.MODULE$.println((Object)("failed:" + ex.getMessage()));
                return scala.package$.MODULE$.Nil();
            }
        });
    }

    public Bson where(String store, String category, String name) {
        return Filters$.MODULE$.eq("storeCategoryName", (Object)BsonString$.MODULE$.apply(store + "_" + category + "_" + name));
    }

    private static final String $anonfun$1(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private final Document $anonfun$2$$anonfun$1(Document doc$2, UserDB.User user$2) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(user$2.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock().now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return (Document)doc$2.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final String $anonfun$4(Set uuids$1) {
        return "deleting " + uuids$1;
    }

    private static final String $anonfun$6(String storeCategoryName$1) {
        return "deleting " + storeCategoryName$1;
    }

    private static final Document aug$1(UserRoleInfo2.Info info$1, Document doc) {
        return URAugment2$.MODULE$.apply(info$1, doc);
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object getByUniqueKeys$$anonfun$1$$anonfun$2$$anonfun$1(ParsingFailure err$2) {
        return "Error parsing BSON json output: " + err$2;
    }

    private static final Object getByMimeType$$anonfun$1$$anonfun$1$$anonfun$2(ParsingFailure err$3) {
        return "Error parsing BSON json output: " + err$3;
    }

    private static final String $anonfun$9() {
        return "";
    }

    private static final String $anonfun$10() {
        return "";
    }

    private static final String $anonfun$11() {
        return "";
    }

    private static final String validateStoreCategoryName$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final Object validateStoreCategoryName$$anonfun$2(Json json$3) {
        return "Json invalid validateCategoryAndName " + json$3;
    }

    private final Observable getCategoryList$$anonfun$1() {
        return this.cltn().cltn().distinct("category", ClassTag$.MODULE$.apply(String.class));
    }

    public static final class StoreCategoryName
    implements Product,
    Serializable {
        private final String store;
        private final String category;
        private final String name;

        public static StoreCategoryName apply(String string, String string2, String string3) {
            return ResourcesManager$StoreCategoryName$.MODULE$.apply(string, string2, string3);
        }

        public static StoreCategoryName fromProduct(Product product) {
            return ResourcesManager$StoreCategoryName$.MODULE$.fromProduct(product);
        }

        public static StoreCategoryName unapply(StoreCategoryName storeCategoryName) {
            return ResourcesManager$StoreCategoryName$.MODULE$.unapply(storeCategoryName);
        }

        public StoreCategoryName(String store, String category, String name) {
            this.store = store;
            this.category = category;
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreCategoryName)) return false;
            StoreCategoryName storeCategoryName = (StoreCategoryName)object;
            String string = this.store();
            String string2 = storeCategoryName.store();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.category();
            String string4 = storeCategoryName.category();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = storeCategoryName.name();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof StoreCategoryName;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StoreCategoryName";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "store";
                }
                case 1: {
                    return "category";
                }
                case 2: {
                    return "name";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String store() {
            return this.store;
        }

        public String category() {
            return this.category;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            if (this.category().trim().isEmpty()) {
                return this.store() + "__" + this.name();
            }
            return this.store() + "_" + this.category() + "_" + this.name();
        }

        public StoreCategoryName copy(String store, String category, String name) {
            return new StoreCategoryName(store, category, name);
        }

        public String copy$default$1() {
            return this.store();
        }

        public String copy$default$2() {
            return this.category();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String _1() {
            return this.store();
        }

        public String _2() {
            return this.category();
        }

        public String _3() {
            return this.name();
        }
    }
}

