/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.geo;

import ambience.etl.geo.GeoCategory;
import ambience.etl.geo.GeoCategory$LatLong$;
import ambience.etl.geo.GeoCategory$SVY21$;
import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;

public final class SVY21Converter$
implements Serializable {
    private static final double radRatio;
    private static final int a;
    private static final double oLat;
    private static final double oLon;
    private static final double No;
    private static final double Eo;
    private static final double k;
    private static final double b;
    private static final double e2;
    private static final double e4;
    private static final double e6;
    private static final double A0;
    private static final double A2;
    private static final double A4;
    private static final double A6;
    private static final double n;
    private static final double n2;
    private static final double n3;
    private static final double n4;
    private static final double G;
    public static final SVY21Converter$ MODULE$;

    private SVY21Converter$() {
    }

    static {
        MODULE$ = new SVY21Converter$();
        radRatio = Math.PI / 180;
        a = 6378137;
        double f = 0.0033528106647474805;
        oLat = 1.366666;
        oLon = 103.833333;
        No = 38744.572;
        Eo = 28001.642;
        k = 1.0;
        b = (double)a * (1.0 - f);
        e2 = (double)2 * f - f * f;
        e4 = MODULE$.e2() * MODULE$.e2();
        e6 = MODULE$.e4() * MODULE$.e2();
        A0 = 1.0 - MODULE$.e2() / (double)4 - (double)3 * MODULE$.e4() / (double)64 - (double)5 * MODULE$.e6() / (double)256;
        A2 = 0.375 * (MODULE$.e2() + MODULE$.e4() / (double)4 + (double)15 * MODULE$.e6() / (double)128);
        A4 = 0.05859375 * (MODULE$.e4() + (double)3 * MODULE$.e6() / (double)4);
        A6 = (double)35 * MODULE$.e6() / (double)3072;
        n = ((double)a - MODULE$.b()) / ((double)a + MODULE$.b());
        n2 = MODULE$.n() * MODULE$.n();
        n3 = MODULE$.n2() * MODULE$.n();
        n4 = MODULE$.n2() * MODULE$.n2();
        G = (double)a * (1.0 - MODULE$.n()) * (1.0 - MODULE$.n2()) * (1.0 + (double)9 * MODULE$.n2() / (double)4 + (double)225 * MODULE$.n4() / (double)64) * radRatio;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SVY21Converter$.class);
    }

    public double b() {
        return b;
    }

    public double e2() {
        return e2;
    }

    public double e4() {
        return e4;
    }

    public double e6() {
        return e6;
    }

    public double A0() {
        return A0;
    }

    public double A2() {
        return A2;
    }

    public double A4() {
        return A4;
    }

    public double A6() {
        return A6;
    }

    public double n() {
        return n;
    }

    public double n2() {
        return n2;
    }

    public double n3() {
        return n3;
    }

    public double n4() {
        return n4;
    }

    public double G() {
        return G;
    }

    public GeoCategory.LatLong convert(GeoCategory.SVY21 svy) {
        double N = svy.northing();
        double E = svy.easting();
        double Nprime = N - No;
        double Mo = this.calcM(oLat);
        double Mprime = Mo + Nprime / k;
        double sigma = Mprime / this.G() * radRatio;
        double latPrimeT1 = ((double)3 * this.n() / (double)2 - (double)27 * this.n3() / (double)32) * Math.sin((double)2 * sigma);
        double latPrimeT2 = ((double)21 * this.n2() / (double)16 - (double)55 * this.n4() / (double)32) * Math.sin((double)4 * sigma);
        double latPrimeT3 = (double)151 * this.n3() / (double)96 * Math.sin((double)6 * sigma);
        double latPrimeT4 = (double)1097 * this.n4() / (double)512 * Math.sin((double)8 * sigma);
        double latPrime = sigma + latPrimeT1 + latPrimeT2 + latPrimeT3 + latPrimeT4;
        double sinLatPrime = Math.sin(latPrime);
        double sin2LatPrime = sinLatPrime * sinLatPrime;
        double rhoPrime = this.calcRho(sin2LatPrime);
        double vPrime = this.calcV(sin2LatPrime);
        double psiPrime = vPrime / rhoPrime;
        double psiPrime2 = psiPrime * psiPrime;
        double psiPrime3 = psiPrime2 * psiPrime;
        double psiPrime4 = psiPrime3 * psiPrime;
        double tPrime = Math.tan(latPrime);
        double tPrime2 = tPrime * tPrime;
        double tPrime4 = tPrime2 * tPrime2;
        double tPrime6 = tPrime4 * tPrime2;
        double Eprime = E - Eo;
        double x = Eprime / (k * vPrime);
        double x2 = x * x;
        double x3 = x2 * x;
        double x5 = x3 * x2;
        double x7 = x5 * x2;
        double latFactor = tPrime / (k * rhoPrime);
        double latTerm1 = latFactor * (Eprime * x / (double)2);
        double latTerm2 = latFactor * (Eprime * x3 / (double)24) * ((double)-4 * psiPrime2 + (double)9 * psiPrime * (1.0 - tPrime2) + (double)12 * tPrime2);
        double latTerm3 = latFactor * (Eprime * x5 / (double)720) * ((double)8 * psiPrime4 * ((double)11 - (double)24 * tPrime2) - (double)12 * psiPrime3 * ((double)21 - (double)71 * tPrime2) + (double)15 * psiPrime2 * ((double)15 - (double)98 * tPrime2 + (double)15 * tPrime4) + (double)180 * psiPrime * ((double)5 * tPrime2 - (double)3 * tPrime4) + (double)360 * tPrime4);
        double latTerm4 = latFactor * (Eprime * x7 / (double)40320) * ((double)1385 - (double)3633 * tPrime2 + (double)4095 * tPrime4 + (double)1575 * tPrime6);
        double lat = latPrime - latTerm1 + latTerm2 - latTerm3 + latTerm4;
        double secLatPrime = 1.0 / Math.cos(lat);
        double lonTerm1 = x * secLatPrime;
        double lonTerm2 = x3 * secLatPrime / (double)6 * (psiPrime + (double)2 * tPrime2);
        double lonTerm3 = x5 * secLatPrime / (double)120 * ((double)-4 * psiPrime3 * (1.0 - (double)6 * tPrime2) + psiPrime2 * ((double)9 - (double)68 * tPrime2) + (double)72 * psiPrime * tPrime2 + (double)24 * tPrime4);
        double lonTerm4 = x7 * secLatPrime / (double)5040 * ((double)61 + (double)662 * tPrime2 + (double)1320 * tPrime4 + (double)720 * tPrime6);
        double lon = oLon * radRatio + lonTerm1 - lonTerm2 + lonTerm3 - lonTerm4;
        return GeoCategory$LatLong$.MODULE$.apply(lat / radRatio, lon / radRatio);
    }

    public GeoCategory.SVY21 convert(GeoCategory.LatLong latLong) {
        double lat = latLong.latitude();
        double lon = latLong.longitude();
        double latR = lat * radRatio;
        double sinLat = Math.sin(latR);
        double sin2Lat = sinLat * sinLat;
        double cosLat = Math.cos(latR);
        double cos2Lat = cosLat * cosLat;
        double cos3Lat = cos2Lat * cosLat;
        double cos4Lat = cos3Lat * cosLat;
        double cos5Lat = cos3Lat * cos2Lat;
        double cos6Lat = cos5Lat * cosLat;
        double cos7Lat = cos5Lat * cos2Lat;
        double rho = this.calcRho(sin2Lat);
        double v = this.calcV(sin2Lat);
        double psi = v / rho;
        double t = Math.tan(latR);
        double w = (lon - oLon) * radRatio;
        double M = this.calcM(lat);
        double Mo = this.calcM(oLat);
        double w2 = w * w;
        double w4 = w2 * w2;
        double w6 = w4 * w2;
        double w8 = w6 * w2;
        double psi2 = psi * psi;
        double psi3 = psi2 * psi;
        double psi4 = psi2 * psi2;
        double t2 = t * t;
        double t4 = t2 * t2;
        double t6 = t4 * t2;
        double nTerm1 = w2 / (double)2 * v * sinLat * cosLat;
        double nTerm2 = w4 / (double)24 * v * sinLat * cos3Lat * ((double)4 * psi2 + psi - t2);
        double nTerm3 = w6 / (double)720 * v * sinLat * cos5Lat * ((double)8 * psi4 * ((double)11 - (double)24 * t2) - (double)28 * psi3 * (1.0 - (double)6 * t2) + psi2 * (1.0 - (double)32 * t2) - psi * (double)2 * t2 + t4);
        double nTerm4 = w8 / (double)40320 * v * sinLat * cos7Lat * ((double)1385 - (double)3111 * t2 + (double)543 * t4 - t6);
        double N = No + k * (M - Mo + nTerm1 + nTerm2 + nTerm3 + nTerm4);
        double eTerm1 = w2 / (double)6 * cos2Lat * (psi - t2);
        double eTerm2 = w4 / (double)120 * cos4Lat * ((double)4 * psi3 * (1.0 - (double)6 * t2) + psi2 * (1.0 + (double)8 * t2) - psi * (double)2 * t2 + t4);
        double eTerm3 = w6 / (double)5040 * cos6Lat * ((double)61 - (double)479 * t2 + (double)179 * t4 - t6);
        double E = Eo + k * v * w * cosLat * (1.0 + eTerm1 + eTerm2 + eTerm3);
        return GeoCategory$SVY21$.MODULE$.apply(N, E);
    }

    private double calcM(double lat) {
        double latR = lat * radRatio;
        return (double)a * (this.A0() * latR - this.A2() * Math.sin((double)2 * latR) + this.A4() * Math.sin((double)4 * latR) - this.A6() * Math.sin((double)6 * latR));
    }

    private double calcRho(double sin2Lat) {
        double num = (double)a * (1.0 - this.e2());
        double denom = Math.pow(1.0 - this.e2() * sin2Lat, 1.5);
        return num / denom;
    }

    private double calcV(double sin2Lat) {
        double poly = 1.0 - this.e2() * sin2Lat;
        return (double)a / Math.sqrt(poly);
    }
}

