/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.binarystore;

import ambience.api.BinaryStore;
import ambience.bson.BsonETL$;
import ambience.etl.Builder;
import ambience.etl.ETLNodeCategory;
import ambience.etl.ETLStepCategory;
import ambience.etl.ETLStepCategory$;
import ambience.etl.ETLStepType;
import ambience.etl.StepBuilderRegistry$;
import ambience.etl.binarystore.BinaryStoreDeleter$;
import ambience.etl.binarystore.BinaryStoreDeleterField$;
import ambience.etl.binarystore.BinaryStoreMigrator$;
import ambience.etl.binarystore.BinaryStoreReader$;
import ambience.etl.binarystore.BinaryStoreReaderField$;
import ambience.etl.binarystore.BinaryStoreWriter$;
import ambience.etl.binarystore.BinaryStoreWriterField$;
import ambience.etl.package$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.json.JsonLens$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monocle.POptional;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left$;
import scala.util.Right$;

public final class BinaryStoreCategory$
implements ETLNodeCategory,
Serializable {
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreCategory$.class.getDeclaredField("definition$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreCategory$.class.getDeclaredField("availableSteps$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreCategory$.class.getDeclaredField("all$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BinaryStoreCategory$.class.getDeclaredField("binaryStore$lzy1"));
    private volatile Object binaryStore$lzy1;
    private static final POptional Filename;
    private static final POptional MimeType;
    private volatile Object all$lzy1;
    private volatile Object availableSteps$lzy1;
    private volatile Object definition$lzy1;
    public static final BinaryStoreCategory$ MODULE$;

    private BinaryStoreCategory$() {
    }

    static {
        MODULE$ = new BinaryStoreCategory$();
        Filename = JsonLens$.MODULE$.root().selectDynamic("filename").string();
        MimeType = JsonLens$.MODULE$.root().selectDynamic("mimeType").string();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BinaryStoreCategory$.class);
    }

    public BinaryStore binaryStore() {
        Object object = this.binaryStore$lzy1;
        if (object instanceof BinaryStore) {
            return (BinaryStore)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BinaryStore)this.binaryStore$lzyINIT1();
    }

    private Object binaryStore$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.binaryStore$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BinaryStore binaryStore = null;
                    try {
                        binaryStore = (BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class));
                        object2 = binaryStore == null ? LazyVals.NullValue$.MODULE$ : binaryStore;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.binaryStore$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return binaryStore;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public POptional<Json, Json, String, String> Filename() {
        return Filename;
    }

    public POptional<Json, Json, String, String> MimeType() {
        return MimeType;
    }

    public List<Builder> all() {
        Object object = this.all$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.all$lzyINIT1();
    }

    private Object all$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.all$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Builder[]{BinaryStoreDeleter$.MODULE$, BinaryStoreReader$.MODULE$, BinaryStoreWriter$.MODULE$, BinaryStoreDeleterField$.MODULE$, BinaryStoreMigrator$.MODULE$, BinaryStoreReaderField$.MODULE$, BinaryStoreWriterField$.MODULE$}));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.all$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.all$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<Builder> availableSteps() {
        Object object = this.availableSteps$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.availableSteps$lzyINIT1();
    }

    private Object availableSteps$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.availableSteps$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    List<Builder> list = null;
                    List<Builder> list2 = null;
                    try {
                        list2 = this.all();
                        list = list2 == null ? LazyVals.NullValue$.MODULE$ : list2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, list)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.availableSteps$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, list);
                            waiting.countDown();
                        }
                    }
                    return list2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ETLStepCategory definition() {
        Object object = this.definition$lzy1;
        if (object instanceof ETLStepCategory) {
            return (ETLStepCategory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ETLStepCategory)this.definition$lzyINIT1();
    }

    private Object definition$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.definition$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ETLStepCategory eTLStepCategory = null;
                    try {
                        eTLStepCategory = ETLStepCategory$.MODULE$.apply("Category.binarystore", this.availableSteps().map((Function1 & Serializable)_$1 -> new ETLStepType(this.definition$lzyINIT1$$anonfun$1((Builder)_$1))));
                        object2 = eTLStepCategory == null ? LazyVals.NullValue$.MODULE$ : eTLStepCategory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.definition$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return eTLStepCategory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void register() {
        this.availableSteps().foreach((Function1)(JProcedure1 & Serializable)builder -> StepBuilderRegistry$.MODULE$.register(builder));
    }

    public EitherT<Task, String, BinaryStore.Location> getLocation(Document doc, String storeField) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.getLocation$$anonfun$1(doc, storeField))).flatMap((Function1 & Serializable)store -> this.getLocation$$anonfun$2(store == null ? null : ((BinaryStore.LocationId)store).value()), (Monad)Task$.MODULE$.catsAsync());
    }

    public EitherT<Task, String, BinaryStore.Location> getLocation(String locId) {
        return EitherT$.MODULE$.apply((Object)this.binaryStore().location(locId).map((Function1 & Serializable)_$2 -> _$2.toRight(() -> this.getLocation$$anonfun$3$$anonfun$1(locId))));
    }

    public EitherT<Task, String, BinaryStore.Content> getContent(Document doc, String contentIdField, BinaryStore.Location location) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.getContent$$anonfun$1(doc, contentIdField))).flatMap((Function1 & Serializable)contentId -> this.getContent$$anonfun$2(location, contentId == null ? null : ((BinaryStore.ContentId)contentId).value()), (Monad)Task$.MODULE$.catsAsync());
    }

    public EitherT<Task, String, BinaryStore.Content> getContent(BinaryStore.Location location, String contentId) {
        return EitherT$.MODULE$.apply((Object)location.get(contentId).map((Function1 & Serializable)_$3 -> _$3.toRight(() -> this.getContent$$anonfun$3$$anonfun$1(contentId))));
    }

    public Either<String, String> getLocationId(Document doc, String storeField) {
        Option option = BsonETL$.MODULE$.get(doc, storeField);
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                return Right$.MODULE$.apply((Object)new BinaryStore.LocationId(BinaryStore.LocationId$.MODULE$.apply(bs.getValue())));
            }
            BsonValue x = bsonValue;
            return Left$.MODULE$.apply((Object)("Invalid storeField (" + storeField + ") value: " + x));
        }
        if (None$.MODULE$.equals(option)) {
            return Left$.MODULE$.apply((Object)("Missing storeField (" + storeField + ")"));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, String> getContentId(Document doc, String contentIdField) {
        Option option = BsonETL$.MODULE$.get(doc, contentIdField);
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                return Right$.MODULE$.apply((Object)new BinaryStore.ContentId(BinaryStore.ContentId$.MODULE$.apply(bs.getValue())));
            }
            BsonValue x = bsonValue;
            return Left$.MODULE$.apply((Object)("Invalid contentIdField (" + contentIdField + ") value: " + x));
        }
        if (None$.MODULE$.equals(option)) {
            return Left$.MODULE$.apply((Object)("Missing contentIdField (" + contentIdField + ")"));
        }
        throw new MatchError((Object)option);
    }

    public EitherT<Task, String, Document> contentToRecord(Builder.Context cxt, BinaryStore.Content content) {
        return EitherT$.MODULE$.apply((Object)cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Read " + content.metadata().noSpaces())).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return content.bytes().observable().toListL().map((Function1 & Serializable)_$4 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])_$4.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
                return (byte[])ArrayOps$.MODULE$.flatten$extension(object, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE));
            }).map((Function1 & Serializable)bytes -> {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                BsonDocument extras = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                this.Filename().getOption((Object)content.metadata()).foreach((Function1 & Serializable)s -> extras.append("filename", (BsonValue)BsonString$.MODULE$.apply(s)));
                this.MimeType().getOption((Object)content.metadata()).foreach((Function1 & Serializable)s -> extras.append("mimeType", (BsonValue)BsonString$.MODULE$.apply(s)));
                return Right$.MODULE$.apply((Object)package$.MODULE$.ETLRecord().apply(extras));
            }).map((Function1 & Serializable)ret -> ret);
        }));
    }

    public EitherT<Task, String, BoxedUnit> deleteContent(Builder.Context cxt, BinaryStore.Location location, String contentId) {
        return EitherT$.MODULE$.apply((Object)location.remove(contentId).flatMap((Function1 & Serializable)_$5 -> {
            BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT);
            return cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Deleted " + location.id() + ":" + contentId)).as((Object)EitherIdOps$.MODULE$.asRight$extension((Object)boxedUnit));
        }));
    }

    public EitherT<Task, String, String> write(BinaryStore.Location location, BinaryStore.Content content) {
        return EitherT$.MODULE$.apply((Object)location.add(content).map((Function1 & Serializable)_$6 -> this.write$$anonfun$1(_$6 == null ? null : ((BinaryStore.ContentId)_$6).value())));
    }

    public EitherT<Task, String, byte[]> getBytes(Document doc) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> this.getBytes$$anonfun$1(doc)));
    }

    public EitherT<Task, String, BinaryStore.Content> buildContent(Builder.Context cxt, Document doc, byte[] bytes) {
        Json metadata = this.buildMetadata(doc, bytes);
        return EitherT$.MODULE$.apply((Object)cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Writing " + metadata.noSpaces())).map((Function1 & Serializable)_$8 -> {
            BinaryStore.Content content = (BinaryStore.Content)implicits$.MODULE$.catsSyntaxEitherId((Object)BinaryStore.Content$.MODULE$.apply((DataBytes)FullDataBytes$.MODULE$.apply(bytes), metadata));
            return EitherIdOps$.MODULE$.asRight$extension((Object)content);
        }));
    }

    public Json buildMetadata(Document doc, byte[] bytes) {
        Option optFilename = doc.get("filename", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> Json$.MODULE$.fromString(s.getValue()));
        Option optMimeType = doc.get("mimeType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> Json$.MODULE$.fromString(s.getValue()));
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromLong(Int$.MODULE$.int2long(bytes.length)));
        return Json$.MODULE$.obj((Seq)((List)((StrictOptimizedIterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{optFilename.map((Function1 & Serializable)_$9 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$9);
        }), optMimeType.map((Function1 & Serializable)_$10 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$10);
        })}))).flatten(Predef$.MODULE$.$conforms())).$colon$colon((Object)tuple2));
    }

    private final /* synthetic */ String definition$lzyINIT1$$anonfun$1(Builder _$1) {
        return _$1.stepType();
    }

    private final Either getLocation$$anonfun$1(Document doc$1, String storeField$1) {
        return this.getLocationId(doc$1, storeField$1);
    }

    private final /* synthetic */ EitherT getLocation$$anonfun$2(String store) {
        return this.getLocation(store).map((Function1 & Serializable)location -> location, (Functor)Task$.MODULE$.catsAsync());
    }

    private final String getLocation$$anonfun$3$$anonfun$1(String locId$2) {
        return "Location " + locId$2 + " not found";
    }

    private final Either getContent$$anonfun$1(Document doc$2, String contentIdField$1) {
        return this.getContentId(doc$2, contentIdField$1);
    }

    private final /* synthetic */ EitherT getContent$$anonfun$2(BinaryStore.Location location$1, String contentId) {
        return this.getContent(location$1, contentId).map((Function1 & Serializable)content -> content, (Functor)Task$.MODULE$.catsAsync());
    }

    private final String getContent$$anonfun$3$$anonfun$1(String contentId$2) {
        return "Content " + contentId$2 + " not found";
    }

    private final /* synthetic */ Either write$$anonfun$1(String _$6) {
        BinaryStore.ContentId contentId = (BinaryStore.ContentId)implicits$.MODULE$.catsSyntaxEitherId((Object)new BinaryStore.ContentId(_$6));
        return EitherIdOps$.MODULE$.asRight$extension((Object)contentId);
    }

    private final String getBytes$$anonfun$1$$anonfun$2() {
        return "No bytes binary field available";
    }

    private final Either getBytes$$anonfun$1(Document doc$3) {
        return doc$3.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$7 -> _$7.getData()).toRight(this::getBytes$$anonfun$1$$anonfun$2);
    }
}

