/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.csv;

import ambience.etl.BsonExtractJson$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLJsonParsingException;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.ETLURL;
import ambience.etl.ETLURL$;
import ambience.etl.csv.CSVCategory$;
import ambience.etl.csv.CSVDefinition;
import ambience.etl.csv.CSVDefinition$;
import ambience.etl.csv.CSVReader;
import ambience.etl.csv.CSVReader$CSVRecordDef$;
import ambience.etl.csv.CSVReader$CSVStream$;
import ambience.etl.csv.CSVReader$Record$;
import ambience.etl.package;
import ambience.etl.package$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple5$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class CSVReader$
implements Builder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CSVReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final CSVReader$CSVStream$ CSVStream;
    public static final CSVReader$Record$ Record;
    public static final CSVReader$CSVRecordDef$ CSVRecordDef;
    private static final String stepType;
    private static final Function1 getDef;
    private static final Function1 defToStream;
    private static final Function1 streamToRecord;
    private static final Function1 recordToBsonFn;
    private static final Function1 recordToBson;
    private static final Function1 pipeline;
    public static final CSVReader$ MODULE$;

    private CSVReader$() {
    }

    static {
        MODULE$ = new CSVReader$();
        stepType = ETLStepType$.MODULE$.apply("csv.CSVReader");
        getDef = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)doc -> {
            Json json = BsonExtractJson$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
            String string = "url";
            String string2 = "separator";
            String string3 = "qualifier";
            String string4 = "header";
            String string5 = "base";
            int size = 5;
            Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("CSVDefinition", this::$init$$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$init$$$anonfun$1$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$init$$$anonfun$1$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                CSVDefinition csvdef = (CSVDefinition)((Right)either).value();
                return Observable$.MODULE$.now((Object)CSVReader$CSVRecordDef$.MODULE$.apply((Document)doc, csvdef));
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                return Observable$.MODULE$.raiseError((Throwable)new ETLJsonParsingException("Can't read CSVDefinition", json, (Throwable)err));
            }
            throw new MatchError((Object)either);
        });
        defToStream = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)csvdef -> {
            ETLURL url = ETLURL$.MODULE$.apply(csvdef.doc(), csvdef.csv().url());
            boolean readable = url.optFile().forall((Function1 & Serializable)f -> CSVCategory$.MODULE$.canRead((File)f));
            if (!readable) {
                return Observable$.MODULE$.raiseError((Throwable)new IOException("CSVReader reading from " + csvdef.csv().url() + " disallowed (see elixir.data.csv.readable)"));
            }
            BufferedInputStream is = new BufferedInputStream((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(url.openStream())).get());
            InputStreamReader in = new InputStreamReader(is);
            return Observable$.MODULE$.now((Object)CSVReader$CSVStream$.MODULE$.apply(csvdef.csv(), in)).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.$init$$$anonfun$2$$anonfun$1$$anonfun$1(in);
                return BoxedUnit.UNIT;
            }));
        });
        streamToRecord = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)in -> {
            String sep;
            CSVFormat.Builder builder = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT);
            boolean hasHeader = in.csvDef().header();
            if (hasHeader) {
                builder.setHeader(new String[0]);
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sep = this.getSeparator(in.csvDef())))) {
                builder.setDelimiter(sep);
            }
            StringOps$.MODULE$.headOption$extension(Predef$.MODULE$.augmentString(in.csvDef().qualifier().trim())).foreach((Function1 & Serializable)x$0 -> this.$init$$$anonfun$3$$anonfun$1$$anonfun$1(builder, BoxesRunTime.unboxToChar((Object)x$0)));
            CSVFormat base = builder.build();
            Option optBase = Try$.MODULE$.apply(() -> this.$anonfun$2(in)).toOption();
            CSVParser data = base.parse((Reader)in.isr());
            return Observable$.MODULE$.fromIterator(Task$.MODULE$.apply(() -> this.$init$$$anonfun$3$$anonfun$1$$anonfun$2(data))).map((Function1 & Serializable)csv -> CSVReader$Record$.MODULE$.apply(hasHeader, (Option<Document>)optBase, (CSVRecord)csv));
        });
        recordToBsonFn = (Function1 & Serializable)rec -> {
            if (rec.hasHeader()) {
                Map pairs = (Map)CollectionConverters$.MODULE$.MapHasAsScala(rec.csv().toMap()).asScala().map((Function1 & Serializable)kv -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply((String)kv._2()));
                });
                Option<Document> option = rec.optBase();
                if (option instanceof Some) {
                    Document base = (Document)((Some)option).value();
                    return base.$plus$plus((IterableOnce)pairs);
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.ETLRecord().apply(BsonMagnets$.MODULE$.iterableToCanBeBsonElements((Iterable)pairs, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue()));
                }
                throw new MatchError(option);
            }
            scala.collection.immutable.Map pairs = CollectionConverters$.MODULE$.IteratorHasAsScala(rec.csv().iterator()).asScala().zipWithIndex().map((Function1 & Serializable)kv -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)kv._2().toString());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply((String)kv._1()));
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option<Document> option = rec.optBase();
            if (option instanceof Some) {
                Document base = (Document)((Some)option).value();
                return base.$plus$plus((IterableOnce)pairs);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.ETLRecord().apply(BsonMagnets$.MODULE$.iterableToCanBeBsonElements((Iterable)pairs, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue()));
            }
            throw new MatchError(option);
        };
        recordToBson = package.Flow$.MODULE$.lift(MODULE$.recordToBsonFn());
        pipeline = MODULE$.getDef().andThen(MODULE$.defToStream()).andThen(MODULE$.streamToRecord()).andThen(MODULE$.recordToBson());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSVReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Function1<Observable<Document>, Observable<CSVReader.CSVRecordDef>> getDef() {
        return getDef;
    }

    public Function1<Observable<CSVReader.CSVRecordDef>, Observable<CSVReader.CSVStream>> defToStream() {
        return defToStream;
    }

    public Function1<Observable<CSVReader.CSVStream>, Observable<CSVReader.Record>> streamToRecord() {
        return streamToRecord;
    }

    public String getSeparator(CSVDefinition csv) {
        return csv.separator().replace("\t", "\u2409").replace("\n", "\u240a").trim().replace("\u2409", "\t").replace("\u240a", "\n");
    }

    public Function1<CSVReader.Record, Document> recordToBsonFn() {
        return recordToBsonFn;
    }

    public Function1<Observable<CSVReader.Record>, Observable<Document>> recordToBson() {
        return recordToBson;
    }

    public Function1<Observable<Document>, Observable<Document>> pipeline() {
        return pipeline;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        return scala.package$.MODULE$.Right().apply(this.pipeline());
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var2_1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeBoolean();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeJson();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $init$$$anonfun$1$$anonfun$1$$anonfun$2() {
        CSVDefinition$ cSVDefinition$ = CSVDefinition$.MODULE$;
        return (Function1 & Serializable)p -> (CSVDefinition)cSVDefinition$.fromProduct((Product)p);
    }

    private final Product $init$$$anonfun$1$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)CSVDefinition$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)CSVDefinition$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)CSVDefinition$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)CSVDefinition$.MODULE$.$lessinit$greater$default$4())), (Object)Some$.MODULE$.apply((Object)CSVDefinition$.MODULE$.$lessinit$greater$default$5()));
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$1(InputStreamReader in$1) {
        in$1.close();
    }

    private final /* synthetic */ CSVFormat.Builder $init$$$anonfun$3$$anonfun$1$$anonfun$1(CSVFormat.Builder builder$1, char x$0) {
        return builder$1.setQuote(x$0);
    }

    private final Document $anonfun$2(CSVReader.CSVStream in$2) {
        return package$.MODULE$.ETLRecord().apply(in$2.csvDef().base().noSpaces());
    }

    private final Iterator $init$$$anonfun$3$$anonfun$1$$anonfun$2(CSVParser data$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(data$1.iterator()).asScala();
    }
}

