/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.file;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.DataInUrl$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.file.FileCategory$;
import ambience.etl.file.FileReader;
import ambience.etl.file.FileReader$Info$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelperT;
import com.elixirtech.arch.LoggingInterfaceT;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.net.URLDecoder;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple1$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class FileReader$
implements Builder,
PanelBuilder,
LoggingHelperT,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final FileReader$Info$ Info;
    private static final String stepType;
    public static final FileReader$ MODULE$;

    private FileReader$() {
    }

    static {
        MODULE$ = new FileReader$();
        stepType = ETLStepType$.MODULE$.apply("file.FileReader");
    }

    public LoggingInterfaceT log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterfaceT) {
            return (LoggingInterfaceT)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterfaceT)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterfaceT loggingInterfaceT = null;
                    try {
                        loggingInterfaceT = LoggingHelperT.log$((LoggingHelperT)this);
                        object2 = loggingInterfaceT == null ? LazyVals.NullValue$.MODULE$ : loggingInterfaceT;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterfaceT;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "file";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), this::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> this.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> this.run(cxt, (FileReader.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "file";
        boolean size = true;
        FileReader.Info info = (FileReader.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(info));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, FileReader.Info info, Observable<Document> from) {
        File file = new File(info.file());
        String path = file.getAbsolutePath();
        if (FileCategory$.MODULE$.canRead(file)) {
            Task tBytes = this.loadBytes(cxt, file).memoize();
            return from.flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromTask(tBytes.map((Function1 & Serializable)bytes -> {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(file.getName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
                objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(FileCategory$.MODULE$.getMimeType(file).value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            })));
        }
        return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Can't access file " + path + " - check folder restrictions"));
    }

    public Task<byte[]> loadBytes(Builder.Context cxt, File file) {
        String path = file.getAbsolutePath();
        return this.log().infoElapsedTimeT(() -> this.loadBytes$$anonfun$1(path), () -> this.loadBytes$$anonfun$2(cxt, path, file), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.etl.file.FileReader.loadBytes"));
    }

    public List<String> loadChoices() {
        return DataInUrl$.MODULE$.load(FileCategory$.MODULE$.FileReadable(), "").take(100).map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$1), "file:")).map((Function1 & Serializable)_$2 -> URLDecoder.decode(_$2, "UTF-8"));
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 build$$anonfun$2() {
        FileReader$Info$ fileReader$Info$ = FileReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileReader.Info)fileReader$Info$.fromProduct((Product)p);
    }

    private final Product build$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileReader$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        FileReader$Info$ fileReader$Info$ = FileReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileReader.Info)fileReader$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileReader$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private final FileReader.Info $anonfun$4() {
        return FileReader$Info$.MODULE$.apply(FileReader$Info$.MODULE$.$lessinit$greater$default$1());
    }

    private final Panel buildPanel$$anonfun$1(FileReader.Info info$2) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{PanelItem$.MODULE$.text("file", "File", info$2.file(), this.loadChoices())})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        FileReader$Info$ fileReader$Info$ = FileReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileReader.Info)fileReader$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileReader$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "file";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            FileReader.Info info2 = (FileReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "file";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string2 = step$2.copy$default$1();
            String string3 = step$2.copy$default$2();
            String string4 = step$2.copy$default$3();
            String string5 = step$2.copy$default$4();
            String string6 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string2, string3, string4, string5, string6, json, bl, bl2);
        });
    }

    private final String loadBytes$$anonfun$1(String path$1) {
        return "Loading " + path$1;
    }

    private final byte[] loadBytes$$anonfun$2$$anonfun$1$$anonfun$1(File file$5) {
        return com.elixirtech.arch.package$.MODULE$.enrichFile(file$5).data();
    }

    private final Task loadBytes$$anonfun$2(Builder.Context cxt$3, String path$2, File file$3) {
        return cxt$3.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Loading " + path$2)).flatMap((Function1 & Serializable)x$1 -> {
            Task task;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Try try_ = Try$.MODULE$.apply(() -> this.loadBytes$$anonfun$2$$anonfun$1$$anonfun$1(file$3));
            if (try_ instanceof Success) {
                byte[] bytes = (byte[])((Success)try_).value();
                task = cxt$3.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Loaded " + bytes.length + " bytes")).as((Object)bytes);
            } else if (try_ instanceof Failure) {
                Throwable err = ((Failure)try_).exception();
                task = cxt$3.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Can't read file " + err, err)).as((Object)new byte[0]);
            } else {
                throw new MatchError((Object)try_);
            }
            return task.map((Function1 & Serializable)ret -> ret);
        });
    }
}

