/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.rest;

import ambience.api.Secrets;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ClientCert$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ClientCert$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String BEGIN_CERT;
    private static final String END_CERT;
    private static final String BEGIN_PRIVATE;
    private static final String END_PRIVATE;
    public static final ClientCert$ MODULE$;

    private ClientCert$() {
    }

    static {
        MODULE$ = new ClientCert$();
        BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
        END_CERT = "-----END CERTIFICATE-----";
        BEGIN_PRIVATE = "-----BEGIN PRIVATE KEY-----";
        END_PRIVATE = "-----END PRIVATE KEY-----";
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClientCert$.class);
    }

    public String BEGIN_CERT() {
        return BEGIN_CERT;
    }

    public String END_CERT() {
        return END_CERT;
    }

    public String BEGIN_PRIVATE() {
        return BEGIN_PRIVATE;
    }

    public String END_PRIVATE() {
        return END_PRIVATE;
    }

    public Task<Either<LogMessage, KeyStore>> buildKeyStoreFromSecret(UserDB.User user, String secretName) {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        return (Task)EitherT$.MODULE$.apply(this.buildCertificateFromSecret(user, secretName)).flatMap((Function1 & Serializable)cert -> {
            keystore.setCertificateEntry("", (Certificate)cert);
            return EitherT$.MODULE$.apply(this.right(BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(this.buildPrivateKeyFromSecret(user, secretName)).flatMap((Function1 & Serializable)priv -> {
                    keystore.setKeyEntry("", (Key)priv, (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Character.TYPE)), new Certificate[]{cert});
                    return EitherT$.MODULE$.apply(this.right(BoxedUnit.UNIT)).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return keystore;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<LogMessage, BoxedUnit>> right(BoxedUnit fn) {
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)fn));
    }

    public Task<Either<LogMessage, Certificate>> buildCertificateFromSecret(UserDB.User user, String secretName) {
        return ((Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class))).getSecret(user, secretName + ".Certificate").map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value secret = (Secrets.Value)((Some)option).value();
                return this.buildX509Cert(secret);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + secretName + ".Certificate not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, PrivateKey>> buildPrivateKeyFromSecret(UserDB.User user, String secretName) {
        return ((Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class))).getSecret(user, secretName + ".PrivateKey").map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Secrets.Value secret = (Secrets.Value)((Some)option).value();
                return this.buildPrivateKey(secret);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Secret " + secretName + ".PrivateKey not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Either<LogMessage, Certificate> buildX509Cert(Secrets.Value secret) {
        return Try$.MODULE$.apply(() -> this.buildX509Cert$$anonfun$1(secret)).toEither().left().map((Function1 & Serializable)ex -> LogMessage.ErrorEx$.MODULE$.apply("Can't build certificate: " + ex, ex));
    }

    public Certificate buildX509Cert(byte[] bytes) {
        this.log().info(() -> this.buildX509Cert$$anonfun$3(bytes), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.etl.rest.ClientCert.buildX509Cert"));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
    }

    public Either<LogMessage, PrivateKey> buildPrivateKey(Secrets.Value secret) {
        return Try$.MODULE$.apply(() -> this.buildPrivateKey$$anonfun$1(secret)).toEither().left().map((Function1 & Serializable)ex -> LogMessage.ErrorEx$.MODULE$.apply("Can't build private key: " + ex, ex));
    }

    private final Object buildX509Cert$$anonfun$1$$anonfun$1(String stringVersion$1) {
        return "Got x509Cert: " + stringVersion$1;
    }

    private final Certificate buildX509Cert$$anonfun$1(Secrets.Value secret$1) {
        String stringVersion = Crypt$.MODULE$.encPrefixDecrypt(secret$1.value(), true).replaceAll(this.BEGIN_CERT(), "").replaceAll(this.END_CERT(), "").trim();
        this.log().info(() -> this.buildX509Cert$$anonfun$1$$anonfun$1(stringVersion), Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.etl.rest.ClientCert.buildX509Cert"));
        byte[] bytes = Base64.getDecoder().decode(stringVersion.replace("\n", "").replace("\r", ""));
        return this.buildX509Cert(bytes);
    }

    private final Object buildX509Cert$$anonfun$3(byte[] bytes$1) {
        return "Got " + bytes$1.length + " bytes in certificate";
    }

    private final PrivateKey buildPrivateKey$$anonfun$1(Secrets.Value secret$2) {
        String stringVersion = Crypt$.MODULE$.encPrefixDecrypt(secret$2.value(), true).replaceAll(this.BEGIN_PRIVATE(), "").replaceAll(this.END_PRIVATE(), "").trim();
        byte[] bytes = Base64.getDecoder().decode(stringVersion.replace("\n", "").replace("\r", ""));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        return factory.generatePrivate(spec);
    }
}

