/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.concurrent.Future;
import scala.util.control.NonFatal$;

public final class UnsafeCreateObservable<A>
extends Observable<A> {
    private final Function1<Subscriber<A>, Cancelable> f;

    public UnsafeCreateObservable(Function1<Subscriber<A>, Cancelable> f) {
        this.f = f;
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        Cancelable cancelable;
        try {
            cancelable = (Cancelable)this.f.apply(new SafeSubscriber<A>(out));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                out.scheduler().reportFailure(ex);
                cancelable = Cancelable$.MODULE$.empty();
            }
            throw throwable;
        }
        return cancelable;
    }

    private static final class SafeSubscriber<A>
    implements Subscriber<A> {
        private final Subscriber<A> underlying;
        private final Scheduler scheduler;
        private boolean isDone;

        public SafeSubscriber(Subscriber<A> underlying) {
            this.underlying = underlying;
            this.scheduler = underlying.scheduler();
            this.isDone = false;
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Future<Ack> onNext(A elem) {
            Ack.Stop$ stop$;
            if (this.isDone) {
                stop$ = Ack.Stop$.MODULE$;
            } else {
                Ack.Stop$ stop$2;
                try {
                    stop$2 = this.underlying.onNext(elem);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        this.onError(ex);
                        stop$2 = Ack.Stop$.MODULE$;
                    }
                    throw throwable;
                }
                Ack.Stop$ ack = stop$2;
                if (ack == Ack.Continue$.MODULE$) {
                    stop$ = Ack.Continue$.MODULE$;
                } else if (ack == Ack.Stop$.MODULE$) {
                    this.isDone = true;
                    stop$ = Ack.Stop$.MODULE$;
                } else {
                    void var2_5;
                    stop$ = var2_5;
                }
            }
            return stop$;
        }

        @Override
        public void onError(Throwable ex) {
            if (!this.isDone) {
                this.isDone = true;
                this.underlying.onError(ex);
            }
        }

        @Override
        public void onComplete() {
            if (!this.isDone) {
                this.isDone = true;
                this.underlying.onComplete();
            }
        }
    }
}

