/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import java.io.Serializable;
import monix.execution.Cancelable;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.MulticastStrategy;
import monix.reactive.MulticastStrategy$Async$;
import monix.reactive.MulticastStrategy$Behavior$;
import monix.reactive.MulticastStrategy$Publish$;
import monix.reactive.MulticastStrategy$Replay$;
import monix.reactive.MulticastStrategy$ReplayLimited$;
import monix.reactive.OverflowStrategy;
import monix.reactive.OverflowStrategy$Unbounded$;
import monix.reactive.observers.Subscriber;
import monix.reactive.observers.Subscriber$;
import monix.reactive.observers.Subscriber$Extensions$;
import monix.reactive.subjects.AsyncSubject$;
import monix.reactive.subjects.BehaviorSubject$;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.PublishSubject$;
import monix.reactive.subjects.PublishToOneSubject$;
import monix.reactive.subjects.ReplaySubject$;
import monix.reactive.subjects.Subject;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscription;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ConcurrentSubject$
implements Serializable {
    public static final ConcurrentSubject$ MODULE$ = new ConcurrentSubject$();

    private ConcurrentSubject$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ConcurrentSubject$.class);
    }

    public <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicast, Scheduler s) {
        return this.apply(multicast, OverflowStrategy$Unbounded$.MODULE$, s);
    }

    public <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicast, OverflowStrategy.Synchronous<A> overflow, Scheduler s) {
        ConcurrentSubject<A, A> concurrentSubject;
        MulticastStrategy<A> multicastStrategy = multicast;
        if (MulticastStrategy$Publish$.MODULE$.equals(multicastStrategy)) {
            concurrentSubject = this.publish(overflow, s);
        } else if (multicastStrategy instanceof MulticastStrategy.Behavior) {
            Object a;
            MulticastStrategy.Behavior behavior = MulticastStrategy$Behavior$.MODULE$.unapply((MulticastStrategy.Behavior)multicastStrategy);
            Object initial = a = behavior._1();
            concurrentSubject = this.behavior(initial, overflow, s);
        } else if (MulticastStrategy$Async$.MODULE$.equals(multicastStrategy)) {
            concurrentSubject = this.async(s);
        } else if (multicastStrategy instanceof MulticastStrategy.Replay) {
            Seq seq;
            MulticastStrategy.Replay replay = MulticastStrategy$Replay$.MODULE$.unapply((MulticastStrategy.Replay)multicastStrategy);
            Seq initial = seq = replay._1();
            concurrentSubject = this.replay(initial, overflow, s);
        } else if (multicastStrategy instanceof MulticastStrategy.ReplayLimited) {
            MulticastStrategy.ReplayLimited replayLimited = MulticastStrategy$ReplayLimited$.MODULE$.unapply((MulticastStrategy.ReplayLimited)multicastStrategy);
            int n = replayLimited._1();
            Seq seq = replayLimited._2();
            int capacity = n;
            Seq initial = seq;
            concurrentSubject = this.replayLimited(capacity, initial, overflow, s);
        } else {
            throw new MatchError(multicastStrategy);
        }
        return concurrentSubject;
    }

    public <I, O> ConcurrentSubject<I, O> from(Subject<I, O> p, OverflowStrategy.Synchronous<I> overflowStrategy, ChannelType.ProducerSide producerType, Scheduler s) {
        return new ConcurrentSubject.SubjectAsConcurrent<I, O>(p, overflowStrategy, producerType, s);
    }

    public <I, O> ChannelType.ProducerSide from$default$3() {
        return ChannelType.MultiProducer$.MODULE$;
    }

    public <A> ConcurrentSubject<A, A> publish(Scheduler s) {
        return this.from(PublishSubject$.MODULE$.apply(), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publish(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(PublishSubject$.MODULE$.apply(), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publishToOne(Scheduler s) {
        return this.from(PublishToOneSubject$.MODULE$.apply(), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publishToOne(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(PublishToOneSubject$.MODULE$.apply(), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> behavior(A initial, Scheduler s) {
        return this.from(BehaviorSubject$.MODULE$.apply(initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> behavior(A initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(BehaviorSubject$.MODULE$.apply(initial), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> async(Scheduler s) {
        return new ConcurrentSubject.ConcurrentAsyncSubject(AsyncSubject$.MODULE$.apply());
    }

    public <A> ConcurrentSubject<A, A> replay(Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(Seq<A> initial, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(Seq<A> initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(initial), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Seq<A> initial, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity, initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Seq<A> initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity, initial), strategy, this.from$default$3(), s);
    }

    public <I, O> Processor<I, O> toReactiveProcessor(ConcurrentSubject<I, O> source, int bufferSize, Scheduler s) {
        return new Processor<I, O>(source, bufferSize, s){
            private final ConcurrentSubject source$2;
            private final Scheduler s$2;
            private final org.reactivestreams.Subscriber subscriber;
            {
                this.source$2 = source$1;
                this.s$2 = s$1;
                Subscriber subscriber = Subscriber$.MODULE$.Extensions(Subscriber$.MODULE$.apply(source$1, s$1));
                this.subscriber = Subscriber$Extensions$.MODULE$.toReactive$extension(subscriber, bufferSize$1);
            }

            public void subscribe(org.reactivestreams.Subscriber subscriber) {
                SingleAssignCancelable sub = SingleAssignCancelable$.MODULE$.apply();
                sub.$colon$eq(this.source$2.unsafeSubscribeFn(Subscriber$.MODULE$.fromReactiveSubscriber(subscriber, (Cancelable)sub, this.s$2)));
            }

            public void onSubscribe(Subscription s) {
                this.subscriber.onSubscribe(s);
            }

            public void onNext(Object t) {
                this.subscriber.onNext(t);
            }

            public void onError(Throwable t) {
                this.subscriber.onError(t);
            }

            public void onComplete() {
                this.subscriber.onComplete();
            }
        };
    }
}

