/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.validation;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.validation.DateRange;
import ambience.etl.validation.DateRange$Info$;
import ambience.etl.validation.DateRange$Struct$;
import ambience.etl.validation.Messages$;
import ambience.etl.validation.ValidationCategory$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DateRange$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    private static final HashMap formatters;
    private static final DateTimeFormatter ISO;
    public static final DateRange$Info$ Info;
    public static final DateRange$Struct$ Struct;
    public static final DateRange$ MODULE$;

    private DateRange$() {
    }

    static {
        MODULE$ = new DateRange$();
        stepType = ETLStepType$.MODULE$.apply("validation.DateRange");
        formatters = new HashMap();
        ISO = DateTimeFormatter.ISO_LOCAL_DATE;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DateRange$.class);
    }

    public String stepType() {
        return stepType;
    }

    public HashMap<String, DateTimeFormatter> formatters() {
        return formatters;
    }

    public DateTimeFormatter ISO() {
        return ISO;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        DateRange$Info$ mirror$proxy1 = DateRange$Info$.MODULE$;
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        DateRange.Info info = (DateRange.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1, Default$.MODULE$.inline$of(this::$anonfun$2))))).toOption().getOrElse(this::$anonfun$3);
        Panel.Item numberField = PanelItem$.MODULE$.text("field", "Date Field", info.field(), PanelItem$.MODULE$.text$default$4());
        Panel.Item minField = PanelItem$.MODULE$.text("min", "Minimum (yyyy-MM-dd)", info.min(), PanelItem$.MODULE$.text$default$4());
        Panel.Item maxField = PanelItem$.MODULE$.text("max", "Maximum (yyyy-MM-dd)", info.max(), PanelItem$.MODULE$.text$default$4());
        Panel.Item format = PanelItem$.MODULE$.text("format", "Format", info.format(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(numberField, minField, maxField, format));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        DateRange$Info$ mirror$proxy4 = DateRange$Info$.MODULE$;
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        return step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy4, Default$.MODULE$.inline$of(this::build$$anonfun$2))))).left().map((Function1 & Serializable)err -> this.error(step, (DecodingFailure)err)).flatMap((Function1 & Serializable)info -> this.logError(step, "Can't parse format " + info.format(), () -> this.build$$anonfun$4$$anonfun$1(info)).flatMap((Function1 & Serializable)formatter -> this.logError(step, "Can't parse min " + info.min(), () -> this.build$$anonfun$4$$anonfun$2$$anonfun$1(info)).flatMap((Function1 & Serializable)min -> this.logError(step, "Can't parse max " + info.max(), () -> this.build$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1(info)).flatMap((Function1 & Serializable)max -> {
            DateRange.Struct struct = DateRange$Struct$.MODULE$.apply((DateTimeFormatter)formatter, (LocalDate)min, (LocalDate)max);
            return package$.MODULE$.Right().apply((Function1 & Serializable)from -> this.run((DateRange.Info)info, struct, (Observable<Document>)from)).map((Function1 & Serializable)ret -> ret);
        }))));
    }

    public Observable<Document> run(DateRange.Info info, DateRange.Struct struct, Observable<Document> from) {
        return from.map((Function1 & Serializable)doc -> {
            BsonValue bsonValue;
            Option option = BsonETL$.MODULE$.get(doc, info.field());
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
                Document document;
                BsonString n = (BsonString)bsonValue;
                try {
                    LocalDate v = LocalDate.parse(n.getValue(), struct.formatter());
                    if (v.isBefore(struct.min()) || v.isAfter(struct.max())) {
                        String msg = Messages$.MODULE$.dateRangeExpected((Document)doc, info.field(), this.format(info.format(), info.min()), this.format(info.format(), info.max()), (Option<String>)Some$.MODULE$.apply((Object)n.getValue()));
                        document = ValidationCategory$.MODULE$.invalid((Document)doc, msg);
                    } else {
                        document = doc;
                    }
                }
                catch (DateTimeParseException dateTimeParseException) {
                    document = ValidationCategory$.MODULE$.invalid((Document)doc, Messages$.MODULE$.cannotParse((Document)doc, info.field(), info.format(), n.getValue()));
                }
                return document;
            }
            String msg = Messages$.MODULE$.dateRangeExpected((Document)doc, info.field(), this.format(info.format(), info.min()), this.format(info.format(), info.max()), (Option<String>)None$.MODULE$);
            return ValidationCategory$.MODULE$.invalid((Document)doc, msg);
        });
    }

    public Observable<Document> invalidRun(Observable<Document> from) {
        return from.map((Function1 & Serializable)doc -> ValidationCategory$.MODULE$.invalid((Document)doc, "Invalid DateRange configuration"));
    }

    public <T> Either<BuildError, T> logError(ETLStep step, String msg, Function0<T> fn) {
        Try try_ = Try$.MODULE$.apply(fn);
        if (try_ instanceof Success) {
            Object t = ((Success)try_).value();
            return package$.MODULE$.Right().apply(t);
        }
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)BuildError$.MODULE$.apply(msg + ": " + err, (Option)Some$.MODULE$.apply((Object)step), (Option)None$.MODULE$));
        }
        throw new MatchError((Object)try_);
    }

    public String format(String fmt, String s) {
        return this.getFormatter(fmt).format(this.ISO().parse(s));
    }

    public DateTimeFormatter getFormatter(String fmt) {
        return (DateTimeFormatter)this.formatters().getOrElseUpdate((Object)fmt, () -> this.getFormatter$$anonfun$1(fmt));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Product $anonfun$2() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private final DateRange.Info $anonfun$3() {
        return DateRange$Info$.MODULE$.apply(DateRange$Info$.MODULE$.$lessinit$greater$default$1(), DateRange$Info$.MODULE$.$lessinit$greater$default$2(), DateRange$Info$.MODULE$.$lessinit$greater$default$3(), DateRange$Info$.MODULE$.$lessinit$greater$default$4());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item numberField$1, Panel.Item minField$1, Panel.Item maxField$1, Panel.Item format$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{numberField$1, minField$1, maxField$1, format$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Product savePanel$$anonfun$1$$anonfun$2() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$4() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var2_1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        DateRange$Info$ mirror$proxy2 = DateRange$Info$.MODULE$;
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2, Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$2))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            DateRange.Info info2 = (DateRange.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            DateRange$Info$ mirror$proxy3 = DateRange$Info$.MODULE$;
            String string = "field";
            String string2 = "min";
            String string3 = "max";
            String string4 = "format";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(this::$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3))));
            String string5 = step$1.copy$default$1();
            String string6 = step$1.copy$default$2();
            String string7 = step$1.copy$default$3();
            String string8 = step$1.copy$default$4();
            String string9 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Product build$$anonfun$2() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)DateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private final DateTimeFormatter build$$anonfun$4$$anonfun$1(DateRange.Info info$1) {
        return this.getFormatter(info$1.format());
    }

    private final LocalDate build$$anonfun$4$$anonfun$2$$anonfun$1(DateRange.Info info$3) {
        return LocalDate.parse(info$3.min(), this.ISO());
    }

    private final LocalDate build$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1(DateRange.Info info$5) {
        return LocalDate.parse(info$5.max(), this.ISO());
    }

    private final DateTimeFormatter getFormatter$$anonfun$1(String fmt$1) {
        return DateTimeFormatter.ofPattern(fmt$1);
    }
}

