/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.validation;

import ambience.api.Repository;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Helpers$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.validation.JsonSchemaValidation;
import ambience.etl.validation.JsonSchemaValidation$Info$;
import ambience.etl.validation.JsonSchemaValidation$Validation$;
import ambience.etl.validation.Messages$;
import ambience.etl.validation.ValidationCategory$;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import jakarta.json.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.function.Consumer;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.leadpony.justify.api.JsonValidationService;
import org.leadpony.justify.api.ProblemHandler;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple1$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class JsonSchemaValidation$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    public static final JsonSchemaValidation$Info$ Info;
    public static final JsonSchemaValidation$Validation$ Validation;
    public static final JsonSchemaValidation$ MODULE$;

    private JsonSchemaValidation$() {
    }

    static {
        MODULE$ = new JsonSchemaValidation$();
        stepType = ETLStepType$.MODULE$.apply("validation.JsonSchema");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonSchemaValidation$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        JsonSchemaValidation$Info$ mirror$proxy1 = JsonSchemaValidation$Info$.MODULE$;
        String string = "schemaUrl";
        boolean size = true;
        JsonSchemaValidation.Info info = (JsonSchemaValidation.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1, Default$.MODULE$.inline$of(this::$anonfun$2))))).toOption().getOrElse(this::$anonfun$3);
        Panel.Item fields = PanelItem$.MODULE$.text("schemaUrl", "Schema URL", info.schemaUrl(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(fields));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        JsonSchemaValidation$Info$ mirror$proxy4 = JsonSchemaValidation$Info$.MODULE$;
        String string = "schemaUrl";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy4, Default$.MODULE$.inline$of(this::build$$anonfun$2))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> this.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> this.run(cxt, (JsonSchemaValidation.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, JsonSchemaValidation.Info info, Observable<Document> from) {
        return Observable$.MODULE$.fromTask(this.buildValidation(cxt, info.schemaUrl())).flatMap((Function1 & Serializable)v -> from.flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{this.validate((JsonSchemaValidation.Validation)v, (Document)doc)})).map((Function1 & Serializable)doc2 -> doc2)));
    }

    public Document validate(JsonSchemaValidation.Validation v, Document doc) {
        ListBuffer errors = new ListBuffer();
        Consumer<String> consumer = new Consumer<String>(errors, doc){
            private final ListBuffer errors$1;
            private final Document doc$1;
            {
                this.errors$1 = errors$2;
                this.doc$1 = doc$2;
            }

            public void accept(String s) {
                int idx = s.indexOf("]");
                this.errors$1.$plus$eq((Object)Messages$.MODULE$.schemaError(this.doc$1, s.substring(idx + 1)));
            }
        };
        ProblemHandler handler = v.service().createProblemPrinter((Consumer)consumer);
        StringReader in = new StringReader(doc.toJson());
        JsonReader reader = v.service().createReader((Reader)in, v.schema(), handler);
        reader.readValue();
        if (errors.isEmpty()) {
            return doc;
        }
        return ValidationCategory$.MODULE$.invalid(doc, (Seq<String>)errors.toSeq());
    }

    public Task<JsonSchemaValidation.Validation> buildValidation(Builder.Context cxt, String schemaUrl) {
        return this.loadSchema(cxt, schemaUrl).map((Function1 & Serializable)bytes -> {
            JsonValidationService service = JsonValidationService.newInstance();
            return JsonSchemaValidation$Validation$.MODULE$.apply(service, service.readSchema((InputStream)new ByteArrayInputStream((byte[])bytes)));
        }).onErrorHandleWith((Function1 & Serializable)ex -> cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Json Schema loading error", ex)).flatMap((Function1 & Serializable)_$1 -> Task$.MODULE$.raiseError((Throwable)new RuntimeException("Json Schema loading error: " + ex))));
    }

    public Task<byte[]> loadSchema(Builder.Context cxt, String schemaUrl) {
        if (schemaUrl.startsWith("repository:")) {
            return this.loadRepositorySchema(cxt, schemaUrl);
        }
        return Task$.MODULE$.apply(() -> this.loadSchema$$anonfun$1(schemaUrl));
    }

    public Task<byte[]> loadRepositorySchema(Builder.Context cxt, String schemaUrl) {
        return this.getUser(cxt).flatMap((Function1 & Serializable)user -> {
            Repository repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
            return repository.readFileT(user, Path$.MODULE$.apply(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(schemaUrl), "repository:")));
        });
    }

    public Task<UserDB.User> getUser(Builder.Context cxt) {
        return Helpers$.MODULE$.user(cxt.credentials().owner()).map((Function1 & Serializable)_$2 -> (UserDB.User)_$2.getOrElse(() -> this.getUser$$anonfun$1$$anonfun$1(cxt)));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Product $anonfun$2() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsonSchemaValidation$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private final JsonSchemaValidation.Info $anonfun$3() {
        return JsonSchemaValidation$Info$.MODULE$.apply(JsonSchemaValidation$Info$.MODULE$.$lessinit$greater$default$1());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item fields$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{fields$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Product savePanel$$anonfun$1$$anonfun$2() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsonSchemaValidation$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$4() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        JsonSchemaValidation$Info$ mirror$proxy2 = JsonSchemaValidation$Info$.MODULE$;
        String string = "schemaUrl";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2, Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$2))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JsonSchemaValidation.Info info2 = (JsonSchemaValidation.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            JsonSchemaValidation$Info$ mirror$proxy3 = JsonSchemaValidation$Info$.MODULE$;
            String string = "schemaUrl";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$of(this::$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3))));
            String string2 = step$1.copy$default$1();
            String string3 = step$1.copy$default$2();
            String string4 = step$1.copy$default$3();
            String string5 = step$1.copy$default$4();
            String string6 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string2, string3, string4, string5, string6, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List build$$anonfun$1() {
        void var2_1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        return package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    private final Product build$$anonfun$2() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JsonSchemaValidation$Info$.MODULE$.$lessinit$greater$default$1()));
    }

    private final byte[] loadSchema$$anonfun$1(String schemaUrl$1) {
        return new URL(schemaUrl$1).openStream().readAllBytes();
    }

    private final UserDB.User getUser$$anonfun$1$$anonfun$1(Builder.Context cxt$5) {
        throw new RuntimeException("User " + cxt$5.credentials().owner() + " not found");
    }
}

