/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.time.Clock;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtTime$;
import pdi.jwt.JwtUtils$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public class JwtClaim {
    private final String content;
    private final Option issuer;
    private final Option subject;
    private final Option audience;
    private final Option expiration;
    private final Option notBefore;
    private final Option issuedAt;
    private final Option jwtId;

    public static JwtClaim apply(String string, Option<String> option, Option<String> option2, Option<Set<String>> option3, Option<Object> option4, Option<Object> option5, Option<Object> option6, Option<String> option7) {
        return JwtClaim$.MODULE$.apply(string, option, option2, option3, option4, option5, option6, option7);
    }

    public static String apply$default$1() {
        return JwtClaim$.MODULE$.apply$default$1();
    }

    public static Option<String> apply$default$2() {
        return JwtClaim$.MODULE$.apply$default$2();
    }

    public static Option<String> apply$default$3() {
        return JwtClaim$.MODULE$.apply$default$3();
    }

    public static Option<Set<String>> apply$default$4() {
        return JwtClaim$.MODULE$.apply$default$4();
    }

    public static Option<Object> apply$default$5() {
        return JwtClaim$.MODULE$.apply$default$5();
    }

    public static Option<Object> apply$default$6() {
        return JwtClaim$.MODULE$.apply$default$6();
    }

    public static Option<Object> apply$default$7() {
        return JwtClaim$.MODULE$.apply$default$7();
    }

    public static Option<String> apply$default$8() {
        return JwtClaim$.MODULE$.apply$default$8();
    }

    public JwtClaim(String content, Option<String> issuer, Option<String> subject, Option<Set<String>> audience, Option<Object> expiration, Option<Object> notBefore, Option<Object> issuedAt, Option<String> jwtId) {
        this.content = content;
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.expiration = expiration;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwtId = jwtId;
    }

    public String content() {
        return this.content;
    }

    public Option<String> issuer() {
        return this.issuer;
    }

    public Option<String> subject() {
        return this.subject;
    }

    public Option<Set<String>> audience() {
        return this.audience;
    }

    public Option<Object> expiration() {
        return this.expiration;
    }

    public Option<Object> notBefore() {
        return this.notBefore;
    }

    public Option<Object> issuedAt() {
        return this.issuedAt;
    }

    public Option<String> jwtId() {
        return this.jwtId;
    }

    public String toJson() {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"iss");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"sub");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"aud");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exp");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"nbf");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"iat");
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"jti");
        return JwtUtils$.MODULE$.mergeJson(JwtUtils$.MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, this.issuer()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, this.subject()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.audience().map((Function1 & Serializable)set -> {
            if (set.size() == 1) {
                return set.head();
            }
            return set;
        })), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, this.expiration()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, this.notBefore()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, this.issuedAt()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, this.jwtId()), (List)Nil$.MODULE$)))))))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        Object value = ((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    String key = (String)tuple2._1();
                    if (option instanceof Some) {
                        Object value = ((Some)option).value();
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value);
                    }
                }
                return function1.apply((Object)x);
            }
        }))), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.content()}));
    }

    public JwtClaim $plus(String json) {
        return JwtClaim$.MODULE$.apply(JwtUtils$.MODULE$.mergeJson(this.content(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{json})), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim $plus(String key, Object value) {
        Object[] objectArray = new String[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        objectArray[0] = JwtUtils$.MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value), (List)Nil$.MODULE$))));
        return JwtClaim$.MODULE$.apply(JwtUtils$.MODULE$.mergeJson(this.content(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public <T> JwtClaim $plus$plus(Seq<Tuple2<String, T>> fields) {
        return JwtClaim$.MODULE$.apply(JwtUtils$.MODULE$.mergeJson(this.content(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JwtUtils$.MODULE$.hashToJson(fields)})), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim by(String issuer) {
        return JwtClaim$.MODULE$.apply(this.content(), (Option<String>)Option$.MODULE$.apply((Object)issuer), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim withContent(String content) {
        return JwtClaim$.MODULE$.apply(content, this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim to(String audience) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), (Option<Set<String>>)Option$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{audience}))), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim to(Set<String> audience) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), (Option<Set<String>>)Option$.MODULE$.apply(audience), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim about(String subject) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), (Option<String>)Option$.MODULE$.apply((Object)subject), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim withId(String id) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), (Option<String>)Option$.MODULE$.apply((Object)id));
    }

    public JwtClaim expiresAt(long seconds) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), this.audience(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)seconds)), this.notBefore(), this.issuedAt(), this.jwtId());
    }

    public JwtClaim expiresIn(long seconds, Clock clock) {
        return this.expiresAt(JwtTime$.MODULE$.nowSeconds(clock) + seconds);
    }

    public JwtClaim expiresNow(Clock clock) {
        return this.expiresAt(JwtTime$.MODULE$.nowSeconds(clock));
    }

    public JwtClaim startsAt(long seconds) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), this.audience(), this.expiration(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)seconds)), this.issuedAt(), this.jwtId());
    }

    public JwtClaim startsIn(long seconds, Clock clock) {
        return this.startsAt(JwtTime$.MODULE$.nowSeconds(clock) + seconds);
    }

    public JwtClaim startsNow(Clock clock) {
        return this.startsAt(JwtTime$.MODULE$.nowSeconds(clock));
    }

    public JwtClaim issuedAt(long seconds) {
        return JwtClaim$.MODULE$.apply(this.content(), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)seconds)), this.jwtId());
    }

    public JwtClaim issuedIn(long seconds, Clock clock) {
        return this.issuedAt(JwtTime$.MODULE$.nowSeconds(clock) + seconds);
    }

    public JwtClaim issuedNow(Clock clock) {
        return this.issuedAt(JwtTime$.MODULE$.nowSeconds(clock));
    }

    public boolean isValid(String issuer, String audience, Clock clock) {
        return this.audience().exists((Function1 & Serializable)_$1 -> _$1.contains((Object)audience)) && this.isValid(issuer, clock);
    }

    public boolean isValid(String issuer, Clock clock) {
        return this.issuer().contains((Object)issuer) && this.isValid(clock);
    }

    public boolean isValid(Clock clock) {
        return JwtTime$.MODULE$.nowIsBetweenSeconds(this.notBefore(), this.expiration(), clock);
    }

    public boolean canEqual(Object other) {
        return other instanceof JwtClaim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof JwtClaim)) return false;
        JwtClaim that = (JwtClaim)object;
        if (!that.canEqual(this)) return false;
        String string = this.content();
        String string2 = that.content();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.issuer();
        Option<String> option2 = that.issuer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.subject();
        Option<String> option4 = that.subject();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Set<String>> option5 = this.audience();
        Option<Set<String>> option6 = that.audience();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        Option<Object> option7 = this.expiration();
        Option<Object> option8 = that.expiration();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Object> option9 = this.notBefore();
        Option<Object> option10 = that.notBefore();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Option<Object> option11 = this.issuedAt();
        Option<Object> option12 = that.issuedAt();
        if (option11 == null) {
            if (option12 != null) {
                return false;
            }
        } else if (!option11.equals(option12)) return false;
        Option<String> option13 = this.jwtId();
        Option<String> option14 = that.jwtId();
        if (option13 == null) {
            if (option14 == null) return true;
            return false;
        } else {
            if (!option13.equals(option14)) return false;
            return true;
        }
    }

    public int hashCode() {
        Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Serializable[]{this.content(), this.issuer(), this.subject(), this.audience(), this.expiration(), this.notBefore(), this.issuedAt(), this.jwtId()}));
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)_$2 -> _$2.hashCode())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public String toString() {
        return new StringBuilder(24).append("JwtClaim(").append(this.content()).append(", ").append(this.issuer()).append(", ").append(this.subject()).append(", ").append(this.audience()).append(", ").append(this.expiration()).append(", ").append(this.notBefore()).append(", ").append(this.issuedAt()).append(", ").append(this.jwtId()).append(")").toString();
    }
}

