/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$ES256$;
import pdi.jwt.JwtAlgorithm$ES384$;
import pdi.jwt.JwtAlgorithm$ES512$;
import pdi.jwt.JwtArrayUtils$;
import pdi.jwt.JwtBase64$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtEdDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import pdi.jwt.exceptions.JwtNonSupportedAlgorithm;
import pdi.jwt.exceptions.JwtSignatureFormatException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class JwtUtils$
implements Serializable {
    private static final String ENCODING;
    private static final String RSA;
    private static final String ECDSA;
    private static final String EdDSA;
    public static final JwtUtils$ MODULE$;

    private JwtUtils$() {
    }

    static {
        MODULE$ = new JwtUtils$();
        ENCODING = "UTF-8";
        RSA = "RSA";
        ECDSA = "EC";
        EdDSA = "EdDSA";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtUtils$.class);
    }

    public String ENCODING() {
        return ENCODING;
    }

    public String RSA() {
        return RSA;
    }

    public String ECDSA() {
        return ECDSA;
    }

    public String EdDSA() {
        return EdDSA;
    }

    public String stringify(byte[] arr) {
        return new String(arr, this.ENCODING());
    }

    public byte[] bytify(String str) {
        return str.getBytes(this.ENCODING());
    }

    private String escape(String value) {
        return value.replaceAll("\"", "\\\\\"");
    }

    public String seqToJson(Seq<Object> seq) {
        return ((IterableOnceOps)seq.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Object object;
            Object object2 = x$1;
            if (object2 instanceof String) {
                String value = (String)object2;
                return new StringBuilder(2).append("\"").append(MODULE$.escape(value)).append("\"").toString();
            }
            if (object2 instanceof Boolean) {
                boolean value = BoxesRunTime.unboxToBoolean((Object)object2);
                if (value) {
                    return "true";
                }
                return "false";
            }
            if (object2 instanceof Double) {
                double value = BoxesRunTime.unboxToDouble((Object)object2);
                return BoxesRunTime.boxToDouble((double)value).toString();
            }
            if (object2 instanceof Short) {
                short value = BoxesRunTime.unboxToShort((Object)object2);
                return BoxesRunTime.boxToShort((short)value).toString();
            }
            if (object2 instanceof Float) {
                float value = BoxesRunTime.unboxToFloat((Object)object2);
                return BoxesRunTime.boxToFloat((float)value).toString();
            }
            if (object2 instanceof Long) {
                long value = BoxesRunTime.unboxToLong((Object)object2);
                return BoxesRunTime.boxToLong((long)value).toString();
            }
            if (object2 instanceof Integer) {
                int value = BoxesRunTime.unboxToInt((Object)object2);
                return BoxesRunTime.boxToInteger((int)value).toString();
            }
            if (object2 instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)object2;
                return value.toString();
            }
            if (object2 instanceof BigInt) {
                BigInt value = (BigInt)object2;
                return value.toString();
            }
            if (object2 instanceof Tuple2 && (object = (tuple2 = (Tuple2)object2)._1()) instanceof String) {
                String key = (String)object;
                Object value = tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value), (List)Nil$.MODULE$))));
            }
            if (object2 instanceof Object) {
                Object value = object2;
                return new StringBuilder(2).append("\"").append(MODULE$.escape(value.toString())).append("\"").toString();
            }
            throw new MatchError(object2);
        })).mkString("[", ",", "]");
    }

    public String hashToJson(Seq<Tuple2<String, Object>> hash) {
        return ((IterableOnceOps)hash.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22;
                Object object;
                String string = (String)tuple2._1();
                Object object2 = tuple2._2();
                String key = string;
                if (object2 instanceof String) {
                    String value = (String)object2;
                    return new StringBuilder(5).append("\"").append(MODULE$.escape(key)).append("\":\"").append(MODULE$.escape(value)).append("\"").toString();
                }
                String key2 = string;
                if (object2 instanceof Boolean) {
                    boolean value = BoxesRunTime.unboxToBoolean((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key2)).append("\":").append(value ? "true" : "false").toString();
                }
                String key3 = string;
                if (object2 instanceof Double) {
                    double value = BoxesRunTime.unboxToDouble((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key3)).append("\":").append(BoxesRunTime.boxToDouble((double)value).toString()).toString();
                }
                String key4 = string;
                if (object2 instanceof Short) {
                    short value = BoxesRunTime.unboxToShort((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key4)).append("\":").append(BoxesRunTime.boxToShort((short)value).toString()).toString();
                }
                String key5 = string;
                if (object2 instanceof Float) {
                    float value = BoxesRunTime.unboxToFloat((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key5)).append("\":").append(BoxesRunTime.boxToFloat((float)value).toString()).toString();
                }
                String key6 = string;
                if (object2 instanceof Long) {
                    long value = BoxesRunTime.unboxToLong((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key6)).append("\":").append(BoxesRunTime.boxToLong((long)value).toString()).toString();
                }
                String key7 = string;
                if (object2 instanceof Integer) {
                    int value = BoxesRunTime.unboxToInt((Object)object2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key7)).append("\":").append(BoxesRunTime.boxToInteger((int)value).toString()).toString();
                }
                String key8 = string;
                if (object2 instanceof BigDecimal) {
                    BigDecimal value = (BigDecimal)object2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key8)).append("\":").append(value.toString()).toString();
                }
                String key9 = string;
                if (object2 instanceof BigInt) {
                    BigInt value = (BigInt)object2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key9)).append("\":").append(value.toString()).toString();
                }
                String key10 = string;
                if (object2 instanceof Tuple2 && (object = (tuple22 = (Tuple2)object2)._1()) instanceof String) {
                    String vKey = (String)object;
                    Object vValue = tuple22._2();
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)vKey);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key10)).append("\":").append(MODULE$.hashToJson((Seq<Tuple2<String, Object>>)((Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, vValue), (List)Nil$.MODULE$))))).toString();
                }
                String key11 = string;
                if (object2 instanceof Seq) {
                    Seq value = (Seq)object2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key11)).append("\":").append(MODULE$.seqToJson((Seq<Object>)value)).toString();
                }
                String key12 = string;
                if (object2 instanceof Set) {
                    Set value = (Set)object2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key12)).append("\":").append(MODULE$.seqToJson((Seq<Object>)value.toSeq())).toString();
                }
                String key13 = string;
                if (object2 instanceof Object) {
                    Object value = object2;
                    return new StringBuilder(5).append("\"").append(MODULE$.escape(key13)).append("\":\"").append(MODULE$.escape(value.toString())).append("\"").toString();
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString("{", ",", "}");
    }

    public String mergeJson(String json, Seq<String> jsonSeq) {
        String string;
        String string2 = json.trim();
        if ("".equals(string2)) {
            string = "";
        } else {
            String value = string2;
            string = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(value), 1)), 1);
        }
        String initJson = string;
        return new StringBuilder(2).append("{").append(((IterableOnceOps)jsonSeq.map((Function1 & Serializable)_$1 -> _$1.trim())).fold((Object)initJson, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                String j1 = string;
                String result = string2;
                if (j1.length() < 5) {
                    return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(result), 1)), 1);
                }
                String result2 = string;
                String j2 = string2;
                if (j2.length() < 7) {
                    return result2;
                }
                String j12 = string;
                String j22 = string2;
                return new StringBuilder(1).append(j12).append(",").append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(j22), 1)), 1)).toString();
            }
            throw new MatchError((Object)tuple2);
        })).append("}").toString();
    }

    private byte[] parseKey(String key) {
        return JwtBase64$.MODULE$.decodeNonSafe(key.replaceAll("-----BEGIN ([^-]*)-----|-----END ([^-]*)-----|\\s*", ""));
    }

    private PrivateKey parsePrivateKey(String key, String keyAlgo) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.parseKey(key));
        return KeyFactory.getInstance(keyAlgo).generatePrivate(spec);
    }

    private PublicKey parsePublicKey(String key, String keyAlgo) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(this.parseKey(key));
        return KeyFactory.getInstance(keyAlgo).generatePublic(spec);
    }

    public byte[] sign(byte[] data, SecretKey key, JwtHmacAlgorithm algorithm) {
        Mac mac = Mac.getInstance(algorithm.fullName());
        mac.init(key);
        return mac.doFinal(data);
    }

    public byte[] sign(String data, SecretKey key, JwtHmacAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public byte[] sign(byte[] data, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initSign(key);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            return signer.sign();
        }
        if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algorithm2 = (JwtECDSAAlgorithm)jwtAsymmetricAlgorithm;
            return this.transcodeSignatureToConcat(signer.sign(), this.getSignatureByteArrayLength(algorithm2));
        }
        if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            return signer.sign();
        }
        throw new MatchError((Object)jwtAsymmetricAlgorithm);
    }

    public byte[] sign(String data, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public byte[] sign(byte[] data, String key, JwtAlgorithm algorithm) {
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
            return this.sign(data, (SecretKey)new SecretKeySpec(this.bytify(key), algo.fullName()), algo);
        }
        if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm algo = (JwtRSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key, this.RSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algo = (JwtECDSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key, this.ECDSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm algo = (JwtEdDSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key, this.EdDSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
            JwtUnknownAlgorithm algo = (JwtUnknownAlgorithm)jwtAlgorithm;
            throw new JwtNonSupportedAlgorithm(algo.fullName());
        }
        throw new MatchError((Object)jwtAlgorithm);
    }

    public byte[] sign(String data, String key, JwtAlgorithm algorithm) {
        return this.sign(this.bytify(data), key, algorithm);
    }

    public boolean verify(byte[] data, byte[] signature, SecretKey key, JwtHmacAlgorithm algorithm) {
        return JwtArrayUtils$.MODULE$.constantTimeAreEqual(this.sign(data, key, algorithm), signature);
    }

    public boolean verify(byte[] data, byte[] signature, PublicKey key, JwtAsymmetricAlgorithm algorithm) {
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initVerify(key);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            return signer.verify(signature);
        }
        if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            return signer.verify(this.transcodeSignatureToDER(signature));
        }
        if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            return signer.verify(signature);
        }
        throw new MatchError((Object)jwtAsymmetricAlgorithm);
    }

    public boolean verify(byte[] data, byte[] signature, String key, JwtAlgorithm algorithm) {
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, new SecretKeySpec(this.bytify(key), algo.fullName()), algo);
        }
        if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm algo = (JwtRSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key, this.RSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algo = (JwtECDSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key, this.ECDSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm algo = (JwtEdDSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key, this.EdDSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
            JwtUnknownAlgorithm algo = (JwtUnknownAlgorithm)jwtAlgorithm;
            throw new JwtNonSupportedAlgorithm(algo.fullName());
        }
        throw new MatchError((Object)jwtAlgorithm);
    }

    public boolean verify(String data, String signature, String key, JwtAlgorithm algorithm) {
        return this.verify(this.bytify(data), this.bytify(signature), key, algorithm);
    }

    public int getSignatureByteArrayLength(JwtECDSAAlgorithm algorithm) {
        JwtECDSAAlgorithm jwtECDSAAlgorithm = algorithm;
        if (JwtAlgorithm$ES256$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 64;
        }
        if (JwtAlgorithm$ES384$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 96;
        }
        if (JwtAlgorithm$ES512$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 132;
        }
        throw new MatchError((Object)jwtECDSAAlgorithm);
    }

    public byte[] transcodeSignatureToConcat(byte[] derSignature, int outputLength) throws JwtSignatureFormatException {
        int sLength;
        int j;
        int rLength;
        int i;
        int n;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte by = derSignature[1];
        byte s = by;
        if (s > 0) {
            n = 2;
        } else {
            byte s2 = by;
            if (s2 == (byte)129) {
                n = 3;
            } else {
                throw new JwtSignatureFormatException("Invalid ECDSA signature format");
            }
        }
        int offset = n;
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(Math.max(i, j), outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public byte[] transcodeSignatureToDER(byte[] signature) throws JwtSignatureFormatException {
        int signatureLength;
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(signature);
        Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, signature.length / 2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] r = (byte[])tuple2._1();
        byte[] s = (byte[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)r, (Object)s);
        byte[] r2 = (byte[])tuple22._1();
        byte[] s2 = (byte[])tuple22._2();
        Object object3 = Predef$.MODULE$.byteArrayOps(r2);
        r2 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(object3, (Function1 & Serializable)_$2 -> JwtUtils$.transcodeSignatureToDER$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$2)));
        if (r2.length > 0 && r2[0] < 0) {
            Object object4 = Predef$.MODULE$.byteArrayOps(r2);
            r2 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(object4, (Object)BoxesRunTime.boxToByte((byte)((byte)0)), ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        if ((s2 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(object = Predef$.MODULE$.byteArrayOps(s2), (Function1 & Serializable)_$3 -> JwtUtils$.transcodeSignatureToDER$$anonfun$2(BoxesRunTime.unboxToByte((Object)_$3)))).length > 0 && s2[0] < 0) {
            Object object5 = Predef$.MODULE$.byteArrayOps(s2);
            s2 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(object5, (Object)BoxesRunTime.boxToByte((byte)((byte)0)), ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        if ((signatureLength = 2 + r2.length + 2 + s2.length) > 255) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        ListBuffer signatureDER = ListBuffer$.MODULE$.empty();
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)48));
        if (signatureLength >= 128) {
            signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)129)));
        }
        signatureDER.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)signatureLength)));
        signatureDER.$plus$plus$eq((IterableOnce)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToByte((byte)((byte)2)), (List)new .colon.colon((Object)BoxesRunTime.boxToByte((byte)((byte)r2.length)), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapByteArray(r2)));
        signatureDER.$plus$plus$eq((IterableOnce)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToByte((byte)((byte)2)), (List)new .colon.colon((Object)BoxesRunTime.boxToByte((byte)((byte)s2.length)), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapByteArray(s2)));
        return (byte[])signatureDER.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public String[] splitString(String input, char separator) {
        ArrayBuffer builder = ArrayBuffer$.MODULE$.empty();
        int lastIndex = 0;
        int index = input.indexOf(separator, lastIndex);
        while (index != -1) {
            builder.$plus$eq((Object)input.substring(lastIndex, index));
            lastIndex = index + 1;
            index = input.indexOf(separator, lastIndex);
        }
        if (lastIndex < input.length()) {
            builder.$plus$eq((Object)input.substring(lastIndex, input.length()));
        }
        return (String[])builder.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private static final /* synthetic */ boolean transcodeSignatureToDER$$anonfun$1(byte _$2) {
        return _$2 == 0;
    }

    private static final /* synthetic */ boolean transcodeSignatureToDER$$anonfun$2(byte _$3) {
        return _$3 == 0;
    }
}

