/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.filter.Filter;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.XMLPart;
import com.elixirtech.opc.docprocessor.Comment;
import com.elixirtech.opc.docprocessor.Processor;
import com.elixirtech.opc.docprocessor.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommentHandler {
    private final Package m_Package;
    private Map<String, String> m_CommentInfo;
    private List<Comment> m_Comments = new ArrayList<Comment>();

    public CommentHandler(Package package_) {
        this.m_Package = package_;
        this.loadCommentInfo();
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/word/document.xml");
        if (xMLPart != null) {
            Element element = xMLPart.getDocument().getRootElement();
            Element element2 = element.getChild("body", Processor.NS_W);
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<Fixup> arrayList = new ArrayList<Fixup>();
            Iterator iterator = element2.getDescendants();
            while (iterator.hasNext()) {
                String string;
                Object object = iterator.next();
                if (!(object instanceof Element)) continue;
                Element object2 = (Element)object;
                if (XMLUtil.equals(object2, "commentRangeStart", Processor.NS_W)) {
                    string = object2.getAttributeValue("id", Processor.NS_W);
                    this.m_Comments.add(new Comment(object2, string, this.m_CommentInfo.get(string)));
                    hashSet.add(string);
                    continue;
                }
                if (!XMLUtil.equals(object2, "commentReference", Processor.NS_W) || hashSet.contains(string = object2.getAttributeValue("id", Processor.NS_W))) continue;
                Element element3 = new Element("commentRangeStart", Processor.NS_W);
                element3.setAttribute("id", string, Processor.NS_W);
                Element element4 = (Element)object2.getParent();
                arrayList.add(new Fixup(element4, element3));
                this.m_Comments.add(new Comment(element3, string, this.m_CommentInfo.get(string)));
            }
            for (Fixup fixup : arrayList) {
                fixup.fix();
            }
            this.adjustComments();
        }
    }

    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.m_Comments);
    }

    public String getComment(String string) {
        return this.m_CommentInfo.get(string);
    }

    private void adjustComments() {
        for (Comment comment : this.m_Comments) {
            if (comment.getText().startsWith("/Elx/RenderIf")) continue;
            this.moveToTableRowOrPara(comment);
        }
    }

    private void moveToTableRowOrPara(Comment comment) {
        List<Element> list = XMLUtil.ancestors(comment.getElement());
        for (Element element : list) {
            if (!XMLUtil.equals(element, "tr", Processor.NS_W)) continue;
            comment.removeFromDocument();
            if (this.isFirstRow(element)) {
                XMLUtil.insertBefore((Element)element.getParent(), comment.getElement());
            } else {
                XMLUtil.insertBefore(element, comment.getElement());
            }
            return;
        }
        for (Element element : list) {
            if (!XMLUtil.equals(element, "p", Processor.NS_W)) continue;
            comment.removeFromDocument();
            XMLUtil.insertBefore(element, comment.getElement());
            break;
        }
    }

    private boolean isFirstRow(Element element) {
        Element element2 = XMLUtil.previousSibling(element);
        return element2 == null || !element2.getName().equals("tr");
    }

    private void loadCommentInfo() {
        this.m_CommentInfo = new HashMap<String, String>();
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/word/comments.xml");
        if (xMLPart != null) {
            Element element = xMLPart.getDocument().getRootElement();
            for (Element element2 : element.getChildren("comment", Processor.NS_W)) {
                String string = element2.getAttributeValue("id", Processor.NS_W);
                String string2 = CommentHandler.concatText(element2.getDescendants((Filter)new WTextFilter()));
                this.m_CommentInfo.put(string, string2);
            }
        }
    }

    static String concatText(Iterator<?> iterator) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            stringBuilder.append(element.getText());
        }
        return stringBuilder.toString();
    }

    private static class Fixup {
        public Element target;
        public Element missing;

        public Fixup(Element element, Element element2) {
            this.target = element;
            this.missing = element2;
        }

        public void fix() {
            XMLUtil.insertBefore(this.target, this.missing);
        }
    }

    private static class WTextFilter
    implements Filter {
        private WTextFilter() {
        }

        public boolean matches(Object object) {
            return object instanceof Element && XMLUtil.equals((Element)object, "t", Processor.NS_W);
        }
    }
}

