/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Node {
    private final String m_Name;
    private Map<String, Node> m_Children;

    public Node(Node node, String string) {
        this.m_Name = string;
        if (node != null) {
            node.addChild(this);
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean hasChildren() {
        return this.m_Children != null && !this.m_Children.isEmpty();
    }

    public void addChild(Node node) {
        if (this.m_Children == null) {
            this.m_Children = new LinkedHashMap<String, Node>();
        }
        this.m_Children.put(node.getName(), node);
    }

    public Node getChild(String string) {
        if (this.m_Children == null) {
            return null;
        }
        return this.m_Children.get(string);
    }

    public Node buildChild(String string) {
        Node node = this.getChild(string);
        if (node == null) {
            node = new Node(this, string);
        }
        return node;
    }

    public Collection<Node> children() {
        if (this.m_Children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.m_Children.values());
    }

    public String getChildText() {
        if (this.m_Children == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.getChild();
        if (node != null) {
            node.getSelfAndChildText(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String getFullText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.getSelfAndChildText(stringBuilder);
        return stringBuilder.toString();
    }

    public void getSelfAndChildText(StringBuilder stringBuilder) {
        stringBuilder.append(this.m_Name);
        Node node = this.getChild();
        if (node != null) {
            stringBuilder.append('/');
            node.getSelfAndChildText(stringBuilder);
        }
    }

    public Node getChild() {
        if (this.m_Children == null) {
            return null;
        }
        return this.m_Children.values().iterator().next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(this.m_Name);
        Collection<Node> collection = this.children();
        if (!collection.isEmpty()) {
            stringBuilder.append("{\n");
            int n2 = n + 1;
            for (Node node : collection) {
                node.toString(stringBuilder, n2);
            }
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("}");
        }
        stringBuilder.append('\n');
    }
}

