/*
 * Decompiled with CFR 0.152.
 */
package ambience.kanban;

import ambience.api.Workflow;
import ambience.form.designer.WorkflowIntegration$;
import ambience.framework.URFilter2$;
import ambience.kanban.Choice;
import ambience.kanban.DragInfo;
import ambience.kanban.KanbanColumn$;
import ambience.kanban.KanbanColumns;
import ambience.kanban.KanbanColumns$;
import ambience.kanban.KanbanItem;
import ambience.kanban.KanbanItem$;
import ambience.kanban.WorkflowInterface$SMEdge$;
import ambience.kanban.WorkflowInterface$SMGraph$;
import ambience.kanban.WorkflowInterface$SMName$;
import ambience.kanban.WorkflowInterface$SMNameGraph$;
import ambience.kanban.WorkflowInterface$SMNode$;
import ambience.kanban.WorkflowInterface$StateMachineGraphs$;
import ambience.kanban.WorkflowInterface$StateMachineNames$;
import ambience.kanban.WorkflowInterface$WFIState$;
import ambience.kanban.WorkflowInterface$WFInstance$;
import ambience.kanban.management.BuildFormAndWorkflowChoices$;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class WorkflowInterface
implements LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInterface.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInterface.class.getDeclaredField("api$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WorkflowInterface.class.getDeclaredField("workflows$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private volatile Object workflows$lzy1;
    private volatile Object api$lzy1;

    public WorkflowInterface(MongoDB mongoDB) {
        this.mongoDB = mongoDB;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RichMongoCollection workflows() {
        Object object = this.workflows$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.workflows$lzyINIT1();
    }

    private Object workflows$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.workflows$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB.database().getCollection("Workflows", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.workflows$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Workflow api() {
        Object object = this.api$lzy1;
        if (object instanceof Workflow) {
            return (Workflow)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Workflow)this.api$lzyINIT1();
    }

    private Object api$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.api$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Workflow workflow = null;
                    try {
                        workflow = (Workflow)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Workflow.class));
                        object2 = workflow == null ? LazyVals.NullValue$.MODULE$ : workflow;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.api$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return workflow;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<List<Choice>> buildWorkflowChoices(UserDB.User user) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> this.workflows().findO((Bson)filter).filter((Function1 & Serializable)doc -> this.hasKanban((Document)doc)).flatMap((Function1 & Serializable)doc -> BuildFormAndWorkflowChoices$.MODULE$.buildChoice((Document)doc)).toListL().map((Function1 & Serializable)_$1 -> (List)_$1.sortBy((Function1 & Serializable)_$2 -> _$2.name(), (Ordering)Ordering.String$.MODULE$)));
    }

    public boolean hasKanban(Document doc) {
        WorkflowInterface$StateMachineNames$ mirror$proxy1 = WorkflowInterface$StateMachineNames$.MODULE$;
        String string = "stateMachines";
        boolean size = true;
        Either either = package$.MODULE$.decode(doc.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("StateMachineNames", WorkflowInterface::hasKanban$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy1, Default$.MODULE$.inline$of(WorkflowInterface::hasKanban$$anonfun$2)))));
        if (either instanceof Right) {
            StateMachineNames smn = (StateMachineNames)((Right)either).value();
            return smn.stateMachines().exists((Function1 & Serializable)_$3 -> {
                String string = _$3.name();
                String string2 = "Kanban";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            this.log().warn(() -> WorkflowInterface.hasKanban$$anonfun$4(doc, err), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.hasKanban"));
            return false;
        }
        throw new MatchError((Object)either);
    }

    public Task<Option<KanbanColumns>> buildColumns(UserDB.User user, String kanbanId, String workflowId) {
        return URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> this.workflows().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("_id", (Object)workflowId), filter}))).firstOptionL().flatMap((Function1 & Serializable)optwf -> ((Task)optwf.map((Function1 & Serializable)wf -> this.buildColumns(kanbanId, (Document)wf)).getOrElse(WorkflowInterface::buildColumns$$anonfun$1$$anonfun$1$$anonfun$2)).map((Function1 & Serializable)reply -> reply)));
    }

    public Task<Option<KanbanColumns>> buildColumns(String kanbanId, Document wf) {
        WorkflowInterface$StateMachineGraphs$ mirror$proxy3 = WorkflowInterface$StateMachineGraphs$.MODULE$;
        String string = "database";
        String string2 = "collection";
        String string3 = "stateMachines";
        int size = 3;
        Either either = package$.MODULE$.decode(wf.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("StateMachineGraphs", WorkflowInterface::buildColumns$$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy3, Default$.MODULE$.inline$of(WorkflowInterface::buildColumns$$anonfun$3)))));
        if (either instanceof Right) {
            StateMachineGraphs graphs = (StateMachineGraphs)((Right)either).value();
            return this.buildColumns(kanbanId, graphs);
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            this.log().warn(() -> WorkflowInterface.buildColumns$$anonfun$4(wf, err), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.buildColumns"));
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)either);
    }

    public Task<Option<KanbanColumns>> buildColumns(String kanbanId, StateMachineGraphs graphs) {
        Option option = graphs.stateMachines().find((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = "Kanban";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            SMNameGraph ng = (SMNameGraph)((Some)option).value();
            KanbanColumns emptyCols = this.buildColumns(ng.graph());
            return this.loadRecords(kanbanId, graphs.database(), graphs.collection()).foldLeft(() -> WorkflowInterface.buildColumns$$anonfun$6(emptyCols), (Function2 & Serializable)(x$12, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
                if (tuple2 != null) {
                    KanbanColumns cols = (KanbanColumns)tuple2._1();
                    Document record = (Document)tuple2._2();
                    return (KanbanColumns)this.buildItem(ng, record).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            int nodeId = BoxesRunTime.unboxToInt((Object)tuple2._1());
                            KanbanItem item = (KanbanItem)tuple2._2();
                            return cols.addItem(nodeId, item);
                        }
                        throw new MatchError((Object)tuple2);
                    }).getOrElse(() -> WorkflowInterface.buildColumns$$anonfun$7$$anonfun$2(cols));
                }
                throw new MatchError((Object)tuple2);
            }).firstOptionL();
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Option<Tuple2<Object, KanbanItem>> buildItem(SMNameGraph ng, Document doc) {
        WorkflowInterface$WFInstance$ mirror$proxy8 = WorkflowInterface$WFInstance$.MODULE$;
        String string = "_id";
        String string2 = "workflowId";
        String string3 = "states";
        int size = 3;
        Either either = package$.MODULE$.decode(doc.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("WFInstance", WorkflowInterface::buildItem$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy8, Default$.MODULE$.inline$of(WorkflowInterface::buildItem$$anonfun$2)))));
        if (either instanceof Right) {
            WFInstance wfi = (WFInstance)((Right)either).value();
            Option optNode = wfi.states().find((Function1 & Serializable)_$5 -> {
                String string = _$5.stateMachineId();
                String string2 = ng.id();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).flatMap((Function1 & Serializable)state -> ng.graph().nodes().find((Function1 & Serializable)_$6 -> _$6.id() == state.nodeId()));
            return optNode.flatMap((Function1 & Serializable)node -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$7 -> _$7.getValue()).flatMap((Function1 & Serializable)formId -> doc.get("elxPublic", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)_$8 -> Document$.MODULE$.apply(_$8)).flatMap((Function1 & Serializable)elxPublic -> elxPublic.get("kanbanLabel", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).flatMap((Function1 & Serializable)label -> Some$.MODULE$.apply(elxPublic.get("kanbanClass", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$10 -> _$10.getValue()).getOrElse(WorkflowInterface::buildItem$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2)).flatMap((Function1 & Serializable)clsName -> Some$.MODULE$.apply(elxPublic.get("kanbanStyle", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$11 -> _$11.getValue()).getOrElse(WorkflowInterface::buildItem$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2)).map((Function1 & Serializable)style -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)node.id()), (Object)KanbanItem$.MODULE$.apply(label, clsName, style, formId))))))));
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            this.log().warn(() -> WorkflowInterface.buildItem$$anonfun$4(doc, err), Line$.MODULE$.apply(104), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.buildItem"));
            return None$.MODULE$;
        }
        throw new MatchError((Object)either);
    }

    public KanbanColumns buildColumns(SMGraph graph) {
        Map startColumnsMap = graph.edges().filter((Function1 & Serializable)_$12 -> _$12.from() == 0).map((Function1 & Serializable)e -> {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)e.to()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)e.actualEvent());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        List superStates = graph.nodes().flatMap((Function1 & Serializable)node -> node.superState());
        List leaves = graph.nodes().filter((Function1 & Serializable)_$13 -> _$13.stateType().isEmpty()).filterNot((Function1 & Serializable)n -> superStates.contains((Object)BoxesRunTime.boxToInteger((int)n.id())));
        List columns = leaves.map((Function1 & Serializable)leaf -> {
            Map transitionsGroups = graph.edges().filter((Function1 & Serializable)_$14 -> _$14.from() == leaf.id()).groupBy((Function1 & Serializable)_$15 -> _$15.to());
            Map transitionsTo = (Map)transitionsGroups.flatMap((Function1 & Serializable)pair -> this.constrainTo((Tuple2<Object, List<SMEdge>>)pair));
            return KanbanColumn$.MODULE$.apply(leaf.id(), leaf.label(), startColumnsMap.get((Object)BoxesRunTime.boxToInteger((int)leaf.id())), transitionsTo, KanbanColumn$.MODULE$.$lessinit$greater$default$5());
        });
        return KanbanColumns$.MODULE$.apply(columns);
    }

    public Option<Tuple2<Object, String>> constrainTo(Tuple2<Object, List<SMEdge>> pair) {
        List list = (List)pair._2();
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            SMEdge head = (SMEdge)colon2.head();
            Nil$ nil$2 = scala.package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(pair._1(), (Object)head.actualEvent()));
            }
        }
        List list5 = list;
        return this.constrainList((List<SMEdge>)list5).map((Function1 & Serializable)choice -> Tuple2$.MODULE$.apply(pair._1(), (Object)choice.actualEvent()));
    }

    public Option<SMEdge> constrainList(List<SMEdge> choices) {
        List list = choices.filter((Function1 & Serializable)_$16 -> _$16.actualEvent().startsWith("kanban"));
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            SMEdge head = (SMEdge)colon2.head();
            Nil$ nil$2 = scala.package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return Some$.MODULE$.apply((Object)head);
            }
        }
        return None$.MODULE$;
    }

    public Observable<Document> loadRecords(String kanbanId, String database, String collection) {
        this.log().info(() -> WorkflowInterface.loadRecords$$anonfun$1(kanbanId, database, collection), Line$.MODULE$.apply(139), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.loadRecords"));
        RichMongoCollection cltn = new RichMongoCollection(this.mongoDB.mongoClient().getDatabase(database).getCollection(collection, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return cltn.findO(Filters$.MODULE$.or((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.exists("elxPublic.kanbanId", false), Filters$.MODULE$.eq("elxPublic.kanbanId", (Object)kanbanId)})));
    }

    public Task<Either<String, Json>> createForm(UserDB.User user, String kanbanId, String workflowId, String eventName) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"kanbanId");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(kanbanId));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        EitherT reply = EitherT$.MODULE$.apply((Object)this.api().sendCreate(user, Workflow.WorkflowId$.MODULE$.apply(workflowId), Workflow.Event$.MODULE$.apply(eventName, json)).map((Function1 & Serializable)_$17 -> _$17.left().map((Function1 & Serializable)_$18 -> _$18 == null ? null : ((Workflow.FailureResult)_$18).msg()))).flatMap((Function1 & Serializable)wf -> EitherT$.MODULE$.apply((Object)WorkflowIntegration$.MODULE$.loadPublic(user, workflowId, wf.id())).map((Function1 & Serializable)formContent -> formContent, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return (Task)reply.value();
    }

    public Task<Either<String, Json>> getForm(UserDB.User user, String workflowId, String workflowInstanceId) {
        return WorkflowIntegration$.MODULE$.loadPublic(user, workflowId, workflowInstanceId);
    }

    public Task<Either<String, KanbanColumns>> drag(UserDB.User user, DragInfo dragInfo) {
        String wf = Workflow.WorkflowId$.MODULE$.apply(dragInfo.workflowId());
        String wfi = Workflow.WorkflowInstanceId$.MODULE$.apply(dragInfo.workflowInstanceId());
        Workflow.Event event = Workflow.Event$.MODULE$.apply(Workflow.EventName$.MODULE$.apply(dragInfo.eventName()), Workflow.Event$.MODULE$.$lessinit$greater$default$2());
        return this.api().sendEvent(user, wf, wfi, event).flatMap((Function1 & Serializable)x$12 -> {
            Either either = x$12;
            if (either instanceof Right) {
                Workflow.SuccessResult v = (Workflow.SuccessResult)((Right)either).value();
                this.log().info(WorkflowInterface::drag$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(163), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.drag"));
                return this.buildColumns(user, dragInfo.kanbanId(), dragInfo.workflowId()).map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        KanbanColumns cols = (KanbanColumns)((Some)option).value();
                        return scala.package$.MODULE$.Right().apply((Object)cols);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return scala.package$.MODULE$.Left().apply((Object)"Can't build columns");
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (either instanceof Left) {
                Object object = ((Left)either).value();
                String err = object == null ? null : ((Workflow.FailureResult)object).msg();
                this.log().error(() -> WorkflowInterface.drag$$anonfun$1$$anonfun$3(dragInfo, err), Line$.MODULE$.apply(169), FullName$.MODULE$.apply("ambience.kanban.WorkflowInterface.drag"));
                return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)err));
            }
            throw new MatchError((Object)either);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$2() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List hasKanban$$anonfun$1() {
        void var1_3;
        WorkflowInterface$SMName$ mirror$proxy2 = WorkflowInterface$SMName$.MODULE$;
        String string = "name";
        boolean size = true;
        Decoder decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("SMName", WorkflowInterface::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy2, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$2)))));
        void var0_4 = var1_3;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_4);
    }

    private static final Product hasKanban$$anonfun$2() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    private static final Object hasKanban$$anonfun$4(Document doc$1, Error err$1) {
        return "Can't decode workflow " + doc$1.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)) + " " + err$1;
    }

    private static final Task buildColumns$$anonfun$1$$anonfun$1$$anonfun$2() {
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeInt();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeJson());
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeInt());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$6() {
        return Tuple4$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$7() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeInt();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeInt();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$8() {
        return Tuple4$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$4() {
        Decoder decodeA;
        void var1_6;
        WorkflowInterface$SMNode$ mirror$proxy6 = WorkflowInterface$SMNode$.MODULE$;
        String string = "id";
        String string2 = "label";
        String string3 = "stateType";
        String string4 = "superState";
        int size = 4;
        Decoder decodeA2 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("SMNode", WorkflowInterface::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy6, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$6)))));
        void var0_7 = var1_6;
        WorkflowInterface$SMEdge$ mirror$proxy7 = WorkflowInterface$SMEdge$.MODULE$;
        String string5 = "from";
        String string6 = "to";
        String string7 = "label";
        String string8 = "event";
        int size2 = 4;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("SMEdge", WorkflowInterface::$anonfun$7, scala.package$.MODULE$.Nil().$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5), Configuration$.MODULE$.default(), (Mirror)mirror$proxy7, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$8)))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var0_7);
    }

    private static final Product $anonfun$9() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        WorkflowInterface$SMGraph$ mirror$proxy5 = WorkflowInterface$SMGraph$.MODULE$;
        String string = "nodes";
        String string2 = "edges";
        int size = 2;
        Decoder decoder = decodeA = Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("SMGraph", WorkflowInterface::$anonfun$4, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy5, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$9))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$10() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildColumns$$anonfun$2() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        WorkflowInterface$SMNameGraph$ mirror$proxy4 = WorkflowInterface$SMNameGraph$.MODULE$;
        String string = "id";
        String string2 = "name";
        String string3 = "graph";
        int size = 3;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("SMNameGraph", WorkflowInterface::$anonfun$3, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy4, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$10)))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product buildColumns$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object buildColumns$$anonfun$4(Document wf$1, Error err$2) {
        return "Can't decode workflow graph " + wf$1.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)) + " " + err$2;
    }

    private static final KanbanColumns buildColumns$$anonfun$6(KanbanColumns emptyCols$1) {
        return emptyCols$1;
    }

    private static final KanbanColumns buildColumns$$anonfun$7$$anonfun$2(KanbanColumns cols$2) {
        return cols$2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$11() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeInt();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product $anonfun$12() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildItem$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        WorkflowInterface$WFIState$ mirror$proxy9 = WorkflowInterface$WFIState$.MODULE$;
        String string = "stateMachineId";
        String string2 = "nodeId";
        int size = 2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$of("WFIState", WorkflowInterface::$anonfun$11, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default(), (Mirror)mirror$proxy9, Default$.MODULE$.inline$of(WorkflowInterface::$anonfun$12)))));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Product buildItem$$anonfun$2() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final String buildItem$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2() {
        return "";
    }

    private static final String buildItem$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$2() {
        return "";
    }

    private static final Object buildItem$$anonfun$4(Document doc$4, Error err$3) {
        return "Can't decode workflowInstance " + doc$4.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)) + " " + err$3;
    }

    private static final Object loadRecords$$anonfun$1(String kanbanId$4, String database$1, String collection$1) {
        return "Loading records for " + kanbanId$4 + " from " + database$1 + " " + collection$1;
    }

    private static final Object drag$$anonfun$1$$anonfun$1() {
        return "drag event completed, building columns";
    }

    private static final Object drag$$anonfun$1$$anonfun$3(DragInfo dragInfo$2, String err$4) {
        return "Error in drag handling for event " + dragInfo$2.eventName() + ": " + new Workflow.FailureResult(err$4);
    }

    public static final class SMEdge
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SMEdge.class.getDeclaredField("actualEvent$lzy1"));
        private final int from;
        private final int to;
        private final String label;
        private final Option event;
        private volatile Object actualEvent$lzy1;

        public static SMEdge apply(int n, int n2, String string, Option<String> option) {
            return WorkflowInterface$SMEdge$.MODULE$.apply(n, n2, string, option);
        }

        public static SMEdge fromProduct(Product product) {
            return WorkflowInterface$SMEdge$.MODULE$.fromProduct(product);
        }

        public static SMEdge unapply(SMEdge sMEdge) {
            return WorkflowInterface$SMEdge$.MODULE$.unapply(sMEdge);
        }

        public SMEdge(int from, int to, String label, Option<String> event) {
            this.from = from;
            this.to = to;
            this.label = label;
            this.event = event;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.from());
            n = Statics.mix((int)n, (int)this.to());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.label()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.event()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SMEdge)) return false;
            SMEdge sMEdge = (SMEdge)object;
            if (this.from() != sMEdge.from()) return false;
            if (this.to() != sMEdge.to()) return false;
            String string = this.label();
            String string2 = sMEdge.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.event();
            Option<String> option2 = sMEdge.event();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SMEdge;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SMEdge";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "from";
                }
                case 1: {
                    return "to";
                }
                case 2: {
                    return "label";
                }
                case 3: {
                    return "event";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }

        public String label() {
            return this.label;
        }

        public Option<String> event() {
            return this.event;
        }

        public String actualEvent() {
            Object object = this.actualEvent$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.actualEvent$lzyINIT1();
        }

        private Object actualEvent$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.actualEvent$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = (String)this.event().getOrElse(this::actualEvent$lzyINIT1$$anonfun$1);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.actualEvent$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public SMEdge copy(int from, int to, String label, Option<String> event) {
            return new SMEdge(from, to, label, event);
        }

        public int copy$default$1() {
            return this.from();
        }

        public int copy$default$2() {
            return this.to();
        }

        public String copy$default$3() {
            return this.label();
        }

        public Option<String> copy$default$4() {
            return this.event();
        }

        public int _1() {
            return this.from();
        }

        public int _2() {
            return this.to();
        }

        public String _3() {
            return this.label();
        }

        public Option<String> _4() {
            return this.event();
        }

        private final String actualEvent$lzyINIT1$$anonfun$1() {
            return this.label();
        }
    }

    public static final class SMGraph
    implements Product,
    Serializable {
        private final List nodes;
        private final List edges;

        public static SMGraph apply(List<SMNode> list, List<SMEdge> list2) {
            return WorkflowInterface$SMGraph$.MODULE$.apply(list, list2);
        }

        public static SMGraph fromProduct(Product product) {
            return WorkflowInterface$SMGraph$.MODULE$.fromProduct(product);
        }

        public static SMGraph unapply(SMGraph sMGraph) {
            return WorkflowInterface$SMGraph$.MODULE$.unapply(sMGraph);
        }

        public SMGraph(List<SMNode> nodes, List<SMEdge> edges) {
            this.nodes = nodes;
            this.edges = edges;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SMGraph)) return false;
            SMGraph sMGraph = (SMGraph)object;
            List<SMNode> list = this.nodes();
            List<SMNode> list2 = sMGraph.nodes();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<SMEdge> list3 = this.edges();
            List<SMEdge> list4 = sMGraph.edges();
            if (list3 == null) {
                if (list4 == null) return true;
                return false;
            } else {
                if (!list3.equals(list4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SMGraph;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SMGraph";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "nodes";
            }
            if (1 == n2) {
                return "edges";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<SMNode> nodes() {
            return this.nodes;
        }

        public List<SMEdge> edges() {
            return this.edges;
        }

        public SMGraph copy(List<SMNode> nodes, List<SMEdge> edges) {
            return new SMGraph(nodes, edges);
        }

        public List<SMNode> copy$default$1() {
            return this.nodes();
        }

        public List<SMEdge> copy$default$2() {
            return this.edges();
        }

        public List<SMNode> _1() {
            return this.nodes();
        }

        public List<SMEdge> _2() {
            return this.edges();
        }
    }

    public static final class SMName
    implements Product,
    Serializable {
        private final String name;

        public static SMName apply(String string) {
            return WorkflowInterface$SMName$.MODULE$.apply(string);
        }

        public static SMName fromProduct(Product product) {
            return WorkflowInterface$SMName$.MODULE$.fromProduct(product);
        }

        public static SMName unapply(SMName sMName) {
            return WorkflowInterface$SMName$.MODULE$.unapply(sMName);
        }

        public SMName(String name) {
            this.name = name;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SMName)) return false;
            SMName sMName = (SMName)object;
            String string = this.name();
            String string2 = sMName.name();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SMName;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SMName";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public SMName copy(String name) {
            return new SMName(name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }
    }

    public static final class SMNameGraph
    implements Product,
    Serializable {
        private final String id;
        private final String name;
        private final SMGraph graph;

        public static SMNameGraph apply(String string, String string2, SMGraph sMGraph) {
            return WorkflowInterface$SMNameGraph$.MODULE$.apply(string, string2, sMGraph);
        }

        public static SMNameGraph fromProduct(Product product) {
            return WorkflowInterface$SMNameGraph$.MODULE$.fromProduct(product);
        }

        public static SMNameGraph unapply(SMNameGraph sMNameGraph) {
            return WorkflowInterface$SMNameGraph$.MODULE$.unapply(sMNameGraph);
        }

        public SMNameGraph(String id, String name, SMGraph graph) {
            this.id = id;
            this.name = name;
            this.graph = graph;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SMNameGraph)) return false;
            SMNameGraph sMNameGraph = (SMNameGraph)object;
            String string = this.id();
            String string2 = sMNameGraph.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = sMNameGraph.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            SMGraph sMGraph = this.graph();
            SMGraph sMGraph2 = sMNameGraph.graph();
            if (sMGraph == null) {
                if (sMGraph2 == null) return true;
                return false;
            } else {
                if (!((Object)sMGraph).equals(sMGraph2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SMNameGraph;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SMNameGraph";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "graph";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public SMGraph graph() {
            return this.graph;
        }

        public SMNameGraph copy(String id, String name, SMGraph graph) {
            return new SMNameGraph(id, name, graph);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public SMGraph copy$default$3() {
            return this.graph();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }

        public SMGraph _3() {
            return this.graph();
        }
    }

    public static final class SMNode
    implements Product,
    Serializable {
        private final int id;
        private final String label;
        private final Option stateType;
        private final Option superState;

        public static SMNode apply(int n, String string, Option<Json> option, Option<Object> option2) {
            return WorkflowInterface$SMNode$.MODULE$.apply(n, string, option, option2);
        }

        public static SMNode fromProduct(Product product) {
            return WorkflowInterface$SMNode$.MODULE$.fromProduct(product);
        }

        public static SMNode unapply(SMNode sMNode) {
            return WorkflowInterface$SMNode$.MODULE$.unapply(sMNode);
        }

        public SMNode(int id, String label, Option<Json> stateType, Option<Object> superState) {
            this.id = id;
            this.label = label;
            this.stateType = stateType;
            this.superState = superState;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.id());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.label()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stateType()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.superState()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SMNode)) return false;
            SMNode sMNode = (SMNode)object;
            if (this.id() != sMNode.id()) return false;
            String string = this.label();
            String string2 = sMNode.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Json> option = this.stateType();
            Option<Json> option2 = sMNode.stateType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.superState();
            Option<Object> option4 = sMNode.superState();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SMNode;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SMNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "label";
                }
                case 2: {
                    return "stateType";
                }
                case 3: {
                    return "superState";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int id() {
            return this.id;
        }

        public String label() {
            return this.label;
        }

        public Option<Json> stateType() {
            return this.stateType;
        }

        public Option<Object> superState() {
            return this.superState;
        }

        public SMNode copy(int id, String label, Option<Json> stateType, Option<Object> superState) {
            return new SMNode(id, label, stateType, superState);
        }

        public int copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.label();
        }

        public Option<Json> copy$default$3() {
            return this.stateType();
        }

        public Option<Object> copy$default$4() {
            return this.superState();
        }

        public int _1() {
            return this.id();
        }

        public String _2() {
            return this.label();
        }

        public Option<Json> _3() {
            return this.stateType();
        }

        public Option<Object> _4() {
            return this.superState();
        }
    }

    public static final class StateMachineGraphs
    implements Product,
    Serializable {
        private final String database;
        private final String collection;
        private final List stateMachines;

        public static StateMachineGraphs apply(String string, String string2, List<SMNameGraph> list) {
            return WorkflowInterface$StateMachineGraphs$.MODULE$.apply(string, string2, list);
        }

        public static StateMachineGraphs fromProduct(Product product) {
            return WorkflowInterface$StateMachineGraphs$.MODULE$.fromProduct(product);
        }

        public static StateMachineGraphs unapply(StateMachineGraphs stateMachineGraphs) {
            return WorkflowInterface$StateMachineGraphs$.MODULE$.unapply(stateMachineGraphs);
        }

        public StateMachineGraphs(String database, String collection, List<SMNameGraph> stateMachines) {
            this.database = database;
            this.collection = collection;
            this.stateMachines = stateMachines;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StateMachineGraphs)) return false;
            StateMachineGraphs stateMachineGraphs = (StateMachineGraphs)object;
            String string = this.database();
            String string2 = stateMachineGraphs.database();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.collection();
            String string4 = stateMachineGraphs.collection();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            List<SMNameGraph> list = this.stateMachines();
            List<SMNameGraph> list2 = stateMachineGraphs.stateMachines();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StateMachineGraphs;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StateMachineGraphs";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "database";
                }
                case 1: {
                    return "collection";
                }
                case 2: {
                    return "stateMachines";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String database() {
            return this.database;
        }

        public String collection() {
            return this.collection;
        }

        public List<SMNameGraph> stateMachines() {
            return this.stateMachines;
        }

        public StateMachineGraphs copy(String database, String collection, List<SMNameGraph> stateMachines) {
            return new StateMachineGraphs(database, collection, stateMachines);
        }

        public String copy$default$1() {
            return this.database();
        }

        public String copy$default$2() {
            return this.collection();
        }

        public List<SMNameGraph> copy$default$3() {
            return this.stateMachines();
        }

        public String _1() {
            return this.database();
        }

        public String _2() {
            return this.collection();
        }

        public List<SMNameGraph> _3() {
            return this.stateMachines();
        }
    }

    public static final class StateMachineNames
    implements Product,
    Serializable {
        private final List stateMachines;

        public static StateMachineNames apply(List<SMName> list) {
            return WorkflowInterface$StateMachineNames$.MODULE$.apply(list);
        }

        public static StateMachineNames fromProduct(Product product) {
            return WorkflowInterface$StateMachineNames$.MODULE$.fromProduct(product);
        }

        public static StateMachineNames unapply(StateMachineNames stateMachineNames) {
            return WorkflowInterface$StateMachineNames$.MODULE$.unapply(stateMachineNames);
        }

        public StateMachineNames(List<SMName> stateMachines) {
            this.stateMachines = stateMachines;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StateMachineNames)) return false;
            StateMachineNames stateMachineNames = (StateMachineNames)object;
            List<SMName> list = this.stateMachines();
            List<SMName> list2 = stateMachineNames.stateMachines();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StateMachineNames;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StateMachineNames";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "stateMachines";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<SMName> stateMachines() {
            return this.stateMachines;
        }

        public StateMachineNames copy(List<SMName> stateMachines) {
            return new StateMachineNames(stateMachines);
        }

        public List<SMName> copy$default$1() {
            return this.stateMachines();
        }

        public List<SMName> _1() {
            return this.stateMachines();
        }
    }

    public static final class WFIState
    implements Product,
    Serializable {
        private final String stateMachineId;
        private final int nodeId;

        public static WFIState apply(String string, int n) {
            return WorkflowInterface$WFIState$.MODULE$.apply(string, n);
        }

        public static WFIState fromProduct(Product product) {
            return WorkflowInterface$WFIState$.MODULE$.fromProduct(product);
        }

        public static WFIState unapply(WFIState wFIState) {
            return WorkflowInterface$WFIState$.MODULE$.unapply(wFIState);
        }

        public WFIState(String stateMachineId, int nodeId) {
            this.stateMachineId = stateMachineId;
            this.nodeId = nodeId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stateMachineId()));
            n = Statics.mix((int)n, (int)this.nodeId());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WFIState)) return false;
            WFIState wFIState = (WFIState)object;
            if (this.nodeId() != wFIState.nodeId()) return false;
            String string = this.stateMachineId();
            String string2 = wFIState.stateMachineId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WFIState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WFIState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "stateMachineId";
            }
            if (1 == n2) {
                return "nodeId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String stateMachineId() {
            return this.stateMachineId;
        }

        public int nodeId() {
            return this.nodeId;
        }

        public WFIState copy(String stateMachineId, int nodeId) {
            return new WFIState(stateMachineId, nodeId);
        }

        public String copy$default$1() {
            return this.stateMachineId();
        }

        public int copy$default$2() {
            return this.nodeId();
        }

        public String _1() {
            return this.stateMachineId();
        }

        public int _2() {
            return this.nodeId();
        }
    }

    public static final class WFInstance
    implements Product,
    Serializable {
        private final String _id;
        private final String workflowId;
        private final List states;

        public static WFInstance apply(String string, String string2, List<WFIState> list) {
            return WorkflowInterface$WFInstance$.MODULE$.apply(string, string2, list);
        }

        public static WFInstance fromProduct(Product product) {
            return WorkflowInterface$WFInstance$.MODULE$.fromProduct(product);
        }

        public static WFInstance unapply(WFInstance wFInstance) {
            return WorkflowInterface$WFInstance$.MODULE$.unapply(wFInstance);
        }

        public WFInstance(String _id, String workflowId, List<WFIState> states) {
            this._id = _id;
            this.workflowId = workflowId;
            this.states = states;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WFInstance)) return false;
            WFInstance wFInstance = (WFInstance)object;
            String string = this._id();
            String string2 = wFInstance._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.workflowId();
            String string4 = wFInstance.workflowId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            List<WFIState> list = this.states();
            List<WFIState> list2 = wFInstance.states();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WFInstance;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WFInstance";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "_id";
                }
                case 1: {
                    return "workflowId";
                }
                case 2: {
                    return "states";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String workflowId() {
            return this.workflowId;
        }

        public List<WFIState> states() {
            return this.states;
        }

        public WFInstance copy(String _id, String workflowId, List<WFIState> states) {
            return new WFInstance(_id, workflowId, states);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.workflowId();
        }

        public List<WFIState> copy$default$3() {
            return this.states();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.workflowId();
        }

        public List<WFIState> _3() {
            return this.states();
        }
    }
}

